/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;
import java.awt.ImageCapabilities;

public class BufferCapabilities
implements Cloneable {
    private ImageCapabilities frontCaps;
    private ImageCapabilities backCaps;
    private FlipContents flipContents;

    public boolean isFullScreenRequired() {
        return false;
    }

    public boolean isMultiBufferAvailable() {
        return false;
    }

    public boolean isPageFlipping() {
        return this.getFlipContents() != null;
    }

    public FlipContents getFlipContents() {
        return this.flipContents;
    }

    public ImageCapabilities getBackBufferCapabilities() {
        return this.backCaps;
    }

    public ImageCapabilities getFrontBufferCapabilities() {
        return this.frontCaps;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public BufferCapabilities(ImageCapabilities imageCapabilities, ImageCapabilities imageCapabilities2, FlipContents flipContents) {
        if (imageCapabilities == null || imageCapabilities2 == null) {
            throw new IllegalArgumentException("Image capabilities specified cannot be null");
        }
        this.frontCaps = imageCapabilities;
        this.backCaps = imageCapabilities2;
        this.flipContents = flipContents;
    }

    public static final class FlipContents
    extends AttributeValue {
        private static int I_UNDEFINED = 0;
        private static int I_BACKGROUND = 1;
        private static int I_PRIOR = 2;
        private static int I_COPIED = 3;
        private static final String[] NAMES = new String[]{"undefined", "background", "prior", "copied"};
        public static final FlipContents UNDEFINED = new FlipContents(I_UNDEFINED);
        public static final FlipContents BACKGROUND = new FlipContents(I_BACKGROUND);
        public static final FlipContents PRIOR = new FlipContents(I_PRIOR);
        public static final FlipContents COPIED = new FlipContents(I_COPIED);

        private FlipContents(int n2) {
            super(n2, NAMES);
        }
    }
}

