/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthIcon;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthPopupMenuUI;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

class SynthMenuItemUI
extends MenuItemUI
implements SynthUI {
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    private SynthStyle style;
    private SynthStyle accStyle;
    protected JMenuItem menuItem = null;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    InputMap windowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    SynthMenuItemUI() {
    }

    protected void installDefaults() {
        this.fetchStyle(this.menuItem);
    }

    protected void installKeyboardActions() {
        this.registerActionMap();
        this.updateAcceleratorBinding();
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    void registerActionMap() {
        LazyActionMap.installLazyActionMap(this.menuItem, SynthMenuItemUI.class, "MenuItem.actionMap");
    }

    private void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    protected void uninstallDefaults() {
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
        SynthContext synthContext = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        SynthContext synthContext2 = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(synthContext2);
        synthContext2.dispose();
        this.accStyle = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (keyStroke != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(keyStroke, "doClick");
        }
    }

    private boolean isInternalFrameSystemMenu() {
        String string = this.menuItem.getActionCommand();
        return string == "Close" || string == "Minimize" || string == "Restore" || string == "Maximize";
    }

    private boolean useCheckAndArrow() {
        boolean bl2 = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl2 = false;
        }
        return bl2;
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("doClick", new ClickAction());
    }

    InputMap createInputMap(int n2) {
        if (n2 == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    private int getComponentState(JComponent jComponent) {
        if (!jComponent.isEnabled()) {
            return 8;
        }
        int n2 = this.menuItem.isArmed() ? 2 : SynthLookAndFeel.getComponentState(jComponent);
        if (this.menuItem.isSelected()) {
            n2 |= 0x200;
        }
        return n2;
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuItem = null;
    }

    private void fetchStyle(JMenuItem jMenuItem) {
        Object object;
        SynthContext synthContext = this.getContext((JComponent)jMenuItem, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != this.style) {
            object = this.getPropertyPrefix();
            this.defaultTextIconGap = this.style.getInt(synthContext, (String)object + ".textIconGap", 4);
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(synthContext, (String)object + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(synthContext, (String)object + ".acceleratorDelimiter", "+");
            this.arrowIcon = this.style.getIcon(synthContext, (String)object + ".arrowIcon");
            this.checkIcon = this.style.getIcon(synthContext, (String)object + ".checkIcon");
        }
        synthContext.dispose();
        object = this.getContext(jMenuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SynthLookAndFeel.updateStyle((SynthContext)object, this);
        ((SynthContext)object).dispose();
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n2 = menuElementArray2.length;
        if (n2 == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n2 - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n2 + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2);
            menuElementArray[n2] = this.menuItem;
        } else {
            int n3;
            for (n3 = menuElementArray2.length - 1; n3 >= 0 && menuElementArray2[n3].getComponent() != container; --n3) {
            }
            menuElementArray = new MenuElement[n3 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n3 + 1);
            menuElementArray[n3 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl2) {
        System.out.println("Path is(");
        int n2 = menuElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 <= i2; ++i3) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i2];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl2) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (!this.isInternalFrameSystemMenu()) {
            SynthLookAndFeel.playSound(this.menuItem, this.getPropertyPrefix() + ".commandSound");
        }
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return this.getComponentState(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        int n2;
        JComponent jComponent = synthContext.getComponent();
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        Insets insets = jMenuItem.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        SynthMenuItemUI.viewRect.x += insets.left;
        SynthMenuItemUI.viewRect.y += insets.top;
        SynthMenuItemUI.viewRect.width -= insets.right + SynthMenuItemUI.viewRect.x;
        SynthMenuItemUI.viewRect.height -= insets.bottom + SynthMenuItemUI.viewRect.y;
        SynthContext synthContext2 = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        SynthStyle synthStyle = synthContext.getStyle();
        Font font = synthStyle.getFont(synthContext);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(synthContext2.getStyle().getFont(synthContext2));
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string = KeyEvent.getKeyModifiersText(n3);
                string = string + this.acceleratorDelimiter;
            }
            string = (n2 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n2) : string + keyStroke.getKeyChar();
        }
        String string2 = this.layoutMenuItem(synthContext, fontMetrics, synthContext2, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), this.checkIcon, this.arrowIcon, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : this.defaultTextIconGap, this.defaultTextIconGap);
        if (this.checkIcon != null && this.useCheckAndArrow()) {
            SynthIcon.paintIcon(this.checkIcon, synthContext, graphics, SynthMenuItemUI.checkIconRect.x, SynthMenuItemUI.checkIconRect.y, SynthMenuItemUI.checkIconRect.width, SynthMenuItemUI.checkIconRect.height);
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon;
            if (!buttonModel.isEnabled()) {
                icon = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = jMenuItem.getPressedIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                }
            } else {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                SynthIcon.paintIcon(icon, synthContext, graphics, SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height);
            }
        }
        if (string2 != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                graphics.setFont(synthStyle.getFont(synthContext));
                synthStyle.getSynthGraphics(synthContext).paintText(synthContext, graphics, string2, SynthMenuItemUI.textRect.x, SynthMenuItemUI.textRect.y, this.menuItem.getDisplayedMnemonicIndex());
            }
        }
        if (string != null && !string.equals("")) {
            Object object;
            n2 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JPopupMenu) {
                object = ((JPopupMenu)container).getUI();
                if (object instanceof SynthPopupMenuUI) {
                    SynthPopupMenuUI synthPopupMenuUI = (SynthPopupMenuUI)object;
                    int n4 = synthPopupMenuUI.getMaxAcceleratorWidth();
                    if (n4 > 0) {
                        n2 = n4 - SynthMenuItemUI.acceleratorRect.width;
                    }
                } else {
                    Integer n5 = (Integer)((JComponent)container).getClientProperty(MAX_ACC_WIDTH);
                    int n6 = n5 != null ? n5 : SynthMenuItemUI.acceleratorRect.width;
                    n2 = n6 - SynthMenuItemUI.acceleratorRect.width;
                }
            }
            object = synthContext2.getStyle();
            graphics.setColor(((SynthStyle)object).getColor(synthContext2, ColorType.TEXT_FOREGROUND));
            graphics.setFont(((SynthStyle)object).getFont(synthContext2));
            ((SynthStyle)object).getSynthGraphics(synthContext2).paintText(synthContext2, graphics, string, SynthMenuItemUI.acceleratorRect.x - n2, SynthMenuItemUI.acceleratorRect.y, -1);
        }
        if (this.arrowIcon != null && this.useCheckAndArrow()) {
            SynthIcon.paintIcon(this.arrowIcon, synthContext, graphics, SynthMenuItemUI.arrowIconRect.x, SynthMenuItemUI.arrowIconRect.y, SynthMenuItemUI.arrowIconRect.width, SynthMenuItemUI.arrowIconRect.height);
        }
        synthContext2.dispose();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthMenuItemUI();
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.accStyle, n2);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        Serializable serializable;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n3;
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n4);
                string2 = string2 + this.acceleratorDelimiter;
            }
            string2 = (n3 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n3) : string2 + keyStroke.getKeyChar();
        }
        SynthContext synthContext = this.getContext(jComponent);
        SynthContext synthContext2 = this.getContext(jComponent, Region.MENU_ITEM_ACCELERATOR);
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = jMenuItem.getToolkit().getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getToolkit().getFontMetrics(synthContext2.getStyle().getFont(synthContext2));
        this.resetRects();
        this.layoutMenuItem(synthContext, fontMetrics, synthContext2, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n2, n2);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height, r);
        Container container = this.menuItem.getParent();
        if (container instanceof JPopupMenu) {
            serializable = (JPopupMenu)container;
            PopupMenuUI popupMenuUI = ((JPopupMenu)serializable).getUI();
            if (popupMenuUI instanceof SynthPopupMenuUI) {
                SynthPopupMenuUI synthPopupMenuUI = (SynthPopupMenuUI)popupMenuUI;
                SynthMenuItemUI.r.width = synthPopupMenuUI.adjustTextWidth(SynthMenuItemUI.r.width);
                synthPopupMenuUI.adjustAcceleratorWidth(SynthMenuItemUI.acceleratorRect.width);
                SynthMenuItemUI.r.width += synthPopupMenuUI.getMaxAcceleratorWidth();
            } else {
                int n5;
                Integer n6 = (Integer)((JComponent)serializable).getClientProperty(MAX_TEXT_WIDTH);
                Integer n7 = (Integer)((JComponent)serializable).getClientProperty(MAX_ACC_WIDTH);
                int n8 = n6 != null ? n6 : 0;
                int n9 = n5 = n7 != null ? n7 : 0;
                if (SynthMenuItemUI.r.width < n8) {
                    SynthMenuItemUI.r.width = n8;
                } else {
                    ((JComponent)serializable).putClientProperty(MAX_TEXT_WIDTH, new Integer(SynthMenuItemUI.r.width));
                }
                if (SynthMenuItemUI.acceleratorRect.width > n5) {
                    n5 = SynthMenuItemUI.acceleratorRect.width;
                    ((JComponent)serializable).putClientProperty(MAX_ACC_WIDTH, new Integer(SynthMenuItemUI.acceleratorRect.width));
                }
                SynthMenuItemUI.r.width += n5;
            }
        }
        if (this.useCheckAndArrow()) {
            SynthMenuItemUI.r.width += SynthMenuItemUI.checkIconRect.width;
            SynthMenuItemUI.r.width += n2;
            SynthMenuItemUI.r.width += n2;
            SynthMenuItemUI.r.width += SynthMenuItemUI.arrowIconRect.width;
        }
        SynthMenuItemUI.r.width += 2 * n2;
        serializable = jMenuItem.getInsets();
        if (serializable != null) {
            SynthMenuItemUI.r.width += ((Insets)serializable).left + ((Insets)serializable).right;
            SynthMenuItemUI.r.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (SynthMenuItemUI.r.width % 2 == 0) {
            ++SynthMenuItemUI.r.width;
        }
        if (SynthMenuItemUI.r.height % 2 == 0) {
            ++SynthMenuItemUI.r.height;
        }
        synthContext.dispose();
        synthContext2.dispose();
        return r.getSize();
    }

    private String layoutMenuItem(SynthContext synthContext, FontMetrics fontMetrics, SynthContext synthContext2, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n6, int n7) {
        Object object;
        synthContext.getStyle().getSynthGraphics(synthContext).layoutText(synthContext, fontMetrics, string, icon, n3, n2, n5, n4, rectangle, rectangle2, rectangle3, n6);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            object = synthContext2.getStyle();
            rectangle4.width = ((SynthStyle)object).getSynthGraphics(synthContext2).computeStringWidth(synthContext2, fontMetrics2.getFont(), fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (icon2 != null) {
                rectangle5.width = SynthIcon.getIconWidth(icon2, synthContext);
                rectangle5.height = SynthIcon.getIconHeight(icon2, synthContext);
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = SynthIcon.getIconWidth(icon3, synthContext);
                rectangle6.height = SynthIcon.getIconHeight(icon3, synthContext);
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        object = rectangle2.union(rectangle3);
        if (SynthLookAndFeel.isLeftToRight(this.menuItem)) {
            rectangle3.x += n7;
            rectangle2.x += n7;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n7 - rectangle4.width;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + n7;
                rectangle3.x += n7 + rectangle5.width;
                rectangle2.x += n7 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n7 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n7;
            rectangle2.x -= n7;
            rectangle4.x = rectangle.x + rectangle6.width + n7;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + rectangle.width - n7 - rectangle5.width;
                rectangle3.x -= n7 + rectangle5.width;
                rectangle2.x -= n7 + rectangle5.width;
                rectangle6.x = rectangle.x + n7;
            }
        }
        rectangle4.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle4.height / 2;
        if (this.useCheckAndArrow()) {
            rectangle6.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle6.height / 2;
            rectangle5.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < SynthMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < SynthMenuItemUI.this.menuItem.getHeight()) {
                SynthMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private char lower(char c2) {
            return Character.toLowerCase(c2);
        }

        private MenuKeyHandler() {
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            int n2 = SynthMenuItemUI.this.menuItem.getMnemonic();
            if (n2 == 0 || menuKeyEvent.getPath().length != 2) {
                return;
            }
            if (this.lower((char)n2) == this.lower(menuKeyEvent.getKeyChar())) {
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                SynthMenuItemUI.this.doClick(menuSelectionManager);
                menuKeyEvent.consume();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n2 = mouseEvent.getModifiers();
            if ((n2 & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(SynthMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n2 = mouseEvent.getModifiers();
            if ((n2 & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n3 = menuElementArray.length - 1;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        menuElementArray2[i2] = menuElementArray[i2];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < SynthMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < SynthMenuItemUI.this.menuItem.getHeight()) {
                SynthMenuItemUI.this.doClick(menuSelectionManager);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthMenuItemUI.this.fetchStyle((JMenuItem)propertyChangeEvent.getSource());
            }
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                SynthMenuItemUI.this.updateAcceleratorBinding();
            } else if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }
}

