/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Metacity;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.TabContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

class GTKPainter
extends SynthPainter {
    static final GTKPainter INSTANCE = new GTKPainter();
    static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets TEMP_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets BUTTON_DEFAULT_BORDER_INSETS = new Insets(1, 1, 1, 1);

    GTKPainter() {
    }

    private void paintArrowButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        String string2 = "button";
        if (string == "ScrollBar.button") {
            if (jComponent.getParent() instanceof JScrollBar) {
                string2 = ((JScrollBar)jComponent.getParent()).getOrientation() == 0 ? "hscrollbar" : "vscrollbar";
            }
        } else if ("Spinner.previousButton" == string || "Spinner.nextButton" == string) {
            string2 = "spinbutton";
        }
        this.paintButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5, string2);
    }

    private void paintArrowButtonForeground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(Region.ARROW_BUTTON, synthContext.getComponentState());
        int n7 = n6 == 4 ? 1 : 0;
        int n8 = ((SynthArrowButton)synthContext.getComponent()).getDirection();
        switch (n8) {
            case 1: {
                n8 = 100;
                break;
            }
            case 5: {
                n8 = 101;
                break;
            }
            case 3: {
                n8 = 103;
                break;
            }
            case 7: {
                n8 = 102;
            }
        }
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        String string2 = "arrow";
        if (string == "ScrollBar.button" && jComponent.getParent() instanceof JScrollBar) {
            string2 = ((JScrollBar)jComponent.getParent()).getOrientation() == 0 ? "hscrollbar" : "vscrollbar";
        }
        int n9 = Math.min(n4 / 2, n5 / 2);
        gTKEngine.paintArrow(synthContext, graphics, n6, n7, n8, string2, n2 += (n4 - n9) / 2, n3 += (n5 - n9) / 2, n9, n9);
    }

    private void paintCheckButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((n6 & 2) != 0) {
            gTKEngine.paintFlatBoxNormal(synthContext, graphics, 2, "checkbutton", n2, n3, n4, n5);
        }
    }

    public void paintCheckButtonMenuItemBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((synthContext.getComponentState() & 2) != 0) {
            gTKEngine.paintBox(synthContext, graphics, n6, 1, "menuitem", n2, n3, n4, n5);
        }
    }

    private void paintListBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(Region.LIST, synthContext.getComponentState());
        if (synthContext.getComponent().getName() == "ComboBox.list") {
            // empty if block
        }
        gTKEngine.paintFlatBoxText(synthContext, graphics, n6, "base", n2, n3, n4, n5);
    }

    private void paintMenuBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if (n6 == 2) {
            gTKEngine.paintBox(synthContext, graphics, n6, 1, "menuitem", n2, n3, n4, n5);
        }
    }

    private void paintMenuBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = gTKStyle.getClassSpecificIntValue(synthContext, "shadow-type", 1);
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n7, n6, "menubar", n2, n3, n4, n5);
    }

    private void paintMenuItemBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((synthContext.getComponentState() & 2) != 0) {
            gTKEngine.paintBox(synthContext, graphics, n6, 1, "menuitem", n2, n3, n4, n5);
        }
    }

    private void paintPopupMenuBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n6, 1, "menu", n2, n3, n4, n5);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n7 = gTKStyle.getXThickness();
        int n8 = gTKStyle.getYThickness();
        gTKEngine.paintBackground(synthContext, graphics, n6, gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.BACKGROUND), n2 + n7, n3 + n8, n4 - n7 - n7, n5 - n8 - n8);
    }

    private void paintProgressBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        gTKEngine.paintBox(synthContext, graphics, 1, 0, "trough", n2, n3, n4 -= gTKStyle.getXThickness(), n5 -= gTKStyle.getYThickness());
    }

    private void paintProgressBarForeground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        if (n4 != 0 || n5 != 0) {
            gTKEngine.paintBox(synthContext, graphics, 1, 1, "bar", n2, n3, n4, n5);
        }
    }

    public void paintRootPaneBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxNormal(synthContext, graphics, n6, "base", n2, n3, n4, n5);
    }

    private void paintScrollBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n9 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n10 = n8 + n9;
        gTKEngine.paintBox(synthContext, graphics, 4, 0, "trough", n2 + n10, n3 + n10, n4 - 2 * n10, n5 - 2 * n10);
        if ((n6 & 0x100) == 256) {
            gTKEngine.paintFocus(synthContext, graphics, 1, "trough", n2, n3, n4, n5);
        }
    }

    private void paintScrollBarThumbBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = ((JScrollBar)synthContext.getComponent()).getOrientation() == 1 ? 1 : 0;
        gTKEngine.paintSlider(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "slider", n2, n3, n4, n5, n6);
    }

    private void paintScrollPaneBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        gTKEngine.paintShadow(synthContext, graphics, 1, 0, "scrolled_window", n2, n3, n4, n5);
    }

    private void paintSeparatorBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        if (((JSeparator)synthContext.getComponent()).getOrientation() == 0) {
            gTKEngine.paintHline(synthContext, graphics, 1, "hseparator", n2, n3, n4, n5);
        } else {
            gTKEngine.paintVline(synthContext, graphics, 1, "vseparator", n2, n3, n4, n5);
        }
    }

    private void paintSliderThumbBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = ((JSlider)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1;
        gTKEngine.paintSlider(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "slider", n2, n3, n4, n5, n6);
    }

    private void paintSliderTrackBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        gTKEngine.paintBox(synthContext, graphics, n7, 0, "trough", n2, n3, n4, n5);
        if ((n6 & 0x100) == 256) {
            int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            gTKEngine.paintFocus(synthContext, graphics, 1, "trough", n2 -= (n8 += gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1)), n3 -= n8, n4 += 2 * n8, n5 += 2 * n8);
        }
    }

    private void paintSpinnerBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n6, 0, "spinbutton", n2, n3, n4, n5);
    }

    private void paintSplitPaneDividerBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = ((JSplitPane)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1;
        gTKEngine.paintHandle(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), -100, "paned", n2, n3, n4, n5, n6);
    }

    private void paintSplitPaneDividerDragBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(synthContext.getStyle().getColor(synthContext, GTKColorType.BACKGROUND));
        graphics.fillRect(n2, n3, n4, n5);
        this.paintSplitPaneDividerBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
    }

    private void paintTabbedPaneContentBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        int n6 = GTKLookAndFeel.SwingOrientationConstantToGTK(jTabbedPane.getTabPlacement());
        int n7 = 0;
        int n8 = 0;
        int n9 = jTabbedPane.getSelectedIndex();
        if (n9 != -1) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(n9);
            if (n6 == 2 || n6 == 3) {
                n7 = rectangle.x - 1;
                n8 = rectangle.width;
            } else {
                n7 = rectangle.y - 1;
                n8 = rectangle.height;
            }
        }
        gTKEngine.paintBoxGap(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "notebook", n2, n3, n4, n5, n6, n7, n8);
    }

    private void paintTabbedPaneTabBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n7 = synthContext.getComponentState();
        int n8 = ((TabContext)synthContext).getTabIndex();
        int n9 = ((JTabbedPane)synthContext.getComponent()).getSelectedIndex();
        int n10 = n9 == n8 ? 0 : 2;
        n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n7);
        switch (((JTabbedPane)synthContext.getComponent()).getTabPlacement()) {
            case 1: {
                n6 = 3;
                n3 += n10;
                n5 -= n10;
                break;
            }
            case 3: {
                n5 -= n10;
                n6 = 2;
                break;
            }
            case 2: {
                n2 += n10;
                n4 -= n10;
                n6 = 1;
                break;
            }
            default: {
                n4 -= n10;
                n6 = 0;
            }
        }
        gTKEngine.paintExtension(synthContext, graphics, n7, 1, "tab", n2, n3, n4, n5, n6);
    }

    private void paintTextAreaBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        gTKEngine.paintFlatBoxText(synthContext, graphics, n6, "base", n2, n3, n4, n5);
    }

    private void paintTextBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.isOpaque() && jComponent.getBackground() instanceof ColorUIResource) {
            graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), 1, GTKColorType.TEXT_BACKGROUND));
            graphics.fillRect(n2, n3, n4, n5);
        }
    }

    private void paintTextFieldBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl2 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n7 = synthContext.getComponentState();
        int n8 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n7);
        int n9 = gTKStyle.getXThickness();
        int n10 = gTKStyle.getYThickness();
        this.paintTextBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
        n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n7);
        if (!bl2 && (n7 & 0x100) == 256) {
            n6 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            n2 += n6;
            n3 += n6;
            n4 -= 2 * n6;
            n5 -= 2 * n6;
        } else {
            n6 = 0;
        }
        gTKEngine.paintFlatBoxText(synthContext, graphics, 1, "entry_bg", n2 + n9, n3 + n10, n4 - 2 * n9, n5 - 2 * n10);
        if (synthContext.getComponent().getName() != "Spinner.formattedTextField") {
            gTKEngine.paintShadow(synthContext, graphics, 1, 0, "entry", n2, n3, n4, n5);
        }
        if (n6 > 0) {
            gTKEngine.paintFocus(synthContext, graphics, n8, "entry", n2 -= n6, n3 -= n6, n4 += 2 * n6, n5 += 2 * n6);
        }
    }

    public void paintToggleButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl2 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n9 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n10 = n8 + n9;
        int n11 = gTKStyle.getXThickness();
        int n12 = gTKStyle.getYThickness();
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        if (!bl2 && (n6 & 0x100) == 256) {
            n2 += n10;
            n3 += n10;
            n4 -= 2 * n10;
            n5 -= 2 * n10;
        }
        int n13 = 1;
        if (jToggleButton.isSelected() || (n6 & 4) != 0) {
            n13 = 0;
        }
        gTKEngine.paintBox(synthContext, graphics, n7, n13, "button", n2, n3, n4, n5);
        if ((n6 & 0x100) == 256) {
            if (bl2) {
                n2 += n11 + n9;
                n3 += n12 + n9;
                n4 -= 2 * (n11 + n9);
                n5 -= 2 * (n12 + n9);
            } else {
                n2 -= n10;
                n3 -= n10;
                n4 += 2 * n10;
                n5 += 2 * n10;
            }
            gTKEngine.paintFocus(synthContext, graphics, n7, "button", n2, n3, n4, n5);
        }
    }

    private void paintToolBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.BACKGROUND));
        gTKEngine.paintFlatBox(synthContext, graphics, n7, "handlebox_bin", n2, n3, n4, n5);
    }

    private void paintToolBarContentBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        gTKEngine.paintShadow(synthContext, graphics, 1, 1, "handlebox_bin", n2, n3, n4, n5);
    }

    private void paintToolTipBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        gTKEngine.paintFlatBoxNormal(synthContext, graphics, 1, "tooltip", n2, n3, n4, n5);
    }

    private void paintTreeBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.TEXT_BACKGROUND));
        graphics.fillRect(n2, n3, n4, n5);
    }

    private void paintTreeCellBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxText(synthContext, graphics, n6, "cell_odd", n2, n3, n4, n5);
    }

    private void paintTreeCellEditorBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxText(synthContext, graphics, n6, "entry_bg", n2, n3, n4, n5);
    }

    private void paintTreeCellFocus(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFocus(synthContext, graphics, n6, "treeview", n2, n3, n4, n5);
    }

    private void paintViewportBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.TEXT_BACKGROUND));
        graphics.fillRect(n2, n3, n4, n5);
    }

    public void paint(SynthContext synthContext, Object object, Graphics graphics, int n2, int n3, int n4, int n5) {
        Region region = synthContext.getRegion();
        String string = region.isSubregion() ? null : synthContext.getComponent().getName();
        GTKEngine gTKEngine = ((GTKStyle)synthContext.getStyle()).getEngine(synthContext);
        if (object == "background") {
            Insets insets;
            Border border;
            if (!region.isSubregion() && (border = synthContext.getComponent().getBorder()) != null && !(border instanceof UIResource) && (insets = synthContext.getComponent().getInsets(TEMP_INSETS)) != null) {
                n2 += insets.left;
                n3 += insets.right;
                n4 -= insets.left + insets.right;
                n5 -= insets.top + insets.bottom;
            }
            if (region == Region.ARROW_BUTTON) {
                this.paintArrowButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.BUTTON) {
                if (string != null && string.startsWith("InternalFrameTitlePane.")) {
                    Metacity.INSTANCE.paintButtonBackground(synthContext, graphics, n2, n3, n4, n5);
                } else {
                    this.paintButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5, "button");
                }
            } else if (region == Region.FORMATTED_TEXT_FIELD) {
                this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.LABEL) {
                if ("TableHeader.renderer" == string || string == "GTKFileChooser.directoryListLabel" || string == "GTKFileChooser.fileListLabel") {
                    this.paintButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5, "button");
                } else if (string == "ComboBox.renderer") {
                    this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
                }
            } else if (region == Region.LIST) {
                this.paintListBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.MENU) {
                this.paintMenuBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.MENU_BAR) {
                this.paintMenuBarBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.MENU_ITEM) {
                this.paintMenuItemBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.POPUP_MENU) {
                this.paintPopupMenuBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.PROGRESS_BAR) {
                this.paintProgressBarBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
                this.paintCheckButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM) {
                this.paintCheckButtonMenuItemBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.ROOT_PANE) {
                this.paintRootPaneBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SCROLL_BAR) {
                this.paintScrollBarBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SCROLL_BAR_THUMB) {
                this.paintScrollBarThumbBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SEPARATOR) {
                this.paintSeparatorBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SLIDER_TRACK) {
                this.paintSliderTrackBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SLIDER_THUMB) {
                this.paintSliderThumbBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SPINNER) {
                this.paintSpinnerBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SPLIT_PANE_DIVIDER) {
                this.paintSplitPaneDividerBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TABBED_PANE_CONTENT) {
                this.paintTabbedPaneContentBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TABBED_PANE_TAB) {
                this.paintTabbedPaneTabBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TEXT_AREA) {
                this.paintTextAreaBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TEXT_FIELD) {
                if (string == "Tree.cellEditor") {
                    this.paintTreeCellEditorBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
                } else {
                    this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
                }
            } else if (region == Region.TOGGLE_BUTTON) {
                this.paintToggleButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TOOL_BAR || region == Region.TOOL_BAR_DRAG_WINDOW) {
                this.paintToolBarBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TOOL_BAR_CONTENT) {
                this.paintToolBarContentBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TOOL_TIP) {
                this.paintToolTipBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TREE) {
                this.paintTreeBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.TREE_CELL) {
                this.paintTreeCellBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.VIEWPORT) {
                this.paintViewportBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            }
        } else if (object == "border") {
            if (region == Region.INTERNAL_FRAME) {
                Metacity.INSTANCE.paintFrameBorder(synthContext, graphics, n2, n3, n4, n5);
            } else if (region == Region.VIEWPORT) {
                this.paintScrollPaneBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            }
        } else if (object == "foreground") {
            if (region == Region.ARROW_BUTTON) {
                this.paintArrowButtonForeground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.PROGRESS_BAR) {
                this.paintProgressBarForeground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            } else if (region == Region.SPLIT_PANE_DIVIDER) {
                this.paintSplitPaneDividerDragBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
            }
        } else if (object == "focus" && region == Region.TREE_CELL) {
            this.paintTreeCellFocus(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
        }
    }

    private Insets getButtonInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n4 = gTKStyle.getXThickness();
        int n5 = gTKStyle.getYThickness();
        int n6 = n2 + n3 + n4;
        int n7 = n2 + n3 + n5;
        JComponent jComponent = synthContext.getComponent();
        insets.left = insets.right = n6;
        insets.top = insets.bottom = n7;
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultCapable()) {
            Insets insets2 = gTKStyle.getClassSpecificInsetsValue(synthContext, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    Insets getInsets(SynthContext synthContext, Insets insets) {
        String string;
        Region region = synthContext.getRegion();
        String string2 = string = region.isSubregion() ? null : synthContext.getComponent().getName();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON || region == Region.CHECK_BOX || region == Region.RADIO_BUTTON || region == Region.ARROW_BUTTON || region == Region.TOGGLE_BUTTON || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM) {
            if ("Spinner.previousButton" == string || "Spinner.nextButton" == string) {
                return this.getSpinnerButtonInsets(synthContext, insets);
            }
            return this.getButtonInsets(synthContext, insets);
        }
        if (region == Region.FORMATTED_TEXT_FIELD) {
            return this.getTextFieldInsets(synthContext, insets);
        }
        if (region == Region.INTERNAL_FRAME) {
            insets = Metacity.INSTANCE.getBorderInsets(synthContext, insets);
        } else if (region == Region.LABEL) {
            if ("TableHeader.renderer" == string) {
                return this.getButtonInsets(synthContext, insets);
            }
            if ("ComboBox.renderer" == string) {
                return this.getTextFieldInsets(synthContext, insets);
            }
            if ("Tree.cellRenderer" == string) {
                return this.getTreeCellRendererInsets(synthContext, insets);
            }
        } else {
            if (region == Region.MENU_BAR) {
                return this.getMenuBarInsets(synthContext, insets);
            }
            if (region == Region.OPTION_PANE) {
                return this.getOptionPaneInsets(synthContext, insets);
            }
            if (region == Region.POPUP_MENU) {
                return this.getPopupMenuInsets(synthContext, insets);
            }
            if (region == Region.PROGRESS_BAR) {
                return this.getProgressBarInsets(synthContext, insets);
            }
            if (region == Region.SCROLL_BAR) {
                return this.getScrollBarInsets(synthContext, insets);
            }
            if (region == Region.SEPARATOR) {
                return this.getSeparatorInsets(synthContext, insets);
            }
            if (region == Region.SLIDER) {
                return this.getSliderInsets(synthContext, insets);
            }
            if (region == Region.SLIDER_TRACK) {
                return this.getSliderTrackInsets(synthContext, insets);
            }
            if (region == Region.SPINNER) {
                return this.getSpinnerInsets(synthContext, insets);
            }
            if (region == Region.TABBED_PANE) {
                return this.getTabbedPaneInsets(synthContext, insets);
            }
            if (region == Region.TABBED_PANE_CONTENT) {
                return this.getTabbedPaneContentInsets(synthContext, insets);
            }
            if (region == Region.TABBED_PANE_TAB) {
                return this.getTabbedPaneTabInsets(synthContext, insets);
            }
            if (region == Region.TEXT_FIELD) {
                if (string == "Tree.cellEditor") {
                    return this.getTreeCellEditorInsets(synthContext, insets);
                }
                return this.getTextFieldInsets(synthContext, insets);
            }
            if (region == Region.TOOL_BAR) {
                return this.getToolBarInsets(synthContext, insets);
            }
            if (region == Region.TOOL_TIP) {
                return this.getToolTipInsets(synthContext, insets);
            }
        }
        return insets;
    }

    private Insets getMenuBarInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "internal-padding", 1);
        int n3 = gTKStyle.getXThickness();
        int n4 = gTKStyle.getYThickness();
        insets.top = insets.bottom = n2 + n4;
        insets.left = insets.right = n2 + n3;
        return insets;
    }

    private Insets getMenuItemInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "internal-padding", 1);
        int n3 = gTKStyle.getXThickness();
        int n4 = gTKStyle.getYThickness();
        insets.top = insets.bottom = n2 + n4;
        insets.left = insets.right = n2 + n3;
        return insets;
    }

    private Insets getOptionPaneInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 6;
        insets.top = 6;
        insets.right = 6;
        insets.left = 6;
        return insets;
    }

    private Insets getPopupMenuInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 2;
        insets.top = 2;
        insets.right = 2;
        insets.left = 2;
        return insets;
    }

    private Insets getProgressBarInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.left = insets.right = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    private Insets getScrollBarInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (synthContext.getComponent().isFocusable()) {
            n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            int n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
            int n4 = n2 + n3;
            int n5 = n2 + n3;
            insets.left = insets.right = n4;
            insets.top = insets.bottom = n5;
        }
        n2 = gTKStyle.getClassSpecificIntValue(synthContext, "trough-border", 1);
        insets.left += n2;
        insets.right += n2;
        insets.top += n2;
        insets.bottom += n2;
        return insets;
    }

    Insets getScrollPaneInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.right = insets.left = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    private Insets getSeparatorInsets(SynthContext synthContext, Insets insets) {
        return insets;
    }

    private Insets getSliderInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    private Insets getSliderTrackInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        insets.left = insets.right = n2 + n3;
        insets.bottom = insets.right;
        insets.top = insets.right;
        return insets;
    }

    private Insets getSpinnerButtonInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.left = 1;
        insets.right = 1;
        return insets;
    }

    private Insets getSpinnerInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = 1;
        insets.left = n3;
        return insets;
    }

    private Insets getTabbedPaneContentInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    private Insets getTabbedPaneInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    private Insets getTabbedPaneTabInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        int n3 = gTKStyle.getYThickness();
        int n4 = 0;
        int n5 = 2;
        n4 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        insets.left = insets.right = n4 + n5 + n2;
        insets.top = insets.bottom = n4 + n5 + n3;
        return insets;
    }

    private Insets getTextFieldInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        int n3 = gTKStyle.getYThickness();
        boolean bl2 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n4 = 0;
        int n5 = 2;
        if (!bl2) {
            n4 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        }
        insets.left = insets.right = n4 + n5 + n2;
        insets.top = insets.bottom = n4 + n5 + n3;
        return insets;
    }

    private Insets getToolBarInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    private Insets getToolTipInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.left = insets.right = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    private Insets getTreeCellEditorInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.right = 1;
        insets.left = 1;
        return insets;
    }

    private Insets getTreeCellRendererInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.right = 1;
        insets.left = 1;
        return insets;
    }

    private void paintButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5, String string) {
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl2 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n9 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n10 = n8 + n9;
        int n11 = gTKStyle.getXThickness();
        int n12 = gTKStyle.getYThickness();
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultCapable()) {
            Insets insets = gTKStyle.getClassSpecificInsetsValue(synthContext, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            if ((n6 & 0x400) == 1024) {
                gTKEngine.paintBox(synthContext, graphics, 1, 0, "buttondefault", n2, n3, n4, n5);
            }
            n2 += insets.left;
            n3 += insets.top;
            n4 -= insets.left + insets.right;
            n5 -= insets.top + insets.bottom;
        }
        if (!bl2 && (n6 & 0x100) == 256) {
            n2 += n10;
            n3 += n10;
            n4 -= 2 * n10;
            n5 -= 2 * n10;
        }
        if (!(jComponent.getParent() instanceof JToolBar) || n7 != 1) {
            int n13 = (n6 & 4) == 4 ? 0 : 1;
            gTKEngine.paintBox(synthContext, graphics, n7, n13, string, n2, n3, n4, n5);
        }
        if ((n6 & 0x100) == 256) {
            if (bl2) {
                n2 += n11 + n9;
                n3 += n12 + n9;
                n4 -= 2 * (n11 + n9);
                n5 -= 2 * (n12 + n9);
            } else {
                n2 -= n10;
                n3 -= n10;
                n4 += 2 * n10;
                n5 += 2 * n10;
            }
            gTKEngine.paintFocus(synthContext, graphics, n7, string, n2, n3, n4, n5);
        }
    }

    static class ListTableFocusBorder
    extends AbstractBorder
    implements UIResource {
        ListTableFocusBorder() {
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.setColor(Color.BLACK);
            GTKEngine.INSTANCE._paintFocus(graphics, n2, n3, n4, n5, GTKEngine.DEFAULT_FOCUS_PATTERN, 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return this.getBorderInsets(component);
            }
            insets.bottom = 1;
            insets.top = 1;
            insets.right = 1;
            insets.left = 1;
            return insets;
        }
    }
}

