#include "main.h"
#include "main.moc"

#include <kaction.h>
#include <kstdaction.h>
#include <kmenubar.h>
#include <kstdgameaction.h>
#include <kcmenumngr.h>
#include <kkeydialog.h>

#include "generic/gmisc.h"
#include "generic/ghighscores.h"
#include "inter.h"
#include "factory.h"


BaseMainWindow::BaseMainWindow()
{
    installEventFilter(this);
    KConfigCollection::init();
    _configCollection = new KConfigCollection(this);

	// File & Popup
	KStdGameAction::gameNew(this, SLOT(start()), actionCollection());
    _pause = KStdGameAction::pause(this, SLOT(pause()), actionCollection());
    _pause->setEnabled(false);
    KStdGameAction::highscores(this, SLOT(showHighscores()),
                               actionCollection());
	KStdGameAction::quit(qApp, SLOT(quit()), actionCollection());

	// Settings
	_menu = KStdAction::showMenubar(this, SLOT(toggleMenubar()),
                                    actionCollection());
    _configCollection->plug("menubar visible", _menu);
	KStdAction::preferences(this, SLOT(configureSettings()),
                            actionCollection());
    KStdAction::keyBindings(this, SLOT(configureKeys()), actionCollection());


    _inter = bfactory->createInterface(this);
}

void BaseMainWindow::buildGUI(QWidget *widget)
{
    createGUI();
	readSettings();
	setCentralWidget(widget);

    QPopupMenu *popup = (QPopupMenu*)factory()->container("popup", this);
    if (popup) KContextMenuManager::insert(this, popup);
}

BaseMainWindow::~BaseMainWindow()
{
    delete _inter;
    KConfigCollection::cleanUp();
}

bool BaseMainWindow::eventFilter(QObject *, QEvent *e)
{
    if ( e->type()==QEvent::LayoutHint )
		setFixedSize(minimumSize()); // because QMainWindow and KMainWindow
		                             // do not manage fixed central widget and
		                             // hidden menubar ...
    return false;
}

void BaseMainWindow::readSettings()
{
    _configCollection->load();
	toggleMenubar();
}

bool BaseMainWindow::queryExit()
{
    _configCollection->save();
    return true;
}

void BaseMainWindow::toggleMenubar()
{
	if ( _menu->isChecked() ) menuBar()->show();
	else menuBar()->hide();
}

void BaseMainWindow::showHighscores()
{
    if ( !_inter->_isPaused() ) _inter->_pause();
    KExtHighscores::showHighscores(this);
}

void BaseMainWindow::start()
{
    _inter->_start();
}

void BaseMainWindow::pause()
{
    _inter->_pause();
}

void BaseMainWindow::configureSettings()
{
    if ( !_inter->_isPaused() ) _inter->_pause();

    KConfigDialog d(this);
    addConfigWidgets(d);
    d.exec();
}

void BaseMainWindow::addConfigWidgets(KConfigDialog &d)
{
    KConfigWidget *cw = bfactory->createGameConfig();
    if (cw) {
        connect(cw->configCollection(), SIGNAL(saved()),
                SIGNAL(settingsChanged()));
        d.append(cw);
    }
    cw = bfactory->createAppearanceConfig();
    if (cw) {
        connect(cw->configCollection(), SIGNAL(saved()),
                SIGNAL(settingsChanged()));
        d.append(cw);
    }
    d.append(new HighscoresConfigWidget);
}

void BaseMainWindow::configureKeys()
{
    KKeyDialog d(true, this);
    addKeys(d);
    d.insert(actionCollection());
    d.configure(false);
    actionCollection()->writeShortcutSettings();
    saveKeys();
}
