// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDDIALOGFACTORY_H
#define KJSEMBEDDIALOGFACTORY_H

#include <kjs/object.h>

class QDialog;
class QObject;
class QString;
class QWidget;

namespace KJSEmbed {

/**
 * Factory class that loads dialogs from Qt Designer XML files.
 *
 * @version $Id: dialogfactory.h,v 1.3 2002/03/08 18:53:34 rich Exp $
 * @author Richard Moore, rich@kde.org
 */
class DialogFactory
{
public:
    static QWidget *create( const QString &uiFile, QObject *connector = 0,
			    QWidget *parent = 0, const char *name = 0 );

    static QWidget *show( const QString &uiFile, QObject *connector = 0,
			  QWidget *parent = 0, const char *name = 0 );

    static QDialog *execDialog( const QString &uiFile, QObject *connector = 0,
				QWidget *parent = 0, const char *name = 0 );

    static void addBindings( KJS::ExecState *exec, KJS::Object &object );

private:

    /**
     * @internal
     * Provides the implementation of a JS method.
     */
    class MethodImp : public KJS::ObjectImp
    {
    public:
	enum MethodId { MethodExec, MethodShow };

	MethodImp( MethodId id );
	~MethodImp();

	/** 
	 * Reimplemented to specify that we implement the call operation.
	 */
	virtual bool implementsCall() const { return true; }

	virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self,
				 const KJS::List &args );

    private:
	MethodId id;
    };
};

}; // KJSEmbed

#endif // KJSEMBEDDIALOGFACTORY_H

// Local Variables:
// c-basic-offset: 4
// End:
