#include <ctype.h>
#include <iostream.h>

#include <qlabel.h>
#include <qframe.h>
#include <qwidget.h>
#include <qtooltip.h>
#include <qbuttongroup.h>

#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kurlrequester.h>

#include "EditLimit.moc"
#include "EditLimitBase.h"
#include "TimeValidator.h"

EditLimit::EditLimit(ftplimit *limit, ftpclass *fcls, 
		     QWidget * parent, char * wname)
 : KDialogBase(parent, wname, true, QString::null, 
               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true)
{
	current=limit;
	fclass=fcls;
	QString caption;
	if(limit)
		if(fcls)
			caption=i18n("Edit Limit for Class") + " " + fcls->getName();
		else
			caption=i18n("Edit Limit");
	else
		if(fcls)
			caption=i18n("Add Limit for Class") + " " + fcls->getName();
		else
			caption=i18n("Add Limit");
	setCaption(caption);
	mWidget = new EditLimitBase(this);
	setMainWidget(mWidget);
	QToolTip::add(mWidget->Frame3,i18n("Use this to specify at which hours this limit is in effect.\nExample:\n0630-1310 -> 06:30 AM - 01:10 PM\nDefaults to 0000-2400."));
	QToolTip::add(mWidget->hrs, i18n("Use this to specify at which hours this limit is in effect.\nExample:\n0630-1310 -> 06:30 AM - 01:10 PM\nDefaults to 0000-2400."));
	TimeValidator const *t=new TimeValidator(mWidget->hrs);
	mWidget->hrs->setValidator(t);
	mWidget->users->setMaxValue(9999);
	mWidget->users->setLineStep(10);

	if(current==0) {
		current=new ftplimit;
		current->setAny(true);
		current->setNum(-1);
		current->setMsgfile("/etc/msgs.toomany");
	}
	if(!current->isAny()) {
		mWidget->limitDays->setChecked(true);
		mWidget->mo->setChecked(current->isMo());
		mWidget->tu->setChecked(current->isTu());
		mWidget->we->setChecked(current->isWe());
		mWidget->th->setChecked(current->isTh());
		mWidget->fr->setChecked(current->isFr());
		mWidget->sa->setChecked(current->isSa());
		mWidget->su->setChecked(current->isSu());
	}
	if(current->getNum() > 0)
	{
		mWidget->limitNumber->setChecked(true);
		mWidget->users->setValue(current->getNum());
	}
	QString a=current->getHours();
	mWidget->hrs->setText(a);
	mWidget->msgFile->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::File);
	mWidget->msgFile->setURL(current->getMsgfile());
}

EditLimit::~EditLimit()
{
}

void EditLimit::slotOk() // SLOT
{
	if(!mWidget->limitDays->isChecked()) {
		current->setAny(true);
		current->setMo(false);
		current->setTu(false);
		current->setWe(false);
		current->setTh(false);
		current->setFr(false);
		current->setSa(false);
		current->setSu(false);
		current->setHours(0);
	} else {
		current->setAny(false);
		current->setMo(mWidget->mo->isChecked());
		current->setTu(mWidget->tu->isChecked());
		current->setWe(mWidget->we->isChecked());
		current->setTh(mWidget->th->isChecked());
		current->setFr(mWidget->fr->isChecked());
		current->setSa(mWidget->sa->isChecked());
		current->setSu(mWidget->su->isChecked());
		if(!mWidget->hrs->text().isEmpty())
			current->setHours(mWidget->hrs->text());
		else
			current->setHours(0);
	}
	if(mWidget->limitNumber->isChecked())
		current->setNum(mWidget->users->value());
	else
		current->setNum(-1);
	current->setMsgfile(mWidget->msgFile->url());
	emit EditLimitOk(current, fclass);
	accept();
}

