// Copyright (c) 2001 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#include <noatun/app.h>
#include <noatun/player.h>
#include <noatun/playlist.h>
#include "cmodule.h"
#include "jefferson.h"

Jefferson *Jefferson::tommy = 0;

Jefferson::Jefferson(void)
{
	tommy = this;

	connect(napp->player(), SIGNAL(newSong(void)), this, SLOT(newSong(void)));
	connect(napp->player(), SIGNAL(volumeChanged(int)), &osd, SLOT(setVolume(int)));
	connect(napp->player(), SIGNAL(playing(void)), this, SLOT(playing(void)));
	connect(napp->player(), SIGNAL(paused(void)), this, SLOT(paused(void)));
	connect(napp->player(), SIGNAL(stopped(void)), this, SLOT(stopped(void)));

	osd.setDisplayTime(5000);
}

Jefferson::~Jefferson(void)
{
	tommy = 0;
}

void Jefferson::init(void)
{
	JeffersonModule *module = new JeffersonModule(this);
	module->reopen();
	module->save();
}

void Jefferson::setFont(QFont f)
{
	osd.setTextFont(f);
}

void Jefferson::setColor(QColor color)
{
	osd.setTextColor(color);
}

void Jefferson::setPosition(int p)
{
	osd.setPosition(p);
}

void Jefferson::setTimeout(u_int t)
{
	osd.setDisplayTime(t);
}

void Jefferson::newSong(void)
{
	PlaylistItem item = napp->player()->current();
	if(!item)
		osd.showText(QString::null);
	else
		osd.showText(item.title());
}

void Jefferson::playing(void)
{
	osd.setStatus(KOSD::Playing);
}

void Jefferson::paused(void)
{
	osd.setStatus(KOSD::Paused);
}

void Jefferson::stopped(void)
{
	osd.setStatus(KOSD::Stopped);
}

#include "jefferson.moc"
