/*-
 * config.h --
 *	Configuration constants for the local site.
 *
 * Copyright (c) 1988 by the Regents of the University of California
 * Copyright (c) 1988 by Adam de Boor
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  Neither the University of California nor
 * Adam de Boor makes any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 *	"$Id: config.h,v 1.28 1995/03/09 09:08:37 stolcke Exp $ ICSI (Berkeley)"
 */

/*
 * DEFSYSPATH
 *	Is the absolute path of the location of system makefiles.
 *	Note: This needn't actually be edited here, since it is overriden
 *	in the top-level makefile.
 */
#ifndef DEFSYSPATH
#define DEFSYSPATH	"/usr/local/lib/pmake"
#endif

/*
 * DEFSHELL
 *	The index of the default shell description in job.c. It indexes the
 *	'shells' table:
 *	    0	  	C Shell
 *	    1	  	Bourne Shell
 *	    2	  	Unknown
 * SHELLDOC
 *	Documentation string to tell what shell is used by default.
 */
#define DEFSHELL  	1
#define SHELLDOC  	"Bourne"

/*
 * DEFSHELLDIR
 *	The directory in which the C Shell and Bourne Shell are to be found.
 */
#define DEFSHELLDIR	"/bin"

/*
 * DEFSYSMK
 *	The absolute path of the default system makefile. It should probably
 *	be in DEFSYSPATH.
 *	Note: This needn't actually be edited here, since it is overriden
 *	in the top-level makefile.
 */
#ifndef DEFSYSMK
#define DEFSYSMK  	"/usr/local/lib/pmake/system.mk"
#endif

/*
 * DEFMAXJOBS
 * DEFMAXLOCAL
 *	These control the default concurrency. On no occasion will more
 *	than DEFMAXJOBS targets be created at once (locally or remotely)
 *	DEFMAXLOCAL is the highest number of targets which will be
 *	created on the local machine at once. Note that if you set this
 *	to 0, nothing will ever happen...
 */
#define DEFMAXJOBS	4
#define DEFMAXLOCAL	1

/*
 * INCLUDES
 * LIBRARIES
 *	These control the handling of the .INCLUDES and .LIBS variables.
 *	If INCLUDES is defined, the .INCLUDES variable will be filled
 *	from the search paths of those suffixes which are marked by
 *	.INCLUDES dependency lines. Similarly for LIBRARIES and .LIBS
 *	See suff.c for more details.
 */
#define INCLUDES
#define LIBRARIES

/*
 * LOCKFILE
 *	This is the name of the lock file which is created in the current
 *	directory if the -l flag isn't given.
 * DONT_LOCK
 *	If this is defined, directory locking will be off by default. The
 *	-l flag will then turn locking on.
 */
#define LOCKFILE  	"LOCK.make"
/*#define DONT_LOCK*/

/*
 * SPECIAL_CHAR
 *	The character that leads into conditionals and include directives
 *	and the like.  This is settable at run-time, too.
 *	Note: 4.4BSD make uses '.'.
 */
#define SPECIAL_CHAR '#'

/*
 * DEF_OLD_VARS
 *	If defined, variable substitution follows the make style. PMake-style
 *	substitution cannot be turned on. In addition, pmake will never
 *	generate a warning for an undefined variable.
 */
#define DEF_OLD_VARS

/*
 * SYSVINCLUDE
 *	If defined, pmake will parse and process System V style include
 *	directives in makefiles, i.e., `include file', which would be
 *	equivalent to pmake's `#include "file"' .  Use of this feature has
 *	become quite widespread (Sun, NeXT, IRIX, HP-UX all have it), so
 *	this is usually desirable to save yourself some makefile editing.
 */
#define SYSVINCLUDE

/*
 * DEFOBJDIR
 *	If defined, use as a subdirectory to cd to (and leave objects etc. in).
 */
/* #define DEFOBJDIR	"obj" */

/*
 * MARK_SHELL_ARG0
 *	If defined, set the zeroth argument of shells spawned by pmake to
 *	contain the name of the make program (makes them easier to spot in
 *	process listings).
 *	
 */
#define MARK_SHELL_ARG0

/*
 * NEED_FD_SET
 *	Define this if your system doesn't define the fd_set type for select
 *	masks in <sys/types.h>
 *
 * FD_SETSIZE
 *	Define this to be the maximum number of files a process can have
 *	open at once. It defaults to 256.
 *
 * NO_VFORK
 *	Define this if your system doesn't support (or you shouldn't use)
 *	the vfork system call found in BSD UNIX.
 *
 * LIBTOC
 *	This is the name by which the table of contents in a ranlib'ed
 *	library is known. Some systems have changed it from __.SYMDEF,
 *	for whatever reason. NOTE: Do not redefine this on MIPS and
 *	Common Archive platforms; these are handled by built-in knowledge
 *	of the respective table-of-contents formats.
 *
 * LIBFLAG
 *	Is the shorthand used for libraries that should be searched in
 *	standard directories, usually "-l".
 *
 * LIBPREFIX
 *	Is the standard prefix for library archives, usually "lib".
 *
 * RECHECK
 *	If defined, Make_Update will check a target for its current
 *	modification time after it has been re-made, setting it to the
 *	starting time of the make only if the target still doesn't exist.
 *	Unfortunately, under NFS the modification time often doesn't
 *	get updated in time, so a target will appear to not have been
 *	re-made, causing later targets to appear up-to-date. On systems
 *	that don't have this problem, you should defined this. Under
 *	NFS you probably should not, unless you aren't exporting jobs.
 *	NOTE: The default behavior with RECHECK undefined is to recheck
 *	only those targets that where created locally. The -R option can
 *	use to control rechecking at runtime.
 *
 * POSIX
 *	If the POSIX standard for Make is to be followed. There are
 *	several areas that I dislike, hence this constant.
 *	Differences include:
 *	- try reading "makefile" before "Makefile";
 *	- use MAKEFLAGS rather than PMAKE environment variable;
 *	- allow leading space to introduce dependency commands;
 *	- commands for the same dependency can have intervening empty
 *	  lines.
 *
 * COREDIR
 *	Define this to a directory where pmake should core dump if it
 *	receives a SIGQUIT.  Leave undefined to suppress core dumping
 *	altogether.  The idea here is to avoid garbling cores produced by
 *	child processes.
 *
 * SYSV
 *	Global switch to change defaults to what is most likely to be
 *	found on a SystemV based platform.
 *	
 * HAVE_POSIX
 *	Replaces assorted functions traditionally found in BSD systems
 *	with POSIX equivalents. NOTE: This has nothing to do with POSIX
 *	above.  Enabled by default if SYSV is also defined.
 *
 */
/*#define NEED_FD_SET*/
/*#define FD_SETSIZE 32*/

#ifdef SYSV
# ifndef sun
#  define NO_VFORK
# endif
# define HAVE_POSIX
#endif /* SYSV */

#define LIBTOC		"__.SYMDEF"
#define LIBFLAG		"-l"
#define LIBPREFIX	"lib"

#define RECHECK
/*#define POSIX*/
#define COREDIR "/tmp"

/*
 * Miscellaneous UN*X compatibility.
 * Hopefully these will work unchanged, given the definitions above.
 */

/*
 * On BSD systems the fileno macro loses when we start using descriptors
 * above 127 and the char type is signed.  To prevent conversion to a
 * negative int we have to explictly cast to unsigned.
 * XXX: Make sure your <stdio.h> defines a
 *
 *	char _file
 *
 * field in the FILE structure.  If not, you don't need this kludge.
 */
#ifdef fileno
#undef fileno
#define fileno(p)	((unsigned char)(p)->_file)
#endif

/* just in case ... */
#undef SIGEMPTYSET
#undef SIGFILLSET
#undef SIGADDSET
#undef SIGDELSET

#ifdef HAVE_POSIX

/*
 * processes etc.
 */
#define KILLPG(pgrp,signo)	kill(-(pgrp),signo)
#define SETPGRP()		setsid()
#define WAIT3(stat,opt,rp)	waitpid(-1,stat,opt)

#define GID_T			gid_t	/* type used in getgroups */

/*
 * signals
 */
#define SIGSET_T		sigset_t
#define SIGEMPTYSET(mask)	sigemptyset(&(mask))
#define SIGFILLSET(mask)	sigfillset(&(mask))
#define SIGADDSET(mask,signo)	sigaddset(&(mask), signo)
#define SIGDELSET(mask,signo)	sigdelset(&(mask), signo)
#define SIGBLOCK(new,old)	sigprocmask(SIG_BLOCK, &(new), &(old))
#define SIGSETMASK(new,old)	sigprocmask(SIG_SETMASK, &(new), &(old))

#ifdef SIG_ERR
/*
 * Static buffers used in emulating BSD signal() semantics with sigaction()
 * We declare these only if <signal.h> has been included.
 * All fields in _new_sa are implicitly initialized to zero, all that ever
 * changes is _new_sa.sa_handler.
 */
static struct sigaction _new_sa, _old_sa;
#endif
#define SIGNAL(signo,handler)	(_new_sa.sa_handler = (handler), \
	sigaction(signo, &_new_sa, &_old_sa) < 0 ? SIG_ERR : _old_sa.sa_handler)

/*
 * SIGRESTORE is used to restore the signal handler after a signal is caught.
 * This should be done automatically with both BSD and POSIX signals.
 * SYSV without sigaction would have to define both SIGNAL and SIGRESTORE to
 * signal(signo, handler).
 */
#define SIGRESTORE(signo,handler)	/* nothing */

/*
 * wait() related stuff
 */
#define WAIT_STATUS	int
#define WSTATUS(status)	(status)

#undef WSTOPPED
#define WSTOPPED		0177

/*
 * directories
 */
#define DIR_INCLUDE		<dirent.h>
#define DIR_STRUCT		dirent

#define GETWD(path)		getcwd(path,MAXPATHLEN)

#else /* !HAVE_POSIX */

/*
 * processes etc.
 */
#define KILLPG(pgrp,signo)	killpg(pgrp,signo)
#define SETPGRP()		setpgrp(0,getpid())
#define WAIT3(stat,opt,ru)	wait3(stat,opt,ru)

#define GID_T			int	/* type used in getgroups */

/*
 * signals
 */
#define SIGSET_T		int
#define SIGEMPTYSET(mask)	((mask) = 0)
#define SIGFILLSET(mask)	((mask) = ~0)
#define SIGADDSET(mask,signo)	((mask) |= sigmask(signo))
#define SIGDELSET(mask,signo)	((mask) &= ~sigmask(signo))
#define SIGBLOCK(new,old)	((old) = sigblock(new))
#define SIGSETMASK(new,old)	((old) = sigsetmask(new))

#define SIGNAL(signo,handler)	signal(signo,handler)
#define SIGRESTORE(signo,handler)	/* nothing */

/*
 * wait() related stuff
 */
#define WAIT_STATUS	union wait
#define WSTATUS(status) ((status).w_status)	/* the status word as an int */

/* 
 * Some older BSD system don't define these
 */
#ifndef WSTOPSIG
#define WSTOPSIG(status)	((status).w_stopsig)
#endif
#ifndef WTERMSIG
#define WTERMSIG(status)	((status).w_termsig)
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(status)	((status).w_retcode)
#endif

/*
 * directories
 */
#define DIR_INCLUDE		<sys/dir.h>
#define DIR_STRUCT		direct

#define GETWD(path)		getwd(path)

#endif /* HAVE_POSIX */

/*
 * How to set real/effective uid/gid
 */
#ifdef hpux
#define SETREUID(ruid,euid)	setresuid(ruid,euid,-1)
#define SETREGID(rgid,egid)	setresgid(rgid,egid,-1)
#else
#ifndef SYSV
#define SETREUID(ruid,euid)	setreuid(ruid,euid)
#define SETREGID(rgid,egid)	setregid(rgid,egid)
#endif /* SYSV */
#endif /* hpux */

/*
 * We test for these to determine what interfaces to use,
 * but some systems define them inappropriately, i.e., without providing
 * the system calls that go with them!
 */
#ifdef hpux
#undef RUSAGE_SELF
/*#undef PRIO_PROCESS*/		/* needed on HP-UX 8.x */
#endif
#if defined(sun) && defined(SYSV)
#undef PRIO_PROCESS
#endif

