 /*********************************************************************
 *	play.c - exercises output interface of an OSS sound driver
 *			continuosly writing to /dev/dsp
 *	Copyright (C) 1999-2000 Rui Sousa 
 ********************************************************************* 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 ********************************************************************* 
*/

#include<stdio.h>
#include<math.h>
#include<unistd.h>
#include "common.h"

/* write countinously to /dev/dsp.
   Since we open in blocking mode write will only
   return after the entire buffer is written */
int main()
{
	int audio_fd;
	__u8 devbuf[BUF_SIZE];
	struct wave wave[CHANNELS];
	mode_t mode;
	unsigned int channel;
	int ret, val;

	mode = O_WRONLY;

	audio_fd = setup("/dev/dsp", mode);

	for (channel = 0; channel < CHANNELS; channel++)
	{
		wave[channel].w = 2.0 * M_PI * freq[channel] / SPEED;
		wave[channel].t0 = 0.0;
	}

	while (1) {

		if (DEBUG)
			print_info(audio_fd, mode);

		fill_devbuf(wave, devbuf);

		val = BUF_SIZE;
		ret = 0;

		if ((ret = write(audio_fd, devbuf, val)) == -1) {
			perror("audio write");
		}

		if (DEBUG)
			printf("(write)\ncount: %d ret: %d\n\n", val, ret);
	}

	close(audio_fd);

	return 0;
}
