/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipEnumeration;
import java.util.zip.ZipException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    ZipEntry entries;
    int numEntries;
    RandomAccessFile file;
    String name;
    File delete_on_close;

    public ZipFile(String fname) throws IOException {
        this(new File(fname));
    }

    public ZipFile(File f) throws IOException {
        this(f, 1);
    }

    public ZipFile(File f, int mode) throws IOException {
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException("mode can only be OPEN_READ or OPEN_READ | OPEN_DELETE");
        }
        if ((mode & 4) != 0) {
            this.delete_on_close = f;
            f.deleteOnExit();
        } else {
            this.delete_on_close = null;
        }
        this.file = new RandomAccessFile(f, "r");
        this.name = f.getName();
        this.readDirectory();
    }

    void readDirectory() throws IOException {
        long size = this.file.length();
        if (size < (long)22) {
            throw new ZipException("zipfile too short");
        }
        this.file.seek(size - (long)22);
        if (this.file.read() != 80 || this.file.read() != 75 || this.file.read() != 5 || this.file.read() != 6) {
            throw new ZipException("not a valid zipfile");
        }
        this.file.skipBytes(6);
        this.numEntries = this.readu2();
        int dir_size = this.read4();
        this.file.seek(size - (long)(dir_size + 22));
        ZipEntry last = null;
        for (int i = 0; i < this.numEntries; ++i) {
            this.file.skipBytes(10);
            int method = this.readu2();
            int modtime = this.readu2();
            int moddate = this.readu2();
            int crc = this.read4();
            int compressedSize = this.read4();
            int uncompressedSize = this.read4();
            int filenameLength = this.readu2();
            int extraLength = this.readu2();
            int commentLength = this.readu2();
            int diskNumberStart = this.readu2();
            int intAttributes = this.readu2();
            int extAttributes = this.read4();
            int relativeOffset = this.read4();
            byte[] bname = new byte[filenameLength];
            this.file.readFully(bname);
            ZipEntry entry = new ZipEntry(new String(bname, "8859_1"));
            if (extraLength > 0) {
                byte[] bextra = new byte[extraLength];
                this.file.readFully(bextra);
                entry.extra = bextra;
            }
            if (commentLength > 0) {
                byte[] bcomment = new byte[commentLength];
                this.file.readFully(bcomment);
                entry.comment = new String(bcomment, "8859_1");
            }
            entry.compressedSize = compressedSize;
            entry.size = uncompressedSize;
            entry.crc = (long)crc & 0xFFFFFFFFL;
            entry.method = method;
            entry.relativeOffset = relativeOffset;
            entry.time = ZipEntry.timeFromDOS(moddate, modtime);
            if (last == null) {
                this.entries = entry;
            } else {
                last.next = entry;
            }
            last = entry;
        }
    }

    public Enumeration entries() {
        return new ZipEnumeration(this);
    }

    public void close() throws IOException {
        this.file.close();
        this.entries = null;
        this.numEntries = 0;
        if (this.delete_on_close != null) {
            this.delete_on_close.delete();
        }
    }

    public ZipEntry getEntry(String name) {
        ZipEntry entry = this.entries;
        while (entry != null) {
            if (name.equals(entry.getName())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException {
        byte[] buffer = new byte[(int)ze.getCompressedSize()];
        this.file.seek(ze.relativeOffset + (long)30 - (long)2);
        int extraFieldLength = this.readu2();
        this.file.skipBytes(ze.getName().length() + extraFieldLength);
        this.file.readFully(buffer);
        InputStream is = new ByteArrayInputStream(buffer);
        if (ze.getMethod() == 8) {
            is = new InflaterInputStream(is, new Inflater(true), 512);
        }
        return is;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile already closed");
        }
        return this.numEntries;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private int readu2() throws IOException {
        int byte0 = this.file.read();
        int byte1 = this.file.read();
        if (byte0 < 0 || byte1 < 0) {
            throw new ZipException(".zip archive ended prematurely");
        }
        return (byte1 & 0xFF) << 8 | byte0 & 0xFF;
    }

    private int read4() throws IOException {
        int byte0 = this.file.read();
        int byte1 = this.file.read();
        int byte2 = this.file.read();
        int byte3 = this.file.read();
        if (byte3 < 0) {
            throw new ZipException(".zip archive ended prematurely");
        }
        return ((byte3 & 0xFF) << 24) + ((byte2 & 0xFF) << 16) + ((byte1 & 0xFF) << 8) + (byte0 & 0xFF);
    }
}

