/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.cert.Certificate;

public class CodeSource
implements Serializable {
    private static final String linesep = System.getProperty("line.separator");
    private URL location;
    private Certificate[] certs;

    public CodeSource(URL location, Certificate[] certs) {
        this.location = location;
        this.certs = certs;
    }

    public final URL getLocation() {
        return this.location;
    }

    public final Certificate[] getCertificates() {
        return this.certs;
    }

    public boolean implies(CodeSource cs) {
        String our_file;
        if (cs == null) {
            return false;
        }
        Certificate[] their_certs = cs.getCertificates();
        Certificate[] our_certs = this.getCertificates();
        if (our_certs != null) {
            if (their_certs == null) {
                return false;
            }
            for (int i = 0; i < our_certs.length; ++i) {
                int j;
                for (j = 0; j < their_certs.length && !our_certs[i].equals(their_certs[j]); ++j) {
                }
                if (j != their_certs.length) continue;
                return false;
            }
        }
        URL their_loc = this.getLocation();
        URL our_loc = this.getLocation();
        if (our_loc == null) {
            return true;
        }
        if (their_loc == null) {
            return false;
        }
        if (!our_loc.getProtocol().equals(their_loc.getProtocol())) {
            return false;
        }
        if (our_loc.getPort() != -1 && our_loc.getPort() != their_loc.getPort()) {
            return false;
        }
        if (our_loc.getRef() != null && !our_loc.getRef().equals(their_loc.getRef())) {
            return false;
        }
        if (our_loc.getHost() != null) {
            SocketPermission their_sockperm;
            String their_host = their_loc.getHost();
            if (their_host == null) {
                return false;
            }
            SocketPermission our_sockperm = new SocketPermission(our_loc.getHost(), "accept");
            if (!our_sockperm.implies(their_sockperm = new SocketPermission(their_host, "accept"))) {
                return false;
            }
        }
        if ((our_file = our_loc.getFile()) != null) {
            String their_file;
            if (!our_file.endsWith("/")) {
                our_file = our_file + "/";
            }
            if ((their_file = their_loc.getFile()) == null) {
                return false;
            }
            if (!their_file.startsWith(our_file)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSource)) {
            return false;
        }
        CodeSource cs = (CodeSource)obj;
        Certificate[] their_certs = cs.getCertificates();
        Certificate[] our_certs = this.getCertificates();
        if (our_certs == null && their_certs != null) {
            return false;
        }
        if (our_certs != null && their_certs == null) {
            return false;
        }
        if (our_certs != null) {
            if (our_certs.length != their_certs.length) {
                return false;
            }
            for (int i = 0; i < our_certs.length; ++i) {
                int j;
                for (j = 0; j < their_certs.length && !our_certs[i].equals(their_certs[j]); ++j) {
                }
                if (j != their_certs.length) continue;
                return false;
            }
        }
        URL their_loc = cs.getLocation();
        URL our_loc = this.getLocation();
        if (our_loc == null && their_loc != null) {
            return false;
        }
        return our_loc.equals(their_loc);
    }

    public int hashCode() {
        URL location = this.getLocation();
        if (location == null) {
            return System.identityHashCode(this);
        }
        return location.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append(super.toString() + " (" + linesep);
        sb.append("Location: " + this.getLocation() + linesep);
        Certificate[] certs = this.getCertificates();
        if (certs == null) {
            sb.append("<none>" + linesep);
        } else {
            for (int i = 0; i < certs.length; ++i) {
                sb.append(certs[i] + linesep);
            }
        }
        sb.append(")" + linesep);
        return sb.toString();
    }
}

