/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;

public class Polygon
implements Shape,
Serializable {
    protected Rectangle bounds;
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;

    public Polygon() {
        this.xpoints = new int[0];
        this.ypoints = new int[0];
        this.npoints = 0;
    }

    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        this.xpoints = new int[npoints];
        this.ypoints = new int[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
    }

    public void addPoint(int x, int y) {
        int[] newx = new int[this.npoints + 1];
        System.arraycopy(this.xpoints, 0, newx, 0, this.npoints);
        int[] newy = new int[this.npoints + 1];
        System.arraycopy(this.ypoints, 0, newy, 0, this.npoints);
        newx[this.npoints] = x;
        newy[this.npoints] = y;
        ++this.npoints;
        this.xpoints = newx;
        this.ypoints = newy;
        if (this.bounds != null) {
            this.computeBoundingBox();
        }
    }

    public boolean contains(double x, double y) {
        boolean inside = false;
        for (int i = 0; i < this.npoints; ++i) {
            double t;
            double x3;
            int y2;
            int x2 = i == this.npoints ? this.xpoints[0] : this.xpoints[i + 1];
            int n = y2 = i == this.npoints ? this.ypoints[0] : this.ypoints[i + 1];
            if (this.ypoints[i] == y2 || !((x3 = (double)this.xpoints[i] + (t = (y - (double)this.ypoints[i]) / (double)(y2 - this.ypoints[i])) * (double)(x2 - this.xpoints[i])) < x)) continue;
            inside ^= true;
        }
        return inside;
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.intersectOrContains(x, y, w, h, false);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBoundingBox() {
        if (this.bounds == null) {
            this.computeBoundingBox();
        }
        return this.bounds;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.computeBoundingBox();
        }
        return this.bounds;
    }

    public Rectangle2D getBounds2D() {
        if (this.bounds == null) {
            this.computeBoundingBox();
        }
        return this.bounds;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new Iterator(this, at);
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.intersectOrContains(x, y, w, h, true);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    private boolean intersectOrContains(double x, double y, double w, double h, boolean intersect) {
        int maxy;
        Rectangle r = this.getBounds();
        int minx = Math.max(r.x, (int)x);
        int maxx = Math.min(r.x + r.width, (int)(x + w));
        int miny = Math.max(r.y, (int)y);
        if (miny > (maxy = Math.min(r.y + r.height, (int)(y + h)))) {
            return false;
        }
        double[] crosses = new double[this.npoints + 1];
        while (miny < maxy) {
            int i;
            int ins = 0;
            for (i = 0; i < this.npoints; ++i) {
                int y2;
                int x2 = i == this.npoints ? this.xpoints[0] : this.xpoints[i + 1];
                int n = y2 = i == this.npoints ? this.ypoints[0] : this.ypoints[i + 1];
                if (this.ypoints[i] == y2) continue;
                double t = ((double)miny - (double)this.ypoints[i]) / (double)(y2 - this.ypoints[i]);
                double x3 = (double)this.xpoints[i] + t * (double)(x2 - this.xpoints[i]);
                crosses[ins++] = x3;
            }
            Arrays.sort(crosses, 0, ins);
            int n = i = intersect ? 0 : 1;
            while (i < ins - 1) {
                if (crosses[i] != crosses[i + 1] && (crosses[i] >= x && crosses[i] < x + w || crosses[i + 1] >= x && crosses[i + 1] < x + w)) {
                    return intersect;
                }
                i += 2;
            }
            ++miny;
        }
        return false;
    }

    public void translate(int deltaX, int deltaY) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + deltaX;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + deltaY;
        }
        if (this.bounds != null) {
            this.bounds.x += deltaX;
            this.bounds.y += deltaY;
        }
    }

    private void computeBoundingBox() {
        if (this.npoints == 0) {
            this.bounds = new Rectangle(0, 0, 0, 0);
        } else {
            int maxx = this.xpoints[0];
            int minx = this.xpoints[0];
            int maxy = this.ypoints[0];
            int miny = this.ypoints[0];
            for (int i = 1; i < this.npoints; ++i) {
                maxx = Math.max(maxx, this.xpoints[i]);
                minx = Math.min(minx, this.xpoints[i]);
                maxy = Math.max(maxy, this.ypoints[i]);
                miny = Math.min(miny, this.ypoints[i]);
            }
            this.bounds = new Rectangle(minx, miny, maxx - minx, maxy - miny);
        }
    }

    class Iterator
    implements PathIterator {
        private /* synthetic */ Polygon this$0;
        public AffineTransform xform;
        public int where;

        public Iterator(Polygon this$0, AffineTransform xform) {
            this.this$0 = this$0;
            this.xform = xform;
            this.where = 0;
        }

        public int currentSegment(double[] coords) {
            int r;
            if (this.where < this.this$0.npoints) {
                coords[0] = this.this$0.xpoints[this.where];
                coords[1] = this.this$0.ypoints[this.where];
                r = this.where == 0 ? 0 : 1;
                this.xform.transform(coords, 0, coords, 0, 1);
                ++this.where;
            } else {
                r = 4;
            }
            return r;
        }

        public int currentSegment(float[] coords) {
            int r;
            if (this.where < this.this$0.npoints) {
                coords[0] = this.this$0.xpoints[this.where];
                coords[1] = this.this$0.ypoints[this.where];
                r = this.where == 0 ? 0 : 1;
                this.xform.transform(coords, 0, coords, 0, 1);
            } else {
                r = 4;
            }
            return r;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.where == this.this$0.npoints + 1;
        }

        public void next() {
            ++this.where;
        }
    }
}

