// Copyright (C) 2002 Neil Stevens <neil@qualityassistant.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kapplication.h>
#include <kcolorbutton.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klineedit.h>
#include <klocale.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include "megamiconfig.h"

MegamiConfig::Data MegamiConfig::readData(KConfig &config)
{
	Data data;

	config.setGroup("Megami");
	// Eat flaming death suncc
	QColor c1(14, 155, 26);
	QColor c2(255, 255, 255);
	data.bgColor = config.readColorEntry("bgColor", &c1);
	data.fgColor = config.readColorEntry("fgColor", &c2);
	data.playerName = config.readEntry("playerName", i18n("Player"));
	data.computerNames.clear();
	data.computerNames.append( config.readEntry("computerName1", i18n("Washuu")) );
	data.computerNames.append( config.readEntry("computerName2", i18n("Tsunami")) );
	data.computerNames.append( config.readEntry("computerName3", i18n("Tokimi")) );

	return data;
}

void MegamiConfig::writeData(const Data &data, KConfig &config)
{
	config.setGroup("Megami");
	config.writeEntry("bgColor", data.bgColor);
	config.writeEntry("fgColor", data.fgColor);
	config.writeEntry("playerName", data.playerName);
	config.writeEntry("computerName1", data.computerNames[0]);
	config.writeEntry("computerName2", data.computerNames[1]);
	config.writeEntry("computerName3", data.computerNames[2]);

	config.sync();
}

MegamiConfig::MegamiConfig(const Data &data, QWidget *parent, const char *name)
	: KDialogBase(parent, name, true, kapp->makeStdCaption(i18n("Settings")), Ok | Default | Apply | Cancel, Ok, true)
{
	QFrame *mainWidget = makeMainWidget();

	QGroupBox *nameFrame = new QGroupBox(4, Vertical, i18n("Player Names"), mainWidget);
	new QLabel(i18n("You:"), nameFrame);
	new QLabel(i18n("Computer:"), nameFrame);
	new QLabel(i18n("Computer:"), nameFrame);
	new QLabel(i18n("Computer:"), nameFrame);
	playerName = new KLineEdit(nameFrame);
	computerName1 = new KLineEdit(nameFrame);
	computerName2 = new KLineEdit(nameFrame);
	computerName3 = new KLineEdit(nameFrame);
	
	QHBoxLayout *bgColorLayout = new QHBoxLayout(0, 0, spacingHint());
	bgColor = new KColorButton(data.bgColor, mainWidget);
	bgColorLayout->addWidget(new QLabel(i18n("Background color:"), mainWidget));
	bgColorLayout->addWidget(bgColor);

	QHBoxLayout *fgColorLayout = new QHBoxLayout(0, 0, spacingHint());
	fgColor = new KColorButton(data.fgColor, mainWidget);
	fgColorLayout->addWidget(new QLabel(i18n("Text color:"), mainWidget));
	fgColorLayout->addWidget(fgColor);

	QVBoxLayout *mainLayout = new QVBoxLayout(mainWidget, 0, spacingHint());
	mainLayout->addLayout(bgColorLayout);
	mainLayout->addLayout(fgColorLayout);
	mainLayout->addWidget(nameFrame);
	mainLayout->addStretch();

	applyData(data);
}

MegamiConfig::Data MegamiConfig::result(void)
{
	Data data;
	data.bgColor = bgColor->color();
	data.fgColor = fgColor->color();
	data.playerName = playerName->text();
	data.computerNames.clear();
	data.computerNames.append(computerName1->text());
	data.computerNames.append(computerName2->text());
	data.computerNames.append(computerName3->text());
	return data;
}

void MegamiConfig::slotApply(void)
{
	emit apply(result());
}

void MegamiConfig::slotDefault(void)
{
	KConfig config;
	Data data = readData(config);
	applyData(data);
}

void MegamiConfig::applyData(const MegamiConfig::Data &data)
{
	bgColor->setColor(data.bgColor);
	fgColor->setColor(data.fgColor);
	playerName->setText(data.playerName);
	computerName1->setText(data.computerNames[0]);
	computerName2->setText(data.computerNames[1]);
	computerName3->setText(data.computerNames[2]);
}

#include "megamiconfig.moc"
