/***************************************************************************
                          eraser.cpp  -  description
                             -------------------
    begin                : Thu Mar 9 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "eraser.h"

Eraser::Eraser(): GeoTool()
{
	ID = ID_eraser;
  identificator = "Eraser";

	int temp[] = { ID_geoObject, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Eraser::~Eraser()
{
}

void Eraser::processObjects()
{
	searchForChildren( parents.first(), eraseList );

	GeoObjects *actual;
	GeoObjects *myParent;

	for ( actual = eraseList.first(); actual; actual = eraseList.next() )
	{
  	for ( myParent = actual->parents.first(); myParent; myParent = actual->parents.next() )
  	{
 			myParent->children.removeRef( actual );
  	}
	}
}

void Eraser::searchForChildren( GeoObjects *obj, QList <GeoObjects> & list )
{
	//	This method generates a list of all children.
	if ( list.contains( obj ) == 0 )
	{
		list.append( obj );
	}

	GeoObjects *actual;

	for ( actual = obj->children.first(); actual; actual = obj->children.next() )
	{
		searchForChildren( actual, list );
	}
}

