namespace Binge.Bits
{
	using System;
	using System.Collections;
	using System.IO;
	using System.Xml;

	public class Class: Binge.Bits.Object
	{
		// FIXME Support for nested classes or interfaces

		public ArrayList Using, Attributes;
		public MemberAccess Access;
		public string NativeName;
		public string TargetName;
		public ArrayList Ancestors, Implements;
		public ArrayList Enums, Fields, Properties;
		public ArrayList Constructors, Destructors, Methods, ImportedMethods;
		public bool Throttle;

		public Class (): this (true) {}

		public Class (bool init)
		{
			if (! init) return;

			Using = new ArrayList ();
			Attributes = new ArrayList ();
			Access = MemberAccess.Default;
			NativeName = TargetName = String.Empty;
			Ancestors = new ArrayList ();
			Implements = new ArrayList ();
			Enums = new ArrayList ();
			Fields = new ArrayList ();
			Properties = new ArrayList ();
			Constructors = new ArrayList ();
			Destructors = new ArrayList ();
			Methods = new ArrayList ();
			ImportedMethods = new ArrayList ();
			Throttle = false;
		}

		public bool IsSubclassOf (Class klass)
		{
			if (this == klass)
				return true;

			foreach (Class ancestor in Ancestors)
				if (ancestor == klass || ancestor.IsSubclassOf (klass))
					return true;

			return false;
		}

		public bool IsImplementorOf (Interface iface)
		{
			foreach (Interface i in Implements)
				if (iface == i)
					return true;

			return false;
		}

		public override string ToString ()
		{
			return "Class";
		}
	}
}
