/***************************************************************************
                            Observer.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef OBSERVER_H
#define OBSERVER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/DCOPObject.h>
#include <qtobjc/QObject.h>

/**

 Observer for @ref -[KIO Job]progress information
 This class, of which there is always only one instance,
 "observes" what jobs do and forwards this information
 to the progress-info server.

 It is a DCOP object so that the UI server can call the
 kill method when the user presses Cancel.

 @author David Faure <faure@kde.org>
 
 @short Observer for @ref KIO::Job progress information.
*/

@class Job;
@class KURL;

@class ctimeSrc; 

@interface Observer : QObject

/** 
 Called by the job constructor, to signal its presence to the
 UI Server.

*/
- (int) newJob: (Job*)job showProgress: (BOOL)showProgress;

/** 
 Called by the job destructor, to tell the UI Server that
 the job ended
   
*/
- jobFinished: (int)progressId;

/** 

   
*/
- (BOOL) openPassDlg: (NSString *)prompt user: (NSString *)user pass: (NSString *)pass readOnly: (BOOL)readOnly;
//- (BOOL) openPassDlg: (AuthInfo*)info;

/** 
 Popup a message box. See @ref -[KIO SlaveBase].
   
*/
- (int) messageBox: (int)progressId type: (int)type text: (NSString *)text caption: (NSString *)caption buttonYes: (NSString *)buttonYes buttonNo: (NSString *)buttonNo;

/** 
 See renamedlg.h
   
*/
//- (int) open_RenameDlg: (Job*)job caption: (NSString *)caption src: (NSString *)src dest: (NSString *)dest mode: (int)mode newDest: (NSString *)newDest int: (int)arg1 int: (int)arg2 time_t: (time_t ctimeSrc  -1)arg3 time_t: (time_t ctimeDest  -1)arg4 time_t: (time_t mtimeSrc  -1)arg5 time_t: (time_t mtimeDest  -1)arg6;
- (int) open_RenameDlg: (Job*)job caption: (NSString *)caption src: (NSString *)src dest: (NSString *)dest mode: (int)mode newDest: (NSString *)newDest ;

/** 
 See skipdlg.h
   
*/
- (int) open_SkipDlg: (Job*)job multi: (BOOL)multi error_text: (NSString *)error_text;
//- (k_dcop: /** * Called by the UI) Server: (using DCOP) if the user presses cancel* / void killJob( int)progressId;

/** 
 Called by the UI Server (using DCOP) to get all the metadata of the job
   
*/
- (int) metadata: (int)progressId;
- stating: (Job*)arg1 url: (KURL*)url;
- mounting: (Job*)arg1 dev: (NSString *)dev point: (NSString *)point;
- unmounting: (Job*)arg1 point: (NSString *)point;
- slotTotalSize: (Job*)arg1 size: (unsigned long)size;
- slotTotalFiles: (Job*)arg1 files: (unsigned long)files;
- slotTotalDirs: (Job*)arg1 dirs: (unsigned long)dirs;
- slotProcessedSize: (Job*)arg1 size: (unsigned long)size;
- slotProcessedFiles: (Job*)arg1 files: (unsigned long)files;
- slotProcessedDirs: (Job*)arg1 dirs: (unsigned long)dirs;
- slotSpeed: (Job*)arg1 bytes_per_second: (unsigned long)bytes_per_second;
- slotPercent: (Job*)arg1 percent: (unsigned long)percent;
- slotInfoMessage: (Job*)arg1 msg: (NSString *)msg;
- slotCopying: (Job*)arg1 from: (KURL*)from to: (KURL*)to;
- slotMoving: (Job*)arg1 from: (KURL*)from to: (KURL*)to;
- slotDeleting: (Job*)arg1 url: (KURL*)url;
- slotCreatingDir: (Job*)arg1 dir: (KURL*)dir;
- slotCanResume: (Job*)arg1 offset: (unsigned long)offset;

/** 

*/
+ (Observer*) self;
- init;
- (void) dealloc;
@end

@class ctimeSrc; 

@interface Observer (DCOPObjectImplementation) <DCOPObjectInterface>
@end

/** Override these methods in subclasses of Observer to customise event handling behaviour */
@protocol ObserverEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
