/***************************************************************************
                            KProcessController.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROCESSCONTROLLER_H
#define KPROCESSCONTROLLER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**


  A class for internal use by KProcess only. -- Exactly one instance
  of this class is generated by the first instance of KProcess that is
  created (a pointer to it gets stored in @ref theKProcessController ).

 This class takes care of the actual (UN*X) signal handling.

 @author Christian Czezakte <e9025461@student.tuwien.ac.at>

 @short Used internally by @ref KProcess.
*/
@class KProcess; 

@interface KProcessController : QObject 
- init;
- (void) dealloc;

/** 

  
*/
- addKProcess: (KProcess*)arg1;

/** 

  
*/
- removeKProcess: (KProcess*)arg1;

/** 

   
*/
- slotDoHousekeeping: (int)socket;

/** 
 Automatically called upon SIGCHLD.

 Normally you do not need to do anything with this function but
 if your application needs to disable SIGCHLD for some time for
 reasons beyond your control, you should call this function afterwards
 to make sure that no SIGCHLDs where missed.
   
*/
+ theSigCHLDHandler: (int)signal;

/** 

  
*/
+ setupHandlers;

/** 

  
*/
+ resetHandlers;
@end

/** Override these methods in subclasses of KProcessController to customise event handling behaviour */
@protocol KProcessControllerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
