/***************************************************************************
                            KFileMetaInfo.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEMETAINFO_H
#define KFILEMETAINFO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 This is the class for objects that hold meta information about a file.
 The information is kept in form of a system of key/value pairs. See also
 @ref KFileMetaInfoItem.
 This information is retrieved from the file through a plugin system, and
 this class is the main interface to it.
 If you want to write your own plugin, have a look at @ref KFilePlugin.
 There are basically two different kinds of meta information: Fixed ones
 that the plugin knows about (e.g. an mp3 id3v1 tag has a well defined
 fixed list of fields), and variable keys that exist in mimetypes that
 support their own key/value system (comments in png files are of this type).
 Almost every file has fixed keys, but some also have variable keys.

 The groups and the What enum are not yet supported, but already added to
 the interface so that adding support doesn't break compatibility.

 
 @short 

*/

@class QVariant;
@class QValidator;
@class QObject;

@interface  KFileMetaInfo : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 The constructor. 

 creating a KFileMetaInfo item through this will autoload the plugin
 belonging to the mimetype and try to get meta information about
 the specified file.

 If no info is available, you'll get an empty (not invalid) object.
 You can test for it with the @ref -isEmpty method.

*/
- initWithText: (NSString *)path mimeType: (NSString *)mimeType what: (int)what;
- initWithText: (NSString *)path ;

/** 
 Default constructor. This will create an invalid object (see 
 @ref -isValid.

*/
- init;

/** 
 Copy constructor

*/
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 This method searches for the specified item. If you also specify
 a group, the item will be searched in this group only.

*/
//- (KFileMetaInfoItem&) item: (NSString *)key group: (NSString *)group;
//- (KFileMetaInfoItem&) item: (NSString *)key ;

/** 

*/
//- (KFileMetaInfoItem&) item: (int)hint group: (NSString *)group;
//- (KFileMetaInfoItem&) item: (int)hint ;

/** 
 Convenience function. Returns the value of the specified key.
 It does the same as item(key, group).-value
     
*/
- (QVariant*) value: (NSString *)key group: (NSString *)group;
- (QVariant*) value: (NSString *)key ;

/** 

*/
- (BOOL) contains: (NSString *)key;

/** 
 Use this method to get a list of keys in the specified group that the
 plugin knows about. No variable keys. If you omit the group, all
 supported keys are returned.
 For a group that doesn't support variable keys, all keys that this group
 may have are returned. For a group that does support them, the
 non-variable ones are returned.

*/
- (NSArray *) supportedKeys: (NSString *)group;

/** 

*/
- (NSArray *) preferredKeys;

/** 

*/
- (NSArray *) keys: (NSString *)group;

/** 

*/
- (BOOL) supportsVariableKeys: (NSString *)group;
- (BOOL) supportsVariableKeys;

/** 
 add an item to the info. This is only possible if the specified key
 is in the supportedKeys list and not yet defined or if
 the group supports variable keys.

*/
//- (KFileMetaInfoItem) addTextItem: (NSString *)key group: (NSString *)group;

/** 

*/
- (NSArray *) supportedGroups;

/** 

*/
- (NSArray *) groups;

/** 

*/
- (NSArray *) editableGroups;

/** 
 Try to add the specified group. This will only succeed if it is
 in the list of @ref -editableGroups. Note that all non-variable
 items that belong to this group are automatically added as empty
 item.
    
*/
- (BOOL) addGroup: (NSString *)name;

/** 
 remove the specified group. This will only succeed if it is
 in the list of @ref -editableGroups. Beware that this also
 removes all the items in that group, so always ask the user
 before removing it!
    
*/
- removeGroup: (NSString *)name;

/** 

*/
- (NSString *) translatedGroup: (NSString *)name;

/** 
 This method writes all pending changes of the meta info back to the file.
 If any items are marked as removed, they are really removed from the 
 list. The info object as well as all items are updated.

*/
- (BOOL) applyChanges;

/** 
 Creates a validator for this item. Make sure to supply a proper parent
 argument or delete the validator yourself.
     
*/
- (QValidator*) createValidator: (NSString *)key parent: (QObject *)parent name: (NSString *)name group: (NSString *)group;
- (QValidator*) createValidator: (NSString *)key ;

/** 

*/
- (BOOL) isValid;

/** 

*/
- (BOOL) isEmpty;

/** 

*/
//- (KFilePlugin*) plugin;
- ref;
- deref;
+ (int) Fastest;
+ (int) DontCare;
+ (int) TechnicalInfo;
+ (int) ContentInfo;
+ (int) ExtenedAttr;
+ (int) Thumbnail;
+ (int) Preferred;
+ (int) Everything;
@end

#endif
