/***************************************************************************
                            HTMLQuoteElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLQUOTEELEMENT_H
#define HTMLQUOTEELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 For the <code> Q </code> and <code> BLOCKQUOTE </code> elements.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/text.-[html edef]-Q"> Q
 element definition </a> in HTML 4.0.

 Note: The DOM is not quite consistent here. They also define the
 HTMLBlockQuoteElement interface, to represent the <code>BLOCKQUOTE</code>
 element. To resolve ambiquities, we use this one for the <code>Q</code>
 element only.
 
 @short 
 For the <code> Q </code> and <code> BLOCKQUOTE </code> elements.
*/

@interface HTMLQuoteElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 A URI designating a document that designates a source document
 or message. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/text.-[html adef]-cite-Q">
 cite attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) cite;

/** 
 see @ref cite
     
*/
- setCite: (NSString *)arg1;
@end

#endif
