/***************************************************************************
                            KSelector.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values. An example is the {@link KGradientSelector}
 which allows to choose from a range of colors.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 See {@link KSelectorSignals} for signals emitted by KSelector.

 

 @short *
 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values.
*/
public class KSelector extends QWidget implements  QRangeControlInterface {
	protected KSelector(Class dummy){super((Class) null);}

	private native void newKSelector( QWidget parent, String name);

/** 
 Constructs a horizontal one-dimensional selection widget.
   
*/
	public KSelector( QWidget parent, String name) {
		super((Class) null);
		newKSelector( parent, name);
	}
	private native void newKSelector();
	public KSelector() {
		super((Class) null);
		newKSelector();
	}
	private native void newKSelector( int o, QWidget parent, String name);

/** 
 Constructs a one-dimensional selection widget with
 a given orientation.
   
*/
	public KSelector( int o, QWidget parent, String name) {
		super((Class) null);
		newKSelector( o, parent, name);
	}
	private native void newKSelector( int o);
	public KSelector( int o) {
		super((Class) null);
		newKSelector( o);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native int orientation();

/** 

*/
	public native QRect contentsRect();

/** 
 Sets the indent option of the widget to i.
 This determines whether a shaded frame is drawn.
   
*/
	public native void setIndent( boolean i);

/** 

*/
	public native boolean indent();

/** 
 Sets the value.
   
*/
	public native void setValue( int value);

/** 

*/
	public native int value();

/** 
 Sets the min value.
   
*/
	public native void setMinValue( int value);

/** 

*/
	public native int minValue();

/** 
 Sets the max value.
   
*/
	public native void setMaxValue( int value);

/** 

*/
	public native int maxValue();

/** 
 Override this function to draw the contents of the control.
 The default implementation does nothing.

 Draw only within contentsRect().
   
*/
	protected native void drawContents( QPainter arg1);

/** 
 Override this function to draw the cursor which
 indicates the current value. This function is
 always called twice, once with argument show=false
 to clear the old cursor, once with argument show=true
 to draw the new one.
   
*/
	protected native void drawArrow( QPainter painter, boolean show, QPoint pos);
	protected native void virtual_hook( int identifier, int data);

        // From QRangeControlInterface

        public native void addPage();
        public native void subtractPage();
        public native void addLine();
        public native void subtractLine();
        public native void setRange( int minValue, int maxValue);
        public native int lineStep();
        public native int pageStep();
        public native void setSteps( int line, int page);
        public native int bound( int arg1);
        protected native int positionFromValue( int val, int space);
        protected native int valueFromPosition( int pos, int space);
        protected native void directSetValue( int val);
        protected native int prevValue();
        protected native void valueChange();
        protected native void rangeChange();
        protected native void stepChange();
}
