/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "generalpageimpl.h"

#include "kxdata.h"

#include <qcheckbox.h>

#include <kdebug.h>
#include <klocale.h>

GeneralPage::GeneralPage(QWidget *parent, const char *name)
  : GeneralPageBase(parent, name)
{
    connect( m_allowZap, SIGNAL( toggled( bool ) ),
             this, SIGNAL( changed() ) );
}

void GeneralPage::load()
{
    m_allowZap->setChecked( m_data->generalServerData().zapAllowed() );

    emit enableForward( true );
}

void GeneralPage::save()
{
    kdDebug() << "GeneralPage::save" << endl;

    m_data->generalServerData().setZapAllowed( m_allowZap->isChecked() );
}

QString GeneralPage::quickHelp() const
{
    return i18n( "<h1>General Setup</h1>You can configure general display options here. "
                 "For example whether you want to enable the "
                 "Ctrl+Alt+Backspace keyboard shortcut for shutting down the display." );
}

#include "generalpageimpl.moc"
