.\" @(#)olwm.man 23.31 93/06/28
.TH olwm 1 "25 Nov 1992"
.SH NAME
olwm \- OPEN LOOK window manager for OpenWindows
.SH SYNOPSIS
.B olwm
[
.I options
]
.\" ========================================================================
.SH DESCRIPTION
.LP
.B Olwm
is a window manager for the X Window System that implements
parts of the OPEN LOOK graphical user interface.  It is the standard window
manager for Sun's OpenWindows product, but it will work properly with any
X11 system.  The only requirements for running
.B olwm
are that the server have the OPEN LOOK glyph and cursor fonts available.
.\" ========================================================================
.SH OPTIONS
.LP
Most command-line options have counterparts in the resource database.  A 
command-line option will override any setting from the resource database.
.TP
.B \-2d
Use two-dimensional look.  This is the default for monochrome systems.
.TP
.B \-3d
Use three-dimensional look.  This is the default for color systems.  This
option is ignored for monochrome systems.
.TP
\fB\-bd\fP\ \fIcolor,\fP\ \ \fB\-bordercolor\fP\ \fIcolor 
Specifies the border color.  See the description of the
.B BorderColor
resource.
.TP
\fB\-bg\fP\ \fIcolor,\fP\ \ \fB\-background\fP\ \fIcolor 
Specifies the background color.  See the description of the
.B Background
resource.
.TP
.BR \-c ",\ \ " \-click
Use click-to-focus mode.  This is the default focus mode.
.TP
.BI "\-depth " depth
Specifies the depth of the visual in which
.B olwm
is to run.  See the discussion in the Screen Resources section for further
information about depths.
.TP
.BI "\-display " display-string
Specify the name of the display to manage.  Overrides the DISPLAY
environment variable, if any.  In addition, the display string is exported
to
.BR olwm 's
environment, so processes forked from
.B olwm
will inherit this value.
.TP
.B \-dsdm
Specify that
.B olwm
should provide the Drop Site Database Management (DSDM) service.  This is
the default.
.TP
.BR \-f ",\ \ " \-follow
Use focus-follows-mouse mode.  Default mode is click-to-focus.
.TP
\fB\-fn\fP\ \fIfont-name,\fP\ \ \fB\-font\fP\ \ \fIfont-name\fP
Set the font for window titles.
.TP
\fB\-fg\fP\ \fIcolor,\fP\ \ \fB\-foreground\fP\ \fIcolor 
Specifies the foreground color.  See the description of the
.B ForegroundColor
resource.
.TP
.BI "\-multi"
Manage windows on all screens that a display supports.
This is the default.
.TP
.BI "\-name " resource-name
Use
.I resource-name
to look up resources in the resource database.
.TP
.B \-nodsdm
Specify that
.B olwm
should not provide the Drop Site Database Management service.  The default
is to provide the service.
.TP
.BI "\-single"
Manage windows for a single screen only, using the default screen
for the specified display.  Overrides the
.B \-multi
option.
.TP
.BI "\-syncpid " process-id
When
.B olwm
has completed its initialization, it will send a signal (SIGALRM by default)
to
.I process-id.
The signal will be sent only if this option is present.
This is useful for running
.B olwm
from shell scripts (such as
.BR .xinitrc )
in such a way that the script waits for
.B olwm
to finish its initialization, while leaving
.B olwm
as a child process of the shell script.
This can be done using the following
.BR sh (1)
construct:
.nf
.sp
	sleep 15 & pid=$!
	olwm \-syncpid $pid &
	wait $pid
.sp
.fi
.TP
.BI "\-syncsignal " signal
Specifies the signal to send instead of SIGALRM.  The signal is specified as
a number, not symbolically.
.TP
.BI "\-visual " visual-class
Specifies the class of the visual in which
.B olwm
is to run.  See the discussion in the Screen Resources section for further
information about visuals.
.TP
.BI "\-xrm " resource-string
Specify resources on the command-line.  Resources specified here will override
resources found in resource files.
.\" ========================================================================
.SH DEBUGGING OPTIONS
.LP
The following options are strictly for debugging.  They are not recommended
for general use.  Don't use them
unless you know what you are doing.
.TP
.B \-all
Print a message for every event received.
.TP
.B \-debug
Equivalent to turning on all debugging options.
.TP
.B \-orphans
Print orphaned events.  Orphaned events are 
events that are associated with a window or frame that has no entry in
the frame hash table, or events that are not handled by the various
event handlers.
.TP
.B \-synchronize
Run the window manager in synchronous mode.
.\" ========================================================================
.SH INTERNATIONALIZATION OPTIONS
.TP
.BI "\-basiclocale " locale-name
Specifies the basic OPEN LOOK locale category setting.
This category will be the base for other locale categories.
.TP
.BI "\-displaylang " locale-name
Specifies the display language OPEN LOOK locale category.
This category affects the contents of workspace menu,
window menu and notice messages.
.TP
.BI "\-numeric " locale-name
Specifies the numeric format OPEN LOOK locale category.
This category affects the numeric format displayed in
any message that contains numerics.
.\" ========================================================================
.SH LOCALE HANDLING
.PP
The 
.I locale
is the set of language and cultural conventions used by a program.
The locale controls the language-dependent part of
.BR olwm 's
behavior.
The OPEN LOOK international extensions have defined
several locale categories as follows:
.TP
.B "Basic Locale"
This is the basic setting for the entire locale mechanism.
This category specifies internal character handling behavior.
.TP
.B "Display Language"
This category specifies the language used for displaying menus,
notice messages, and error messages.
.TP
.B "Input Language"
This category specifies the language used for text input.
This category has no effect on
.BR olwm ,
because it does not accept text input from the keyboard.
.TP
.B "Date Format"
This category specifies the format of date and time.
This category has no effect on
.BR olwm ,
because it does not display any date and time information.
.TP
.B "Numeric Format"
This category specifies the format of displayed numeric data.
.PP
The Basic Locale setting determines the character set used by
.BR olwm .
The other locale categories can differ from the basic setting, but they
cannot require a different character set from the
Basic Locale.  The following restrictions thus apply:
.IP 1. 3
If basic locale setting is the "C" locale, then
all other locale categories must be in the "C" locale.
.IP 2.
If the Basic Locale is set to a locale other than the "C" locale, then all
other locale categories must be set either to a locale that uses the same
character set as the basic setting, or to the "C" locale.
.PP
The following methods are available to inform 
.B olwm
of the locale settings, listed in order of priority:
.IP 1. 3
Command line options (such as \fB\-basiclocale\fP);
.IP 2.
by resource database; and
.IP 3.
.BR setlocale (3C)
function defaults (e.g. LANG environment variable).
.\" ========================================================================
.SH INPUT FOCUS
The
.I
input focus
is the window that will receive keystrokes.
.B olwm
has two different input focus modes,
which are different ways of transferring the input focus from one
window to another.  By default,
.B olwm
uses "click-to-focus" (also known as "click-to-type") mode.  This means that
you must click on the window in order to get the focus to it.  While a
window has the input focus, the pointer can be anywhere on the screen; the
keyboard events will still go to that window.  You can set the input focus
to a window and simultaneously raise it to the top by clicking the left
mouse button in the window's title bar or border.
.LP
.B olwm
has another focus mode called "focus-follows-mouse."  In this mode, whatever
window the mouse is pointing to will receive the input focus.  To switch the
input focus from one window to another, you simply move the pointer to the
other window; you don't have to click at all.  Note, however, that to
transfer the focus amongst subwindows of a single top-level window, you must
click in the subwindow, or you must use focus transfer function keys (if
available from the application).
.LP
The input focus mode can be controlled with command-line options or by
entries in the resource database.  Neither focus mode has inherent
advantages.  Which one you choose is a matter of personal preference.
.\" ========================================================================
.SH MOUSE BUTTONS
OPEN LOOK defines three mouse button functions: SELECT, ADJUST, and MENU.
On systems with three mouse buttons, these functions are mapped to buttons
1, 2, and 3 (left, middle, and right) respectively.  On systems with two
mouse buttons, SELECT is on button 1 (left) and MENU is on button 2 (right).
ADJUST can be performed by holding down the Shift key while pressing button
1.  On systems with a single mouse button, that button is SELECT.  Holding
Shift while pressing the button gives ADJUST, and holding Control gives
MENU.
.LP
There is an alternate style of button handling for two-button mice: SELECT
is button 1, ADJUST is button 2, and MENU is performed by holding down
buttons 1 and 2 simultaneously.  This technique is referred to as
mouse button
.I chording.
It can be activated on systems with two-button mice by setting the
.B MouseChordMenu
resource to true.
.\" ========================================================================
.SH MANIPULATING WINDOWS AND ICONS
.I
Window Title Bar and Borders.
.PP
Clicking SELECT selects the window, raises it above other windows, and
deselects any other objects.  In click-focus mode, the focus is also
transferred to this window.  Pressing and holding SELECT and then dragging
the mouse will move windows without raising them or setting the focus.  If
this window is selected, it and all other selected windows are moved
simultaneously.  Otherwise, just this window is moved, and it is not
selected.  If you hold down the Control key while you are moving a window,
motion is constrained either vertically or horizontally, depending on
which direction you move first.
.LP
Double-clicking SELECT on the window is the same as selecting the Full Size
(or Restore Size) menu item.  Clicking ADJUST will toggle the selected state
of this window.  If other windows or icons are already selected, they remain
selected.  ADJUST is useful for selecting several windows and icons.
Pressing MENU will bring up the window menu.  See the Window Menu section
for further details.  If the
.B Alt
key is held down, the mouse button functions become accessible anywhere over
the window, not just over the title bar and borders.  The modifier used can
be changed; see the description of the
.B WMGrab
resource in the section on Modifier Customization.
.LP
.I
Resize Corners.
.PP
You can resize a window by pressing and holding SELECT over any of the
resize corners and then dragging the mouse to the new location.  
Releasing the mouse button will set the new size of the window.  
If you hold down the Control key while you are dragging, the resize 
operation is constrained to resize vertically or horizontally, depending 
on which direction you move first.
.LP
.I
Window Button.
.PP
The Window Button is the small box with a downward-pointing triangle near
the left end of the title bar.  Pressing MENU over the window button will
bring up the Window Menu.  Clicking SELECT over the left mouse button on the
Window Button will execute the window menu's default action.  This will
usually close the window into an icon.  You can change the window menu's
default action by holding down the Control key while manipulating the window
menu.
.LP
.I
Pushpin.
.PP
OPEN LOOK pop-up windows have a pushpin instead of a window button.  The pin
is either in or out, and you can click SELECT on the pin to move it to the
other state.  If the pin is out, pressing a command button inside the window
will execute the command and then dismiss (take down) the window.  If the
pin is in, the window is "pinned" to the workspace, and it will remain on
the screen even after you have pressed a command button in the window.  This
allows you to press several command buttons in the same window.  Pulling the
pin out (by clicking SELECT over it) will dismiss the window immediately.
.LP
.I
Icons.
.PP
An icon represents a closed window.  You can still do most of the same
operations as with an open window.  Moving and selecting icons with SELECT
and ADJUST is exactly the same as for open windows.  A similar version of
the Window Menu is available on an icon by pressing MENU.  Double-clicking
SELECT will open the icon.  Icons cannot be resized.
.\" ========================================================================
.SH NON-RECTANGULAR WINDOWS
The X11 Non-Rectangular Window Shape Extension (commonly referred to simply
as the SHAPE extension) allows windows to have arbitrary shapes.
.B Olwm
will handle these windows by giving them no decoration whatsoever.  Shaped
windows can be manipulated by using the WMGrab modifier (Alt by default)
with the mouse buttons.  (See the section on Modifier Customization for
further details.)  Shaped windows can be moved, resized, closed, opened, etc.
like ordinary windows.  The selection feedback for shaped windows is the
presence of resize corners floating at the corners of the bounding rectangle
of the window's shape.
.\" ========================================================================
.SH SELECTIONS ON THE WORKSPACE
.LP
You can select a group of windows and icons by using the left or middle
mouse buttons over the Workspace (the area of the screen outside of all
windows and icons, commonly known as the "root window").  Pressing either
SELECT or ADJUST and dragging the mouse will define a rubber-band rectangle.
When you release the mouse button, the set of windows and icons enclosed by
this rectangle will be operated on.  If you created the rectangle using
SELECT, the windows and icons within will be selected, and all other objects
will be deselected.  If you used ADJUST, the objects within will have their
selected state toggled, and any other windows and icons already selected
will remain selected.
.\" ========================================================================
.SH MENU OPERATION
.LP
In general, pop-up menus are operated using the MENU mouse button.  There
are two methods of operating with an OPEN LOOK menu: the "click-move-click"
method and the "press-drag-release" method.  You choose the method either by
clicking the MENU button (pressing and releasing it quickly) or by pressing
it down and holding it.  If you click the MENU button, the menu will pop up
and will stay up indefinitely.  To continue operating the menu, click the
MENU button over a menu item.  To dismiss the menu, click the MENU button on
an area of the screen outside the menu.  To operate menus in
press-drag-release mode, press the MENU button and hold it down while you
move the mouse.  The menu will remain on the screen as long as you hold down
the MENU button.  To execute an action, move the pointer over a menu item
and release the mouse button.  To dismiss the menu, move the pointer outside
the menu and release the MENU button.
.LP
Some menu items have a sub-menu.  This is indicated by a right-pointing
triangle at the right edge of the item.  To activate a submenu, click on the
item (in click-move-click mode) or move the pointer to the item and then move
toward the right edge of the menu (in press-drag-release mode).
.LP
Some menus have pushpins.  If a menu has a pushpin, it will initially be in
the "out" state.  If you click on the pin (in click-move-click mode) or move
over it and release (in press-drag-release mode) you will pin the menu to
the workspace.  The menu will remain on the screen indefinitely and you can
execute commands from it by clicking on its items.  To remove the menu, move
over the pin and click SELECT on it.
.LP
The behavior of menus can be customized using \fBolwm\fP's resources.  In
the Global Resources section, see the entries for \fBClickMoveThreshold\fP,
\fBDragRightDistance\fP, \fBMultiClickTimeout\fP, and
\fBSelectDisplaysMenu\fP for further information.
.LP
Some menus may have "accelerators" defined for them.  See the section on
Menu Accelerators for further details.
.\" ========================================================================
.SH WORKSPACE MENU
.LP
Pressing MENU over the workspace brings up the Workspace Menu.  This menu is
customizable, but it typically contains at least the following items.
(The items may appear in a different language depending on the current
locale setting.)
.TP
.B Programs
This item has a sub-menu that allows you to invoke applications.  The
default Programs sub-menu contains all of the programs in the OpenWindows
DeskSet.  However, users typically customize this menu to contain many more
programs and to contain nested sub-menus.  See the section on Menu
Customization for further information.
.TP
.B Utilities
This item has a sub-menu that contains several utility functions for the
workspace, including Refresh (redisplay all windows on the screen), Lock
Screen, and Save Workspace.
.TP
.B Properties...
This item brings up the Workspace Properties window, which allows you to
view and customize settings of the OpenWindows environment.
.TP
.B Help...
Brings up the table of contents of the Help Handbooks.
.TP
.B "Desktop Intro..."
Brings up a tutorial introduction to the Sun Desktop.
.TP
.B Exit
Shuts down all applications and exits the window system.  A confirmation
notice will appear first to give you a chance to cancel the operation.
.\" ========================================================================
.SH WINDOW MENU
.LP
The window menu of most windows has the following items.
(The items may appear in a different language depending on
the current locale setting.)
.TP
.B Close 
Closes the window to an icon.  Any OPEN LOOK pop-up windows are closed into
this icon as well.  They will reappear when the icon is opened.  This item
is "Open" if you bring up this menu over an icon.
.TP
.B Full Size
Expands the window to the full height of the screen.  If this has already
done, the button is Normal Size instead of Full Size.  Normal Size restores
the window to the size it was before you did the Full Size operation.  If
the application has specified a maximum size for the window, this size is
used for Full Size instead of the full screen height.
.TP
.B Move
Starts the keyboard-based form of moving the window.  Appears only if OPEN
LOOK Mouseless Mode is enabled.
.TP
.B Resize
Starts the keyboard-based form of resizing the window.  Appears only if OPEN
LOOK Mouseless Mode is enabled.
.TP
.B Back
Moves the window behind all other windows.
.TP
.B Refresh
Clears and redisplays the window.
.TP
.B Quit
Kills the program running in the window and removes the window.  If the
application has elected to participate in the WM_DELETE_WINDOW protocol,
.B olwm
sends a WM_DELETE_WINDOW ClientMessage instead of killing that window.
.LP
OPEN LOOK pop-up windows (as opposed to base windows) have a smaller window
menu.  It lacks the Close, Full Size, and Quit items, but it has two new
items:
.TP
.B Dismiss
Causes the window to be dismissed.  This button has a sub-menu with two
items: This Window, which dismisses just this window, and All Pop-ups, which
dismisses all pop-up windows owned by this application.
.TP
.B Owner?
Raises and flashes the title bar of the base window that "owns" this pop-up
window.
.\" ========================================================================
.SH MENU CUSTOMIZATION FILES
.LP
You can customize
.BR olwm 's
Workspace Menu by putting a menu description into a file that
.B olwm
will read.  When it starts up,
.B olwm
will first look for a file named by the OLWMMENU environment variable.  If
this variable does not exist, or if the file is not readable,
.B olwm
will then look in the file named
.B .openwin\-menu
in your home
directory.  If this file is not present or is unreadable,
.B olwm
will fall back on the system default menu file.  If, for some reason, the
system default menu file cannot be found,
.B olwm
will use a minimal, built-in menu.  The menu file that is read can also be
modified by the display language locale setting.  The locale name is used as
a suffix for the filename.  If a localized menu file is found, it is used in
preference to the non-localized menu file.  For example, if the display
language locale is "japanese", the file 
.B .openwin\-menu.japanese
will take precedence over the file
.BR .openwin\-menu .
.LP
.B Olwm
will automatically re-read its menu file whenever the menu file changes.
This lets you make many small changes to a menu file, trying out the
modified menu after each change.  The automatic re-reading can be controlled
with the
.B AutoReReadMenuFile
resource.
.LP
If
.B olwm
encounters a syntax error during the reading of any menu file, a message is
printed to the standard error file and the reading of this menu file is
considered to have failed.
.B Olwm
will then attempt to read the next file in the sequence as described above.
.\" ========================================================================
.SH MENU SPECIFICATION SYNTAX
The menu specification language has a number of keywords, all of which are
in all upper case letters.  The keywords are
.I not
translated into the language specified by the the locale category settings.
Keywords are always in English.
.LP
Each line typically specifies one menu button.  There are three fields on
each line: a label, the optional keyword DEFAULT, and a command.  The
label is either a single word or a string enclosed in double quotes.  This
is the label that appears in the menu button.  If the optional keyword
DEFAULT appears next, this menu item becomes the default item for this
menu.  The rest of the line (excluding leading whitespace) is considered to
be a command.  It is executed by sending it to
.BR sh (1).
Any shell metacharacters will be passed through to the shell unchanged.
The command field can be extended onto the next line by placing a backslash
`\\' at the end of the line.  The newline will not be embedded in the command.
.LP
A sub-menu is specified using the special keyword MENU in place of a
command.  A button is added to the current menu, and clicking or pulling
right on this button will bring up the sub-menu.  Subsequent lines in the
menu file define buttons for the sub-menu, until a line that has the special
keyword END in the command field is encountered.  The label of the MENU
line must match the label on the END line, otherwise an error is signaled.
Sub-menus can be nested arbitrarily, bracketed by MENU and END lines with
matching labels.
.LP
Sub-menus can be defined in a different file using either the MENU or the
INCLUDE keyword.  To include a sub-menu from another file, use a line with a
label, either the MENU or the INCLUDE keyword, and then the filename.  The
file so named is assumed to contain lines that specify menu buttons.  The
sub-menu file need not have any MENU or END lines (unless it has sub-menus
itself).  The current file need not have a matching END line if the sub-menu
is read from another file.  Sub-menu files included with the MENU keyword
are considered to be an integral part of the menu tree, and any error
encountered during reading of the file will cause the entire menu to be
considered invalid.  A sub-menu file included with the INCLUDE keyword is
considered optional, and any error encountered during reading of the file is
not considered fatal.  If an error occurs during INCLUDE processing, a
disabled (grayed-out) item is inserted in place of the sub-menu and
processing of the current menu file continues.
.LP
To make a sub-menu pinnable, add the special keyword "PIN" after the END
keyword on the line that ends the sub-menu definition, or after the TITLE
directive (see below).
.LP
By default, the label in a menu button is used as the title of the sub-menu.
This can be overridden by specifying a line that has the special keyword
TITLE in the command field.  The label from this line will be used as the
sub-menu's title.  This line can appear anywhere in the sub-menu definition.
It does not add an item to the menu.  In addition, if the PIN keyword
follows the TITLE keyword on this line, the sub-menu will be made pinnable.
This construct is useful for declaring that a sub-menu defined in a separate
file be pinnable.
.LP
A line containing only the keyword SEPARATOR will add extra space before
the next item.
.LP
The following keywords can be used in the command field of a menu item.
They specify functions that are internal to
.B olwm,
that are not invoked by running a shell.
.TP
BACK_SELN
Move the selected windows and icons behind other windows.
.TP
EXIT
.br
Kills all applications and exits the window manager after getting
confirmation from the user.  
This is useful for exiting the entire window system.
.TP
EXIT_NO_CONFIRM
Like EXIT but skips the confirmation notice.
.TP
FLIPDRAG
Toggle the state of the 
.B DragWindow
resource.
.TP
FLIPFOCUS
Toggle the state of the 
.B SetInput
resource.
.TP
FULL_RESTORE_SIZE_SELN
Toggle the full-sized/normal-sized states of the selected windows and icons.
.TP
NOP
.br
No operation; don't do anything.
.TP
OPEN_CLOSE_SELN
Toggle the opened/closed states of the selected windows and icons.
.TP
QUIT_SELN
Quit the selected windows and icons.
.TP
PROPERTIES
Bring up Workspace Properties.
.TP
REFRESH
Refresh causes all windows on the screen to be repainted.
.TP
REREAD_MENU_FILE
Force an immediate rereading of the workspace menu customization file.  
.B Olwm 
will start a complete search for a menu file (as described in the
.I Menu Customization
section) and use the first valid file it finds.
.TP
RESTART
Restart the window manager by issuing an
.BR exec (2)
on
.B argv.
This shouldn't affect any running applications, nor should it cause the
server to shut down.
.TP
SAVE_WORKSPACE
.br
Take a snapshot of the set of currently running
applications, and put the command lines so obtained
into the file ".openwin\-init" in the user's home directory.
This runs the command specified by the
.B SaveWorkspaceCmd
resource.
.TP
START_DSDM
Start providing the DSDM service.  See the section on Drag and Drop for
further information.
.TP
STOP_DSDM
Stop providing the DSDM service.  See the section on Drag and Drop for
further information.
.TP
WMEXIT
Exit the window manager without killing any applications.
.LP
Here is an example root menu specification.
.LP
.nf
"My Custom Menu" TITLE
.sp
Programs		 MENU
	"Command Tool"		DEFAULT cmdtool
	"Text Editor"		textedit
	Mail			mailtool
	"File Manager"		filemgr
	Other			MENU
		"Other Tools"		TITLE
		"Shell Tool"		shelltool
		"Icon Editor"		iconedit
		Clock			clock
		"Perf Meter"		DEFAULT perfmeter
	Other			END
Programs		END PIN
.sp
"Repaint Screen"	REFRESH
.sp
"Properties ..."	PROPERTIES
.sp
Exit		EXIT
.fi
.\" ========================================================================
.SH COLORMAP INSTALLATION
.LP
.B Olwm
will handle colormap installation for windows that have colormaps other than
the default colormap.  There are two colormap focus modes:
"color-follows-mouse" and "color-locked".  They are roughly analogous to the
corresponding modes for input focus.  However, the colormap focus mode can
be completely independent of the input focus mode.  The mode in which the
system starts up is determined by the 
.B ColorFocusLocked
resource.
.LP
.B Olwm
keeps track of a set of windows that are eligible to have their colormaps
installed.  This set includes all top-level windows of clients.  
If any clients have specified other windows in a WM_COLORMAP_WINDOWS
property, these windows are included in the set as well.  The windows listed
in this property need not be top-level windows; they can be nested
subwindows as well.
.LP
In color-follows-mouse mode,
.B olwm
keeps track of the location of the pointer and always keeps installed the
colormap of the eligible window underneath the pointer.  Thus, you can
install the colormap of a particular window simply by sliding the pointer
into it.  The default colormap will be restored if you move the pointer back
out into a window frame or into the workspace.  In this mode, the
WM_COLORMAP_WINDOWS properties are tracked for changes, but only to change
the set of eligible windows.  Changes to these properties only cause
colormaps to be installed if the eligible window under the pointer has
changed as a result of the set of eligible windows changing.  In this mode,
no window is considered to have the colormap focus; colormap installation
entirely is under control of the user.
.LP
In color-locked mode, colormaps are not installed based on pointer motion.
Instead, colormaps are installed explicitly by the user using function keys
or by a program changing the contents of the WM_COLORMAP_WINDOWS property on
its top-level window.
.LP
The user can install the colormap of a window (or subwindow listed in the
WM_COLORMAP_WINDOWS property) by moving the pointer over the window or
subwindow and pressing the Color-Lock key (which is bound to Control-L2 by
default).  This will install the colormap of the window or subwindow under
the pointer, and it will also grant the colormap focus to the top-level window.
When a window has the colormap focus,
.B olwm
will honor changes to this window's WM_COLORMAP_WINDOWS property by
installing the colormap of the first window named in this property.  In this
way, the application whose window has the colormap focus can control
colormap installation by altering the contents of the WM_COLORMAP_WINDOWS
property.
.LP
Note that, according to the ICCCM, if WM_COLORMAP_WINDOWS does not include
the top-level window, it is assumed to occur first in the list.  If you want
your program to request colormap installation via changes to
WM_COLORMAP_WINDOWS, you must make sure that the top-level window appears
somewhere in this property.  Otherwise,
.B olwm
will always install the colormap of the top-level window.
.LP
The colormap focus may be given to a window in several other ways.  If you
press the Color-Lock key over a window's title bar or border, that window
will be given the colormap focus and the first window in the
WM_COLORMAP_WINDOWS property will be installed.
If the 
.B AutoColorFocus
resource is
set, new windows will be given the colormap focus automatically.  If the
.B ColorTracksInputFocus
resource is set, the colormap focus will always be
given to the window that has the input focus.
.LP
If you press the Color-Lock key over the workspace, the default colormap
will be installed, and any window with the colormap focus will lose it.  The
root window is then considered to have the colormap focus.  At any time, you
can revert to color-follows-mouse mode by pressing the Color-Unlock key.
Any window with the colormap focus will lose it.
.\" ========================================================================
.SH SPOT HELP
.LP
.B Olwm
provides spot help for frames, icons, the Workspace and Window menus, window
buttons, resize corners, pushpins, and the Workspace itself.
This is done via a separate slave program,
.BR olwmslave (1) .
The slave program is forked automatically when
.B olwm
starts up.  The forking of the slave program can be controlled by the
.B RunSlaveProcess
resource.
.\" ========================================================================
.SH MULTIPLE SCREENS
.LP
By default,
.B olwm
will manage windows on all screens of the display server.  Most operations
are unchanged from single screen operation.  A window exists on a particular
screen for its entire lifetime.  The window cannot be moved from one screen
to another, nor can it be resized to cross a screen boundary.  Windows
invoked from the Workspace menu will appear on the same screen as the
menu.  Spot help will appear on the same screen as the pointer
when the Help key is pressed.
.LP
Previous releases required modifications to the user's
.B .xinitrc
script to start multiple instances of
.B olwm,
one for each screen.  These modifications are no longer necessary.  The
default
.B Xinitrc
(which contains a single invocation of
.BR olwm )
works for both single and multiple screen situations.
.\" ========================================================================
.SH DRAG AND DROP
.LP
The OpenWindows drag and drop system relies on a third-party client (i.e. a
client other than the source or destination clients of a drag and drop
operation) to maintain a database of all possible locations on the screen
where an object may be dropped.  These locations are referred to as ``drop
sites.''  This third party client is thus called the Drop Site Database
Manager or DSDM.  By default,
.B olwm
is configured to provide the DSDM service to clients.  This can be
controlled using the 
.B StartDSDM
resource or the
.B \-dsdm
and
.B \-nodsdm
command-line options.
.LP
If you have customized your Workspace Menu (see the section on Menu
Customization) you can add items that use the START_DSDM and STOP_DSDM menu
keywords.  Invoking a menu item bound to one of these keywords will enable
or disable
.BR olwm 's
providing of the DSDM service.
.LP
A standalone client
.BR dsdm (1)
exists in order to provide the DSDM service in the case where
.B olwm
is not running or if it has been directed not to provide the DSDM service.
Note that the START_DSDM and STOP_DSDM functions do not run an actual
.B dsdm
process; rather, they control whether
.B olwm
provides the DSDM service itself.  It is not necessary to run
.B dsdm
if
.B olwm
is providing the DSDM service.
.\" ========================================================================
.SH GLOBAL RESOURCES
.LP
Global resources in
.B olwm
consist of two resource components.
The first component in the resource name is taken from the trailing
pathname component of
.BR argv[0] .
This value is typically `olwm'.  This name can be altered by using the
.B \-name
command-line argument.  The second resource component names the global
attribute being set.  It should be one of the names from the following list.
Thus, to set the
.B AutoColorFocus
attribute, one would use
"olwm.AutoColorFocus" as the resource specification.
.LP
.B Olwm
will automatically pick up changes to many of these resources if the
resource database changes at run-time.  One can thus modify \fBolwm\fP's
behavior by changing the resource database with
.BR xrdb (1)
or with Workspace Properties.
If a resource value is specified on \fBolwm\fP's command line, it will
override the value in the resource database, and thus changing the resource's
value in the database will have no effect on this resource setting.
.LP
Some resources are also interpreted by XView (see
.BR xview (7))
and are set by the Workspace
Properties program (see
.BR props (1)).
For these resources,
.B olwm
will also accept the string `OpenWindows' as the first resource component.
These resources are marked with an asterisk `*'.
.LP
Colors can be specified using the formats parsed by the Xlib XParseColor()
function.  Common formats are color names (see
.BR showrgb (1))
and explicit red, green, and blue values in hexadecimal, preceded by a `#'.
For example, a cyan (full green and blue) would be specified with "#00ffff".
.LP
Boolean values can be specified with the words
"true", "false", "on", "off", "yes", "no", "1", "0", "t", and "nil".
.TP
.BI AutoColorFocus " (boolean)"
Indicates whether newly appearing windows are to be given the colormap focus
automatically.  See the section on Colormap Installation for further details.
.I
Default value: false.
.TP
.BI AutoInputFocus " (boolean)"
Indicates whether newly appearing windows are to be given the input focus
automatically.
.I
Default value: false.
.TP
.BI AutoRaise " (boolean)"
Raise windows automatically when they receive the focus.  This is useful in
click-to-focus if you always like to type into the topmost window.  This is
useful in focus-follow-mouse when the
.B AutoRaiseDelay
resource is set to a reasonable value.
.I
Default value: false.
.TP
.BI AutoRaiseDelay " (integer)"
Amount of time to delay, in microseconds, between a window receiving the
focus and raising it above other windows.  Effective only when the value of the
.B AutoRaise
resource is true.
.I
Default value: 0.
.TP
.BI AutoReReadMenuFile " (boolean)"
Specifies whether the menu file is to be re-read whenever it changes.
.I
Default value: true.
.TP
.BI Background " (color)"
Specifies the background color.  This is used for the background of masked
icons.  Note: it is not used for the backgrounds of icon windows such as
those used by XView (see
.BR xview (7)).
This resource is also distinct from the
.B WindowColor
resource.
.I
Default value: white.
.TP
.BI BasicLocale " (locale name)"
Specifies the basic OPEN LOOK locale category setting.
See the section on Locale Handling for more details.
.TP
.BI Beep " (enumeration) " *
Specifies the circumstances under which
.B olwm
should beep.  Permissible values are the strings "always", "never", and
"notices".  The string "never" means that
.B olwm
should never beep, "notices" means that
.B olwm
should beep only when a notice appears, and "always" means that
.B olwm
will beep whenever it is appropriate.
.I
Default value: always.
.TP
.BI BorderColor " (color)"
Specifies the color used for window and icon borders.
.I
Default value: black.
.TP
.BI ButtonFont " (font name)"
Font to be used for buttons in menus and notices.
.I
Default value: Lucida-Sans-12.
.TP
.BI ClickMoveThreshold " (integer)"
This value is used when bringing up a menu.  If the pointer moves more than
this amount while the menu button is down, the menu is considered to be in
press-drag-release mode.  Otherwise, the menu is in click-move-click mode.
.I
Default value: 5.
.TP
.BI ColorFocusLocked " (boolean)"
Specifies the initial state of the colormap focus policy.  If true, the
default colormap is locked into the hardware.  If false, the colormap of the
window under the pointer is kept installed.  See the section on Colormap
Installation for further details.
.I
Default value: false.
.TP
.BI ColorTracksInputFocus " (boolean)"
If true, indicates that the colormap focus is to be set automatically to any
window that receives the input focus.  See the section on Colormap
Installation for further details.
.I
Default value: false.
.TP
.BI CursorFont " (font name)"
Specifies the font to be used for cursors.  It is probably not useful to
change this unless you have an alternate cursor font with the same encoding
as the OPEN LOOK cursor font.
.I
Default value:
.br
.I
\-sun\-open look cursor\-*\-*\-*\-*\-*\-120\-*\-*\-*\-*\-*\-*.
.TP
.BI DefaultIconImage " (filename)"
Specifies a file containing a bitmap to be used as the default icon image.
.TP
.BI DefaultIconMask " (filename)"
Specifies a file containing a bitmap to be used as the default icon mask.
.TP
.BI DefaultTitle " (string)"
Specifies the string to be used in the title bar of windows that have not
provided a string in the WM_NAME property.
.I
Default value: No Name.
.TP
.BI DisplayLang " (locale name)"
Specifies the display language OPEN LOOK locale category.
See the section on Locale Handling for more details.
.TP
.BI DragRightDistance " (integer) " *
The number of pixels you must drag the mouse to the right in a menu item to
bring up a sub-menu.  The sub-menu always comes up when you move over the menu
mark (the right-pointing triangle), regardless of the drag-right distance.
.I
Default value: 100.
.TP
.BI DragThreshold " (integer) " *
This is the number of pixels the mouse must move while a mouse button is down
in order to have the action be considered a drag.  If the mouse moves fewer
than this number of pixels while the button is down, it is considered to be
click instead of a drag.
.I
Default value: 5.
.TP
.BI DragWindow " (boolean)"
If true, drags the entire image of the window when you move it.  Otherwise,
just drags the window outline.
.I
Default value: false.
.TP
.BI EdgeMoveThreshold " (integer)"
Specifies the amount of "hysteresis" provided when moving windows past the
edge of the screen.  When you move a window or an icon, it will pause when
it touches the edge of the screen.  This is to allow you to easily position
windows right up against the edge of the screen.  If you move farther, the
window or icon will continue to move past the edge.  You can prevent windows
from ever lapping off the screen by setting an extremely large value (say,
10000) for
this resource, and you can disable this feature entirely by specifying a
value of zero.
.I
Default value: 10.
.TP
.BI FlashCount " (integer)"
Number of times the title bar is flashed when the "Owners?" menu item is
activated.
.I
Default value: 6.
.TP
.BI FlashTime " (integer)"
Amount of time, in microseconds, for which the title bar is flashed when
the "Owner?" menu item is activated.
.I
Default value: 100000.
.TP
.BI FocusLenience " (boolean)"
If this is set to true, 
.B olwm
will not enforce the ICCCM requirement that windows must have the input hint
set in order to receive the input focus.  This option is useful if you run
clients that aren't ICCCM-compliant, like many X11R3-based clients.
.I
Default value: false.
.TP
.BI Foreground " (color)"
Specifies the foreground color.  This color is used mainly for the text of
window and icon titles and in menus.
.I
Default value: black.
.TP
.BI GlyphFont " (font name)"
Glyph font used for drawing OPEN LOOK graphics.  Changing this font is
mainly useful for changing its size.  Specifying a different font, such as a
text font, will result in undesirable behavior.
.I
Default value:
.br
.I
\-sun\-open look glyph\-*\-*\-*\-*\-*\-120\-*\-*\-*\-*\-*\-*.
.TP
.BI IconFlashCount " (integer)"
Number of times to flash the open/close "zoom" lines.
.I
Default value: 3.
.TP
.BI IconFlashOffTime " (integer)"
Amount of time to pause, in microseconds, while open/close "zoom" lines are
not visible.
.I
Default value: 1.
.TP
.BI IconFlashOnTime " (integer)"
Amount of time to pause, in microseconds, while open/close "zoom" lines are
visible.
.I
Default value: 20000.
.TP
.BI IconFont " (font name)"
Font used for icon names.
.I
Default: Lucida-Sans-12.
.TP
.BI IconLocation " (enumeration) " *
One of the words "top-lr", "top-rl", "bottom-lr", "bottom-rl", "left-tb",
"left-bt", "right-tb", or "right-bt".  These specify that icons should be
arranged along a particular edge of the screen, ordered from left to right
or top to bottom as appropriate.  The words "top", "bottom", "left", and
"right" are synonyms for "top-lr", "bottom-lr", "left-tb", and "right-tb",
respectively.
.I
Default value: bottom.
.TP
.BI InvertFocusHighlighting " (boolean)"
In click-to-focus, the input focus is normally indicated by a solid
rectangle in the title bar.  In focus-follows-mouse, focus is normally
indicated with two lines in the title bar.  If this resource is true, the
style of highlighting is inverted with respect to the focus style.  This
results in two lines for click-to-focus and a solid bar for
focus-follows-mouse.
.I
Default value: false.
.TP
.BI KeepTransientsAbove " (boolean)"
Specifies whether
.B olwm
should attempt to keep transient windows above their owner window.
.I
Default value: false.
.TP
.BI KeyboardCommands " (enumeration) " *
Permissible values for this resource are
.B "SunView1, Basic,"
and
.B Full.
Values are case-sensitive.  In
.B Full
mode, all OPEN LOOK Mouseless commands implemented by the window manager are
active.  See the section on Mouseless Navigation
for further information.  In
.B Basic
mode, the keys active are Open, Front, Help, and the colormap keys.  In
.B SunView1
mode, the only keys active are Open and Front.
.I
Default value: Basic.
.TP
.BI MenuAccelerators " (boolean)"
Determines whether menu accelerators are active.  Used in conjunction
with the
.B WindowMenuAccelerators
resource.  Both must be set to true for menu accelerators to be active.
.I
Default value: true.
.TP
.BI MinimalDecor " (list of strings)"
Specifies a list of windows that are to be decorated minimally.  Decoration
on such windows includes only a thin border and resize corners, with no
title bar or window button.  The value should be a whitespace-separated list
of strings.  Each string should specify an application's class or instance
name, as passed in the WM_CLASS property.  Most applications set this
property based on the name of the executable (i.e. argv[0]).  For example,
to specify that the clock and the calculator should be decorated minimally,
you would use the following resource:
.nf
.sp
	olwm.MinimalDecor: calctool clock
.sp
.fi
Many applications will allow you to override the value of the WM_CLASS
property using the
.B \-name
option on the command line.
.I
Default value: (null).
.TP
.BI MouseChordMenu " (boolean)"
If true, uses a chorded mouse button combination for MENU instead of
shift keys.  See the Mouse Buttons section for further details.
.I
Default value: false.
.TP
.BI MouseChordTimeout " (integer)"
Specifies the amount of time, in milliseconds, that
.B olwm
is to wait for subsequent events to disambiguate chorded mouse button
event sequences.
.I
Default value: 100.
.TP
.BI MultiClickTimeout " (integer) " *
The time, in tenths of a second, that differentiates a double-click
from two single clicks.  This value is also used to distinguish the
click-move-click and press-drag-release modes of pop-up menus.  If the MENU
button is held down longer than this amount of time, the menu is considered
to be in press-drag-release mode, otherwise it is considered to be in
click-move-click mode.
.I
Default value: 5.
.TP
.BI Numeric " (locale name)"
Specifies the numeric format OPEN LOOK locale category.
See the section on Locale Handling for more details.
.TP
.BI PaintWorkspace " (boolean)"
If true,
.B olwm
will use the
.B WorkspaceColor
resource to set the workspace (root window) background color.  If false,
.B olwm
will not change the root window background.  This is useful
If you prefer to set your own workspace color using
.BR xsetroot (1)
or a similar program.
.I
Default value: true.
.TP
.BI PointerWorkspace " (boolean)"
If true,
.B olwm
will set the workspace (root window) cursor.  If false,
.B olwm
will not change the root window cursor.  This is useful
if you prefer to set your own workspace cursor using
.BR xsetroot (1)
or a similar program.
.I
Default value: true.
.TP
.BI PPositionCompat " (boolean)"
Turns on backward compatibility for older applications that have a habit of
always setting the PPosition flag in the WM_NORMAL_HINTS property, even when
they haven't set a position.  This most often occurs with X11R3-based
clients.  Without backward compatibility, these windows will always appear
in the upper-left corner of the screen.  With backward compatibility, these
windows will be positioned according to the default OPEN LOOK window
placement policy, along the diagonal of the screen.  This option will not
affect windows that have a geometry specified on the command line.
.I
Default value: false.
.TP
.BI PopupJumpCursor " (boolean) " *
Specifies whether to warp the cursor to pop-up windows.
.I
Default value: true.
.TP
.BI PrintWarnings " (boolean)"
Determines whether 
.B olwm
will issue non-fatal warning messages (such as X protocol errors)
to its standard error file.
.I
Default value: false.
.TP
.BI RaiseOnActivate " (boolean)"
Specifies whether a window is to be raised when it is activated via a
Mouseless command.
.I
Default value: true.
.TP
.BI RaiseOnMove " (boolean)"
Tells \fBolwm\fP to raise a window whenever it is moved by the user.
.I
Default value: false.
.TP
.BI RaiseOnResize " (boolean)"
Tells \fBolwm\fP to raise a window whenever it is resized by the user.
.I
Default value: false.
.TP
.BI RefreshRecursively " (boolean)"
Determines how
the Refresh menu items on the window and workspace menus operate.  If the
value is true,
.B olwm
will walk the window hierarchy and send exposure events to every window.
This is useful for refreshing windows that have backing store.  If the value
is false,
.B olwm
will map a window and then unmap it, causing all windows underneath that do
not have backing store get exposures.  When this feature is on, the
Refresh operation generates a large amount of client-server traffic.  It may
be useful to turn this feature off if the connection transport has low
bandwidth or high latency.
.I
Default value: true.
.TP
.BI ReverseVideo " (boolean)"
If true, reverses the sense of black and white on monochrome screens.
Ignored for color screens.
.I
Default value: false.
.TP
.BI RubberBandThickness " (integer)"
Specifies the thickness of the "rubber-band" line that is drawn when a
window is resized, when a group of windows is selected by dragging a
rectangle on the root, and when a window is moved and the value of the
.B DragWindow
resource is false.
.I
Default value: 2.
.TP
.BI RunSlaveProcess " (boolean)"
If false, disables the running of
.BR olwmslave (1)
at startup time.  If the slave process is not running, Spot Help will not be
available on objects owned by
.B olwm
such as pushpins and resize corners.
.I
Default value: true.
.TP
.BI SaveWorkspaceCmd " (string)"
The command to execute to perform the Save Workspace functionality.
This command defaults to running owplaces(1) which saves the currently
running clients into the OpenWindows startup script $HOME/.openwin\-init. 
.I
Default value:
.br
.I
owplaces \-silent \-multi \-local \-script \-tw \-output $HOME/.openwin\-init
.TP
.BI SaveWorkspaceTimeout " (integer)"
Number of seconds to wait while the Save Workspace operation is in progress.
If the Save Workspace command has not completed within this amount of time, 
the operation is considered to have failed.
.I
Default value: 30.
.TP
.BI SelectDisplaysMenu " (boolean) " *
If true, pressing the SELECT mouse button will bring up a menu item's
sub-menu (if any) instead of executing the sub-menu's default action.
.I
Default value: false.
.TP
.BI SelectionFuzz " (integer)"
Number of pixels of "fuzz" to be applied when selecting windows and icons by
dragging a rectangle on the workspace.  Consider an object that lies almost
entirely within the selection rectangle, but that laps outside the rectangle
by a few pixels.  The object will be considered to be within the selection
rectangle if it laps outside by fewer than or equal to "fuzz" pixels.
.I
Default value: 1.
.TP
.BI SelectToggleStacking " (boolean)"
If true, double-clicking on a window will push it to the back instead of
zooming it to and from its full size.
.I
Default value: false.
.TP
.BI SelectWindows " (boolean)"
If false, the SELECT mouse button will not select windows and icons.  Its
other functions are unaffected.  The ADJUST mouse button can still be used
to select windows and icons.
.I
Default value: true.
.TP
.BI ServerGrabs " (boolean)"
Controls whether
.B olwm
grabs the server while menus and notices are up.
.I
Default value: true.
.TP
.BI SetInput " (enumeration) " *
Controls the input focus mode.  If the value is "select", it
means click-to-focus.  If the value is "followmouse", it means
focus-follows-mouse.
.I
Default value: select.
.TP
.BI ShowMoveGeometry " (boolean)"
Indicates whether the geometry box should be shown while moving windows and
icons.
.I
Default value: false.
.TP
.BI ShowResizeGeometry " (boolean)"
Indicates whether the geometry box should be shown while resizing windows.
.I
Default value: false.
.TP
.BI SnapToGrid " (boolean)"
Determines whether icons will snap to a grid when they are moved.
.I
Default value: false.
.TP
.BI StartDSDM " (boolean)"
Determines whether
.B olwm
will provide the DSDM service.  See the section on Drag and Drop for further
details.
.I
Default value: true.
.TP
.BI TextFont " (font name)"
Font used in the text of notices.
.I
Default: Lucida-Sans-12.
.if 0 \{
.TP
.BI timeFormat " (locale name)"
Specify the time format OPEN LOOK locale category.
See the section on Locale Handling for more details.
\}
.TP
.BI TitleFont " (font name)"
Font used in title bars atop windows and menus.
.I
Default: Lucida-Sans-12 Bold.
.TP
.BI TransientsSaveUnder " (boolean)"
Specifies whether the save-under attribute of frames of transient windows is
to be forced on.
.I
Default value: true.
.TP
.BI TransientsTitled " (boolean)"
Specifies whether transient windows should have title bars.  Normally,
transient windows have a title bar and resize corners, but no window button
or pushpin.  Setting this resource to false will remove the title bar from
transient windows.
.I
Default value: true.
.TP
.BI Use3D " (boolean)"
Specifies whether to use 3D OPEN LOOK when possible.  If false, 3D look is
never used.  If true, 3D is used unless the display hardware cannot support
it.
.I
Default value: true.
.TP
.BI Use3DFrames " (boolean)"
Specifies whether to use a 3D look for the frame borders.  If true, the
frames will be given a 3D look; otherwise, they have the same thick border
as in 2D look.  Some people prefer the look of 3D frames, but it is more
difficult to distinguish selected from unselected windows with this option
turned on.
.I
Default value: false.
.TP
.BI Use3DResize " (boolean)"
Specifies whether the window resize corners are to be in the 3D look.
If false, the 2D look is used for window resize corners.
.I
Default value: true.
.TP
.BI WindowCacheSize " (integer)"
.B Olwm
keeps a cache of windows in order to minimize unnecessary window creation
and destruction.  The value of this resource specifies the size of this
cache.  Setting this resource to zero disables the window cache.
.I
Default value: 500.
.TP
.BI WindowColor " (color) " *
Specifies the color of windows.  This is the "BG1" color for 3D OPEN LOOK.
It is used for the backgrounds of windows, menus, and notices.  The 3D
effect is achieved by using highlight and shadow colors derived from this
color.
.I
Default value: #cccccc.
This specifies a 20% gray value.
.TP
.BI WindowMenuAccelerators " (boolean)"
Determines whether menu accelerators are active.  Used in conjunction
with the
.B MenuAccelerators
resource.  Both must be set to true for menu accelerators to be active.
.I
Default value: true.
.TP
.BI WorkspaceBitmapBg " (color specification)"
Specifies the background color used for the workspace bitmap when the
.B WorkspaceStyle
resource is "tilebitmap".
.I
Default value: black.
.TP
.BI WorkspaceBitmapFg " (color specification)"
Specifies the foreground color used for the workspace bitmap when the
.B WorkspaceStyle
resource is "tilebitmap".
.I
Default value: white.
.TP
.BI WorkspaceBitmapFile " (filename)"
Specifies a X bitmap file that will be used for the workspace background
when WorkspaceStyle is "tilebitmap".
If the filename is not a full path name, the following directories
are searched:
.nf
.sp
	$OPENWINHOME/etc/workspace/patterns
	$OPENWINHOME/include/X11/include/bitmaps
	/usr/X11/include/X11/include/bitmaps
.sp
.fi
.I
Default value: gray.
.TP
.BI WorkspaceColor " (color) " *
Specifies the color for the workspace (root window).  On startup,
.B olwm
will set the root window's background color to the color specified by this
resource, and it will restore the default background on shutdown.  To turn
off this behavior, see the description of the
.B PaintWorkspace
resource.
.I
Default value: #40a0c0.
This specifies a light blue color.
.I Note:
earlier versions of
.B olwm
would accept a bitmap file name as the value of the
.B WorkspaceColor
resource.  This is no longer supported, and the
.B
WorkspaceBitmapFile, WorkspaceBitmapBg,
and
.B WorkspaceBitmapFg
resources should be used instead.
.TP
.BI WorkspaceStyle " (enumeration)"
This controls how the workspace is painted.
If the value is "paintcolor", the solid color
specified by the
.B WorkspaceColor
resource is used.
If the value is "tilebitmap", the workspace is tiled with a bitmap
using the
.B
WorkspaceBitmapFile, WorkspaceBitmapBg,
and
.B WorkspaceBitmapFg
resources.
If the value is "default", the server default root-weave pattern is used.
If the value of the
.B PaintWorkspace
resource is false, then all of these resources are ignored and the workspace
color or pattern is left unchanged.
.I
Default value: paintcolor
.\" ========================================================================
.SH SCREEN RESOURCES
.LP
In addition to the global resources described above,
.B
olwm
also uses screen-specific resources.  
The first component of the resource specification is the trailing pathname
component of
.BR argv[0] .
The second component is the screen number appended to the string `screen'.
The screens are numbered sequentially starting from zero.
The third component of the resource name is the name of the resource itself.
For example,
.nf
.sp
	olwm.screen1.ReverseVideo: true
.sp
.fi
enables reverse video on screen number 1 for
.B olwm.
To affect all screens, you can use resource wildcarding.  For example,
`olwm*ReverseVideo: true' will set reverse video for all screens
.B olwm
manages.
.LP
The following resources are available both globally and on a per-screen
basis.  A screen-specific resource overrides the corresponding global
setting for that screen.  Note that screen specific settings for
WorkspaceColor and WindowColor will only affect \fBolwm\fP;
this may cause clashes with XView clients which only use the global setting.
.nf
.sp
	Background
	BorderColor
	Foreground
	ReverseVideo
	WindowColor
	WorkspaceColor
.sp
.fi
.LP
The following resources allow the selection of visuals other
than the screen's default.  Available visuals may be listed with
the
.BR xdpyinfo (1)
command.
.TP
.BI Depth " (integer)"
Specify the visual depth to be used when searching for visuals.
.I
Default value: none.
.TP
.BI Visual " (enumeration)"
Specify the visual class to be used when searching for visuals.
Valid visual classes are
.BR StaticGray ,
.BR GrayScale ,
.BR StaticColor ,
.BR PseudoColor ,
.BR TrueColor ,
and
.BR DirectColor .
Names are case-sensitive.
.I
Default value: none.
.TP
.BI VisualID " (id)"
Specify the visual ID to be used.
Note: specifying a visual by its ID is not portable, as IDs may vary from
server to server and even from one invocation of a server to the next.
.I
Default value: none.
.\" ========================================================================
.SH MOUSELESS NAVIGATION
.B Olwm
implements OPEN LOOK Mouseless operations.  This is a set of functions bound
to keys that enable one to use the window system entirely without a pointing
device.  Some Mouseless functions are also useful for "cross-over" users,
who may want to use them as accelerators for mouse-based operations.  The
full benefits of Mouseless operations are realized in click-to-focus mode,
although the Mouseless operations can still be used in focus-follows-mouse
mode.
.LP
To use the Mouseless functions, you must make sure that the
.B KeyboardCommands
resource value is "Full".  Other settings for this resource will leave most
of the Mouseless functions disabled.  For further details, see the
description of the 
.B KeyboardCommands
resource in the Global Resources
section.  Enabling Mouseless operation only activates keyboard-based
functions.  It does not affect mouse functions in any way.
.LP
One can navigate from window to window using the Next Application, Previous
Application, Next Window, and Previous Window functions, bound by default to
Alt-n, Alt-Shift-n, Alt-w, and Alt-Shift-w, respectively.  (See the section
on Mouseless Navigation for more detailed information.)  You can bring up
both the window and the workspace menu using Alt-m and Alt-Shift-m,
respectively.  Once a menu is up, you can navigate through it by using the
arrow keys or by pressing the first letter of the menu item you want to go
to.  You can execute the current item by pressing Return, or you can cancel
the menu using Stop or Escape.
.LP
When Mouseless navigation is turned on, Move and Resize items will appear on
the window menu.  These items provide an alternative technique for moving
and resizing windows.  They can be invoked using the mouse, using the
Mouseless menu navigation functions from the keyboard, or by using Menu
Accelerator keys (although they are not bound to any accelerator keys by
default).  After selecting either of these items, you will be put into a
mode where you can move or resize the window using keyboard keys.  In Move
mode, you can use the arrow keys to move the window in the desired
direction.  You can also hold down the Control key to "jump" the window by a
larger distance each time you press an arrow key.  You can press Return to
accept the new location, or you can press Escape or Stop to abort the move
operation.
.LP
In Resize mode, the first arrow key selects the edge you are moving, and
subsequent arrow keys move that edge.  For example, to shrink a window from
the right (that is, to move its right edge to the left) you would first
enter resize mode, press the right arrow key to select the right edge, and
then press the left arrow key to move this edge to the left.  As in move
mode, you can hold down Control to "jump" the edge by a greater increment.
You can press Return to accept the new size, and you can press Escape or
Stop to abort the resize operation.
.\" ========================================================================
.SH MENU ACCELERATORS
.LP
.B Olwm
supports accelerator keys for certain items on the Window Menu.  By default,
the items for which accelerators are enabled are Close (Meta-W) and Quit
(Meta-Q).  Pressing these key combinations will operate on the window or
icon that has the input focus.  Other Window Menu items are not bound
to key combinations, but can be bound with resources.  See the Key Binding
Resources section (below) for further information.  When a menu accelerator
key is active for a particular function, an indication of this appears at
the right edge of the menu item.  Key combinations with modifiers are
displayed in a self-evident fashion, except for the Meta modifier, which is
displayed as a diamond mark.  (The meta keys are marked with diamonds on Sun
keyboards.)
.LP
The default menu accelerator bindings may conflict with certain popular
applications (such as Emacs or the Athena text widget).  It is thus possible
to disable menu accelerators on a per-application basis.
To disable menu accelerators, add a resource of the form
.nf
.sp
	olwm.Client.\fIclass\fP.MenuAccelerators: false
.sp
.fi
to the resource database, where \fIclass\fP is the application's class or
instance name as written in the WM_CLASS property.  For instance, to disable
menu accelerators for Emacs, one would add the following
.nf
.sp
	olwm.Client.Emacs.MenuAccelerators: false
.sp
.fi
to the \fB.Xdefaults\fP file.
.\" ========================================================================
.SH KEY BINDING RESOURCES
.LP
Key bindings for mouseless navigation functions and menu accelerator keys
are specified using resources.  There is one resource per function, and the
value of the resources are the keys to which the function is bound.  The
resource value consists of a comma-separated list of key specifications.
Each key specification consists of a keysym optionally followed by modifier
keysyms; the modifier keysyms are separated by `+' signs.  For example, to
bind a function to F2, control-F3, and alt-shift-F4, one would use the
value:
.nf
.sp
	F2,F3+Control,F4+Shift+Alt
.sp
.fi
.LP
Any keysym whose key is in the modifier mapping may be used as a modifier.
The following can also be used as aliases for common modifier keysyms:
.BR Shift ,
.BR Lock ,
.BR Control ,
.BR Ctrl ,
.BR Ctl ,
.BR Meta ,
.BR Alt ,
.BR Super ,
and
.B Hyper.
.LP
Resource names are prefixed with the trailing pathname component of
.BR argv[0] ,
followed by
.B KeyboardCommand
for mouseless navigation functions, or
.B MenuAccelerator
for menu accelerator keys, followed by one of the resource names from the
following list.  (Note that the
.B KeyboardCommand
resource component is singular, and is 
not to be confused with the
.B KeyboardCommands
global resource name.)  For example, the resource specification for setting
the Stop function would be:
.nf
.sp
	olwm.KeyboardCommand.Stop
.sp
.fi
and the resource specification for setting the Back menu accelerator
function would be:
.nf
.sp
	olwm.MenuAccelerator.Back
.sp
.fi
.LP
Each item
in this list is followed by its default keyboard binding and a
description of what the function does.  Items marked with an asterisk `*'
involve keyboard grabs.
Items not marked with an asterisk are active only while
.B olwm
is in a mode, such as when a menu is up.
Items marked with an exclamation point `!' are
menu accelerators and are specified using the
.B MenuAccelerator
resource component as described above.  Items not marked with an
exclamation point are considered mouseless navigation functions and use the
.B KeyboardCommand
resource component.
.LP
Most of the mouseless navigation functions that use grabs are active only
when the
.B KeyboardCommands
resource is set to
.B Full.
The menu accelerator functions all use grabs, and they are controlled
by the global resources
.B MenuAccelerators
and
.B WindowMenuAccelerators.
For further information,
see the description of these resources in the Global Resources section.
.TP
Stop \fI(L1, Escape)\fP
Abort the current mode or action.
.TP
DefaultAction \fI(Return, Meta-Return, Enter)\fP
Execute the default action for the current menu or notice.
.TP
Select \fI(space)\fP
Select the current button.
.TP
Adjust \fI(Alt-Insert)\fP
Toggle the selected state of the current object.
.TP
Menu \fI(Alt-space)\fP
Bring up a menu on the current object.
.TP
InputFocusHelp \fI(?, Control-?)\fP
Bring up Help on the object with the input focus.
.TP
Up \fI(up-arrow)\fP
Move up one item.
.TP
Down \fI(down-arrow)\fP
Move down one item.
.TP
Left \fI(left-arrow)\fP
Move left one item.
.TP
Right \fI(right-arrow)\fP
Move right one item.
.TP
JumpUp \fI(Control up-arrow)\fP
Move up ten items.
.TP
JumpDown \fI(Control down-arrow)\fP
Move down ten items.
.TP
JumpLeft \fI(Control left-arrow)\fP
Move left ten items.
.TP
JumpRight \fI(Control right-arrow)\fP
Move right ten items.
.TP
RowStart \fI(Home, R7)\fP
Move to the start of the current row.
.TP
RowEnd \fI(End, R13)\fP
Move to the end of the current row.
.TP
DataStart \fI(Control-Home)\fP
Move to the start of the data.
.TP
DataEnd \fI(Control-End)\fP
Move to the end of the data.
.TP
FirstControl \fI(Control-[)\fP
Move to the first item.
.TP
LastControl \fI(Control-])\fP
Move to the last item.
.TP
NextElement \fI(Tab, Control-Tab)\fP
Move to the next item.
.TP
PreviousElement \fI(Shift-Tab, Control-Shift-Tab)\fP
Move to the previous item.
.TP
Open \fI(Alt-L7)\fP *
Open the object with the input focus.
.TP
Help \fI(Help)\fP *
Bring up Spot Help on the object under the pointer.
.TP
LockColormap \fI(Control-L2)\fP *
Install the colormap of the subwindow under the pointer, and give the
colormap focus to the top-level window containing the pointer.  See
.I
Colormap Installation
for further details.
.TP
UnlockColormap \fI(Control-L4)\fP *
Revert to color-follows-mouse mode, and unset colormap focus.  See
.I
Colormap Installation
for further details.
.TP
Front \fI(Alt-L5)\fP *
Bring the object with the input focus to the front.
.TP
FocusToPointer \fI(Alt-Shift-j)\fP *
Set the focus to the window under the pointer.
.TP
NextApp \fI(Alt-n)\fP *
Move the focus to the next base window.  Windows are ordered clockwise
starting at the top.  Icons come after all windows, also in a clockwise
fashion.  Order proceeds from the last icon on a screen to the first window
of the next screen.  After the last screen, the order wraps back around to
the first screen.
.TP
PreviousApp \fI(Alt-Shift-n)\fP *
Move the focus to the previous base window.  See
.B NextApp
for details about the window traversal order.
.TP
ToggleInput \fI(Alt-t)\fP *
Move the input focus to the previous window that had the input focus.
.TP
NextWindow \fI(Alt-w)\fP *
Move to the next window in the family of windows consisting of a base window
and a set of pop-up windows.  Windows are ordered clockwise, starting at the
top of the screen.
.TP
PreviousWindow \fI(Alt-Shift-w)\fP *
Move to the previous window in the family of windows consisting of a base
window and a set of pop-up windows.  Windows are ordered clockwise, starting
at the top of the screen.
.TP
TogglePin \fI(Meta-Insert)\fP *
Toggle the state of the pin of the window with the input focus.
.TP
SuspendMouseless \fI(Alt-z)\fP *
Temporarily suspend all key grabs associated with Mouseless operation.
.TP
ResumeMouseless \fI(Alt-Shift-z)\fP *
Resume grabs after temporary suspension.
.TP
QuoteNextKey \fI(Alt-q)\fP *
Pass the next key sequence to the application with the focus, ignoring any
grabs.
.TP
Refresh \fI(no binding)\fP *!
Repaint the window with the focus.
.TP
Back \fI(no binding)\fP *!
Move the focus window behind other windows.
.TP
OpenClose \fI(Meta-W)\fP *!
Toggle the open/close state of the window with the focus.
.TP
FullRestore \fI(no binding)\fP *!
Toggle the full-sized/normal-sized state of the window with the focus.
.TP
Quit \fI(Meta-Q)\fP *!
Quit the window with the focus.
.TP
Owner \fI(no binding)\fP *!
Flash the owner window of the pop-up window with the focus.
.TP
WorkspaceMenu \fI(Alt-Shift-m)\fP *
Bring up the workspace menu.
.TP
WindowMenu \fI(Alt-m)\fP *
Bring up the window menu on the window with the focus.
.TP
Move \fI(no binding)\fP *!
Move the window with the focus.
.TP
Resize \fI(no binding)\fP *!
Resize the window with the focus.
.TP
OpenClosePointer \fI(L7)\fP *
Toggle the open/close state of the window or icon under the pointer.
.TP
RaiseLower \fI(L5)\fP *
Raise the window under the pointer if obscured by other windows.  Otherwise,
lower the window if it obscures other windows.
.\" ========================================================================
.SH MODIFIER CUSTOMIZATION
.B Olwm
will alter the operation of certain mouse-based functions based on the
state of the modifier keys.  The relationship between the alteration and the
associated modifier keys is controlled by a set of resources.
Resource names are prefixed with the trailing pathname component of
.BR argv[0] ,
followed by
.B Modifier,
followed by a resource from the list below.  For example, the resource 
specification to bind the Reduce modifier would typically be
.nf
.sp
	olwm.Modifier.Reduce
.sp
.fi
The value of each resource is a comma-separated list of modifier keysyms.
Each item in this list is followed by its default modifier and a description
of what it does.
.TP
Constrain \fI(Control)\fP
Constrain a move or resize operation to be only on a horizontal or vertical
direction.
.TP
Ignore \fI(Lock, NumLock, mod5, Mode_switch)\fP
The set of modifiers to be ignored when processing mouse button events.  This
resource should contain the set of locking modifiers, so that mouse actions
are still interpreted properly even while locking modifiers are in effect.
The \fImod5\fP modifier is included in this set because XView places
function keys into this row in the modifier mapping table for use with
quick-move and quick-copy operations.
.TP
Invert \fI(Shift)\fP
When moving windows, temporarily invert the sense of the
.B DragWindow
resource.  When resizing a window, temporarily move the window as long as
this modifier is held down.  Return to resizing when the modifier is
released.
.TP
Reduce \fI(Meta)\fP
When moving windows, reduce the amount of mouse motion by a factor of ten.
.TP
SetDefault \fI(Control)\fP
Sets the default item for a menu.
.TP
WMGrab \fI(Alt)\fP
Using the WMGrab modifier allows access to the mouse button functions
anywhere over the window, not just over the window's title bar and border.
.\" ========================================================================
.SH ENVIRONMENT
.TP
DISPLAY
Specifies the X11 server to which to connect.
.TP
LANG, LC_CTYPE, LC_MESSAGE, LC_TIME
These variables specify which locale to use when other methods of locale
announcement are not available.  (See the section on Locale Handling for
more details.)
.TP
OLWMMENU
Specifies a file to use for the Workspace Menu.
.TP
OPENWINHOME
Specifies the location of the OpenWindows software.
.\" ========================================================================
.SH FILES
.TP
$HOME/.openwin\-menu\fI.localename\fP
.TP
$HOME/.openwin\-menu
Contains the user-customized Workspace Menu specification.
.TP
$OPENWINHOME/lib/openwin\-menu.\fIlocale-name\fP
.TP
$OPENWINHOME/lib/openwin\-menu
Contains the default Workspace Menu specification.
.TP
$HOME/.openwin\-init
Stores the command lines obtained during the Save Workspace operation.
.TP
$OPENWINHOME/lib/app\-defaults/Olwm
.TP
$OPENWINHOME/lib/locale/\fIlocale-name\fP/app\-defaults/Olwm
Specifies system-wide default resource values.
.\" ========================================================================
.SH TRADEMARKS
.LP
OPEN LOOK is a trademark of AT&T.
.br
The X Window system is a trademark of the Massachusetts Institute of
Technology.
.br
OpenWindows is a trademark of Sun Microsystems, Inc.
.\" ========================================================================
.SH REFERENCES
.LP
Rosenthal, David S.H.
.I Inter-Client Communication Conventions Manual for X11.
Copyright 1989 by the Massachusetts
Institute of Technology.  This document is commonly known as the ICCCM.  It
is an X Consortium Standard that specifies conventions to which all X11
clients must adhere.
.LP
OPEN LOOK Graphical User Interface Functional Specification.  Copyright 1989
by Sun Microsystems, Inc.  Addison-Wesley Publishing Company, Inc.  ISBN
0\-201\-52365\-5.
.LP
OPEN LOOK Graphical User Interface
International Extensions Functional Specification.
Draft 1.1 (May 10, 1990).
Copyright 1990 by Unix International.
.SH SEE ALSO
.LP
.BR dsdm (1),
.BR olwmslave (1),
.BR openwin (1),
.BR owplaces (1),
.BR setlocale (3C),
.BR xinit (1),
.BR xnews (1)
.\" ========================================================================
.SH NOTES
.LP
The resource names do not follow any classing structure.  There is no
general way to specify resources on a per-client basis.
.LP
There is no way to reconfigure the mouse buttons.
.LP
The uses of the modifier keys described in the Modifier Customization
section interferes with the button bindings for one- and two-button mice.
The default value of Modifier.Invert is Shift, which interferes with using
shift-button1 for ADJUST.  The default value of Modifier.Constrain is
Control, which interferes with using control-button1 for MENU (on one-button
mice only).  One can set the Modifier.Invert and Modifier.Constrain
resources to null (or to other modifiers) to avoid these conflicts, allowing
full access to ADJUST and MENU on systems with one- and two-button mice.
There is still a further conflict, as the default value of
Modifier.SetDefault is also Control.  Using control-button1 on a one-button
system will bring up the menu, but will set the menu's default item.  One
must release the Control key after the menu is up in order to get normal
menu operation.  The choice of Alt as the default value for Modifier.WMGrab
may conflict with some applications' key bindings.
.LP
The Exit menu item on the Workspace Menu doesn't really shut down the
server.  It kills off all clients being managed by the window manager, and
then it exits the window manager itself.  This works properly
if some outside agent such as
.BR xinit (1)
or
.BR xdm (1)
is waiting for the window manager or a client to exit.  The outside agent
will take care of shutting down the server or reinitializing it.  If you've
started up the server a different way, this option may not work.  Instead,
the server will be left running with no clients and no window manager
running, and you will have to login from elsewhere to kill the server.  A
common cause of this problem is an \fB.xinitrc\fP script that inadvertently
leaves a non-windowed application (such as a daemon) running in the
background.  If the \fB.xinitrc\fP script ends with the \fBwait\fP shell
command, it will never terminate.  The fix is to change the script to either
wait for a particular process-id, or to run the daemon in a subshell:
.nf
.sp
	(daemon &)
.sp
.fi
.LP
.B Olwm
is fairly simplistic about how it manages its keyboard bindings.  For
example, if you bind a function to control-F2,
.B olwm
will grab F2 with the Control modifier and with all combinations of the Lock
and NumLock modifiers.  If another locking modifier is in effect,
.BR olwm 's
passive grab will not be activated, and thus the function will not work.
.LP
.B Olwm
cannot manage multiple locales at one time,
therefore all clients should be running in the same locale.
The "C" locale is the exception.  Applications using the "C" locale (such as
non-internationalized applications) can be mixed with applications using one
other locale.
.LP
.B Olwm
does not handle different sizes of the glyph fonts well.
Each locale can define a different size for the default font
(for example, the default glyph font size is 12 for the
"C" locale and is 14 for the "japanese" locale).
.B Olwm
does not re-position the window decorations after switching locale,
therefore the window decorations may appear
to be wrong.
To remedy this problem partially,
.B olwm
will not change the font when locale is switching from
non-"C" locale to the "C" locale.
.LP
There is no input focus feedback for non-rectangular windows.  The title
string of non-rectangular windows cannot be displayed.  Non-rectangular icon
windows are not supported.
.LP
.B Olwm
will not dynamically track screen-specific and client-specific resources.
Changes to global resources, key binding resources, and modifier resources
are applied dynamically.
.LP
The interaction of the
.BR AutoColorFocus ,
.BR ColorFocusLocked ,
and
.B ColorTracksInputFocus
resources and the color locking and unlocking keys is overly complex.
.LP
Changing the Display Language locale setting or editing the menu
specification file will cause
.B olwm
to unpin any menus that were pinned at the time.
.LP
Resources that specify time values use inconsistent units.  Some resources
are in tenths of a second, some are in milliseconds, and some are in
microseconds.
