/* identify.c  -  Translate label names to kernel paths */

/* 
Copyright 1992-1998 Werner Almesberger.
Copyright 1999-2003 John Coffman.
All rights reserved.

Licensed under the terms contained in the file 'COPYING' in the 
source directory.

*/


#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "lilo.h"
#include "common.h"
#include "cfg.h"


static char *identify,*opt;


static void do_identify(char *var,char type)
{
    char *label,*path,*alias,*initrd,*keytab;
    int image, ramdisk,kt;

#if 1
    image = !!strchr(opt,'i');
    ramdisk = !!strchr(opt,'r');
    kt = !!strchr(opt,'k');
    if (opt && !image && !ramdisk && !kt) exit(1);
    if (!opt) image = 1;
#else
    image = ramdisk = 1;
    printf("do_identify:  opt=\"%s\"\n", opt);
#endif
    
    label = strrchr(path = cfg_get_strg(cf_identify,var),'/');
    if (label) label++;
    if (cfg_get_strg(cf_all,"label")) label = cfg_get_strg(cf_all,"label");
    else if (!label) label = path;
    alias = cfg_get_strg(cf_all,"alias");
    initrd = cfg_get_strg(cf_kernel,"initrd");
    keytab = cfg_get_strg(cf_options,"keytable");
    if (!keytab) keytab="us.ktl";
#ifdef LCF_IGNORECASE
    if (!strcasecmp(label,identify) || (alias && !strcasecmp(alias,identify))) {
#else
    if (!strcmp(label,identify) || (alias && !strcmp(alias,identify))) {
#endif
	if (image) printf("%s\n",path);
	if (ramdisk) printf("%s\n",initrd?initrd:"No initial ramdisk specified");
	if (kt) printf("%s\n",keytab);
	exit(0);
    }
}


void id_image(void)
{
    cfg_init(cf_image);
    (void) cfg_parse(cf_image);
    do_identify("image",'i');
    cfg_init(cf_identify);
}


void id_other(void)
{
    cfg_init(cf_other);
    cfg_init(cf_kernel);
    curr_drv_map = curr_prt_map = 0;
    (void) cfg_parse(cf_other);
    cfg_init(cf_identify);
}


void identify_image(char *label,char *options)
{
    identify = label;
    opt = options;
    cfg_init(cf_identify);
    if (cfg_parse(cf_identify)) cfg_error("Syntax error");
    fprintf(errstd,"No image found for \"%s\"\n",label);
    exit(1);
}
