/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.util;

import com.sun.security.sasl.preview.SaslException;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class SaslImpl {
    protected static final boolean debug = false;
    protected static final boolean verbose = false;
    protected boolean completed = false;
    protected boolean privacy = false;
    protected boolean integrity = false;
    protected byte[] qop;
    protected byte allQop;
    protected byte[] strength;
    protected int sendMaxBufSize = 0;
    protected int recvMaxBufSize = 65536;
    protected int rawSendSize;
    protected static final String MAX_SEND_BUF = "javax.security.sasl.sendmaxbuffer";
    protected static final byte NO_PROTECTION = 1;
    protected static final byte INTEGRITY_ONLY_PROTECTION = 2;
    protected static final byte PRIVACY_PROTECTION = 4;
    protected static final byte LOW_STRENGTH = 1;
    protected static final byte MEDIUM_STRENGTH = 2;
    protected static final byte HIGH_STRENGTH = 4;
    private static final byte[] DEFAULT_QOP = new byte[]{1};
    private static final String[] QOP_TOKENS = new String[]{"auth-conf", "auth-int", "auth"};
    private static final byte[] QOP_MASKS = new byte[]{4, 2, 1};
    private static final byte[] DEFAULT_STRENGTH = new byte[]{4, 2, 1};
    private static final String[] STRENGTH_TOKENS = new String[]{"low", "medium", "high"};
    private static final byte[] STRENGTH_MASKS = new byte[]{1, 2, 4};

    protected SaslImpl(Map map) throws SaslException {
        if (map != null) {
            this.qop = this.parseQop((String)map.get("javax.security.sasl.qop"));
            this.allQop = SaslImpl.combineMasks(this.qop);
            this.strength = this.parseStrength((String)map.get("javax.security.sasl.strength"));
            String string = (String)map.get("javax.security.sasl.maxbuffer");
            if (string != null) {
                try {
                    this.recvMaxBufSize = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.maxbuffer");
                }
            }
            if ((string = (String)map.get(MAX_SEND_BUF)) != null) {
                try {
                    this.sendMaxBufSize = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.sendmaxbuffer");
                }
            }
        } else {
            this.qop = DEFAULT_QOP;
            this.strength = STRENGTH_MASKS;
        }
    }

    protected static byte combineMasks(byte[] byArray) {
        byte by = 0;
        int n = 0;
        while (n < byArray.length) {
            by = (byte)(by | byArray[n]);
            ++n;
        }
        return by;
    }

    protected static byte findPreferredMask(byte by, byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & by) != 0) {
                return byArray[n];
            }
            ++n;
        }
        return 0;
    }

    protected byte[] parseQop(String string) throws SaslException {
        return this.parseQop(string, null, false);
    }

    protected byte[] parseQop(String string, String[] stringArray, boolean bl) throws SaslException {
        if (string == null) {
            return DEFAULT_QOP;
        }
        return this.parseProp("javax.security.sasl.qop", string, QOP_TOKENS, QOP_MASKS, stringArray, bl);
    }

    protected byte[] parseStrength(String string) throws SaslException {
        if (string == null) {
            return DEFAULT_STRENGTH;
        }
        return this.parseProp("javax.security.sasl.strength", string, STRENGTH_TOKENS, STRENGTH_MASKS, null, false);
    }

    protected byte[] parseProp(String string, String string2, String[] stringArray, byte[] byArray, String[] stringArray2, boolean bl) throws SaslException {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \t\n");
        byte[] byArray2 = new byte[stringArray.length];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 < byArray2.length) {
            String string3 = stringTokenizer.nextToken();
            boolean bl2 = false;
            n = 0;
            while (!bl2 && n < stringArray.length) {
                if (string3.equalsIgnoreCase(stringArray[n])) {
                    bl2 = true;
                    byArray2[n2++] = byArray[n];
                    if (stringArray2 != null) {
                        stringArray2[n] = string3;
                    }
                }
                ++n;
            }
            if (bl2 || bl) continue;
            throw new SaslException("Invalid token in " + string + ": " + string2);
        }
        n = n2;
        while (n < byArray2.length) {
            byArray2[n] = 0;
            ++n;
        }
        return byArray2;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public String getNegotiatedProperty(String string) throws SaslException {
        if (!this.completed) {
            throw new SaslException("Not completed");
        }
        if (string.equals("javax.security.sasl.qop")) {
            if (this.privacy) {
                return "auth-conf";
            }
            if (this.integrity) {
                return "auth-int";
            }
            return "auth";
        }
        if (string.equals("javax.security.sasl.maxbuffer")) {
            return Integer.toString(this.recvMaxBufSize);
        }
        if (string.equals("javax.security.sasl.rawsendsize")) {
            return Integer.toString(this.rawSendSize);
        }
        if (string.equals(MAX_SEND_BUF)) {
            return Integer.toString(this.sendMaxBufSize);
        }
        return null;
    }

    public static final void traceOutput(String string, byte[] byArray) {
        SaslImpl.traceOutput(string, byArray, 0, byArray.length);
    }

    public static final void traceOutput(String string, byte[] byArray, int n, int n2) {
    }

    public static int networkByteOrderToInt(byte[] byArray, int n, int n2) {
        if (n2 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 <<= 8;
            n3 |= byArray[n + n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    public static void intToNetworkByteOrder(int n, byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n4 = n3 - 1;
        while (n4 >= 0) {
            byArray[n2 + n4] = (byte)(n & 0xFF);
            n >>>= 8;
            --n4;
        }
    }
}

