/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class GSSHeader {
    private ObjectIdentifier mechOid = null;
    private byte[] mechOidBytes = null;
    private int mechTokenLength = 0;
    public static final int TOKEN_ID = 96;

    public GSSHeader(ObjectIdentifier objectIdentifier, int n2) throws IOException {
        this.mechOid = objectIdentifier;
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(objectIdentifier);
        this.mechOidBytes = derOutputStream.toByteArray();
        this.mechTokenLength = n2;
    }

    public GSSHeader(InputStream inputStream) throws IOException, GSSException {
        int n2 = inputStream.read();
        if (n2 != 96) {
            throw new GSSException(10, -1, "GSSHeader did not find the right tag");
        }
        int n3 = this.getLength(inputStream);
        DerValue derValue = new DerValue(inputStream);
        this.mechOidBytes = derValue.toByteArray();
        this.mechOid = derValue.getOID();
        this.mechTokenLength = n3 - this.mechOidBytes.length;
    }

    public ObjectIdentifier getOid() {
        return this.mechOid;
    }

    public int getMechTokenLength() {
        return this.mechTokenLength;
    }

    public int getLength() {
        int n2 = this.mechOidBytes.length + this.mechTokenLength;
        return 1 + this.getLenFieldSize(n2) + this.mechOidBytes.length;
    }

    public static int getMaxMechTokenSize(ObjectIdentifier objectIdentifier, int n2) {
        int n3 = 0;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            n3 = derOutputStream.toByteArray().length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n2 -= 1 + n3;
        return n2 -= 5;
    }

    private int getLenFieldSize(int n2) {
        int n3 = 1;
        n3 = n2 < 128 ? 1 : (n2 < 256 ? 2 : (n2 < 65536 ? 3 : (n2 < 0x1000000 ? 4 : 5)));
        return n3;
    }

    public int encode(OutputStream outputStream) throws IOException {
        int n2 = 1 + this.mechOidBytes.length;
        outputStream.write(96);
        int n3 = this.mechOidBytes.length + this.mechTokenLength;
        outputStream.write(this.mechOidBytes);
        return n2 += this.putLength(n3, outputStream);
    }

    private int getLength(InputStream inputStream) throws IOException {
        return this.getLength(inputStream.read(), inputStream);
    }

    private int getLength(int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4 = n2;
        if ((n4 & 0x80) == 0) {
            n3 = n4;
        } else {
            if ((n4 &= 0x7F) == 0) {
                return -1;
            }
            if (n4 < 0 || n4 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n4 + ", " + (n4 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n3 = 0;
            while (n4 > 0) {
                n3 <<= 8;
                n3 += 0xFF & inputStream.read();
                --n4;
            }
        }
        return n3;
    }

    private int putLength(int n2, OutputStream outputStream) throws IOException {
        int n3 = 0;
        if (n2 < 128) {
            outputStream.write((byte)n2);
            n3 = 1;
        } else if (n2 < 256) {
            outputStream.write(-127);
            outputStream.write((byte)n2);
            n3 = 2;
        } else if (n2 < 65536) {
            outputStream.write(-126);
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)n2);
            n3 = 3;
        } else if (n2 < 0x1000000) {
            outputStream.write(-125);
            outputStream.write((byte)(n2 >> 16));
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)n2);
            n3 = 4;
        } else {
            outputStream.write(-124);
            outputStream.write((byte)(n2 >> 24));
            outputStream.write((byte)(n2 >> 16));
            outputStream.write((byte)(n2 >> 8));
            outputStream.write((byte)n2);
            n3 = 5;
        }
        return n3;
    }

    private void debug(String string) {
        System.err.print(string);
    }

    private String getHexBytes(byte[] byArray, int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n3] >> 4 & 0xF;
            int n5 = byArray[n3] & 0xF;
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(Integer.toHexString(n5));
            stringBuffer.append(' ');
            ++n3;
        }
        return stringBuffer.toString();
    }
}

