/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.runtime;

import java.security.AccessController;
import java.util.LinkedList;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.NewThreadAction;
import sun.security.action.GetLongAction;

final class ThreadPool
implements Executor {
    private static final long idleTimeout = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.jrmp.idleThreadTimeout", 300000L));
    private final ThreadGroup threadGroup;
    private final Object lock = new Object();
    private int totalThreads = 0;
    private int idleThreads = 0;
    private final LinkedList queue = new LinkedList();

    ThreadPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, String string) {
        Task task = new Task(runnable, string);
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() < this.idleThreads) {
                this.queue.addLast(task);
                this.lock.notify();
            } else {
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(task), string, true));
                thread.start();
                ++this.totalThreads;
            }
        }
    }

    private class Worker
    implements Runnable {
        private Task first;

        Worker(Task task) {
            this.first = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Task task = this.first;
                this.first = null;
                while (true) {
                    task.runnable.run();
                    Object object = ThreadPool.this.lock;
                    synchronized (object) {
                        if (ThreadPool.this.queue.isEmpty()) {
                            block14: {
                                Object var5_4;
                                Thread.currentThread().setName("RMI Idle");
                                ThreadPool.this.idleThreads++;
                                try {
                                    try {
                                        ThreadPool.this.lock.wait(idleTimeout);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        var5_4 = null;
                                        ThreadPool.this.idleThreads--;
                                        break block14;
                                    }
                                    var5_4 = null;
                                }
                                catch (Throwable throwable) {
                                    var5_4 = null;
                                    ThreadPool.this.idleThreads--;
                                    throw throwable;
                                }
                                ThreadPool.this.idleThreads--;
                            }
                            if (ThreadPool.this.queue.isEmpty()) {
                                // MONITOREXIT @DISABLED, blocks:[0, 6, 11, 12, 13] lbl33 : MonitorExitStatement: MONITOREXIT : object
                                Object var8_6 = null;
                                break;
                            }
                        }
                        task = (Task)ThreadPool.this.queue.removeFirst();
                        Thread.currentThread().setName("RMI " + task.name);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Object object = ThreadPool.this.lock;
                synchronized (object) {
                    ThreadPool.this.totalThreads--;
                    throw throwable;
                }
            }
            Object object = ThreadPool.this.lock;
            synchronized (object) {
                ThreadPool.this.totalThreads--;
                return;
            }
        }
    }

    private static class Task {
        final Runnable runnable;
        final String name;

        Task(Runnable runnable, String string) {
            this.runnable = runnable;
            this.name = string;
        }
    }
}

