/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLED = 3;
    private int state = -1;
    private SocketAddress localAddress = null;
    private SocketAddress remoteAddress = null;
    private boolean isInputOpen = true;
    private boolean isOutputOpen = true;
    private boolean readyToConnect = false;
    private SocketOpts.IP.TCP options = null;
    private Socket socket = null;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$SocketChannelImpl;

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 2;
        this.remoteAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n4;
            int n2;
            block24: {
                if (!this.ensureReadOpen()) {
                    return -1;
                }
                n2 = 0;
                this.begin();
                if (this.isOpen()) break block24;
                int n3 = 0;
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (n2 <= 0 && !this.isInputOpen) {
                        return -1;
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            try {
                this.readerThread = NativeThread.current();
                while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
                }
                n4 = IOStatus.normalize(n2);
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
            }
            catch (Throwable throwable) {
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (n2 <= 0 && !this.isInputOpen) {
                        return -1;
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            Object object4 = this.stateLock;
            synchronized (object4) {
                if (n2 <= 0 && !this.isInputOpen) {
                    return -1;
                }
            }
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private int read0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n4;
            int n2;
            block24: {
                if (!this.ensureReadOpen()) {
                    return -1;
                }
                n2 = 0;
                this.begin();
                if (this.isOpen()) break block24;
                int n3 = 0;
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (n2 <= 0 && !this.isInputOpen) {
                        return -1;
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            try {
                this.readerThread = NativeThread.current();
                while ((n2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3 && this.isOpen()) {
                }
                n4 = IOStatus.normalize(n2);
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
            }
            catch (Throwable throwable) {
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (n2 <= 0 && !this.isInputOpen) {
                        return -1;
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            Object object4 = this.stateLock;
            synchronized (object4) {
                if (n2 <= 0 && !this.isInputOpen) {
                    return -1;
                }
            }
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n4;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n4;
            int n2;
            block23: {
                this.ensureWriteOpen();
                n2 = 0;
                this.begin();
                if (this.isOpen()) break block23;
                int n3 = 0;
                this.writerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (n2 <= 0 && !this.isOutputOpen) {
                        throw new AsynchronousCloseException();
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((n2 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
                }
                n4 = IOStatus.normalize(n2);
                this.writerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
            }
            catch (Throwable throwable) {
                this.writerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (n2 <= 0 && !this.isOutputOpen) {
                        throw new AsynchronousCloseException();
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            Object object4 = this.stateLock;
            synchronized (object4) {
                if (n2 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
            }
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int write0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n4;
            int n2;
            block23: {
                this.ensureWriteOpen();
                n2 = 0;
                this.begin();
                if (this.isOpen()) break block23;
                int n3 = 0;
                this.end(n2 > 0 || n2 == -2);
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (n2 <= 0 && !this.isOutputOpen) {
                        throw new AsynchronousCloseException();
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((n2 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3 && this.isOpen()) {
                }
                n4 = IOStatus.normalize(n2);
                this.end(n2 > 0 || n2 == -2);
            }
            catch (Throwable throwable) {
                this.end(n2 > 0 || n2 == -2);
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (n2 <= 0 && !this.isOutputOpen) {
                        throw new AsynchronousCloseException();
                    }
                }
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            Object object4 = this.stateLock;
            synchronized (object4) {
                if (n2 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
            }
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n4;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n2, n3));
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher dispatcher = new SocketOptsImpl.Dispatcher(){

                    int getInt(int n2) throws IOException {
                        return Net.getIntOption(SocketChannelImpl.this.fd, n2);
                    }

                    void setInt(int n2, int n3) throws IOException {
                        Net.setIntOption(SocketChannelImpl.this.fd, n2, n3);
                    }
                };
                this.options = new SocketOptsImpl.IP.TCP(dispatcher);
            }
            return this.options;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2 && this.localAddress == null) {
                this.localAddress = Net.localAddress(this.fd);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpenAndUnconnected();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(SocketAddress socketAddress) throws IOException {
        int n2 = 0;
        boolean bl2 = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.ensureOpenAndUnconnected();
                InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                Object object3 = this.blockingLock();
                synchronized (object3) {
                    int n3 = 0;
                    try {
                        try {
                            this.begin();
                            if (this.isOpen()) {
                                this.readerThread = NativeThread.current();
                                while ((n3 = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n2)) == -3 && this.isOpen()) {
                                }
                            }
                            this.end(n3 > 0 || n3 == -2);
                        }
                        catch (Throwable throwable) {
                            this.end(n3 > 0 || n3 == -2);
                            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                                throw new AssertionError();
                            }
                            throw throwable;
                        }
                        if (!$assertionsDisabled && !IOStatus.check(n3)) {
                            throw new AssertionError();
                        }
                    }
                    catch (IOException iOException) {
                        this.close();
                        throw iOException;
                    }
                    Object object4 = this.stateLock;
                    synchronized (object4) {
                        this.remoteAddress = inetSocketAddress;
                        if (n3 > 0) {
                            this.state = 2;
                            return true;
                        }
                        if (!this.isBlocking()) {
                            this.state = 1;
                        } else if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishConnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3;
                Object object4 = this.stateLock;
                synchronized (object4) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (this.state == 2) {
                        return true;
                    }
                    if (this.state != 1) {
                        throw new NoConnectionPendingException();
                    }
                }
                int n2 = 0;
                try {
                    try {
                        this.begin();
                        if (this.isOpen()) {
                            object3 = this.blockingLock();
                            synchronized (object3) {
                                if (!this.isBlocking()) {
                                    while ((n2 = SocketChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                                    }
                                } else {
                                    while ((n2 = SocketChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n2 == -3 && this.isOpen()) {
                                    }
                                }
                            }
                        }
                        this.end(n2 > 0 || n2 == -2);
                    }
                    catch (Throwable throwable) {
                        this.end(n2 > 0 || n2 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n2)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                    if (!$assertionsDisabled && !IOStatus.check(n2)) {
                        throw new AssertionError();
                    }
                }
                catch (IOException iOException) {
                    this.close();
                    throw iOException;
                }
                if (n2 > 0) {
                    object3 = this.stateLock;
                    synchronized (object3) {
                        this.state = 2;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isInputOpen = false;
            SocketChannelImpl.shutdown(this.fd, 0);
            long l2 = this.readerThread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isOutputOpen = false;
            SocketChannelImpl.shutdown(this.fd, 1);
            long l2 = this.writerThread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            nd.preClose(this.fd);
            long l2 = this.readerThread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
            if ((l2 = this.writerThread) != 0L) {
                NativeThread.signal(l2);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                return;
            }
            if (this.state == -1) {
                this.state = 3;
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.state = 3;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((n2 & 0x18) != 0) {
            selectionKeyImpl.readyOps(selectionKeyImpl.interestOps());
            this.readyToConnect = true;
            return;
        }
        if ((n2 & 1) != 0 && (selectionKeyImpl.interestOps() & 1) != 0 && this.state == 2) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0 && (selectionKeyImpl.interestOps() & 8) != 0) {
            n3 |= 8;
            this.readyToConnect = true;
        }
        if ((n2 & 4) != 0 && (selectionKeyImpl.interestOps() & 4) != 0 && this.state == 2) {
            n3 |= 4;
        }
        selectionKeyImpl.readyOps(n3);
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 8) != 0) {
            n3 |= 4;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n3);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSuperclass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        stringBuffer.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("connected");
                        if (!this.isInputOpen) {
                            stringBuffer.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        stringBuffer.append(" oshut");
                    }
                }
                if (this.localAddress() != null) {
                    stringBuffer.append(" local=");
                    stringBuffer.append(this.localAddress().toString());
                }
                if (this.remoteAddress() != null) {
                    stringBuffer.append(" remote=");
                    stringBuffer.append(this.remoteAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    private static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$SocketChannelImpl == null ? (class$sun$nio$ch$SocketChannelImpl = SocketChannelImpl.class$("sun.nio.ch.SocketChannelImpl")) : class$sun$nio$ch$SocketChannelImpl).desiredAssertionStatus();
        Util.load();
        nd = new SocketDispatcher();
    }
}

