/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectorImpl;

class SelectionKeyImpl
extends AbstractSelectionKey {
    final SelChImpl channel;
    final SelectorImpl selector;
    private int index;
    private int interestOps;
    private int readyOps;

    SelectionKeyImpl(SelChImpl selChImpl, SelectorImpl selectorImpl) {
        this.channel = selChImpl;
        this.selector = selectorImpl;
    }

    public SelectableChannel channel() {
        return (SelectableChannel)((Object)this.channel);
    }

    public Selector selector() {
        return this.selector;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int n2) {
        this.index = n2;
    }

    private void ensureValid() {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int interestOps() {
        this.ensureValid();
        SelectorImpl selectorImpl = this.selector;
        synchronized (selectorImpl) {
            return this.interestOps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey interestOps(int n2) {
        this.ensureValid();
        SelectorImpl selectorImpl = this.selector;
        synchronized (selectorImpl) {
            if ((n2 & ~this.channel().validOps()) != 0) {
                throw new IllegalArgumentException();
            }
            this.channel.translateAndSetInterestOps(n2, this);
            this.interestOps = n2;
        }
        return this;
    }

    public int readyOps() {
        this.ensureValid();
        return this.readyOps;
    }

    void readyOps(int n2) {
        this.readyOps = n2;
    }
}

