/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class DTMDefaultBase
implements DTM {
    protected int m_size = 0;
    protected SuballocatedIntVector m_exptype;
    protected SuballocatedIntVector m_firstch;
    protected SuballocatedIntVector m_nextsib;
    protected SuballocatedIntVector m_prevsib;
    protected SuballocatedIntVector m_parent;
    protected Vector m_namespaceDeclSets = null;
    protected SuballocatedIntVector m_namespaceDeclSetElements = null;
    protected int[][][] m_elemIndexes;
    protected int m_initialblocksize = 512;
    protected int m_blocksize = 2048;
    protected static final int NOTPROCESSED = -2;
    protected DTMManager m_mgr;
    protected int m_dtmIdent;
    protected static final int m_mask = 0x3FFFFF;
    protected String m_documentBaseURI;
    protected DTMWSFilter m_wsfilter;
    protected boolean m_shouldStripWS = false;
    protected BoolStack m_shouldStripWhitespaceStack;
    protected XMLStringFactory m_xstrf;
    public static final int ROOTNODE = 0;
    protected ExpandedNameTable m_expandedNameTable;
    protected boolean m_indexing;
    protected DTMAxisTraverser[] m_traversers;
    private Vector m_namespaceLists = null;

    public DTMDefaultBase(DTMManager dTMManager, Source source, int n2, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl2) {
        if (!bl2) {
            this.m_initialblocksize = 8;
            this.m_blocksize = 16;
        }
        this.m_exptype = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_firstch = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_nextsib = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_prevsib = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_parent = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_mgr = dTMManager;
        this.m_documentBaseURI = null != source ? source.getSystemId() : null;
        this.m_dtmIdent = n2;
        this.m_wsfilter = dTMWSFilter;
        this.m_xstrf = xMLStringFactory;
        this.m_indexing = bl2;
        if (bl2) {
            this.m_expandedNameTable = new ExpandedNameTable();
        } else {
            DTMManagerDefault dTMManagerDefault = (DTMManagerDefault)this.m_mgr;
            this.m_expandedNameTable = dTMManagerDefault.getExpandedNameTable(this);
        }
        if (null != dTMWSFilter) {
            this.m_shouldStripWhitespaceStack = new BoolStack();
            this.pushShouldStripWhitespace(false);
        }
    }

    protected void ensureSizeOfIndex(int n2, int n3) {
        Object object;
        Object object2;
        if (null == this.m_elemIndexes) {
            this.m_elemIndexes = new int[n2 + 20][][];
        } else if (this.m_elemIndexes.length <= n2) {
            object2 = this.m_elemIndexes;
            this.m_elemIndexes = new int[n2 + 20][][];
            System.arraycopy(object2, 0, this.m_elemIndexes, 0, ((int[][][])object2).length);
        }
        object2 = this.m_elemIndexes[n2];
        if (null == object2) {
            object2 = new int[n3 + 100][];
            this.m_elemIndexes[n2] = (int[][])object2;
        } else if (((int[][][])object2).length <= n3) {
            object = object2;
            object2 = new int[n3 + 100][];
            System.arraycopy(object, 0, object2, 0, ((int[][][])object).length);
            this.m_elemIndexes[n2] = (int[][])object2;
        }
        object = object2[n3];
        if (null == object) {
            object = new int[128];
            object2[n3] = (int[][])object;
            object[0] = (int[][])true;
        } else if (((int[][][])object).length <= object[0] + true) {
            Object object3 = object;
            object = new int[object[0] + 1024];
            System.arraycopy(object3, 0, object, 0, ((int[][][])object3).length);
            object2[n3] = (int[][])object;
        }
    }

    protected void indexNode(int n2, int n3) {
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        short s2 = ExpandedNameTable.getType(n2);
        if (1 == s2) {
            int n4 = ExpandedNameTable.getNamespaceID(n2);
            int n5 = ExpandedNameTable.getLocalNameID(n2);
            this.ensureSizeOfIndex(n4, n5);
            int[] nArray = this.m_elemIndexes[n4][n5];
            nArray[nArray[0]] = n3;
            nArray[0] = nArray[0] + 1;
        }
    }

    protected int findGTE(int[] nArray, int n2, int n3, int n4) {
        int n5;
        int n6 = n2;
        int n7 = n5 = n2 + (n3 - 1);
        while (n6 <= n5) {
            int n8 = (n6 + n5) / 2;
            int n9 = nArray[n8];
            if (n9 > n4) {
                n5 = n8 - 1;
                continue;
            }
            if (n9 < n4) {
                n6 = n8 + 1;
                continue;
            }
            return n8;
        }
        return n6 <= n7 && nArray[n6] > n4 ? n6 : -1;
    }

    int findElementFromIndex(int n2, int n3, int n4) {
        int n5;
        int[] nArray;
        int[][] nArray2;
        int[][][] nArray3 = this.m_elemIndexes;
        if (null != nArray3 && n2 < nArray3.length && null != (nArray2 = nArray3[n2]) && n3 < nArray2.length && null != (nArray = nArray2[n3]) && (n5 = this.findGTE(nArray, 1, nArray[0], n4)) > -1) {
            return nArray[n5];
        }
        return -2;
    }

    protected abstract int getNextNodeIdentity(int var1);

    protected abstract boolean nextNode();

    protected abstract int getNumberOfNodes();

    protected short _type(int n2) {
        int n3 = this.getExpandedTypeID(n2);
        if (-1 != n3) {
            return ExpandedNameTable.getType(n3);
        }
        return -1;
    }

    protected int _exptype(int n2) {
        while (n2 >= this.m_size) {
            if (this.nextNode() || n2 < this.m_size) continue;
            return -1;
        }
        return this.m_exptype.elementAt(n2);
    }

    protected int _level(int n2) {
        int n3;
        while (n2 >= this.m_size) {
            n3 = this.nextNode();
            if (n3 != 0 || n2 < this.m_size) continue;
            return -1;
        }
        n3 = 0;
        while (-1 != (n2 = this._parent(n2))) {
            ++n3;
        }
        return n3;
    }

    protected int _firstch(int n2) {
        int n3 = n2 >= this.m_size ? -2 : this.m_firstch.elementAt(n2);
        while (n3 == -2) {
            boolean bl2 = this.nextNode();
            if (n2 >= this.m_size && !bl2) {
                return -1;
            }
            n3 = this.m_firstch.elementAt(n2);
            if (n3 != -2 || bl2) continue;
            return -1;
        }
        return n3;
    }

    protected int _nextsib(int n2) {
        int n3 = n2 >= this.m_size ? -2 : this.m_nextsib.elementAt(n2);
        while (n3 == -2) {
            boolean bl2 = this.nextNode();
            if (n2 >= this.m_size && !bl2) {
                return -1;
            }
            n3 = this.m_nextsib.elementAt(n2);
            if (n3 != -2 || bl2) continue;
            return -1;
        }
        return n3;
    }

    protected int _prevsib(int n2) {
        if (n2 < this.m_size) {
            return this.m_prevsib.elementAt(n2);
        }
        do {
            boolean bl2 = this.nextNode();
            if (n2 < this.m_size || bl2) continue;
            return -1;
        } while (n2 >= this.m_size);
        return this.m_prevsib.elementAt(n2);
    }

    protected int _parent(int n2) {
        if (n2 < this.m_size) {
            return this.m_parent.elementAt(n2);
        }
        do {
            boolean bl2 = this.nextNode();
            if (n2 < this.m_size || bl2) continue;
            return -1;
        } while (n2 >= this.m_size);
        return this.m_parent.elementAt(n2);
    }

    public void dumpDTM() {
        try {
            File file = new File("DTMDump" + this.hashCode() + ".txt");
            System.err.println("Dumping... " + file.getAbsolutePath());
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            while (this.nextNode()) {
            }
            int n2 = this.m_size;
            printStream.println("Total nodes: " + n2);
            int n3 = 0;
            while (n3 < n2) {
                String string;
                printStream.println("=========== " + n3 + " ===========");
                printStream.println("NodeName: " + this.getNodeName(n3));
                printStream.println("NodeNameX: " + this.getNodeNameX(n3));
                printStream.println("LocalName: " + this.getLocalName(n3));
                printStream.println("NamespaceURI: " + this.getNamespaceURI(n3));
                printStream.println("Prefix: " + this.getPrefix(n3));
                int n4 = this.getExpandedTypeID(n3);
                printStream.println("Expanded Type ID: " + Integer.toHexString(n4));
                short s2 = this.getNodeType(n3);
                switch (s2) {
                    case 2: {
                        string = "ATTRIBUTE_NODE";
                        break;
                    }
                    case 4: {
                        string = "CDATA_SECTION_NODE";
                        break;
                    }
                    case 8: {
                        string = "COMMENT_NODE";
                        break;
                    }
                    case 11: {
                        string = "DOCUMENT_FRAGMENT_NODE";
                        break;
                    }
                    case 9: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 10: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 1: {
                        string = "ELEMENT_NODE";
                        break;
                    }
                    case 6: {
                        string = "ENTITY_NODE";
                        break;
                    }
                    case 5: {
                        string = "ENTITY_REFERENCE_NODE";
                        break;
                    }
                    case 13: {
                        string = "NAMESPACE_NODE";
                        break;
                    }
                    case 12: {
                        string = "NOTATION_NODE";
                        break;
                    }
                    case -1: {
                        string = "NULL";
                        break;
                    }
                    case 7: {
                        string = "PROCESSING_INSTRUCTION_NODE";
                        break;
                    }
                    case 3: {
                        string = "TEXT_NODE";
                        break;
                    }
                    default: {
                        string = "Unknown!";
                    }
                }
                printStream.println("Type: " + string);
                int n5 = this._firstch(n3);
                if (-1 == n5) {
                    printStream.println("First child: DTM.NULL");
                } else if (-2 == n5) {
                    printStream.println("First child: NOTPROCESSED");
                } else {
                    printStream.println("First child: " + n5);
                }
                int n6 = this._prevsib(n3);
                if (-1 == n6) {
                    printStream.println("Prev sibling: DTM.NULL");
                } else if (-2 == n6) {
                    printStream.println("Prev sibling: NOTPROCESSED");
                } else {
                    printStream.println("Prev sibling: " + n6);
                }
                int n7 = this._nextsib(n3);
                if (-1 == n7) {
                    printStream.println("Next sibling: DTM.NULL");
                } else if (-2 == n7) {
                    printStream.println("Next sibling: NOTPROCESSED");
                } else {
                    printStream.println("Next sibling: " + n7);
                }
                int n8 = this._parent(n3);
                if (-1 == n8) {
                    printStream.println("Parent: DTM.NULL");
                } else if (-2 == n8) {
                    printStream.println("Parent: NOTPROCESSED");
                } else {
                    printStream.println("Parent: " + n8);
                }
                int n9 = this._level(n3);
                printStream.println("Level: " + n9);
                printStream.println("Node Value: " + this.getNodeValue(n3));
                printStream.println("String Value: " + this.getStringValue(n3));
                ++n3;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public String dumpNode(int n2) {
        String string;
        if (n2 == -1) {
            return "[null]";
        }
        switch (this.getNodeType(n2)) {
            case 2: {
                string = "ATTR";
                break;
            }
            case 4: {
                string = "CDATA";
                break;
            }
            case 8: {
                string = "COMMENT";
                break;
            }
            case 11: {
                string = "DOC_FRAG";
                break;
            }
            case 9: {
                string = "DOC";
                break;
            }
            case 10: {
                string = "DOC_TYPE";
                break;
            }
            case 1: {
                string = "ELEMENT";
                break;
            }
            case 6: {
                string = "ENTITY";
                break;
            }
            case 5: {
                string = "ENT_REF";
                break;
            }
            case 13: {
                string = "NAMESPACE";
                break;
            }
            case 12: {
                string = "NOTATION";
                break;
            }
            case -1: {
                string = "null";
                break;
            }
            case 7: {
                string = "PI";
                break;
            }
            case 3: {
                string = "TEXT";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + n2 + ": " + string + "(0x" + Integer.toHexString(this.getExpandedTypeID(n2)) + ") " + this.getNodeNameX(n2) + " {" + this.getNamespaceURI(n2) + "}" + "=\"" + this.getNodeValue(n2) + "\"]");
        return stringBuffer.toString();
    }

    public void setFeature(String string, boolean bl2) {
    }

    public boolean hasChildNodes(int n2) {
        int n3 = n2 & 0x3FFFFF;
        int n4 = this._firstch(n3);
        return n4 != -1;
    }

    public int getFirstChild(int n2) {
        int n3 = n2 & 0x3FFFFF;
        int n4 = this._firstch(n3);
        return n4 | this.m_dtmIdent;
    }

    public int getLastChild(int n2) {
        int n3 = n2 & 0x3FFFFF;
        int n4 = this._firstch(n3);
        int n5 = -1;
        while (n4 != -1) {
            n5 = n4;
            n4 = this._nextsib(n4);
        }
        return n5 | this.m_dtmIdent;
    }

    public abstract int getAttributeNode(int var1, String var2, String var3);

    public int getFirstAttribute(int n2) {
        short s2 = this.getNodeType(n2);
        if (1 == s2) {
            int n3 = n2 & 0x3FFFFF;
            while (-1 != (n3 = this.getNextNodeIdentity(n3))) {
                s2 = this.getNodeType(n3);
                if (s2 == 2) {
                    return n3 | this.m_dtmIdent;
                }
                if (13 != s2) break;
            }
        }
        return -1;
    }

    public int getNextSibling(int n2) {
        return this._nextsib(n2 & 0x3FFFFF) | this.m_dtmIdent;
    }

    public int getPreviousSibling(int n2) {
        return this._prevsib(n2 & 0x3FFFFF) | this.m_dtmIdent;
    }

    public int getNextAttribute(int n2) {
        short s2 = this.getNodeType(n2);
        if (2 == s2) {
            int n3 = n2 & 0x3FFFFF;
            while (-1 != (n3 = this.getNextNodeIdentity(n3))) {
                s2 = this.getNodeType(n3);
                if (s2 == 2) {
                    return n3 | this.m_dtmIdent;
                }
                if (s2 != 13) break;
            }
        }
        return -1;
    }

    protected void declareNamespaceInContext(int n2, int n3) {
        int n4;
        int n5;
        SuballocatedIntVector suballocatedIntVector = null;
        if (this.m_namespaceDeclSets == null) {
            this.m_namespaceDeclSetElements = new SuballocatedIntVector();
            this.m_namespaceDeclSetElements.addElement(n2);
            this.m_namespaceDeclSets = new Vector();
            suballocatedIntVector = new SuballocatedIntVector();
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
        } else {
            n5 = this.m_namespaceDeclSetElements.size() - 1;
            if (n2 == this.m_namespaceDeclSetElements.elementAt(n5)) {
                suballocatedIntVector = (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n5);
            }
        }
        if (suballocatedIntVector == null) {
            this.m_namespaceDeclSetElements.addElement(n2);
            suballocatedIntVector = new SuballocatedIntVector();
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
            SuballocatedIntVector suballocatedIntVector2 = this.findNamespaceContext(this._parent(n2));
            if (suballocatedIntVector2 != null) {
                n4 = suballocatedIntVector2.size();
                int n6 = 0;
                while (n6 < n4) {
                    suballocatedIntVector.addElement(suballocatedIntVector2.elementAt(n6));
                    ++n6;
                }
            }
        }
        n5 = this.getExpandedTypeID(n3);
        n4 = suballocatedIntVector.size() - 1;
        while (n4 >= 0) {
            if (n5 == this.getExpandedTypeID(suballocatedIntVector.elementAt(n4))) {
                suballocatedIntVector.setElementAt(n3 | this.m_dtmIdent, n4);
                return;
            }
            --n4;
        }
        suballocatedIntVector.addElement(n3 | this.m_dtmIdent);
    }

    protected SuballocatedIntVector findNamespaceContext(int n2) {
        if (null != this.m_namespaceDeclSetElements) {
            int n3 = this.findInSortedSuballocatedIntVector(this.m_namespaceDeclSetElements, n2);
            if (n3 >= 0) {
                return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n3);
            }
            if (n3 == -1) {
                return null;
            }
            n3 = -1 - n3;
            int n4 = this.m_namespaceDeclSetElements.elementAt(--n3);
            int n5 = this._parent(n2);
            while (n3 >= 0 && n5 > 0) {
                n4 = this.m_namespaceDeclSetElements.elementAt(n3);
                if (n4 == n5) {
                    return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n3);
                }
                if (n4 < n5) {
                    n5 = this._parent(n5);
                    continue;
                }
                --n3;
            }
        }
        return null;
    }

    protected int findInSortedSuballocatedIntVector(SuballocatedIntVector suballocatedIntVector, int n2) {
        int n3 = 0;
        if (suballocatedIntVector != null) {
            int n4 = 0;
            int n5 = suballocatedIntVector.size() - 1;
            while (n4 <= n5) {
                n3 = (n4 + n5) / 2;
                int n6 = n2 - suballocatedIntVector.elementAt(n3);
                if (n6 == 0) {
                    return n3;
                }
                if (n6 < 0) {
                    n5 = n3 - 1;
                    continue;
                }
                n4 = n3 + 1;
            }
            if (n4 > n3) {
                n3 = n4;
            }
        }
        return -1 - n3;
    }

    public int getFirstNamespaceNode(int n2, boolean bl2) {
        if (bl2) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n2 & 0x3FFFFF);
            if (suballocatedIntVector == null || suballocatedIntVector.size() < 1) {
                return -1;
            }
            return suballocatedIntVector.elementAt(0) | this.m_dtmIdent;
        }
        int n3 = n2 & 0x3FFFFF;
        while (-1 != (n3 = this.getNextNodeIdentity(n3))) {
            short s2 = this.getNodeType(n3);
            if (s2 == 13) {
                return n3 | this.m_dtmIdent;
            }
            if (2 != s2) break;
        }
        return -1;
    }

    public int getNextNamespaceNode(int n2, int n3, boolean bl2) {
        if (bl2) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n2 & 0x3FFFFF);
            if (suballocatedIntVector == null) {
                return -1;
            }
            int n4 = 1 + suballocatedIntVector.indexOf(n3);
            if (n4 <= 0 || n4 == suballocatedIntVector.size()) {
                return -1;
            }
            return suballocatedIntVector.elementAt(n4) | this.m_dtmIdent;
        }
        int n5 = n3 & 0x3FFFFF;
        while (-1 != (n5 = this.getNextNodeIdentity(n5))) {
            short s2 = this.getNodeType(n5);
            if (s2 == 13) {
                return n5 | this.m_dtmIdent;
            }
            if (s2 != 2) break;
        }
        return -1;
    }

    public int getParent(int n2) {
        int n3 = n2 & 0x3FFFFF;
        if (n3 > 0) {
            return this._parent(n3) | this.m_dtmIdent;
        }
        return -1;
    }

    public int getDocument() {
        return this.m_dtmIdent;
    }

    public int getOwnerDocument(int n2) {
        short s2 = this.getNodeType(n2);
        if (9 == s2) {
            return -1;
        }
        return this.getDocument();
    }

    public abstract XMLString getStringValue(int var1);

    public int getStringValueChunkCount(int n2) {
        this.error(XSLMessages.createMessage(210, null));
        return 0;
    }

    public char[] getStringValueChunk(int n2, int n3, int[] nArray) {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    public int getExpandedTypeID(int n2) {
        return this._exptype(n2 & 0x3FFFFF);
    }

    public int getExpandedTypeID(String string, String string2, int n2) {
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        return expandedNameTable.getExpandedTypeID(string, string2, n2);
    }

    public String getLocalNameFromExpandedNameID(int n2) {
        return this.m_expandedNameTable.getLocalName(n2);
    }

    public String getNamespaceFromExpandedNameID(int n2) {
        return this.m_expandedNameTable.getNamespace(n2);
    }

    public int getNamespaceType(int n2) {
        int n3 = n2 & 0x3FFFFF;
        int n4 = this._exptype(n3);
        return ExpandedNameTable.getNamespaceID(n4);
    }

    public abstract String getNodeName(int var1);

    public String getNodeNameX(int n2) {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    public abstract String getLocalName(int var1);

    public abstract String getPrefix(int var1);

    public abstract String getNamespaceURI(int var1);

    public abstract String getNodeValue(int var1);

    public short getNodeType(int n2) {
        return (short)(this._exptype(n2 & 0x3FFFFF) >> ExpandedNameTable.ROTAMOUNT_TYPE);
    }

    public short getLevel(int n2) {
        int n3 = n2 & 0x3FFFFF;
        return (short)(this._level(n3) + 1);
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getDocumentBaseURI() {
        return this.m_documentBaseURI;
    }

    public void setDocumentBaseURI(String string) {
        this.m_documentBaseURI = string;
    }

    public String getDocumentSystemIdentifier(int n2) {
        return this.m_documentBaseURI;
    }

    public String getDocumentEncoding(int n2) {
        return "UTF-8";
    }

    public String getDocumentStandalone(int n2) {
        return null;
    }

    public String getDocumentVersion(int n2) {
        return null;
    }

    public boolean getDocumentAllDeclarationsProcessed() {
        return true;
    }

    public abstract String getDocumentTypeDeclarationSystemIdentifier();

    public abstract String getDocumentTypeDeclarationPublicIdentifier();

    public abstract int getElementById(String var1);

    public abstract String getUnparsedEntityURI(String var1);

    public boolean supportsPreStripping() {
        return true;
    }

    public boolean isNodeAfter(int n2, int n3) {
        if ((n2 & 0xFFC00000) != (n3 & 0xFFC00000)) {
            return false;
        }
        int n4 = n2 & 0x3FFFFF;
        int n5 = n3 & 0x3FFFFF;
        return n4 <= n5;
    }

    public boolean isCharacterElementContentWhitespace(int n2) {
        return false;
    }

    public boolean isDocumentAllDeclarationsProcessed(int n2) {
        return true;
    }

    public abstract boolean isAttributeSpecified(int var1);

    public abstract void dispatchCharactersEvents(int var1, ContentHandler var2, boolean var3) throws SAXException;

    public abstract void dispatchToEvents(int var1, ContentHandler var2) throws SAXException;

    public Node getNode(int n2) {
        return new DTMNodeProxy(this, n2);
    }

    public void appendChild(int n2, boolean bl2, boolean bl3) {
        this.error(XSLMessages.createMessage(210, null));
    }

    public void appendTextChild(String string) {
        this.error(XSLMessages.createMessage(210, null));
    }

    protected void error(String string) {
        throw new DTMException(string);
    }

    protected boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS;
    }

    protected void pushShouldStripWhitespace(boolean bl2) {
        this.m_shouldStripWS = bl2;
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWhitespaceStack.push(bl2);
        }
    }

    protected void popShouldStripWhitespace() {
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
    }

    protected void setShouldStripWhitespace(boolean bl2) {
        this.m_shouldStripWS = bl2;
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWhitespaceStack.setTop(bl2);
        }
    }

    public void documentRegistration() {
    }

    public void documentRelease() {
    }
}

