/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    public IdentityHashMap() {
        this.init(32);
    }

    public IdentityHashMap(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n2);
        }
        this.init(this.capacity(n2));
    }

    private int capacity(int n2) {
        int n3;
        int n4 = 3 * n2 / 2;
        if (n4 > 0x20000000 || n4 < 0) {
            n3 = 0x20000000;
        } else {
            n3 = 4;
            while (n3 < n4) {
                n3 <<= 1;
            }
        }
        return n3;
    }

    private void init(int n2) {
        this.threshold = n2 * 2 / 3;
        this.table = new Object[2 * n2];
    }

    public IdentityHashMap(Map map) {
        this((int)((double)(1 + map.size()) * 1.1));
        this.putAll(map);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n2) {
        int n3 = System.identityHashCode(object);
        return (n3 << 1) - (n3 << 8) & n2 - 1;
    }

    private static int nextKeyIndex(int n2, int n3) {
        return n2 + 2 < n3 ? n2 + 2 : 0;
    }

    public Object get(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        Object object3;
        while ((object3 = objectArray[n3]) != object2) {
            if (object3 == null) {
                return object3;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return objectArray[n3 + 1];
    }

    public boolean containsKey(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        Object object3;
        while ((object3 = objectArray[n3]) != object2) {
            if (object3 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return true;
    }

    public boolean containsValue(Object object) {
        Object[] objectArray = this.table;
        int n2 = 1;
        while (n2 < objectArray.length) {
            if (objectArray[n2] == object) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    private boolean containsMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object3, n2);
        Object object4;
        while ((object4 = objectArray[n3]) != object3) {
            if (object4 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return objectArray[n3 + 1] == object2;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object4, n2);
        while ((object3 = objectArray[n3]) != null) {
            if (object3 == object4) {
                Object object5 = objectArray[n3 + 1];
                objectArray[n3 + 1] = object2;
                return object5;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        ++this.modCount;
        objectArray[n3] = object4;
        objectArray[n3 + 1] = object2;
        if (++this.size >= this.threshold) {
            this.resize(n2);
        }
        return null;
    }

    private void resize(int n2) {
        int n3 = n2 * 2;
        Object[] objectArray = this.table;
        int n4 = objectArray.length;
        if (n4 == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n4 >= n3) {
            return;
        }
        Object[] objectArray2 = new Object[n3];
        this.threshold = n3 / 3;
        int n5 = 0;
        while (n5 < n4) {
            Object object = objectArray[n5];
            if (object != null) {
                Object object2 = objectArray[n5 + 1];
                objectArray[n5] = null;
                objectArray[n5 + 1] = null;
                int n6 = IdentityHashMap.hash(object, n3);
                while (objectArray2[n6] != null) {
                    n6 = IdentityHashMap.nextKeyIndex(n6, n3);
                }
                objectArray2[n6] = object;
                objectArray2[n6 + 1] = object2;
            }
            n5 += 2;
        }
        this.table = objectArray2;
    }

    public void putAll(Map map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            this.resize(this.capacity(n2));
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        while (true) {
            Object object3;
            if ((object3 = objectArray[n3]) == object2) {
                ++this.modCount;
                --this.size;
                Object object4 = objectArray[n3 + 1];
                objectArray[n3 + 1] = null;
                objectArray[n3] = null;
                this.closeDeletion(n3);
                return object4;
            }
            if (object3 == null) {
                return null;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    private boolean removeMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object3, n2);
        while (true) {
            Object object4;
            if ((object4 = objectArray[n3]) == object3) {
                if (objectArray[n3 + 1] != object2) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                objectArray[n3] = null;
                objectArray[n3 + 1] = null;
                this.closeDeletion(n3);
                return true;
            }
            if (object4 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    private void closeDeletion(int n2) {
        Object object;
        Object[] objectArray = this.table;
        int n3 = objectArray.length;
        int n4 = IdentityHashMap.nextKeyIndex(n2, n3);
        while ((object = objectArray[n4]) != null) {
            int n5 = IdentityHashMap.hash(object, n3);
            if (n4 < n5 && (n5 <= n2 || n2 <= n4) || n5 <= n2 && n2 <= n4) {
                objectArray[n2] = object;
                objectArray[n2 + 1] = objectArray[n4 + 1];
                objectArray[n4] = null;
                objectArray[n4 + 1] = null;
                n2 = n4;
            }
            n4 = IdentityHashMap.nextKeyIndex(n4, n3);
        }
    }

    public void clear() {
        ++this.modCount;
        Object[] objectArray = this.table;
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray[n2] = null;
            ++n2;
        }
        this.size = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashMap) {
            IdentityHashMap identityHashMap = (IdentityHashMap)object;
            if (identityHashMap.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashMap.table;
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object2 = objectArray[n2];
                if (object2 != null && !this.containsMapping(object2, objectArray[n2 + 1])) {
                    return false;
                }
                n2 += 2;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        Object[] objectArray = this.table;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Object object = objectArray[n3];
            if (object != null) {
                Object object2 = IdentityHashMap.unmaskNull(object);
                n2 += System.identityHashCode(object2) ^ System.identityHashCode(objectArray[n3 + 1]);
            }
            n3 += 2;
        }
        return n2;
    }

    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.entrySet = null;
            identityHashMap.table = (Object[])this.table.clone();
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    public Collection values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values();
        return this.values;
    }

    public Set entrySet() {
        Set set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Object[] objectArray = this.table;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (object != null) {
                objectOutputStream.writeObject(IdentityHashMap.unmaskNull(object));
                objectOutputStream.writeObject(objectArray[n2 + 1]);
            }
            n2 += 2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.init(this.capacity(n2 * 4 / 3));
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        public int size() {
            return IdentityHashMap.this.size;
        }

        public void clear() {
            IdentityHashMap.this.clear();
        }

        public boolean removeAll(Collection collection) {
            boolean bl2 = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry((Map.Entry)iterator.next()));
            }
            return arrayList.toArray(objectArray);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return IdentityHashMap.this.size;
        }

        public boolean contains(Object object) {
            return IdentityHashMap.this.containsValue(object);
        }

        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != object) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public void clear() {
            IdentityHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return IdentityHashMap.this.size;
        }

        public boolean contains(Object object) {
            return IdentityHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            int n2 = IdentityHashMap.this.size;
            IdentityHashMap.this.remove(object);
            return IdentityHashMap.this.size != n2;
        }

        public boolean removeAll(Collection collection) {
            boolean bl2 = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        public void clear() {
            IdentityHashMap.this.clear();
        }

        public int hashCode() {
            int n2 = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                n2 += System.identityHashCode(iterator.next());
            }
            return n2;
        }
    }

    private class EntryIterator
    extends IdentityHashMapIterator
    implements Map.Entry {
        private EntryIterator() {
        }

        public Object next() {
            this.nextIndex();
            return this;
        }

        public Object getKey() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return IdentityHashMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        public Object getValue() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.traversalTable[this.lastReturnedIndex + 1];
        }

        public Object setValue(Object object) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            Object object2 = this.traversalTable[this.lastReturnedIndex + 1];
            this.traversalTable[this.lastReturnedIndex + 1] = object;
            if (this.traversalTable != IdentityHashMap.this.table) {
                IdentityHashMap.this.put(this.traversalTable[this.lastReturnedIndex], object);
            }
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return entry.getKey() == this.getKey() && entry.getValue() == this.getValue();
        }

        public int hashCode() {
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class ValueIterator
    extends IdentityHashMapIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    private class KeyIterator
    extends IdentityHashMapIterator {
        private KeyIterator() {
        }

        public Object next() {
            return IdentityHashMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    private abstract class IdentityHashMapIterator
    implements Iterator {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = IdentityHashMap.this.size != 0 ? 0 : IdentityHashMap.this.table.length;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashMap.this.table;
        }

        public boolean hasNext() {
            Object[] objectArray = this.traversalTable;
            int n2 = this.index;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                if (object != null) {
                    this.index = n2;
                    this.indexValid = true;
                    return true;
                }
                n2 += 2;
            }
            this.index = objectArray.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        public void remove() {
            Object object;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashMap.this.modCount;
            int n2 = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            IdentityHashMap.this.size--;
            this.index = n2;
            this.indexValid = false;
            Object[] objectArray = this.traversalTable;
            int n3 = objectArray.length;
            int n4 = n2;
            Object object2 = objectArray[n4];
            objectArray[n4] = null;
            objectArray[n4 + 1] = null;
            if (objectArray != IdentityHashMap.this.table) {
                IdentityHashMap.this.remove(object2);
                this.expectedModCount = IdentityHashMap.this.modCount;
                return;
            }
            int n5 = IdentityHashMap.nextKeyIndex(n4, n3);
            while ((object = objectArray[n5]) != null) {
                int n6 = IdentityHashMap.hash(object, n3);
                if (n5 < n6 && (n6 <= n4 || n4 <= n5) || n6 <= n4 && n4 <= n5) {
                    if (n5 < n2 && n4 >= n2 && this.traversalTable == IdentityHashMap.this.table) {
                        int n7 = n3 - n2;
                        Object[] objectArray2 = new Object[n7];
                        System.arraycopy(objectArray, n2, objectArray2, 0, n7);
                        this.traversalTable = objectArray2;
                        this.index = 0;
                    }
                    objectArray[n4] = object;
                    objectArray[n4 + 1] = objectArray[n5 + 1];
                    objectArray[n5] = null;
                    objectArray[n5 + 1] = null;
                    n4 = n5;
                }
                n5 = IdentityHashMap.nextKeyIndex(n5, n3);
            }
        }
    }
}

