/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Date;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRLEntry)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRLEntry)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] != byArray2[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CRLException cRLException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n3 = 1;
            while (n3 < byArray.length) {
                n2 += byArray[n3] * n3;
                ++n3;
            }
        }
        catch (CRLException cRLException) {
            return n2;
        }
        return n2;
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();
}

