/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;

public class CertPathValidatorException
extends GeneralSecurityException {
    private int index = -1;
    private CertPath certPath;

    public CertPathValidatorException() {
    }

    public CertPathValidatorException(String string) {
        super(string);
    }

    public CertPathValidatorException(Throwable throwable) {
        this.initCause(throwable);
    }

    public CertPathValidatorException(String string, Throwable throwable) {
        super(string);
        this.initCause(throwable);
    }

    public CertPathValidatorException(String string, Throwable throwable, CertPath certPath, int n2) {
        this(string, throwable);
        if (certPath == null && n2 != -1) {
            throw new IllegalArgumentException();
        }
        if (n2 < -1 || certPath != null && n2 >= certPath.getCertificates().size()) {
            throw new IndexOutOfBoundsException();
        }
        this.certPath = certPath;
        this.index = n2;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getIndex() {
        return this.index;
    }

    public Throwable getCause() {
        return super.getCause();
    }

    public String toString() {
        if (this.getCause() == null) {
            return super.toString();
        }
        return super.toString() + "; internal cause is: \n\t" + this.getCause().toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }
}

