/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.SignedMutableBigInteger;

class MutableBigInteger {
    int[] value;
    int intLen;
    int offset = 0;
    private static final long LONG_MASK = 0xFFFFFFFFL;

    MutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    MutableBigInteger(int n2) {
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = n2;
    }

    MutableBigInteger(int[] nArray, int n2) {
        this.value = nArray;
        this.intLen = n2;
    }

    MutableBigInteger(int[] nArray) {
        this.value = nArray;
        this.intLen = nArray.length;
    }

    MutableBigInteger(BigInteger bigInteger) {
        this.value = (int[])bigInteger.mag.clone();
        this.intLen = this.value.length;
    }

    MutableBigInteger(MutableBigInteger mutableBigInteger) {
        this.intLen = mutableBigInteger.intLen;
        this.value = new int[this.intLen];
        int n2 = 0;
        while (n2 < this.intLen) {
            this.value[n2] = mutableBigInteger.value[mutableBigInteger.offset + n2];
            ++n2;
        }
    }

    void clear() {
        this.intLen = 0;
        this.offset = 0;
        int n2 = 0;
        int n3 = this.value.length;
        while (n2 < n3) {
            this.value[n2] = 0;
            ++n2;
        }
    }

    void reset() {
        this.intLen = 0;
        this.offset = 0;
    }

    final int compare(MutableBigInteger mutableBigInteger) {
        if (this.intLen < mutableBigInteger.intLen) {
            return -1;
        }
        if (this.intLen > mutableBigInteger.intLen) {
            return 1;
        }
        int n2 = 0;
        while (n2 < this.intLen) {
            int n3 = this.value[this.offset + n2] + Integer.MIN_VALUE;
            int n4 = mutableBigInteger.value[mutableBigInteger.offset + n2] + Integer.MIN_VALUE;
            if (n3 < n4) {
                return -1;
            }
            if (n3 > n4) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    private final int getLowestSetBit() {
        if (this.intLen == 0) {
            return -1;
        }
        int n2 = this.intLen - 1;
        while (n2 > 0 && this.value[n2 + this.offset] == 0) {
            --n2;
        }
        int n3 = this.value[n2 + this.offset];
        if (n3 == 0) {
            return -1;
        }
        return (this.intLen - 1 - n2 << 5) + BigInteger.trailingZeroCnt(n3);
    }

    private final int getInt(int n2) {
        return this.value[this.offset + n2];
    }

    private final long getLong(int n2) {
        return (long)this.value[this.offset + n2] & 0xFFFFFFFFL;
    }

    final void normalize() {
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int n2 = this.offset;
        if (this.value[n2] != 0) {
            return;
        }
        int n3 = n2 + this.intLen;
        while (++n2 < n3 && this.value[n2] == 0) {
        }
        int n4 = n2 - this.offset;
        this.intLen -= n4;
        this.offset = this.intLen == 0 ? 0 : this.offset + n4;
    }

    private final void ensureCapacity(int n2) {
        if (this.value.length < n2) {
            this.value = new int[n2];
            this.offset = 0;
            this.intLen = n2;
        }
    }

    int[] toIntArray() {
        int[] nArray = new int[this.intLen];
        int n2 = 0;
        while (n2 < this.intLen) {
            nArray[n2] = this.value[this.offset + n2];
            ++n2;
        }
        return nArray;
    }

    void setInt(int n2, int n3) {
        this.value[this.offset + n2] = n3;
    }

    void setValue(int[] nArray, int n2) {
        this.value = nArray;
        this.intLen = n2;
        this.offset = 0;
    }

    void copyValue(MutableBigInteger mutableBigInteger) {
        int n2 = mutableBigInteger.intLen;
        if (this.value.length < n2) {
            this.value = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.value[n3] = mutableBigInteger.value[mutableBigInteger.offset + n3];
            ++n3;
        }
        this.intLen = n2;
        this.offset = 0;
    }

    void copyValue(int[] nArray) {
        int n2 = nArray.length;
        if (this.value.length < n2) {
            this.value = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.value[n3] = nArray[n3];
            ++n3;
        }
        this.intLen = n2;
        this.offset = 0;
    }

    boolean isOne() {
        return this.intLen == 1 && this.value[this.offset] == 1;
    }

    boolean isZero() {
        return this.intLen == 0;
    }

    boolean isEven() {
        return this.intLen == 0 || (this.value[this.offset + this.intLen - 1] & 1) == 0;
    }

    boolean isOdd() {
        return (this.value[this.offset + this.intLen - 1] & 1) == 1;
    }

    boolean isNormal() {
        if (this.intLen + this.offset > this.value.length) {
            return false;
        }
        if (this.intLen == 0) {
            return true;
        }
        return this.value[this.offset] != 0;
    }

    public String toString() {
        BigInteger bigInteger = new BigInteger(this, 1);
        return bigInteger.toString();
    }

    void rightShift(int n2) {
        if (this.intLen == 0) {
            return;
        }
        int n3 = n2 >>> 5;
        int n4 = n2 & 0x1F;
        this.intLen -= n3;
        if (n4 == 0) {
            return;
        }
        int n5 = BigInteger.bitLen(this.value[this.offset]);
        if (n4 >= n5) {
            this.primitiveLeftShift(32 - n4);
            --this.intLen;
        } else {
            this.primitiveRightShift(n4);
        }
    }

    void leftShift(int n2) {
        if (this.intLen == 0) {
            return;
        }
        int n3 = n2 >>> 5;
        int n4 = n2 & 0x1F;
        int n5 = BigInteger.bitLen(this.value[this.offset]);
        if (n2 <= 32 - n5) {
            this.primitiveLeftShift(n4);
            return;
        }
        int n6 = this.intLen + n3 + 1;
        if (n4 <= 32 - n5) {
            --n6;
        }
        if (this.value.length < n6) {
            int[] nArray = new int[n6];
            int n7 = 0;
            while (n7 < this.intLen) {
                nArray[n7] = this.value[this.offset + n7];
                ++n7;
            }
            this.setValue(nArray, n6);
        } else if (this.value.length - this.offset >= n6) {
            int n8 = 0;
            while (n8 < n6 - this.intLen) {
                this.value[this.offset + this.intLen + n8] = 0;
                ++n8;
            }
        } else {
            int n9 = 0;
            while (n9 < this.intLen) {
                this.value[n9] = this.value[this.offset + n9];
                ++n9;
            }
            int n10 = this.intLen;
            while (n10 < n6) {
                this.value[n10] = 0;
                ++n10;
            }
            this.offset = 0;
        }
        this.intLen = n6;
        if (n4 == 0) {
            return;
        }
        if (n4 <= 32 - n5) {
            this.primitiveLeftShift(n4);
        } else {
            this.primitiveRightShift(32 - n4);
        }
    }

    private int divadd(int[] nArray, int[] nArray2, int n2) {
        long l2 = 0L;
        int n3 = nArray.length - 1;
        while (n3 >= 0) {
            long l3 = ((long)nArray[n3] & 0xFFFFFFFFL) + ((long)nArray2[n3 + n2] & 0xFFFFFFFFL) + l2;
            nArray2[n3 + n2] = (int)l3;
            l2 = l3 >>> 32;
            --n3;
        }
        return (int)l2;
    }

    private int mulsub(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = 0L;
        n4 += n3;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            long l4 = ((long)nArray2[n5] & 0xFFFFFFFFL) * l2 + l3;
            long l5 = (long)nArray[n4] - l4;
            nArray[n4--] = (int)l5;
            l3 = (l4 >>> 32) + (long)((l5 & 0xFFFFFFFFL) > ((long)(~((int)l4)) & 0xFFFFFFFFL) ? 1 : 0);
            --n5;
        }
        return (int)l3;
    }

    private final void primitiveRightShift(int n2) {
        int[] nArray = this.value;
        int n3 = 32 - n2;
        int n4 = this.offset + this.intLen - 1;
        int n5 = nArray[n4];
        while (n4 > this.offset) {
            int n6 = n5;
            n5 = nArray[n4 - 1];
            nArray[n4] = n5 << n3 | n6 >>> n2;
            --n4;
        }
        int n7 = this.offset;
        nArray[n7] = nArray[n7] >>> n2;
    }

    private final void primitiveLeftShift(int n2) {
        int[] nArray = this.value;
        int n3 = 32 - n2;
        int n4 = this.offset;
        int n5 = nArray[n4];
        int n6 = n4 + this.intLen - 1;
        while (n4 < n6) {
            int n7 = n5;
            n5 = nArray[n4 + 1];
            nArray[n4] = n7 << n2 | n5 >>> n3;
            ++n4;
        }
        int n8 = this.offset + this.intLen - 1;
        nArray[n8] = nArray[n8] << n2;
    }

    void add(MutableBigInteger mutableBigInteger) {
        int n2 = this.intLen;
        int n3 = mutableBigInteger.intLen;
        int n4 = this.intLen > mutableBigInteger.intLen ? this.intLen : mutableBigInteger.intLen;
        int[] nArray = this.value.length < n4 ? new int[n4] : this.value;
        int n5 = nArray.length - 1;
        long l2 = 0L;
        while (n2 > 0 && n3 > 0) {
            l2 = ((long)this.value[--n2 + this.offset] & 0xFFFFFFFFL) + ((long)mutableBigInteger.value[--n3 + mutableBigInteger.offset] & 0xFFFFFFFFL) + (l2 >>> 32);
            nArray[n5--] = (int)l2;
        }
        while (n2 > 0) {
            l2 = ((long)this.value[--n2 + this.offset] & 0xFFFFFFFFL) + (l2 >>> 32);
            nArray[n5--] = (int)l2;
        }
        while (n3 > 0) {
            l2 = ((long)mutableBigInteger.value[--n3 + mutableBigInteger.offset] & 0xFFFFFFFFL) + (l2 >>> 32);
            nArray[n5--] = (int)l2;
        }
        if (l2 >>> 32 > 0L) {
            if (nArray.length < ++n4) {
                int[] nArray2 = new int[n4];
                int n6 = n4 - 1;
                while (n6 > 0) {
                    nArray2[n6] = nArray[n6 - 1];
                    --n6;
                }
                nArray2[0] = 1;
                nArray = nArray2;
            } else {
                nArray[n5--] = 1;
            }
        }
        this.value = nArray;
        this.intLen = n4;
        this.offset = nArray.length - n4;
    }

    int subtract(MutableBigInteger mutableBigInteger) {
        int n2;
        MutableBigInteger mutableBigInteger2 = this;
        int[] nArray = this.value;
        int n3 = mutableBigInteger2.compare(mutableBigInteger);
        if (n3 == 0) {
            this.reset();
            return 0;
        }
        if (n3 < 0) {
            MutableBigInteger mutableBigInteger3 = mutableBigInteger2;
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger3;
        }
        if (nArray.length < (n2 = mutableBigInteger2.intLen)) {
            nArray = new int[n2];
        }
        long l2 = 0L;
        int n4 = mutableBigInteger2.intLen;
        int n5 = mutableBigInteger.intLen;
        int n6 = nArray.length - 1;
        while (n5 > 0) {
            l2 = ((long)mutableBigInteger2.value[--n4 + mutableBigInteger2.offset] & 0xFFFFFFFFL) - ((long)mutableBigInteger.value[--n5 + mutableBigInteger.offset] & 0xFFFFFFFFL) - (long)((int)(-(l2 >> 32)));
            nArray[n6--] = (int)l2;
        }
        while (n4 > 0) {
            l2 = ((long)mutableBigInteger2.value[--n4 + mutableBigInteger2.offset] & 0xFFFFFFFFL) - (long)((int)(-(l2 >> 32)));
            nArray[n6--] = (int)l2;
        }
        this.value = nArray;
        this.intLen = n2;
        this.offset = this.value.length - n2;
        this.normalize();
        return n3;
    }

    private int difference(MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = this;
        int n2 = mutableBigInteger2.compare(mutableBigInteger);
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0) {
            MutableBigInteger mutableBigInteger3 = mutableBigInteger2;
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger3;
        }
        long l2 = 0L;
        int n3 = mutableBigInteger2.intLen;
        int n4 = mutableBigInteger.intLen;
        while (n4 > 0) {
            l2 = ((long)mutableBigInteger2.value[mutableBigInteger2.offset + --n3] & 0xFFFFFFFFL) - ((long)mutableBigInteger.value[mutableBigInteger.offset + --n4] & 0xFFFFFFFFL) - (long)((int)(-(l2 >> 32)));
            mutableBigInteger2.value[mutableBigInteger2.offset + n3] = (int)l2;
        }
        while (n3 > 0) {
            l2 = ((long)mutableBigInteger2.value[mutableBigInteger2.offset + --n3] & 0xFFFFFFFFL) - (long)((int)(-(l2 >> 32)));
            mutableBigInteger2.value[mutableBigInteger2.offset + n3] = (int)l2;
        }
        mutableBigInteger2.normalize();
        return n2;
    }

    void multiply(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2) {
        int n2 = this.intLen;
        int n3 = mutableBigInteger.intLen;
        int n4 = n2 + n3;
        if (mutableBigInteger2.value.length < n4) {
            mutableBigInteger2.value = new int[n4];
        }
        mutableBigInteger2.offset = 0;
        mutableBigInteger2.intLen = n4;
        long l2 = 0L;
        int n5 = n3 - 1;
        int n6 = n3 + n2 - 1;
        while (n5 >= 0) {
            long l3 = ((long)mutableBigInteger.value[n5 + mutableBigInteger.offset] & 0xFFFFFFFFL) * ((long)this.value[n2 - 1 + this.offset] & 0xFFFFFFFFL) + l2;
            mutableBigInteger2.value[n6] = (int)l3;
            l2 = l3 >>> 32;
            --n5;
            --n6;
        }
        mutableBigInteger2.value[n2 - 1] = (int)l2;
        int n7 = n2 - 2;
        while (n7 >= 0) {
            l2 = 0L;
            int n8 = n3 - 1;
            int n9 = n3 + n7;
            while (n8 >= 0) {
                long l4 = ((long)mutableBigInteger.value[n8 + mutableBigInteger.offset] & 0xFFFFFFFFL) * ((long)this.value[n7 + this.offset] & 0xFFFFFFFFL) + ((long)mutableBigInteger2.value[n9] & 0xFFFFFFFFL) + l2;
                mutableBigInteger2.value[n9] = (int)l4;
                l2 = l4 >>> 32;
                --n8;
                --n9;
            }
            mutableBigInteger2.value[n7] = (int)l2;
            --n7;
        }
        mutableBigInteger2.normalize();
    }

    void mul(int n2, MutableBigInteger mutableBigInteger) {
        if (n2 == 1) {
            mutableBigInteger.copyValue(this);
            return;
        }
        if (n2 == 0) {
            mutableBigInteger.clear();
            return;
        }
        long l2 = (long)n2 & 0xFFFFFFFFL;
        int[] nArray = mutableBigInteger.value.length < this.intLen + 1 ? new int[this.intLen + 1] : mutableBigInteger.value;
        long l3 = 0L;
        int n3 = this.intLen - 1;
        while (n3 >= 0) {
            long l4 = l2 * ((long)this.value[n3 + this.offset] & 0xFFFFFFFFL) + l3;
            nArray[n3 + 1] = (int)l4;
            l3 = l4 >>> 32;
            --n3;
        }
        if (l3 == 0L) {
            mutableBigInteger.offset = 1;
            mutableBigInteger.intLen = this.intLen;
        } else {
            mutableBigInteger.offset = 0;
            mutableBigInteger.intLen = this.intLen + 1;
            nArray[0] = (int)l3;
        }
        mutableBigInteger.value = nArray;
    }

    void divideOneWord(int n2, MutableBigInteger mutableBigInteger) {
        long l2 = (long)n2 & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            long l3 = (long)this.value[this.offset] & 0xFFFFFFFFL;
            mutableBigInteger.value[0] = (int)(l3 / l2);
            mutableBigInteger.intLen = mutableBigInteger.value[0] == 0 ? 0 : 1;
            mutableBigInteger.offset = 0;
            this.value[0] = (int)(l3 - (long)mutableBigInteger.value[0] * l2);
            this.offset = 0;
            this.intLen = this.value[0] == 0 ? 0 : 1;
            return;
        }
        if (mutableBigInteger.value.length < this.intLen) {
            mutableBigInteger.value = new int[this.intLen];
        }
        mutableBigInteger.offset = 0;
        mutableBigInteger.intLen = this.intLen;
        int n3 = 32 - BigInteger.bitLen(n2);
        int n4 = this.value[this.offset];
        long l4 = (long)n4 & 0xFFFFFFFFL;
        if (l4 < l2) {
            mutableBigInteger.value[0] = 0;
        } else {
            mutableBigInteger.value[0] = (int)(l4 / l2);
            n4 = (int)(l4 - (long)mutableBigInteger.value[0] * l2);
            l4 = (long)n4 & 0xFFFFFFFFL;
        }
        int n5 = this.intLen;
        int[] nArray = new int[2];
        while (--n5 > 0) {
            long l5 = l4 << 32 | (long)this.value[this.offset + this.intLen - n5] & 0xFFFFFFFFL;
            if (l5 >= 0L) {
                nArray[0] = (int)(l5 / l2);
                nArray[1] = (int)(l5 - (long)nArray[0] * l2);
            } else {
                this.divWord(nArray, l5, n2);
            }
            mutableBigInteger.value[this.intLen - n5] = nArray[0];
            n4 = nArray[1];
            l4 = (long)n4 & 0xFFFFFFFFL;
        }
        this.value[0] = n3 > 0 ? (n4 %= n2) : n4;
        this.intLen = this.value[0] == 0 ? 0 : 1;
        mutableBigInteger.normalize();
    }

    void divide(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, MutableBigInteger mutableBigInteger3) {
        if (mutableBigInteger.intLen == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            mutableBigInteger3.offset = 0;
            mutableBigInteger3.intLen = 0;
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.intLen = 0;
            return;
        }
        int n2 = this.compare(mutableBigInteger);
        if (n2 < 0) {
            mutableBigInteger2.offset = 0;
            mutableBigInteger2.intLen = 0;
            mutableBigInteger3.copyValue(this);
            return;
        }
        if (n2 == 0) {
            mutableBigInteger2.intLen = 1;
            mutableBigInteger2.value[0] = 1;
            mutableBigInteger3.offset = 0;
            mutableBigInteger3.intLen = 0;
            mutableBigInteger2.offset = 0;
            return;
        }
        mutableBigInteger2.clear();
        if (mutableBigInteger.intLen == 1) {
            mutableBigInteger3.copyValue(this);
            mutableBigInteger3.divideOneWord(mutableBigInteger.value[mutableBigInteger.offset], mutableBigInteger2);
            return;
        }
        int[] nArray = new int[mutableBigInteger.intLen];
        int n3 = 0;
        while (n3 < mutableBigInteger.intLen) {
            nArray[n3] = mutableBigInteger.value[mutableBigInteger.offset + n3];
            ++n3;
        }
        int n4 = mutableBigInteger.intLen;
        if (mutableBigInteger3.value.length < this.intLen + 1) {
            mutableBigInteger3.value = new int[this.intLen + 1];
        }
        int n5 = 0;
        while (n5 < this.intLen) {
            mutableBigInteger3.value[n5 + 1] = this.value[n5 + this.offset];
            ++n5;
        }
        mutableBigInteger3.intLen = this.intLen;
        mutableBigInteger3.offset = 1;
        int n6 = mutableBigInteger3.intLen;
        int n7 = n6 - n4 + 1;
        if (mutableBigInteger2.value.length < n7) {
            mutableBigInteger2.value = new int[n7];
            mutableBigInteger2.offset = 0;
        }
        mutableBigInteger2.intLen = n7;
        int[] nArray2 = mutableBigInteger2.value;
        int n8 = 32 - BigInteger.bitLen(nArray[0]);
        if (n8 > 0) {
            BigInteger.primitiveLeftShift(nArray, n4, n8);
            mutableBigInteger3.leftShift(n8);
        }
        if (mutableBigInteger3.intLen == n6) {
            mutableBigInteger3.offset = 0;
            mutableBigInteger3.value[0] = 0;
            ++mutableBigInteger3.intLen;
        }
        int n9 = nArray[0];
        long l2 = (long)n9 & 0xFFFFFFFFL;
        int n10 = nArray[1];
        int[] nArray3 = new int[2];
        int n11 = 0;
        while (n11 < n7) {
            long l3;
            int n12 = 0;
            int n13 = 0;
            boolean bl2 = false;
            int n14 = mutableBigInteger3.value[n11 + mutableBigInteger3.offset];
            int n15 = n14 + Integer.MIN_VALUE;
            int n16 = mutableBigInteger3.value[n11 + 1 + mutableBigInteger3.offset];
            if (n14 == n9) {
                n12 = -1;
                n13 = n14 + n16;
                bl2 = n13 + Integer.MIN_VALUE < n15;
            } else {
                l3 = (long)n14 << 32 | (long)n16 & 0xFFFFFFFFL;
                if (l3 >= 0L) {
                    n12 = (int)(l3 / l2);
                    n13 = (int)(l3 - (long)n12 * l2);
                } else {
                    this.divWord(nArray3, l3, n9);
                    n12 = nArray3[0];
                    n13 = nArray3[1];
                }
            }
            if (n12 != 0) {
                long l4;
                long l5;
                if (!bl2 && this.unsignedLongCompare(l5 = ((long)n10 & 0xFFFFFFFFL) * ((long)n12 & 0xFFFFFFFFL), l4 = ((long)n13 & 0xFFFFFFFFL) << 32 | (l3 = (long)mutableBigInteger3.value[n11 + 2 + mutableBigInteger3.offset] & 0xFFFFFFFFL)) && ((long)(n13 = (int)(((long)n13 & 0xFFFFFFFFL) + l2)) & 0xFFFFFFFFL) >= l2 && this.unsignedLongCompare(l5 = ((long)n10 & 0xFFFFFFFFL) * ((long)(--n12) & 0xFFFFFFFFL), l4 = ((long)n13 & 0xFFFFFFFFL) << 32 | l3)) {
                    --n12;
                }
                mutableBigInteger3.value[n11 + mutableBigInteger3.offset] = 0;
                int n17 = this.mulsub(mutableBigInteger3.value, nArray, n12, n4, n11 + mutableBigInteger3.offset);
                if (n17 + Integer.MIN_VALUE > n15) {
                    this.divadd(nArray, mutableBigInteger3.value, n11 + 1 + mutableBigInteger3.offset);
                }
                nArray2[n11] = --n12;
            }
            ++n11;
        }
        if (n8 > 0) {
            mutableBigInteger3.rightShift(n8);
        }
        mutableBigInteger3.normalize();
        mutableBigInteger2.normalize();
    }

    private boolean unsignedLongCompare(long l2, long l3) {
        return l2 + Long.MIN_VALUE > l3 + Long.MIN_VALUE;
    }

    private void divWord(int[] nArray, long l2, int n2) {
        long l3 = (long)n2 & 0xFFFFFFFFL;
        if (l3 == 1L) {
            nArray[0] = (int)l2;
            nArray[1] = 0;
            return;
        }
        long l4 = (l2 >>> 1) / (l3 >>> 1);
        long l5 = l2 - l4 * l3;
        while (l5 < 0L) {
            l5 += l3;
            --l4;
        }
        while (l5 >= l3) {
            l5 -= l3;
            ++l4;
        }
        nArray[0] = (int)l4;
        nArray[1] = (int)l5;
    }

    MutableBigInteger hybridGCD(MutableBigInteger mutableBigInteger) {
        MutableBigInteger mutableBigInteger2 = this;
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        while (mutableBigInteger.intLen != 0) {
            if (Math.abs(mutableBigInteger2.intLen - mutableBigInteger.intLen) < 2) {
                return mutableBigInteger2.binaryGCD(mutableBigInteger);
            }
            mutableBigInteger2.divide(mutableBigInteger, mutableBigInteger3, mutableBigInteger4);
            MutableBigInteger mutableBigInteger5 = mutableBigInteger2;
            mutableBigInteger2 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger4;
            mutableBigInteger4 = mutableBigInteger5;
        }
        return mutableBigInteger2;
    }

    private MutableBigInteger binaryGCD(MutableBigInteger mutableBigInteger) {
        int n2;
        int n3;
        int n4;
        MutableBigInteger mutableBigInteger2 = this;
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        int n5 = mutableBigInteger2.getLowestSetBit();
        int n6 = n4 = n5 < (n3 = mutableBigInteger.getLowestSetBit()) ? n5 : n3;
        if (n4 != 0) {
            mutableBigInteger2.rightShift(n4);
            mutableBigInteger.rightShift(n4);
        }
        boolean bl2 = n4 == n5;
        MutableBigInteger mutableBigInteger5 = bl2 ? mutableBigInteger : mutableBigInteger2;
        int n7 = bl2 ? -1 : 1;
        while ((n2 = mutableBigInteger5.getLowestSetBit()) >= 0) {
            mutableBigInteger5.rightShift(n2);
            if (n7 > 0) {
                mutableBigInteger2 = mutableBigInteger5;
            } else {
                mutableBigInteger = mutableBigInteger5;
            }
            if (mutableBigInteger2.intLen < 2 && mutableBigInteger.intLen < 2) {
                int n8 = mutableBigInteger2.value[mutableBigInteger2.offset];
                int n9 = mutableBigInteger.value[mutableBigInteger.offset];
                mutableBigInteger4.value[0] = n8 = MutableBigInteger.binaryGcd(n8, n9);
                mutableBigInteger4.intLen = 1;
                mutableBigInteger4.offset = 0;
                if (n4 > 0) {
                    mutableBigInteger4.leftShift(n4);
                }
                return mutableBigInteger4;
            }
            n7 = mutableBigInteger2.difference(mutableBigInteger);
            if (n7 == 0) break;
            MutableBigInteger mutableBigInteger6 = mutableBigInteger5 = n7 >= 0 ? mutableBigInteger2 : mutableBigInteger;
        }
        if (n4 > 0) {
            mutableBigInteger2.leftShift(n4);
        }
        return mutableBigInteger2;
    }

    static int binaryGcd(int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n3;
        }
        int n5 = 0;
        while ((n4 = n2 & 0xFF) == 0) {
            n2 >>>= 8;
            n5 += 8;
        }
        byte by = BigInteger.trailingZeroTable[n4];
        n5 += by;
        n2 >>>= by;
        int n6 = 0;
        while ((n4 = n3 & 0xFF) == 0) {
            n3 >>>= 8;
            n6 += 8;
        }
        by = BigInteger.trailingZeroTable[n4];
        n3 >>>= by;
        int n7 = n5 < (n6 += by) ? n5 : n6;
        while (n2 != n3) {
            if (n2 + Integer.MIN_VALUE > n3 + Integer.MIN_VALUE) {
                n2 -= n3;
                while ((n4 = n2 & 0xFF) == 0) {
                    n2 >>>= 8;
                }
                n2 >>>= BigInteger.trailingZeroTable[n4];
                continue;
            }
            n3 -= n2;
            while ((n4 = n3 & 0xFF) == 0) {
                n3 >>>= 8;
            }
            n3 >>>= BigInteger.trailingZeroTable[n4];
        }
        return n2 << n7;
    }

    MutableBigInteger mutableModInverse(MutableBigInteger mutableBigInteger) {
        if (mutableBigInteger.isOdd()) {
            return this.modInverse(mutableBigInteger);
        }
        if (this.isEven()) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        int n2 = mutableBigInteger.getLowestSetBit();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        mutableBigInteger2.rightShift(n2);
        if (mutableBigInteger2.isOne()) {
            return this.modInverseMP2(n2);
        }
        MutableBigInteger mutableBigInteger3 = this.modInverse(mutableBigInteger2);
        MutableBigInteger mutableBigInteger4 = this.modInverseMP2(n2);
        MutableBigInteger mutableBigInteger5 = MutableBigInteger.modInverseBP2(mutableBigInteger2, n2);
        MutableBigInteger mutableBigInteger6 = mutableBigInteger2.modInverseMP2(n2);
        MutableBigInteger mutableBigInteger7 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger8 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger9 = new MutableBigInteger();
        mutableBigInteger3.leftShift(n2);
        mutableBigInteger3.multiply(mutableBigInteger5, mutableBigInteger9);
        mutableBigInteger4.multiply(mutableBigInteger2, mutableBigInteger7);
        mutableBigInteger7.multiply(mutableBigInteger6, mutableBigInteger8);
        mutableBigInteger9.add(mutableBigInteger8);
        mutableBigInteger9.divide(mutableBigInteger, mutableBigInteger7, mutableBigInteger8);
        return mutableBigInteger8;
    }

    MutableBigInteger modInverseMP2(int n2) {
        if (this.isEven()) {
            throw new ArithmeticException("Non-invertible. (GCD != 1)");
        }
        if (n2 > 64) {
            return this.euclidModInverse(n2);
        }
        int n3 = MutableBigInteger.inverseMod32(this.value[this.offset + this.intLen - 1]);
        if (n2 < 33) {
            n3 = n2 == 32 ? n3 : n3 & (1 << n2) - 1;
            return new MutableBigInteger(n3);
        }
        long l2 = (long)this.value[this.offset + this.intLen - 1] & 0xFFFFFFFFL;
        if (this.intLen > 1) {
            l2 |= (long)this.value[this.offset + this.intLen - 2] << 32;
        }
        long l3 = (long)n3 & 0xFFFFFFFFL;
        l3 *= 2L - l2 * l3;
        l3 = n2 == 64 ? l3 : l3 & (1L << n2) - 1L;
        MutableBigInteger mutableBigInteger = new MutableBigInteger(new int[2]);
        mutableBigInteger.value[0] = (int)(l3 >>> 32);
        mutableBigInteger.value[1] = (int)l3;
        mutableBigInteger.intLen = 2;
        mutableBigInteger.normalize();
        return mutableBigInteger;
    }

    static int inverseMod32(int n2) {
        int n3 = n2;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        return n3;
    }

    static MutableBigInteger modInverseBP2(MutableBigInteger mutableBigInteger, int n2) {
        return MutableBigInteger.fixup(new MutableBigInteger(1), new MutableBigInteger(mutableBigInteger), n2);
    }

    private MutableBigInteger modInverse(MutableBigInteger mutableBigInteger) {
        int n2;
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger(mutableBigInteger2);
        SignedMutableBigInteger signedMutableBigInteger = new SignedMutableBigInteger(1);
        SignedMutableBigInteger signedMutableBigInteger2 = new SignedMutableBigInteger();
        MutableBigInteger mutableBigInteger5 = null;
        SignedMutableBigInteger signedMutableBigInteger3 = null;
        int n3 = 0;
        if (mutableBigInteger3.isEven()) {
            n2 = mutableBigInteger3.getLowestSetBit();
            mutableBigInteger3.rightShift(n2);
            signedMutableBigInteger2.leftShift(n2);
            n3 = n2;
        }
        while (!mutableBigInteger3.isOne()) {
            if (mutableBigInteger3.isZero()) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            if (mutableBigInteger3.compare(mutableBigInteger4) < 0) {
                mutableBigInteger5 = mutableBigInteger3;
                mutableBigInteger3 = mutableBigInteger4;
                mutableBigInteger4 = mutableBigInteger5;
                signedMutableBigInteger3 = signedMutableBigInteger2;
                signedMutableBigInteger2 = signedMutableBigInteger;
                signedMutableBigInteger = signedMutableBigInteger3;
            }
            if (((mutableBigInteger3.value[mutableBigInteger3.offset + mutableBigInteger3.intLen - 1] ^ mutableBigInteger4.value[mutableBigInteger4.offset + mutableBigInteger4.intLen - 1]) & 3) == 0) {
                mutableBigInteger3.subtract(mutableBigInteger4);
                signedMutableBigInteger.signedSubtract(signedMutableBigInteger2);
            } else {
                mutableBigInteger3.add(mutableBigInteger4);
                signedMutableBigInteger.signedAdd(signedMutableBigInteger2);
            }
            n2 = mutableBigInteger3.getLowestSetBit();
            mutableBigInteger3.rightShift(n2);
            signedMutableBigInteger2.leftShift(n2);
            n3 += n2;
        }
        while (signedMutableBigInteger.sign < 0) {
            signedMutableBigInteger.signedAdd(mutableBigInteger2);
        }
        return MutableBigInteger.fixup(signedMutableBigInteger, mutableBigInteger2, n3);
    }

    static MutableBigInteger fixup(MutableBigInteger mutableBigInteger, MutableBigInteger mutableBigInteger2, int n2) {
        int n3;
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger();
        int n4 = -MutableBigInteger.inverseMod32(mutableBigInteger2.value[mutableBigInteger2.offset + mutableBigInteger2.intLen - 1]);
        int n5 = 0;
        int n6 = n2 >> 5;
        while (n5 < n6) {
            n3 = n4 * mutableBigInteger.value[mutableBigInteger.offset + mutableBigInteger.intLen - 1];
            mutableBigInteger2.mul(n3, mutableBigInteger3);
            mutableBigInteger.add(mutableBigInteger3);
            --mutableBigInteger.intLen;
            ++n5;
        }
        n3 = n2 & 0x1F;
        if (n3 != 0) {
            int n7 = n4 * mutableBigInteger.value[mutableBigInteger.offset + mutableBigInteger.intLen - 1];
            mutableBigInteger2.mul(n7 &= (1 << n3) - 1, mutableBigInteger3);
            mutableBigInteger.add(mutableBigInteger3);
            mutableBigInteger.rightShift(n3);
        }
        while (mutableBigInteger.compare(mutableBigInteger2) >= 0) {
            mutableBigInteger.subtract(mutableBigInteger2);
        }
        return mutableBigInteger;
    }

    MutableBigInteger euclidModInverse(int n2) {
        MutableBigInteger mutableBigInteger = new MutableBigInteger(1);
        mutableBigInteger.leftShift(n2);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(mutableBigInteger);
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(this);
        MutableBigInteger mutableBigInteger4 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger5 = new MutableBigInteger();
        mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger4, mutableBigInteger5);
        MutableBigInteger mutableBigInteger6 = mutableBigInteger;
        mutableBigInteger = mutableBigInteger5;
        mutableBigInteger5 = mutableBigInteger6;
        MutableBigInteger mutableBigInteger7 = new MutableBigInteger(mutableBigInteger4);
        MutableBigInteger mutableBigInteger8 = new MutableBigInteger(1);
        MutableBigInteger mutableBigInteger9 = new MutableBigInteger();
        while (!mutableBigInteger.isOne()) {
            mutableBigInteger3.divide(mutableBigInteger, mutableBigInteger4, mutableBigInteger5);
            if (mutableBigInteger5.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            mutableBigInteger6 = mutableBigInteger5;
            mutableBigInteger5 = mutableBigInteger3;
            mutableBigInteger3 = mutableBigInteger6;
            if (mutableBigInteger4.intLen == 1) {
                mutableBigInteger7.mul(mutableBigInteger4.value[mutableBigInteger4.offset], mutableBigInteger9);
            } else {
                mutableBigInteger4.multiply(mutableBigInteger7, mutableBigInteger9);
            }
            mutableBigInteger6 = mutableBigInteger4;
            mutableBigInteger4 = mutableBigInteger9;
            mutableBigInteger9 = mutableBigInteger6;
            mutableBigInteger8.add(mutableBigInteger4);
            if (mutableBigInteger3.isOne()) {
                return mutableBigInteger8;
            }
            mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger4, mutableBigInteger5);
            if (mutableBigInteger5.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            mutableBigInteger6 = mutableBigInteger;
            mutableBigInteger = mutableBigInteger5;
            mutableBigInteger5 = mutableBigInteger6;
            if (mutableBigInteger4.intLen == 1) {
                mutableBigInteger8.mul(mutableBigInteger4.value[mutableBigInteger4.offset], mutableBigInteger9);
            } else {
                mutableBigInteger4.multiply(mutableBigInteger8, mutableBigInteger9);
            }
            mutableBigInteger6 = mutableBigInteger4;
            mutableBigInteger4 = mutableBigInteger9;
            mutableBigInteger9 = mutableBigInteger6;
            mutableBigInteger7.add(mutableBigInteger4);
        }
        mutableBigInteger2.subtract(mutableBigInteger7);
        return mutableBigInteger2;
    }
}

