/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import sun.reflect.FieldAccessor;
import sun.reflect.Reflection;

public final class Field
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class type;
    private int modifiers;
    private volatile FieldAccessor fieldAccessor;
    private Field root;
    private volatile Class securityCheckTargetClassCache;

    Field(Class clazz, String string, Class clazz2, int n2, int n3) {
        this.clazz = clazz;
        this.name = string;
        this.type = clazz2;
        this.modifiers = n2;
        this.slot = n3;
    }

    Field copy() {
        Field field = new Field(this.clazz, this.name, this.type, this.modifiers, this.slot);
        field.root = this;
        field.fieldAccessor = this.fieldAccessor;
        return field;
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Field) {
            Field field = (Field)object;
            return this.getDeclaringClass() == field.getDeclaringClass() && this.getName().equals(field.getName()) && this.getType() == field.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int n2 = this.getModifiers();
        return (n2 == 0 ? "" : Modifier.toString(n2) + " ") + Field.getTypeName(this.getType()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).get(object);
    }

    public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getBoolean(object);
    }

    public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getByte(object);
    }

    public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getChar(object);
    }

    public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getShort(object);
    }

    public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getInt(object);
    }

    public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getLong(object);
    }

    public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getFloat(object);
    }

    public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getDouble(object);
    }

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).set(object, object2);
    }

    public void setBoolean(Object object, boolean bl2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setBoolean(object, bl2);
    }

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setByte(object, by);
    }

    public void setChar(Object object, char c2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setChar(object, c2);
    }

    public void setShort(Object object, short s2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setShort(object, s2);
    }

    public void setInt(Object object, int n2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setInt(object, n2);
    }

    public void setLong(Object object, long l2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setLong(object, l2);
    }

    public void setFloat(Object object, float f2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setFloat(object, f2);
    }

    public void setDouble(Object object, double d2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setDouble(object, d2);
    }

    private FieldAccessor getFieldAccessor(Object object) throws IllegalAccessException {
        this.doSecurityCheck(object);
        if (this.fieldAccessor == null) {
            this.acquireFieldAccessor();
        }
        return this.fieldAccessor;
    }

    private void acquireFieldAccessor() {
        FieldAccessor fieldAccessor = null;
        if (this.root != null) {
            fieldAccessor = this.root.getFieldAccessor();
        }
        if (fieldAccessor != null) {
            this.fieldAccessor = fieldAccessor;
            return;
        }
        fieldAccessor = AccessibleObject.reflectionFactory.newFieldAccessor(this);
        this.setFieldAccessor(fieldAccessor);
    }

    private FieldAccessor getFieldAccessor() {
        return this.fieldAccessor;
    }

    private void setFieldAccessor(FieldAccessor fieldAccessor) {
        this.fieldAccessor = fieldAccessor;
        if (this.root != null) {
            this.root.setFieldAccessor(fieldAccessor);
        }
    }

    private void doSecurityCheck(Object object) throws IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class clazz;
            Class clazz2 = Reflection.getCallerClass(4);
            Class clazz3 = clazz = object == null || !Modifier.isProtected(this.modifiers) ? this.clazz : object.getClass();
            if (this.securityCheckCache != clazz2 || clazz != this.securityCheckTargetClassCache) {
                Reflection.ensureMemberAccess(clazz2, this.clazz, object, this.modifiers);
                this.securityCheckCache = clazz2;
                this.securityCheckTargetClassCache = clazz;
            }
        }
    }

    static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class clazz2 = clazz;
                int n2 = 0;
                while (clazz2.isArray()) {
                    ++n2;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append("[]");
                    ++n3;
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
            }
        }
        return clazz.getName();
    }
}

