/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private static final long serialVersionUID = 6992337162326171013L;

    private StackTraceElement() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        return this.getClassName() + "." + this.methodName + (this.isNativeMethod() ? "(Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)")));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        return stackTraceElement.declaringClass.equals(this.declaringClass) && stackTraceElement.lineNumber == this.lineNumber && StackTraceElement.eq(this.methodName, stackTraceElement.methodName) && StackTraceElement.eq(this.fileName, stackTraceElement.fileName);
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public int hashCode() {
        int n2 = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        n2 = 31 * n2 + (this.fileName == null ? 0 : this.fileName.hashCode());
        n2 = 31 * n2 + this.lineNumber;
        return n2;
    }
}

