/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    Kernel kernel;
    int edgeHint;
    RenderingHints hints;
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;

    public ConvolveOp(Kernel kernel, int n2, RenderingHints renderingHints) {
        this.kernel = kernel;
        this.edgeHint = n2;
        this.hints = renderingHints;
    }

    public ConvolveOp(Kernel kernel) {
        this.kernel = kernel;
        this.edgeHint = 0;
    }

    public int getEdgeCondition() {
        return this.edgeHint;
    }

    public final Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        if (bufferedImage == null) {
            throw new NullPointerException("src image is null");
        }
        if (bufferedImage == bufferedImage2) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        boolean bl2 = false;
        ColorModel colorModel = bufferedImage.getColorModel();
        BufferedImage bufferedImage3 = bufferedImage2;
        if (colorModel instanceof IndexColorModel) {
            object = (IndexColorModel)colorModel;
            bufferedImage = ((IndexColorModel)object).convertToIntDiscrete(bufferedImage.getRaster(), false);
            colorModel = bufferedImage.getColorModel();
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            ColorModel colorModel2 = colorModel;
            bufferedImage3 = bufferedImage2;
        } else {
            ColorModel colorModel3 = bufferedImage2.getColorModel();
            if (colorModel.getColorSpace().getType() != colorModel3.getColorSpace().getType()) {
                bl2 = true;
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
                colorModel3 = bufferedImage2.getColorModel();
            } else if (colorModel3 instanceof IndexColorModel) {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
                colorModel3 = bufferedImage2.getColorModel();
            }
        }
        if (ImagingLib.filter(this, bufferedImage, bufferedImage2) == null) {
            throw new ImagingOpException("Unable to convolve src image");
        }
        if (bl2) {
            object = new ColorConvertOp(this.hints);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        } else if (bufferedImage3 != bufferedImage2) {
            object = bufferedImage3.createGraphics();
            try {
                ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((Graphics)object).dispose();
                throw throwable;
            }
            ((Graphics)object).dispose();
            {
            }
        }
        return bufferedImage3;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (raster == writableRaster) {
                throw new IllegalArgumentException("src image cannot be the same as the dst image");
            }
            if (raster.getNumBands() != writableRaster.getNumBands()) {
                throw new ImagingOpException("Different number of bands in src  and dst Rasters");
            }
        }
        if (ImagingLib.filter(this, raster, writableRaster) == null) {
            throw new ImagingOpException("Unable to convolve src image");
        }
        return writableRaster;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null && (colorModel = bufferedImage.getColorModel()) instanceof IndexColorModel) {
            colorModel = ColorModel.getRGBdefault();
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n2, n3), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

