/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import sun.awt.datatransfer.DataTransferer;

public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static String JavaMIME;
    private static final WeakHashMap flavorMaps;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String[] UNICODE_TEXT_CLASSES;
    private static final String[] ENCODED_TEXT_CLASSES;
    private static final String TEXT_PLAIN_BASE_TYPE = "text/plain";
    private static final boolean SYNTHESIZE_IF_NOT_FOUND = true;
    private Map nativeToFlavor;
    private Map flavorToNative;
    private Map getNativesForFlavorCache;
    private Map getFlavorsForNativeCache;
    private Set disabledMappingGenerationKeys;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$awt$datatransfer$SystemFlavorMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlavorMap getDefaultFlavorMap() {
        FlavorMap flavorMap;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        WeakHashMap weakHashMap = flavorMaps;
        synchronized (weakHashMap) {
            flavorMap = (FlavorMap)flavorMaps.get(classLoader);
            if (flavorMap == null) {
                flavorMap = new SystemFlavorMap();
                flavorMaps.put(classLoader, flavorMap);
            }
        }
        return flavorMap;
    }

    private SystemFlavorMap() {
        block5: {
            this.nativeToFlavor = new HashMap();
            this.flavorToNative = new HashMap();
            this.getNativesForFlavorCache = new HashMap();
            this.getFlavorsForNativeCache = new HashMap();
            this.disabledMappingGenerationKeys = new HashSet();
            BufferedReader bufferedReader = (BufferedReader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = "file:" + System.getProperty("java.home") + File.separator + "lib" + File.separator + "flavormap.properties";
                    try {
                        return new BufferedReader(new InputStreamReader(new URL(string).openStream(), "ISO-8859-1"));
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("MalformedURLException:" + malformedURLException + " while loading default flavormap.properties file URL:" + string);
                    }
                    catch (IOException iOException) {
                        System.err.println("IOException:" + iOException + " while loading default flavormap.properties file URL:" + string);
                    }
                    return null;
                }
            });
            BufferedReader bufferedReader2 = (BufferedReader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit();
                    String string = Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
                    if (string == null) {
                        return null;
                    }
                    try {
                        return new BufferedReader(new InputStreamReader(new URL(string).openStream(), "ISO-8859-1"));
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("MalformedURLException:" + malformedURLException + " while reading AWT.DnD.flavorMapFileURL:" + string);
                    }
                    catch (IOException iOException) {
                        System.err.println("IOException:" + iOException + " while reading AWT.DnD.flavorMapFileURL:" + string);
                    }
                    return null;
                }
            });
            if (bufferedReader != null) {
                try {
                    this.parseAndStoreReader(bufferedReader);
                }
                catch (IOException iOException) {
                    System.err.println("IOException:" + iOException + " while parsing default flavormap.properties file");
                }
            }
            if (bufferedReader2 == null) break block5;
            try {
                this.parseAndStoreReader(bufferedReader2);
            }
            catch (IOException iOException) {
                System.err.println("IOException:" + iOException + " while parsing AWT.DnD.flavorMapFileURL");
            }
        }
    }

    private void parseAndStoreReader(BufferedReader bufferedReader) throws IOException {
        while (true) {
            Cloneable cloneable;
            String string;
            String string2;
            block20: {
                int n2;
                int n3;
                char c2;
                String string3;
                if ((string3 = bufferedReader.readLine()) == null) {
                    return;
                }
                if (string3.length() <= 0 || (c2 = string3.charAt(0)) == '#' || c2 == '!') continue;
                while (this.continueLine(string3)) {
                    String string4 = bufferedReader.readLine();
                    if (string4 == null) {
                        string4 = new String("");
                    }
                    String string5 = string3.substring(0, string3.length() - 1);
                    n3 = 0;
                    while (n3 < string4.length()) {
                        if (whiteSpaceChars.indexOf(string4.charAt(n3)) == -1) break;
                        ++n3;
                    }
                    string4 = string4.substring(n3, string4.length());
                    string3 = new String(string5 + string4);
                }
                int n4 = string3.length();
                int n5 = 0;
                while (n5 < n4) {
                    if (whiteSpaceChars.indexOf(string3.charAt(n5)) == -1) break;
                    ++n5;
                }
                if (n5 == n4) continue;
                n3 = n5;
                while (n3 < n4) {
                    n2 = string3.charAt(n3);
                    if (n2 == 92) {
                        ++n3;
                    } else if (keyValueSeparators.indexOf(n2) != -1) break;
                    ++n3;
                }
                n2 = n3;
                while (n2 < n4) {
                    if (whiteSpaceChars.indexOf(string3.charAt(n2)) == -1) break;
                    ++n2;
                }
                if (n2 < n4 && strictKeyValueSeparators.indexOf(string3.charAt(n2)) != -1) {
                    ++n2;
                }
                while (n2 < n4) {
                    if (whiteSpaceChars.indexOf(string3.charAt(n2)) == -1) break;
                    ++n2;
                }
                string2 = string3.substring(n5, n3);
                string = n3 < n4 ? string3.substring(n2, n4) : "";
                string2 = this.loadConvert(string2);
                string = this.loadConvert(string);
                try {
                    DataTransferer dataTransferer;
                    cloneable = new MimeType(string);
                    if (!"text".equals(((MimeType)cloneable).getPrimaryType())) break block20;
                    String string6 = ((MimeType)cloneable).getParameter("charset");
                    if (DataTransferer.doesSubtypeSupportCharset(((MimeType)cloneable).getSubType(), string6) && (dataTransferer = DataTransferer.getInstance()) != null) {
                        dataTransferer.registerTextFlavorProperties(string2, string6, ((MimeType)cloneable).getParameter("eoln"), ((MimeType)cloneable).getParameter("terminators"));
                    }
                    ((MimeType)cloneable).removeParameter("charset");
                    ((MimeType)cloneable).removeParameter("class");
                    ((MimeType)cloneable).removeParameter("eoln");
                    ((MimeType)cloneable).removeParameter("terminators");
                    string = ((MimeType)cloneable).toString();
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    mimeTypeParseException.printStackTrace();
                    continue;
                }
            }
            try {
                cloneable = new DataFlavor(string);
            }
            catch (Exception exception) {
                try {
                    cloneable = new DataFlavor(string, (String)null);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    continue;
                }
            }
            if ("text".equals(((DataFlavor)cloneable).getPrimaryType())) {
                this.store(string, string2, this.flavorToNative);
                this.store(string2, string, this.nativeToFlavor);
                continue;
            }
            this.store(cloneable, string2, this.flavorToNative);
            this.store(string2, cloneable, this.nativeToFlavor);
        }
    }

    private boolean continueLine(String string) {
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0 && string.charAt(n3--) == '\\') {
            ++n2;
        }
        return n2 % 2 == 1;
    }

    private String loadConvert(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if ((n4 = string.charAt(n3++)) == 92) {
                if ((n4 = string.charAt(n3++)) == 117) {
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < 4) {
                        n4 = string.charAt(n3++);
                        switch (n4) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n5 = (n5 << 4) + n4 - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n5 = (n5 << 4) + 10 + n4 - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n5 = (n5 << 4) + 10 + n4 - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n6;
                    }
                    stringBuffer.append((char)n5);
                    continue;
                }
                if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 102) {
                    n4 = 12;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    private void store(Object object, Object object2, Map map) {
        List list = (List)map.get(object);
        if (list == null) {
            list = new ArrayList(1);
            map.put(object, list);
        }
        if (!list.contains(object2)) {
            list.add(object2);
        }
    }

    private List nativeToFlavorLookup(String string) {
        List list = (List)this.nativeToFlavor.get(string);
        if (list == null && SystemFlavorMap.isJavaMIMEType(string)) {
            String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
            DataFlavor dataFlavor = null;
            try {
                dataFlavor = new DataFlavor(string2);
            }
            catch (Exception exception) {
                System.err.println("Exception \"" + exception.getClass().getName() + ": " + exception.getMessage() + "\"while constructing DataFlavor for: " + string2);
            }
            if (dataFlavor != null) {
                list = new ArrayList(1);
                this.nativeToFlavor.put(string, list);
                list.add(dataFlavor);
                this.getFlavorsForNativeCache.remove(string);
                this.getFlavorsForNativeCache.remove(null);
                List list2 = (List)this.flavorToNative.get(dataFlavor);
                if (list2 == null) {
                    list2 = new ArrayList(1);
                    this.flavorToNative.put(dataFlavor, list2);
                }
                list2.add(string);
                this.getNativesForFlavorCache.remove(dataFlavor);
                this.getNativesForFlavorCache.remove(null);
            }
        }
        return list != null ? list : new ArrayList(0);
    }

    private List flavorToNativeLookup(DataFlavor dataFlavor, boolean bl2) {
        List list = (List)this.flavorToNative.get(dataFlavor);
        if (list == null) {
            if (bl2) {
                String string = SystemFlavorMap.encodeDataFlavor(dataFlavor);
                list = new ArrayList(1);
                this.flavorToNative.put(dataFlavor, list);
                list.add(string);
                this.getNativesForFlavorCache.remove(dataFlavor);
                this.getNativesForFlavorCache.remove(null);
                List list2 = (List)this.nativeToFlavor.get(string);
                if (list2 == null) {
                    list2 = new ArrayList(1);
                    this.nativeToFlavor.put(string, list2);
                }
                list2.add(dataFlavor);
                this.getFlavorsForNativeCache.remove(string);
                this.getFlavorsForNativeCache.remove(null);
            } else {
                list = new ArrayList(0);
            }
        }
        return list;
    }

    public synchronized List getNativesForFlavor(DataFlavor dataFlavor) {
        List list = null;
        SoftReference softReference = (SoftReference)this.getNativesForFlavorCache.get(dataFlavor);
        if (softReference != null && (list = (List)softReference.get()) != null) {
            return new ArrayList(list);
        }
        if (dataFlavor == null) {
            list = new ArrayList(this.nativeToFlavor.keySet());
        } else if (this.disabledMappingGenerationKeys.contains(dataFlavor)) {
            list = this.flavorToNativeLookup(dataFlavor, false);
        } else if (DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            List list2;
            if ("text".equals(dataFlavor.getPrimaryType()) && (list = (List)this.flavorToNative.get(dataFlavor.mimeType.getBaseType())) != null) {
                list = new ArrayList(list);
            }
            if ((list2 = (List)this.flavorToNative.get(TEXT_PLAIN_BASE_TYPE)) != null && !list2.isEmpty()) {
                list2 = new ArrayList(list2);
                if (list != null && !list.isEmpty()) {
                    list2.removeAll(new HashSet(list));
                    list.addAll(list2);
                } else {
                    list = list2;
                }
            }
            if (list == null || list.isEmpty()) {
                list = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                List list3 = this.flavorToNativeLookup(dataFlavor, false);
                if (!list3.isEmpty()) {
                    list3 = new ArrayList(list3);
                    list3.removeAll(new HashSet(list));
                    list.addAll(list3);
                }
            }
        } else if (DataTransferer.isFlavorNoncharsetTextType(dataFlavor)) {
            list = (List)this.flavorToNative.get(dataFlavor.mimeType.getBaseType());
            if (list == null || list.isEmpty()) {
                list = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                List list4 = this.flavorToNativeLookup(dataFlavor, false);
                if (!list4.isEmpty()) {
                    list = new ArrayList(list);
                    list4 = new ArrayList(list4);
                    list4.removeAll(new HashSet(list));
                    list.addAll(list4);
                }
            }
        } else {
            list = this.flavorToNativeLookup(dataFlavor, true);
        }
        this.getNativesForFlavorCache.put(dataFlavor, new SoftReference(list));
        return new ArrayList(list);
    }

    public synchronized List getFlavorsForNative(String string) {
        List list;
        AbstractList abstractList;
        SoftReference softReference = (SoftReference)this.getFlavorsForNativeCache.get(string);
        if (softReference != null && (abstractList = (ArrayList)softReference.get()) != null) {
            return (List)((ArrayList)abstractList).clone();
        }
        abstractList = new LinkedList();
        if (string == null) {
            list = this.getNativesForFlavor(null);
            HashSet hashSet = new HashSet(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                List list2 = this.getFlavorsForNative((String)iterator.next());
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Object object = iterator2.next();
                    if (!hashSet.add(object)) continue;
                    ((LinkedList)abstractList).add(object);
                }
            }
        } else {
            list = this.nativeToFlavorLookup(string);
            if (this.disabledMappingGenerationKeys.contains(string)) {
                return list;
            }
            HashSet hashSet = new HashSet(list.size());
            List list3 = this.nativeToFlavorLookup(string);
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2 = iterator.next();
                if (object2 instanceof String) {
                    Object object3;
                    int n2;
                    String string2;
                    block26: {
                        object = (String)object2;
                        string2 = null;
                        try {
                            MimeType mimeType = new MimeType((String)object);
                            string2 = mimeType.getSubType();
                        }
                        catch (MimeTypeParseException mimeTypeParseException) {
                            if ($assertionsDisabled) break block26;
                            throw new AssertionError();
                        }
                    }
                    if (DataTransferer.doesSubtypeSupportCharset(string2, null)) {
                        if (TEXT_PLAIN_BASE_TYPE.equals(object) && hashSet.add(DataFlavor.stringFlavor)) {
                            ((LinkedList)abstractList).add(DataFlavor.stringFlavor);
                        }
                        n2 = 0;
                        while (n2 < UNICODE_TEXT_CLASSES.length) {
                            object3 = null;
                            try {
                                object3 = new DataFlavor((String)object + ";charset=Unicode;class=" + UNICODE_TEXT_CLASSES[n2]);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                            if (hashSet.add(object3)) {
                                ((LinkedList)abstractList).add(object3);
                            }
                            ++n2;
                        }
                        object3 = DataTransferer.standardEncodings();
                        while (object3.hasNext()) {
                            String string3 = (String)object3.next();
                            int n3 = 0;
                            while (n3 < ENCODED_TEXT_CLASSES.length) {
                                DataFlavor dataFlavor = null;
                                try {
                                    dataFlavor = new DataFlavor((String)object + ";charset=" + string3 + ";class=" + ENCODED_TEXT_CLASSES[n3]);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                                if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
                                    dataFlavor = DataFlavor.plainTextFlavor;
                                }
                                if (hashSet.add(dataFlavor)) {
                                    ((LinkedList)abstractList).add(dataFlavor);
                                }
                                ++n3;
                            }
                        }
                        if (!TEXT_PLAIN_BASE_TYPE.equals(object) || !hashSet.add(DataFlavor.plainTextFlavor)) continue;
                        ((LinkedList)abstractList).add(DataFlavor.plainTextFlavor);
                        continue;
                    }
                    n2 = 0;
                    while (n2 < ENCODED_TEXT_CLASSES.length) {
                        object3 = null;
                        try {
                            object3 = new DataFlavor((String)object + ";class=" + ENCODED_TEXT_CLASSES[n2]);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (hashSet.add(object3)) {
                            ((LinkedList)abstractList).add(object3);
                        }
                        ++n2;
                    }
                    continue;
                }
                object = (DataFlavor)object2;
                if (!hashSet.add(object)) continue;
                ((LinkedList)abstractList).add(object);
            }
        }
        list = new ArrayList(abstractList);
        this.getFlavorsForNativeCache.put(string, new SoftReference(list));
        return (List)((ArrayList)list).clone();
    }

    public synchronized Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        Object object;
        if (dataFlavorArray == null) {
            object = this.getFlavorsForNative(null);
            dataFlavorArray = new DataFlavor[object.size()];
            object.toArray(dataFlavorArray);
        }
        object = new HashMap(dataFlavorArray.length, 1.0f);
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            List list = this.getNativesForFlavor(dataFlavorArray[n2]);
            String string = list.isEmpty() ? null : (String)list.get(0);
            ((HashMap)object).put(dataFlavorArray[n2], string);
            ++n2;
        }
        return object;
    }

    public synchronized Map getFlavorsForNatives(String[] stringArray) {
        Object object;
        if (stringArray == null) {
            object = this.getNativesForFlavor(null);
            stringArray = new String[object.size()];
            object.toArray(stringArray);
        }
        object = new HashMap(stringArray.length, 1.0f);
        int n2 = 0;
        while (n2 < stringArray.length) {
            List list = this.getFlavorsForNative(stringArray[n2]);
            DataFlavor dataFlavor = list.isEmpty() ? null : (DataFlavor)list.get(0);
            ((HashMap)object).put(stringArray[n2], dataFlavor);
            ++n2;
        }
        return object;
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor dataFlavor, String string) {
        if (dataFlavor == null || string == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        List list = (List)this.flavorToNative.get(dataFlavor);
        if (list == null) {
            list = new ArrayList(1);
            this.flavorToNative.put(dataFlavor, list);
        } else if (list.contains(string)) {
            return;
        }
        list.add(string);
        this.getNativesForFlavorCache.remove(dataFlavor);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void setNativesForFlavor(DataFlavor dataFlavor, String[] stringArray) {
        if (dataFlavor == null || stringArray == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.flavorToNative.remove(dataFlavor);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.addUnencodedNativeForFlavor(dataFlavor, stringArray[n2]);
            ++n2;
        }
        this.disabledMappingGenerationKeys.add(dataFlavor);
        this.getNativesForFlavorCache.remove(dataFlavor);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void addFlavorForUnencodedNative(String string, DataFlavor dataFlavor) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        List list = (List)this.nativeToFlavor.get(string);
        if (list == null) {
            list = new ArrayList(1);
            this.nativeToFlavor.put(string, list);
        } else if (list.contains(dataFlavor)) {
            return;
        }
        list.add(dataFlavor);
        this.getFlavorsForNativeCache.remove(string);
        this.getFlavorsForNativeCache.remove(null);
    }

    public synchronized void setFlavorsForNative(String string, DataFlavor[] dataFlavorArray) {
        if (string == null || dataFlavorArray == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.nativeToFlavor.remove(string);
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            this.addFlavorForUnencodedNative(string, dataFlavorArray[n2]);
            ++n2;
        }
        this.disabledMappingGenerationKeys.add(string);
        this.getFlavorsForNativeCache.remove(string);
        this.getFlavorsForNativeCache.remove(null);
    }

    public static String encodeJavaMIMEType(String string) {
        return string != null ? JavaMIME + string : null;
    }

    public static String encodeDataFlavor(DataFlavor dataFlavor) {
        return dataFlavor != null ? SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType()) : null;
    }

    public static boolean isJavaMIMEType(String string) {
        return string != null && string.startsWith(JavaMIME, 0);
    }

    public static String decodeJavaMIMEType(String string) {
        return SystemFlavorMap.isJavaMIMEType(string) ? string.substring(JavaMIME.length(), string.length()).trim() : null;
    }

    public static DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
        return string2 != null ? new DataFlavor(string2) : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$awt$datatransfer$SystemFlavorMap == null ? (class$java$awt$datatransfer$SystemFlavorMap = SystemFlavorMap.class$("java.awt.datatransfer.SystemFlavorMap")) : class$java$awt$datatransfer$SystemFlavorMap).desiredAssertionStatus();
        JavaMIME = "JAVA_DATAFLAVOR:";
        flavorMaps = new WeakHashMap();
        UNICODE_TEXT_CLASSES = new String[]{"java.io.Reader", "java.lang.String", "java.nio.CharBuffer", "\"[C\""};
        ENCODED_TEXT_CLASSES = new String[]{"java.io.InputStream", "java.nio.ByteBuffer", "\"[B\""};
    }
}

