/* valagerrormodule.c generated by valac, the Vala compiler
 * generated from valagerrormodule.vala, do not modify */

/* valagerrormodule.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Jürg Billeter <j@bitron.ch>
 *	Thijs Vermeir <thijsvermeir@gmail.com>
 */

#include "valacodegen.h"
#include <glib.h>
#include <vala.h>
#include <valaccode.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaGErrorModulePrivate {
	gboolean is_in_catch;
};

static gint ValaGErrorModule_private_offset;
static gpointer vala_gerror_module_parent_class = NULL;

static void vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                                ValaErrorDomain* edomain,
                                                                ValaCCodeFile* decl_space);
static void vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* edomain);
static void vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                                    ValaCCodeExpression* error_expr);
static void vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                                  ValaCCodeExpression* inner_error,
                                                  gboolean unexpected,
                                                  ValaCodeNode* start_at);
static gboolean vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                              ValaCodeNode* node);
static void vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                               ValaCodeNode* node,
                                               gboolean always_fails);
static void vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static void vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                                 ValaCatchClause* clause);
static void vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                                ValaSymbol* sym,
                                                ValaCodeNode* stop_at);
static void vala_gerror_module_finalize (ValaCodeVisitor * obj);
static GType vala_gerror_module_get_type_once (void);

static inline gpointer
vala_gerror_module_get_instance_private (ValaGErrorModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGErrorModule_private_offset);
}

static void
vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                           ValaErrorDomain* edomain,
                                                           ValaCCodeFile* decl_space)
{
	ValaGErrorModule * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	ValaDataType* _tmp3_;
	ValaCCodeEnum* cenum = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeEnum* _tmp6_;
	ValaCCodeEnum* _tmp7_;
	ValaCCodeEnum* _tmp38_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	ValaCCodeMacroReplacement* error_domain_define = NULL;
	gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	ValaCCodeMacroReplacement* _tmp48_;
	ValaCCodeMacroReplacement* _tmp49_;
	ValaCCodeMacroReplacement* _tmp50_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp51_;
	ValaDataType* _tmp52_;
	ValaTypeSymbol* _tmp53_;
	ValaTypeSymbol* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeModifiers _tmp61_;
	ValaCCodeModifiers _tmp62_;
	ValaCCodeFunction* _tmp63_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_add_symbol_declaration ((ValaCCodeBaseModule*) self, decl_space, (ValaSymbol*) edomain, _tmp1_);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, _tmp3_, decl_space);
	_tmp4_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_enum_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	cenum = _tmp7_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp8_;
		gint _ecode_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _ecode_index = 0;
		_tmp8_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp8_;
		_tmp9_ = _ecode_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_ecode_size = _tmp11_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaErrorCode* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			_ecode_index = _ecode_index + 1;
			_tmp12_ = _ecode_index;
			_tmp13_ = _ecode_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _ecode_list;
			_tmp15_ = vala_list_get (_tmp14_, _ecode_index);
			ecode = (ValaErrorCode*) _tmp15_;
			_tmp16_ = ecode;
			_tmp17_ = vala_error_code_get_value (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				ValaCCodeEnum* _tmp19_;
				ValaErrorCode* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				ValaCCodeEnumValue* _tmp23_;
				ValaCCodeEnumValue* _tmp24_;
				_tmp19_ = cenum;
				_tmp20_ = ecode;
				_tmp21_ = vala_get_ccode_name ((ValaCodeNode*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_ccode_enum_value_new (_tmp22_, NULL);
				_tmp24_ = _tmp23_;
				vala_ccode_enum_add_value (_tmp19_, _tmp24_);
				_vala_ccode_node_unref0 (_tmp24_);
				_g_free0 (_tmp22_);
			} else {
				ValaErrorCode* _tmp25_;
				ValaExpression* _tmp26_;
				ValaExpression* _tmp27_;
				ValaCCodeEnum* _tmp28_;
				ValaErrorCode* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				ValaErrorCode* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaCCodeExpression* _tmp35_;
				ValaCCodeEnumValue* _tmp36_;
				ValaCCodeEnumValue* _tmp37_;
				_tmp25_ = ecode;
				_tmp26_ = vala_error_code_get_value (_tmp25_);
				_tmp27_ = _tmp26_;
				vala_code_node_emit ((ValaCodeNode*) _tmp27_, (ValaCodeGenerator*) self);
				_tmp28_ = cenum;
				_tmp29_ = ecode;
				_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = ecode;
				_tmp33_ = vala_error_code_get_value (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_get_cvalue (_tmp34_);
				_tmp36_ = vala_ccode_enum_value_new (_tmp31_, _tmp35_);
				_tmp37_ = _tmp36_;
				vala_ccode_enum_add_value (_tmp28_, _tmp37_);
				_vala_ccode_node_unref0 (_tmp37_);
				_g_free0 (_tmp31_);
			}
			_vala_code_node_unref0 (ecode);
		}
	}
	_tmp38_ = cenum;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp38_);
	_tmp39_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strconcat (_tmp40_, "quark", NULL);
	_tmp42_ = _tmp41_;
	_g_free0 (_tmp40_);
	quark_fun_name = _tmp42_;
	_tmp43_ = vala_get_ccode_upper_case_name ((ValaSymbol*) edomain, NULL);
	_tmp44_ = _tmp43_;
	_tmp45_ = quark_fun_name;
	_tmp46_ = g_strconcat (_tmp45_, " ()", NULL);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_macro_replacement_new (_tmp44_, _tmp47_);
	_tmp49_ = _tmp48_;
	_g_free0 (_tmp47_);
	_g_free0 (_tmp44_);
	error_domain_define = _tmp49_;
	_tmp50_ = error_domain_define;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp50_);
	_tmp51_ = quark_fun_name;
	_tmp52_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp53_ = vala_data_type_get_type_symbol (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_get_ccode_name ((ValaCodeNode*) _tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_ccode_function_new (_tmp51_, _tmp56_);
	_tmp58_ = _tmp57_;
	_g_free0 (_tmp56_);
	cquark_fun = _tmp58_;
	_tmp59_ = cquark_fun;
	_tmp60_ = cquark_fun;
	_tmp61_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp60_);
	_tmp62_ = _tmp61_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp60_, _tmp62_ | VALA_CCODE_MODIFIERS_EXTERN);
	((ValaCCodeBaseModule*) self)->requires_vala_extern = TRUE;
	_tmp63_ = cquark_fun;
	vala_ccode_file_add_function_declaration (decl_space, _tmp63_);
	_vala_ccode_node_unref0 (cquark_fun);
	_vala_ccode_node_unref0 (error_domain_define);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (cenum);
}

static void
vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* edomain)
{
	ValaGErrorModule * self;
	ValaComment* _tmp0_;
	ValaComment* _tmp1_;
	ValaCCodeFile* _tmp9_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ValaCCodeFunction* cquark_fun = NULL;
	ValaDataType* _tmp16_;
	ValaTypeSymbol* _tmp17_;
	ValaTypeSymbol* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunctionCall* cquark_call = NULL;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeConstant* _tmp33_;
	ValaCCodeConstant* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	ValaCCodeFile* _tmp37_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaCCodeFile* _tmp2_;
		ValaComment* _tmp3_;
		ValaComment* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValaCCodeComment* _tmp7_;
		ValaCCodeComment* _tmp8_;
		_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp3_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_comment_get_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_comment_new (_tmp6_);
		_tmp8_ = _tmp7_;
		vala_ccode_file_add_type_definition (_tmp2_, (ValaCCodeNode*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
	}
	_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp9_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp10_;
		_tmp10_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp10_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp11_;
		_tmp11_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp11_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
	_tmp12_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "quark", NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	quark_fun_name = _tmp15_;
	_tmp16_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_get_ccode_name ((ValaCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_ccode_function_new (quark_fun_name, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	cquark_fun = _tmp22_;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, cquark_fun);
	_tmp23_ = vala_ccode_identifier_new ("g_quark_from_static_string");
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp24_);
	_tmp26_ = _tmp25_;
	_vala_ccode_node_unref0 (_tmp24_);
	cquark_call = _tmp26_;
	_tmp27_ = vala_get_ccode_quark_name (edomain);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat ("\"", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "\"", NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_constant_new (_tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_call_add_argument (cquark_call, (ValaCCodeExpression*) _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp36_ = _tmp35_;
	vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) cquark_call);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp37_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function (_tmp37_, cquark_fun);
	_vala_ccode_node_unref0 (cquark_call);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
}

static void
vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaGErrorModule * self;
	ValaCCodeFunction* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCCodeExpression* _tmp6_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_throw_statement_get_error_expression (stmt);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_get_cvalue (_tmp5_);
	vala_ccode_function_add_assignment (_tmp1_, _tmp3_, _tmp6_);
	_vala_ccode_node_unref0 (_tmp3_);
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                               ValaCCodeExpression* error_expr)
{
	ValaCCodeFunctionCall* cpropagate = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	gboolean _tmp15_ = FALSE;
	ValaMethod* _tmp16_;
	ValaMethod* _tmp17_;
	g_return_if_fail (error_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_propagate_error");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cpropagate = _tmp3_;
	_tmp4_ = cpropagate;
	_tmp5_ = vala_ccode_identifier_new ("error");
	_tmp6_ = _tmp5_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp6_);
	_vala_ccode_node_unref0 (_tmp6_);
	_tmp7_ = cpropagate;
	vala_ccode_function_call_add_argument (_tmp7_, error_expr);
	_tmp8_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = cpropagate;
	vala_ccode_function_add_expression (_tmp9_, (ValaCCodeExpression*) _tmp10_);
	_tmp11_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
	_tmp12_ = _tmp11_;
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp12_, NULL, NULL);
	_tmp13_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_append_out_param_free ((ValaCCodeBaseModule*) self, _tmp14_);
	_tmp16_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp18_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_CLASS);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaClass* cl = NULL;
		ValaMethod* _tmp22_;
		ValaMethod* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaClass* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeFunction* _tmp28_;
		ValaClass* _tmp29_;
		ValaObjectType* _tmp30_;
		ValaObjectType* _tmp31_;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeIdentifier* _tmp33_;
		ValaGLibValue* _tmp34_;
		ValaGLibValue* _tmp35_;
		ValaCCodeExpression* _tmp36_;
		ValaCCodeExpression* _tmp37_;
		ValaCCodeFunction* _tmp38_;
		ValaCCodeFunction* _tmp39_;
		ValaCCodeConstant* _tmp40_;
		ValaCCodeConstant* _tmp41_;
		_tmp22_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp26_;
		_tmp27_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = cl;
		_tmp30_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_ccode_identifier_new ("self");
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_glib_value_new ((ValaDataType*) _tmp31_, (ValaCCodeExpression*) _tmp33_, TRUE);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp35_, FALSE);
		_tmp37_ = _tmp36_;
		vala_ccode_function_add_expression (_tmp28_, _tmp37_);
		_vala_ccode_node_unref0 (_tmp37_);
		_vala_target_value_unref0 (_tmp35_);
		_vala_ccode_node_unref0 (_tmp33_);
		_vala_code_node_unref0 (_tmp31_);
		_tmp38_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_ccode_constant_new ("NULL");
		_tmp41_ = _tmp40_;
		vala_ccode_function_add_return (_tmp39_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (_tmp41_);
		_vala_code_node_unref0 (cl);
	} else {
		if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
			ValaCCodeFunction* _tmp42_;
			ValaCCodeFunction* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_constant_new ("FALSE");
			_tmp45_ = _tmp44_;
			vala_ccode_function_add_return (_tmp43_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
		} else {
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			_tmp46_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
			_tmp47_ = _tmp46_;
			vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp47_, TRUE);
		}
	}
	_vala_ccode_node_unref0 (cpropagate);
}

void
vala_gerror_module_return_with_exception (ValaGErrorModule* self,
                                          ValaCCodeExpression* error_expr)
{
	ValaGErrorModuleClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_GERROR_MODULE_GET_CLASS (self);
	if (_klass_->return_with_exception) {
		_klass_->return_with_exception (self, error_expr);
	}
}

static void
vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                             ValaCCodeExpression* inner_error,
                                             gboolean unexpected,
                                             ValaCodeNode* start_at)
{
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	ValaCCodeFile* _tmp6_;
	ValaCCodeFunctionCall* ccritical = NULL;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	const gchar* _tmp11_ = NULL;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeConstant* _tmp13_;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeConstant* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeMemberAccess* _tmp22_;
	ValaCCodeMemberAccess* _tmp23_;
	ValaCCodeFunctionCall* domain_name = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeMemberAccess* _tmp29_;
	ValaCCodeMemberAccess* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeFunctionCall* _tmp32_;
	ValaCCodeFunctionCall* _tmp33_;
	ValaCCodeMemberAccess* _tmp34_;
	ValaCCodeMemberAccess* _tmp35_;
	ValaCCodeFunctionCall* cclear = NULL;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeUnaryExpression* _tmp41_;
	ValaCCodeUnaryExpression* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunctionCall* _tmp48_;
	gboolean _tmp49_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inner_error != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (start_at, VALA_TYPE_TRY_STATEMENT)) {
		ValaCodeNode* _tmp0_;
		ValaCodeNode* _tmp1_;
		_tmp0_ = vala_code_node_get_parent_node (start_at);
		_tmp1_ = _tmp0_;
		vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, (ValaSymbol*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp1_) : NULL), NULL, NULL);
	} else {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
		_tmp3_ = _tmp2_;
		vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp3_, NULL, NULL);
	}
	_tmp4_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
	_tmp5_ = _tmp4_;
	vala_ccode_base_module_append_out_param_free ((ValaCCodeBaseModule*) self, _tmp5_);
	_tmp6_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp6_, "glib.h", FALSE);
	_tmp7_ = vala_ccode_identifier_new ("g_critical");
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_ccode_node_unref0 (_tmp8_);
	ccritical = _tmp10_;
	if (unexpected) {
		_tmp11_ = "\"file %s: line %d: unexpected error: %s (%s, %d)\"";
	} else {
		_tmp11_ = "\"file %s: line %d: uncaught error: %s (%s, %d)\"";
	}
	_tmp12_ = ccritical;
	_tmp13_ = vala_ccode_constant_new (_tmp11_);
	_tmp14_ = _tmp13_;
	vala_ccode_function_call_add_argument (_tmp12_, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_tmp15_ = ccritical;
	_tmp16_ = vala_ccode_constant_new ("__FILE__");
	_tmp17_ = _tmp16_;
	vala_ccode_function_call_add_argument (_tmp15_, (ValaCCodeExpression*) _tmp17_);
	_vala_ccode_node_unref0 (_tmp17_);
	_tmp18_ = ccritical;
	_tmp19_ = vala_ccode_constant_new ("__LINE__");
	_tmp20_ = _tmp19_;
	vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_tmp21_ = ccritical;
	_tmp22_ = vala_ccode_member_access_new_pointer (inner_error, "message");
	_tmp23_ = _tmp22_;
	vala_ccode_function_call_add_argument (_tmp21_, (ValaCCodeExpression*) _tmp23_);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("g_quark_to_string");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	domain_name = _tmp27_;
	_tmp28_ = domain_name;
	_tmp29_ = vala_ccode_member_access_new_pointer (inner_error, "domain");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = ccritical;
	_tmp32_ = domain_name;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp32_);
	_tmp33_ = ccritical;
	_tmp34_ = vala_ccode_member_access_new_pointer (inner_error, "code");
	_tmp35_ = _tmp34_;
	vala_ccode_function_call_add_argument (_tmp33_, (ValaCCodeExpression*) _tmp35_);
	_vala_ccode_node_unref0 (_tmp35_);
	_tmp36_ = vala_ccode_identifier_new ("g_clear_error");
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_ccode_node_unref0 (_tmp37_);
	cclear = _tmp39_;
	_tmp40_ = cclear;
	_tmp41_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, inner_error);
	_tmp42_ = _tmp41_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = ccritical;
	vala_ccode_function_add_expression (_tmp44_, (ValaCCodeExpression*) _tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = cclear;
	vala_ccode_function_add_expression (_tmp47_, (ValaCCodeExpression*) _tmp48_);
	if (vala_ccode_base_module_is_in_constructor ((ValaCCodeBaseModule*) self)) {
		_tmp49_ = TRUE;
	} else {
		_tmp49_ = vala_ccode_base_module_is_in_destructor ((ValaCCodeBaseModule*) self);
	}
	if (_tmp49_) {
	} else {
		ValaMethod* _tmp50_;
		ValaMethod* _tmp51_;
		_tmp50_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp51_ = _tmp50_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp52_;
			ValaMethod* _tmp53_;
			ValaSymbol* _tmp54_;
			ValaSymbol* _tmp55_;
			_tmp52_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp53_);
			_tmp55_ = _tmp54_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_STRUCT)) {
				ValaCCodeFunction* _tmp56_;
				ValaCCodeFunction* _tmp57_;
				_tmp56_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp57_ = _tmp56_;
				vala_ccode_function_add_return (_tmp57_, NULL);
			} else {
				ValaCCodeFunction* _tmp58_;
				ValaCCodeFunction* _tmp59_;
				ValaCCodeConstant* _tmp60_;
				ValaCCodeConstant* _tmp61_;
				_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_ccode_constant_new ("NULL");
				_tmp61_ = _tmp60_;
				vala_ccode_function_add_return (_tmp59_, (ValaCCodeExpression*) _tmp61_);
				_vala_ccode_node_unref0 (_tmp61_);
			}
		} else {
			if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
				ValaCCodeFunctionCall* unref = NULL;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				ValaCCodeFunctionCall* _tmp64_;
				ValaCCodeFunctionCall* _tmp65_;
				ValaCCodeFunctionCall* _tmp66_;
				ValaCCodeExpression* _tmp67_;
				ValaCCodeExpression* _tmp68_;
				ValaCCodeFunction* _tmp69_;
				ValaCCodeFunction* _tmp70_;
				ValaCCodeFunctionCall* _tmp71_;
				ValaCCodeFunction* _tmp72_;
				ValaCCodeFunction* _tmp73_;
				ValaCCodeConstant* _tmp74_;
				ValaCCodeConstant* _tmp75_;
				_tmp62_ = vala_ccode_identifier_new ("g_object_unref");
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
				_tmp65_ = _tmp64_;
				_vala_ccode_node_unref0 (_tmp63_);
				unref = _tmp65_;
				_tmp66_ = unref;
				_tmp67_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_async_result");
				_tmp68_ = _tmp67_;
				vala_ccode_function_call_add_argument (_tmp66_, _tmp68_);
				_vala_ccode_node_unref0 (_tmp68_);
				_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp70_ = _tmp69_;
				_tmp71_ = unref;
				vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
				_tmp72_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_ccode_constant_new ("FALSE");
				_tmp75_ = _tmp74_;
				vala_ccode_function_add_return (_tmp73_, (ValaCCodeExpression*) _tmp75_);
				_vala_ccode_node_unref0 (_tmp75_);
				_vala_ccode_node_unref0 (unref);
			} else {
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				_tmp76_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
				_tmp77_ = _tmp76_;
				if (_tmp77_ != NULL) {
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					_tmp78_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
					_tmp79_ = _tmp78_;
					vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp79_, TRUE);
				}
			}
		}
	}
	_vala_ccode_node_unref0 (cclear);
	_vala_ccode_node_unref0 (domain_name);
	_vala_ccode_node_unref0 (ccritical);
}

static gboolean
vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                     ValaCodeNode* node)
{
	ValaCodeNode* current_node = NULL;
	ValaCodeNode* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (node);
	current_node = _tmp0_;
	while (TRUE) {
		ValaCodeNode* _tmp1_;
		ValaTryStatement* try_stmt = NULL;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaTryStatement* _tmp5_;
		gboolean _tmp6_ = FALSE;
		ValaTryStatement* _tmp7_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		_tmp1_ = current_node;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = current_node;
		_tmp3_ = vala_code_node_get_parent_node (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_TRY_STATEMENT) ? ((ValaTryStatement*) _tmp4_) : NULL);
		try_stmt = _tmp5_;
		_tmp7_ = try_stmt;
		if (_tmp7_ != NULL) {
			ValaTryStatement* _tmp8_;
			ValaBlock* _tmp9_;
			ValaBlock* _tmp10_;
			ValaCodeNode* _tmp11_;
			_tmp8_ = try_stmt;
			_tmp9_ = vala_try_statement_get_finally_body (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = current_node;
			_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp11_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = TRUE;
			_vala_code_node_unref0 (try_stmt);
			_vala_code_node_unref0 (current_node);
			return result;
		}
		_tmp12_ = current_node;
		_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _vala_code_node_ref0 (_tmp14_);
		_vala_code_node_unref0 (current_node);
		current_node = _tmp15_;
		_vala_code_node_unref0 (try_stmt);
	}
	result = FALSE;
	_vala_code_node_unref0 (current_node);
	return result;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static void
vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                          ValaCodeNode* node,
                                          gboolean always_fails)
{
	ValaGErrorModule * self;
	ValaTryStatement* _tmp15_;
	ValaTryStatement* _tmp16_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (node != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	if (always_fails) {
	} else {
		ValaCCodeBinaryExpression* ccond = NULL;
		ValaCCodeExpression* _tmp0_;
		ValaCCodeExpression* _tmp1_;
		ValaCCodeConstant* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeBinaryExpression* _tmp4_;
		ValaCCodeBinaryExpression* _tmp5_;
		ValaCCodeFunctionCall* unlikely = NULL;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		ValaCCodeBinaryExpression* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		ValaCCodeFunction* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		_tmp0_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_ccode_constant_new ("NULL");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp1_, (ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		_vala_ccode_node_unref0 (_tmp1_);
		ccond = _tmp5_;
		_tmp6_ = vala_ccode_identifier_new ("G_UNLIKELY");
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		_vala_ccode_node_unref0 (_tmp7_);
		unlikely = _tmp9_;
		_tmp10_ = unlikely;
		_tmp11_ = ccond;
		vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp11_);
		_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = unlikely;
		vala_ccode_function_open_if (_tmp13_, (ValaCCodeExpression*) _tmp14_);
		_vala_ccode_node_unref0 (unlikely);
		_vala_ccode_node_unref0 (ccond);
	}
	_tmp15_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp25_;
		ValaArrayList* _tmp26_;
		ValaArrayList* _tmp27_;
		gboolean has_general_catch_clause = FALSE;
		if (self->priv->is_in_catch) {
			ValaSymbol* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaCatchClause* _tmp19_;
			ValaCatchClause* _tmp20_;
			_tmp17_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
			_tmp20_ = _tmp19_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp18_, NULL, (ValaCodeNode*) _tmp20_);
		} else {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaTryStatement* _tmp23_;
			ValaTryStatement* _tmp24_;
			_tmp21_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
			_tmp24_ = _tmp23_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp22_, NULL, (ValaCodeNode*) _tmp24_);
		}
		_tmp25_ = g_direct_equal;
		_tmp26_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp25_);
		error_types = _tmp26_;
		_tmp27_ = error_types;
		vala_code_node_get_error_types (node, (ValaCollection*) _tmp27_, NULL);
		has_general_catch_clause = FALSE;
		if (!self->priv->is_in_catch) {
			ValaArrayList* handled_error_types = NULL;
			GEqualFunc _tmp28_;
			ValaArrayList* _tmp29_;
			_tmp28_ = g_direct_equal;
			_tmp29_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp28_);
			handled_error_types = _tmp29_;
			{
				ValaList* _clause_list = NULL;
				ValaTryStatement* _tmp30_;
				ValaTryStatement* _tmp31_;
				ValaList* _tmp32_;
				gint _clause_size = 0;
				ValaList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _clause_index = 0;
				_tmp30_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_try_statement_get_catch_clauses (_tmp31_);
				_clause_list = _tmp32_;
				_tmp33_ = _clause_list;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_clause_size = _tmp35_;
				_clause_index = -1;
				while (TRUE) {
					gint _tmp36_;
					gint _tmp37_;
					ValaCatchClause* clause = NULL;
					ValaList* _tmp38_;
					gpointer _tmp39_;
					ValaArrayList* _tmp68_;
					ValaCatchClause* _tmp69_;
					ValaDataType* _tmp70_;
					ValaDataType* _tmp71_;
					ValaErrorType* _tmp72_;
					_clause_index = _clause_index + 1;
					_tmp36_ = _clause_index;
					_tmp37_ = _clause_size;
					if (!(_tmp36_ < _tmp37_)) {
						break;
					}
					_tmp38_ = _clause_list;
					_tmp39_ = vala_list_get (_tmp38_, _clause_index);
					clause = (ValaCatchClause*) _tmp39_;
					{
						ValaArrayList* _node_error_type_list = NULL;
						ValaArrayList* _tmp40_;
						gint _node_error_type_size = 0;
						ValaArrayList* _tmp41_;
						gint _tmp42_;
						gint _tmp43_;
						gint _node_error_type_index = 0;
						_tmp40_ = error_types;
						_node_error_type_list = _tmp40_;
						_tmp41_ = _node_error_type_list;
						_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
						_tmp43_ = _tmp42_;
						_node_error_type_size = _tmp43_;
						_node_error_type_index = -1;
						while (TRUE) {
							gint _tmp44_;
							gint _tmp45_;
							ValaDataType* node_error_type = NULL;
							ValaArrayList* _tmp46_;
							gpointer _tmp47_;
							gboolean _tmp48_ = FALSE;
							ValaCatchClause* _tmp49_;
							ValaDataType* _tmp50_;
							ValaDataType* _tmp51_;
							_node_error_type_index = _node_error_type_index + 1;
							_tmp44_ = _node_error_type_index;
							_tmp45_ = _node_error_type_size;
							if (!(_tmp44_ < _tmp45_)) {
								break;
							}
							_tmp46_ = _node_error_type_list;
							_tmp47_ = vala_list_get ((ValaList*) _tmp46_, _node_error_type_index);
							node_error_type = (ValaDataType*) _tmp47_;
							_tmp49_ = clause;
							_tmp50_ = vala_catch_clause_get_error_type (_tmp49_);
							_tmp51_ = _tmp50_;
							if (_tmp51_ == NULL) {
								_tmp48_ = TRUE;
							} else {
								ValaDataType* _tmp52_;
								ValaCatchClause* _tmp53_;
								ValaDataType* _tmp54_;
								ValaDataType* _tmp55_;
								_tmp52_ = node_error_type;
								_tmp53_ = clause;
								_tmp54_ = vala_catch_clause_get_error_type (_tmp53_);
								_tmp55_ = _tmp54_;
								_tmp48_ = vala_data_type_compatible (_tmp52_, _tmp55_);
							}
							if (_tmp48_) {
								ValaArrayList* _tmp56_;
								ValaDataType* _tmp57_;
								_tmp56_ = handled_error_types;
								_tmp57_ = node_error_type;
								vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
							}
							_vala_code_node_unref0 (node_error_type);
						}
					}
					{
						ValaArrayList* _handled_error_type_list = NULL;
						ValaArrayList* _tmp58_;
						gint _handled_error_type_size = 0;
						ValaArrayList* _tmp59_;
						gint _tmp60_;
						gint _tmp61_;
						gint _handled_error_type_index = 0;
						_tmp58_ = handled_error_types;
						_handled_error_type_list = _tmp58_;
						_tmp59_ = _handled_error_type_list;
						_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
						_tmp61_ = _tmp60_;
						_handled_error_type_size = _tmp61_;
						_handled_error_type_index = -1;
						while (TRUE) {
							gint _tmp62_;
							gint _tmp63_;
							ValaDataType* handled_error_type = NULL;
							ValaArrayList* _tmp64_;
							gpointer _tmp65_;
							ValaArrayList* _tmp66_;
							ValaDataType* _tmp67_;
							_handled_error_type_index = _handled_error_type_index + 1;
							_tmp62_ = _handled_error_type_index;
							_tmp63_ = _handled_error_type_size;
							if (!(_tmp62_ < _tmp63_)) {
								break;
							}
							_tmp64_ = _handled_error_type_list;
							_tmp65_ = vala_list_get ((ValaList*) _tmp64_, _handled_error_type_index);
							handled_error_type = (ValaDataType*) _tmp65_;
							_tmp66_ = error_types;
							_tmp67_ = handled_error_type;
							vala_collection_remove ((ValaCollection*) _tmp66_, _tmp67_);
							_vala_code_node_unref0 (handled_error_type);
						}
					}
					_tmp68_ = handled_error_types;
					vala_collection_clear ((ValaCollection*) _tmp68_);
					_tmp69_ = clause;
					_tmp70_ = vala_catch_clause_get_error_type (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp71_, (ValaDataType*) _tmp72_)) {
						ValaCCodeFunction* _tmp73_;
						ValaCCodeFunction* _tmp74_;
						ValaCatchClause* _tmp75_;
						gchar* _tmp76_;
						gchar* _tmp77_;
						has_general_catch_clause = TRUE;
						_tmp73_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp74_ = _tmp73_;
						_tmp75_ = clause;
						_tmp76_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp75_, "CCode", "cname", NULL);
						_tmp77_ = _tmp76_;
						vala_ccode_function_add_goto (_tmp74_, _tmp77_);
						_g_free0 (_tmp77_);
						_vala_code_node_unref0 (clause);
						break;
					} else {
						ValaErrorType* catch_type = NULL;
						ValaCatchClause* _tmp78_;
						ValaDataType* _tmp79_;
						ValaDataType* _tmp80_;
						ValaErrorType* _tmp81_;
						ValaErrorCode* _tmp82_;
						ValaErrorCode* _tmp83_;
						ValaCCodeFunction* _tmp126_;
						ValaCCodeFunction* _tmp127_;
						ValaCatchClause* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						ValaCCodeFunction* _tmp131_;
						ValaCCodeFunction* _tmp132_;
						_tmp78_ = clause;
						_tmp79_ = vala_catch_clause_get_error_type (_tmp78_);
						_tmp80_ = _tmp79_;
						catch_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_ERROR_TYPE, ValaErrorType);
						_tmp81_ = catch_type;
						_tmp82_ = vala_error_type_get_error_code (_tmp81_);
						_tmp83_ = _tmp82_;
						if (_tmp83_ != NULL) {
							ValaCCodeFunctionCall* error_match = NULL;
							ValaCCodeIdentifier* _tmp84_;
							ValaCCodeIdentifier* _tmp85_;
							ValaCCodeFunctionCall* _tmp86_;
							ValaCCodeFunctionCall* _tmp87_;
							ValaCCodeFunctionCall* _tmp88_;
							ValaCCodeExpression* _tmp89_;
							ValaCCodeExpression* _tmp90_;
							ValaCCodeFunctionCall* _tmp91_;
							ValaErrorType* _tmp92_;
							ValaErrorDomain* _tmp93_;
							ValaErrorDomain* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							ValaCCodeIdentifier* _tmp97_;
							ValaCCodeIdentifier* _tmp98_;
							ValaCCodeFunctionCall* _tmp99_;
							ValaErrorType* _tmp100_;
							ValaErrorCode* _tmp101_;
							ValaErrorCode* _tmp102_;
							gchar* _tmp103_;
							gchar* _tmp104_;
							ValaCCodeIdentifier* _tmp105_;
							ValaCCodeIdentifier* _tmp106_;
							ValaCCodeFunction* _tmp107_;
							ValaCCodeFunction* _tmp108_;
							ValaCCodeFunctionCall* _tmp109_;
							_tmp84_ = vala_ccode_identifier_new ("g_error_matches");
							_tmp85_ = _tmp84_;
							_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
							_tmp87_ = _tmp86_;
							_vala_ccode_node_unref0 (_tmp85_);
							error_match = _tmp87_;
							_tmp88_ = error_match;
							_tmp89_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
							_tmp90_ = _tmp89_;
							vala_ccode_function_call_add_argument (_tmp88_, _tmp90_);
							_vala_ccode_node_unref0 (_tmp90_);
							_tmp91_ = error_match;
							_tmp92_ = catch_type;
							_tmp93_ = vala_error_type_get_error_domain (_tmp92_);
							_tmp94_ = _tmp93_;
							_tmp95_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp94_, NULL);
							_tmp96_ = _tmp95_;
							_tmp97_ = vala_ccode_identifier_new (_tmp96_);
							_tmp98_ = _tmp97_;
							vala_ccode_function_call_add_argument (_tmp91_, (ValaCCodeExpression*) _tmp98_);
							_vala_ccode_node_unref0 (_tmp98_);
							_g_free0 (_tmp96_);
							_tmp99_ = error_match;
							_tmp100_ = catch_type;
							_tmp101_ = vala_error_type_get_error_code (_tmp100_);
							_tmp102_ = _tmp101_;
							_tmp103_ = vala_get_ccode_name ((ValaCodeNode*) _tmp102_);
							_tmp104_ = _tmp103_;
							_tmp105_ = vala_ccode_identifier_new (_tmp104_);
							_tmp106_ = _tmp105_;
							vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp106_);
							_vala_ccode_node_unref0 (_tmp106_);
							_g_free0 (_tmp104_);
							_tmp107_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp108_ = _tmp107_;
							_tmp109_ = error_match;
							vala_ccode_function_open_if (_tmp108_, (ValaCCodeExpression*) _tmp109_);
							_vala_ccode_node_unref0 (error_match);
						} else {
							ValaCCodeBinaryExpression* ccond = NULL;
							ValaCCodeExpression* _tmp110_;
							ValaCCodeExpression* _tmp111_;
							ValaCCodeMemberAccess* _tmp112_;
							ValaCCodeMemberAccess* _tmp113_;
							ValaErrorType* _tmp114_;
							ValaErrorDomain* _tmp115_;
							ValaErrorDomain* _tmp116_;
							gchar* _tmp117_;
							gchar* _tmp118_;
							ValaCCodeIdentifier* _tmp119_;
							ValaCCodeIdentifier* _tmp120_;
							ValaCCodeBinaryExpression* _tmp121_;
							ValaCCodeBinaryExpression* _tmp122_;
							ValaCCodeFunction* _tmp123_;
							ValaCCodeFunction* _tmp124_;
							ValaCCodeBinaryExpression* _tmp125_;
							_tmp110_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
							_tmp111_ = _tmp110_;
							_tmp112_ = vala_ccode_member_access_new_pointer (_tmp111_, "domain");
							_tmp113_ = _tmp112_;
							_tmp114_ = catch_type;
							_tmp115_ = vala_error_type_get_error_domain (_tmp114_);
							_tmp116_ = _tmp115_;
							_tmp117_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp116_, NULL);
							_tmp118_ = _tmp117_;
							_tmp119_ = vala_ccode_identifier_new (_tmp118_);
							_tmp120_ = _tmp119_;
							_tmp121_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp113_, (ValaCCodeExpression*) _tmp120_);
							_tmp122_ = _tmp121_;
							_vala_ccode_node_unref0 (_tmp120_);
							_g_free0 (_tmp118_);
							_vala_ccode_node_unref0 (_tmp113_);
							_vala_ccode_node_unref0 (_tmp111_);
							ccond = _tmp122_;
							_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp124_ = _tmp123_;
							_tmp125_ = ccond;
							vala_ccode_function_open_if (_tmp124_, (ValaCCodeExpression*) _tmp125_);
							_vala_ccode_node_unref0 (ccond);
						}
						_tmp126_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp127_ = _tmp126_;
						_tmp128_ = clause;
						_tmp129_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp128_, "CCode", "cname", NULL);
						_tmp130_ = _tmp129_;
						vala_ccode_function_add_goto (_tmp127_, _tmp130_);
						_g_free0 (_tmp130_);
						_tmp131_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp132_ = _tmp131_;
						vala_ccode_function_close (_tmp132_);
					}
					_vala_code_node_unref0 (clause);
				}
			}
			_vala_iterable_unref0 (handled_error_types);
		}
		if (has_general_catch_clause) {
		} else {
			ValaArrayList* _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			_tmp133_ = error_types;
			_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
			_tmp135_ = _tmp134_;
			if (_tmp135_ > 0) {
				ValaCCodeFunction* _tmp136_;
				ValaCCodeFunction* _tmp137_;
				gint _tmp138_;
				gint _tmp139_;
				gchar* _tmp140_;
				gchar* _tmp141_;
				_tmp136_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_ccode_base_module_get_current_try_id ((ValaCCodeBaseModule*) self);
				_tmp139_ = _tmp138_;
				_tmp140_ = g_strdup_printf ("__finally%d", _tmp139_);
				_tmp141_ = _tmp140_;
				vala_ccode_function_add_goto (_tmp137_, _tmp141_);
				_g_free0 (_tmp141_);
			} else {
				if (vala_gerror_module_in_finally_block (self, node)) {
				} else {
					ValaCCodeExpression* _tmp142_;
					ValaCCodeExpression* _tmp143_;
					ValaTryStatement* _tmp144_;
					ValaTryStatement* _tmp145_;
					_tmp142_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
					_tmp143_ = _tmp142_;
					_tmp144_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
					_tmp145_ = _tmp144_;
					vala_gerror_module_uncaught_error_statement (self, _tmp143_, TRUE, (ValaCodeNode*) _tmp145_);
					_vala_ccode_node_unref0 (_tmp143_);
				}
			}
		}
		_vala_iterable_unref0 (error_types);
	} else {
		gboolean _tmp146_ = FALSE;
		ValaMethod* _tmp147_;
		ValaMethod* _tmp148_;
		_tmp147_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp148_ = _tmp147_;
		if (_tmp148_ != NULL) {
			ValaMethod* _tmp149_;
			ValaMethod* _tmp150_;
			gboolean _tmp151_;
			gboolean _tmp152_;
			_tmp149_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp150_);
			_tmp152_ = _tmp151_;
			_tmp146_ = _tmp152_;
		} else {
			_tmp146_ = FALSE;
		}
		if (_tmp146_) {
			ValaCCodeBinaryExpression* ccond = NULL;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp153_;
			ValaArrayList* _tmp154_;
			ValaMethod* _tmp155_;
			ValaMethod* _tmp156_;
			ValaArrayList* _tmp157_;
			ValaCCodeBinaryExpression* _tmp187_;
			ccond = NULL;
			_tmp153_ = g_direct_equal;
			_tmp154_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp153_);
			error_types = _tmp154_;
			_tmp155_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp156_ = _tmp155_;
			_tmp157_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp156_, (ValaCollection*) _tmp157_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp158_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp159_;
				gint _tmp160_;
				gint _tmp161_;
				gint _error_type_index = 0;
				_tmp158_ = error_types;
				_error_type_list = _tmp158_;
				_tmp159_ = _error_type_list;
				_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
				_tmp161_ = _tmp160_;
				_error_type_size = _tmp161_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp162_;
					gint _tmp163_;
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp164_;
					gpointer _tmp165_;
					ValaDataType* _tmp166_;
					ValaErrorType* _tmp167_;
					ValaCCodeBinaryExpression* domain_check = NULL;
					ValaCCodeExpression* _tmp168_;
					ValaCCodeExpression* _tmp169_;
					ValaCCodeMemberAccess* _tmp170_;
					ValaCCodeMemberAccess* _tmp171_;
					ValaDataType* _tmp172_;
					ValaErrorDomain* _tmp173_;
					ValaErrorDomain* _tmp174_;
					gchar* _tmp175_;
					gchar* _tmp176_;
					ValaCCodeIdentifier* _tmp177_;
					ValaCCodeIdentifier* _tmp178_;
					ValaCCodeBinaryExpression* _tmp179_;
					ValaCCodeBinaryExpression* _tmp180_;
					ValaCCodeBinaryExpression* _tmp181_;
					_error_type_index = _error_type_index + 1;
					_tmp162_ = _error_type_index;
					_tmp163_ = _error_type_size;
					if (!(_tmp162_ < _tmp163_)) {
						break;
					}
					_tmp164_ = _error_type_list;
					_tmp165_ = vala_list_get ((ValaList*) _tmp164_, _error_type_index);
					error_type = (ValaDataType*) _tmp165_;
					_tmp166_ = error_type;
					_tmp167_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp166_, (ValaDataType*) _tmp167_)) {
						_vala_ccode_node_unref0 (ccond);
						ccond = NULL;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp168_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
					_tmp169_ = _tmp168_;
					_tmp170_ = vala_ccode_member_access_new_pointer (_tmp169_, "domain");
					_tmp171_ = _tmp170_;
					_tmp172_ = error_type;
					_tmp173_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp172_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp174_ = _tmp173_;
					_tmp175_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp174_, NULL);
					_tmp176_ = _tmp175_;
					_tmp177_ = vala_ccode_identifier_new (_tmp176_);
					_tmp178_ = _tmp177_;
					_tmp179_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp171_, (ValaCCodeExpression*) _tmp178_);
					_tmp180_ = _tmp179_;
					_vala_ccode_node_unref0 (_tmp178_);
					_g_free0 (_tmp176_);
					_vala_ccode_node_unref0 (_tmp171_);
					_vala_ccode_node_unref0 (_tmp169_);
					domain_check = _tmp180_;
					_tmp181_ = ccond;
					if (_tmp181_ == NULL) {
						ValaCCodeBinaryExpression* _tmp182_;
						ValaCCodeBinaryExpression* _tmp183_;
						_tmp182_ = domain_check;
						_tmp183_ = _vala_ccode_node_ref0 (_tmp182_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp183_;
					} else {
						ValaCCodeBinaryExpression* _tmp184_;
						ValaCCodeBinaryExpression* _tmp185_;
						ValaCCodeBinaryExpression* _tmp186_;
						_tmp184_ = ccond;
						_tmp185_ = domain_check;
						_tmp186_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) _tmp184_, (ValaCCodeExpression*) _tmp185_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp186_;
					}
					_vala_ccode_node_unref0 (domain_check);
					_vala_code_node_unref0 (error_type);
				}
			}
			_tmp187_ = ccond;
			if (_tmp187_ != NULL) {
				ValaCCodeFunction* _tmp188_;
				ValaCCodeFunction* _tmp189_;
				ValaCCodeBinaryExpression* _tmp190_;
				ValaCCodeExpression* _tmp191_;
				ValaCCodeExpression* _tmp192_;
				ValaCCodeFunction* _tmp193_;
				ValaCCodeFunction* _tmp194_;
				ValaCCodeExpression* _tmp195_;
				ValaCCodeExpression* _tmp196_;
				ValaCCodeFunction* _tmp197_;
				ValaCCodeFunction* _tmp198_;
				_tmp188_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp189_ = _tmp188_;
				_tmp190_ = ccond;
				vala_ccode_function_open_if (_tmp189_, (ValaCCodeExpression*) _tmp190_);
				_tmp191_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp192_ = _tmp191_;
				vala_gerror_module_return_with_exception (self, _tmp192_);
				_vala_ccode_node_unref0 (_tmp192_);
				_tmp193_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp194_ = _tmp193_;
				vala_ccode_function_add_else (_tmp194_);
				_tmp195_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp196_ = _tmp195_;
				vala_gerror_module_uncaught_error_statement (self, _tmp196_, FALSE, NULL);
				_vala_ccode_node_unref0 (_tmp196_);
				_tmp197_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp198_ = _tmp197_;
				vala_ccode_function_close (_tmp198_);
			} else {
				ValaCCodeExpression* _tmp199_;
				ValaCCodeExpression* _tmp200_;
				_tmp199_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp200_ = _tmp199_;
				vala_gerror_module_return_with_exception (self, _tmp200_);
				_vala_ccode_node_unref0 (_tmp200_);
			}
			_vala_iterable_unref0 (error_types);
			_vala_ccode_node_unref0 (ccond);
		} else {
			ValaCCodeExpression* _tmp201_;
			ValaCCodeExpression* _tmp202_;
			_tmp201_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
			_tmp202_ = _tmp201_;
			vala_gerror_module_uncaught_error_statement (self, _tmp202_, FALSE, NULL);
			_vala_ccode_node_unref0 (_tmp202_);
		}
	}
	if (!always_fails) {
		ValaCCodeFunction* _tmp203_;
		ValaCCodeFunction* _tmp204_;
		_tmp203_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp204_ = _tmp203_;
		vala_ccode_function_close (_tmp204_);
	}
}

static void
vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaGErrorModule * self;
	gint this_try_id = 0;
	gint _tmp0_;
	gint _tmp1_;
	ValaTryStatement* old_try = NULL;
	ValaTryStatement* _tmp2_;
	ValaTryStatement* _tmp3_;
	ValaTryStatement* _tmp4_;
	gint old_try_id = 0;
	gint _tmp5_;
	gint _tmp6_;
	gboolean old_is_in_catch = FALSE;
	ValaCatchClause* old_catch = NULL;
	ValaCatchClause* _tmp7_;
	ValaCatchClause* _tmp8_;
	ValaCatchClause* _tmp9_;
	ValaBlock* _tmp26_;
	ValaBlock* _tmp27_;
	ValaTryStatement* _tmp42_;
	ValaCatchClause* _tmp43_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	ValaBlock* _tmp48_;
	ValaBlock* _tmp49_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_ccode_base_module_get_next_try_id ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_set_next_try_id ((ValaCCodeBaseModule*) self, _tmp1_ + 1);
	this_try_id = _tmp1_;
	_tmp2_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	old_try = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_current_try_id ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	old_try_id = _tmp6_;
	old_is_in_catch = self->priv->is_in_catch;
	_tmp7_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (_tmp8_);
	old_catch = _tmp9_;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, stmt);
	vala_ccode_base_module_set_current_try_id ((ValaCCodeBaseModule*) self, this_try_id);
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp10_;
		gint _clause_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _clause_index = 0;
		_tmp10_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp10_;
		_tmp11_ = _clause_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_clause_size = _tmp13_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaCatchClause* _tmp18_;
			ValaCatchClause* _tmp19_;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_clause_index = _clause_index + 1;
			_tmp14_ = _clause_index;
			_tmp15_ = _clause_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _clause_list;
			_tmp17_ = vala_list_get (_tmp16_, _clause_index);
			clause = (ValaCatchClause*) _tmp17_;
			_tmp18_ = clause;
			_tmp19_ = clause;
			_tmp20_ = vala_catch_clause_get_error_type (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup_printf ("__catch%d_%s", this_try_id, _tmp23_);
			_tmp25_ = _tmp24_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp18_, "CCode", "cname", _tmp25_, NULL);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
			_vala_code_node_unref0 (clause);
		}
	}
	self->priv->is_in_catch = FALSE;
	_tmp26_ = vala_try_statement_get_body (stmt);
	_tmp27_ = _tmp26_;
	vala_code_node_emit ((ValaCodeNode*) _tmp27_, (ValaCodeGenerator*) self);
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp28_;
		gint _clause_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _clause_index = 0;
		_tmp28_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp28_;
		_tmp29_ = _clause_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_clause_size = _tmp31_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp34_;
			gpointer _tmp35_;
			ValaCatchClause* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			ValaCatchClause* _tmp41_;
			_clause_index = _clause_index + 1;
			_tmp32_ = _clause_index;
			_tmp33_ = _clause_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _clause_list;
			_tmp35_ = vala_list_get (_tmp34_, _clause_index);
			clause = (ValaCatchClause*) _tmp35_;
			_tmp36_ = clause;
			vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp36_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup_printf ("__finally%d", this_try_id);
			_tmp40_ = _tmp39_;
			vala_ccode_function_add_goto (_tmp38_, _tmp40_);
			_g_free0 (_tmp40_);
			_tmp41_ = clause;
			vala_code_node_emit ((ValaCodeNode*) _tmp41_, (ValaCodeGenerator*) self);
			_vala_code_node_unref0 (clause);
		}
	}
	_tmp42_ = old_try;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, _tmp42_);
	vala_ccode_base_module_set_current_try_id ((ValaCCodeBaseModule*) self, old_try_id);
	self->priv->is_in_catch = old_is_in_catch;
	_tmp43_ = old_catch;
	vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp43_);
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf ("__finally%d", this_try_id);
	_tmp47_ = _tmp46_;
	vala_ccode_function_add_label (_tmp45_, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = vala_try_statement_get_finally_body (stmt);
	_tmp49_ = _tmp48_;
	if (_tmp49_ != NULL) {
		gint _tmp50_;
		gint _tmp51_;
		ValaBlock* _tmp52_;
		ValaBlock* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		_tmp50_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
		_tmp51_ = _tmp50_;
		vala_ccode_base_module_set_current_inner_error_id ((ValaCCodeBaseModule*) self, _tmp51_ + 1);
		_tmp52_ = vala_try_statement_get_finally_body (stmt);
		_tmp53_ = _tmp52_;
		vala_code_node_emit ((ValaCodeNode*) _tmp53_, (ValaCodeGenerator*) self);
		_tmp54_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
		_tmp55_ = _tmp54_;
		vala_ccode_base_module_set_current_inner_error_id ((ValaCCodeBaseModule*) self, _tmp55_ - 1);
	}
	_tmp56_ = vala_try_statement_get_after_try_block_reachable (stmt);
	_tmp57_ = _tmp56_;
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, !_tmp57_);
	_vala_code_node_unref0 (old_catch);
	_vala_code_node_unref0 (old_try);
}

static void
vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                            ValaCatchClause* clause)
{
	ValaGErrorModule * self;
	ValaErrorType* error_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaErrorType* _tmp2_;
	ValaErrorType* _tmp3_;
	ValaErrorDomain* _tmp4_;
	ValaErrorDomain* _tmp5_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaLocalVariable* _tmp17_;
	ValaLocalVariable* _tmp18_;
	ValaBlock* _tmp58_;
	ValaBlock* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (clause != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_catch_clause_get_error_type (clause);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
	error_type = _tmp2_;
	_tmp3_ = error_type;
	_tmp4_ = vala_error_type_get_error_domain (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaErrorType* _tmp6_;
		ValaErrorDomain* _tmp7_;
		ValaErrorDomain* _tmp8_;
		ValaCCodeFile* _tmp9_;
		_tmp6_ = error_type;
		_tmp7_ = vala_error_type_get_error_domain (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, _tmp8_, _tmp9_);
	}
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_code_node_get_attribute_string ((ValaCodeNode*) clause, "CCode", "cname", NULL);
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_label (_tmp11_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	vala_ccode_function_open_block (_tmp15_);
	_tmp17_ = vala_catch_clause_get_error_variable (clause);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaLocalVariable* _tmp19_;
		ValaLocalVariable* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = vala_catch_clause_get_error_variable (clause);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_used ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaLocalVariable* _tmp23_;
		ValaLocalVariable* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaLocalVariable* _tmp27_;
		ValaLocalVariable* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		ValaCCodeExpression* _tmp31_;
		ValaCCodeExpression* _tmp32_;
		ValaCCodeExpression* _tmp33_;
		ValaCCodeExpression* _tmp34_;
		ValaCCodeFunction* _tmp35_;
		ValaCCodeFunction* _tmp36_;
		ValaCCodeExpression* _tmp37_;
		ValaCCodeExpression* _tmp38_;
		ValaCCodeConstant* _tmp39_;
		ValaCCodeConstant* _tmp40_;
		_tmp23_ = vala_catch_clause_get_error_variable (clause);
		_tmp24_ = _tmp23_;
		vala_code_visitor_visit_local_variable ((ValaCodeVisitor*) self, _tmp24_);
		_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_catch_clause_get_error_variable (clause);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_ccode_base_module_get_local_cname ((ValaCCodeBaseModule*) self, _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp34_ = _tmp33_;
		vala_ccode_function_add_assignment (_tmp26_, _tmp32_, _tmp34_);
		_vala_ccode_node_unref0 (_tmp34_);
		_vala_ccode_node_unref0 (_tmp32_);
		_g_free0 (_tmp30_);
		_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_ccode_constant_new ("NULL");
		_tmp40_ = _tmp39_;
		vala_ccode_function_add_assignment (_tmp36_, _tmp38_, (ValaCCodeExpression*) _tmp40_);
		_vala_ccode_node_unref0 (_tmp40_);
		_vala_ccode_node_unref0 (_tmp38_);
	} else {
		ValaLocalVariable* _tmp41_;
		ValaLocalVariable* _tmp42_;
		ValaCCodeFile* _tmp45_;
		ValaCCodeFunctionCall* cclear = NULL;
		ValaCCodeIdentifier* _tmp46_;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeFunctionCall* _tmp49_;
		ValaCCodeFunctionCall* _tmp50_;
		ValaCCodeExpression* _tmp51_;
		ValaCCodeExpression* _tmp52_;
		ValaCCodeUnaryExpression* _tmp53_;
		ValaCCodeUnaryExpression* _tmp54_;
		ValaCCodeFunction* _tmp55_;
		ValaCCodeFunction* _tmp56_;
		ValaCCodeFunctionCall* _tmp57_;
		_tmp41_ = vala_catch_clause_get_error_variable (clause);
		_tmp42_ = _tmp41_;
		if (_tmp42_ != NULL) {
			ValaLocalVariable* _tmp43_;
			ValaLocalVariable* _tmp44_;
			_tmp43_ = vala_catch_clause_get_error_variable (clause);
			_tmp44_ = _tmp43_;
			vala_code_node_set_unreachable ((ValaCodeNode*) _tmp44_, TRUE);
		}
		_tmp45_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp45_, "glib.h", FALSE);
		_tmp46_ = vala_ccode_identifier_new ("g_clear_error");
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_ccode_node_unref0 (_tmp47_);
		cclear = _tmp49_;
		_tmp50_ = cclear;
		_tmp51_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp52_);
		_tmp54_ = _tmp53_;
		vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp54_);
		_vala_ccode_node_unref0 (_tmp54_);
		_vala_ccode_node_unref0 (_tmp52_);
		_tmp55_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp56_ = _tmp55_;
		_tmp57_ = cclear;
		vala_ccode_function_add_expression (_tmp56_, (ValaCCodeExpression*) _tmp57_);
		_vala_ccode_node_unref0 (cclear);
	}
	_tmp58_ = vala_catch_clause_get_body (clause);
	_tmp59_ = _tmp58_;
	vala_code_node_emit ((ValaCodeNode*) _tmp59_, (ValaCodeGenerator*) self);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	vala_ccode_function_close (_tmp61_);
	_vala_code_node_unref0 (error_type);
}

static void
vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                           ValaSymbol* sym,
                                           ValaCodeNode* stop_at)
{
	ValaGErrorModule * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (sym != NULL);
	VALA_CCODE_BASE_MODULE_CLASS (vala_gerror_module_parent_class)->append_scope_free ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule), sym, stop_at);
	if (G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_TRY_STATEMENT)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_CATCH_CLAUSE);
	}
	if (!_tmp0_) {
		ValaBlock* finally_block = NULL;
		ValaBlock* _tmp1_;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		gboolean _tmp18_ = FALSE;
		ValaBlock* _tmp19_;
		_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (NULL, VALA_TYPE_BLOCK, ValaBlock));
		finally_block = _tmp1_;
		_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
		_tmp3_ = _tmp2_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TRY_STATEMENT)) {
			ValaCodeNode* _tmp4_;
			ValaCodeNode* _tmp5_;
			ValaBlock* _tmp6_;
			ValaBlock* _tmp7_;
			ValaBlock* _tmp8_;
			_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
			_tmp7_ = _tmp6_;
			_tmp8_ = _vala_code_node_ref0 (_tmp7_);
			_vala_code_node_unref0 (finally_block);
			finally_block = _tmp8_;
		} else {
			ValaCodeNode* _tmp9_;
			ValaCodeNode* _tmp10_;
			_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp10_ = _tmp9_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_CATCH_CLAUSE)) {
				ValaCodeNode* _tmp11_;
				ValaCodeNode* _tmp12_;
				ValaCodeNode* _tmp13_;
				ValaCodeNode* _tmp14_;
				ValaBlock* _tmp15_;
				ValaBlock* _tmp16_;
				ValaBlock* _tmp17_;
				_tmp11_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
				_tmp16_ = _tmp15_;
				_tmp17_ = _vala_code_node_ref0 (_tmp16_);
				_vala_code_node_unref0 (finally_block);
				finally_block = _tmp17_;
			}
		}
		_tmp19_ = finally_block;
		if (_tmp19_ != NULL) {
			ValaBlock* _tmp20_;
			_tmp20_ = finally_block;
			_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_SYMBOL, ValaSymbol) != sym;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaBlock* _tmp21_;
			_tmp21_ = finally_block;
			vala_code_node_emit ((ValaCodeNode*) _tmp21_, (ValaCodeGenerator*) self);
		}
		_vala_code_node_unref0 (finally_block);
	}
}

ValaGErrorModule*
vala_gerror_module_construct (GType object_type)
{
	ValaGErrorModule* self = NULL;
	self = (ValaGErrorModule*) vala_ccode_delegate_module_construct (object_type);
	return self;
}

ValaGErrorModule*
vala_gerror_module_new (void)
{
	return vala_gerror_module_construct (VALA_TYPE_GERROR_MODULE);
}

static void
vala_gerror_module_class_init (ValaGErrorModuleClass * klass,
                               gpointer klass_data)
{
	vala_gerror_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gerror_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGErrorModule_private_offset);
	((ValaCCodeBaseModuleClass *) klass)->generate_error_domain_declaration = (void (*) (ValaCCodeBaseModule*, ValaErrorDomain*, ValaCCodeFile*)) vala_gerror_module_real_generate_error_domain_declaration;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gerror_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_gerror_module_real_visit_throw_statement;
	((ValaGErrorModuleClass *) klass)->return_with_exception = (void (*) (ValaGErrorModule*, ValaCCodeExpression*)) vala_gerror_module_real_return_with_exception;
	((ValaCCodeBaseModuleClass *) klass)->add_simple_check = (void (*) (ValaCCodeBaseModule*, ValaCodeNode*, gboolean)) vala_gerror_module_real_add_simple_check;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_gerror_module_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor*, ValaCatchClause*)) vala_gerror_module_real_visit_catch_clause;
	((ValaCCodeBaseModuleClass *) klass)->append_scope_free = (void (*) (ValaCCodeBaseModule*, ValaSymbol*, ValaCodeNode*)) vala_gerror_module_real_append_scope_free;
}

static void
vala_gerror_module_instance_init (ValaGErrorModule * self,
                                  gpointer klass)
{
	self->priv = vala_gerror_module_get_instance_private (self);
	self->priv->is_in_catch = FALSE;
}

static void
vala_gerror_module_finalize (ValaCodeVisitor * obj)
{
	ValaGErrorModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GERROR_MODULE, ValaGErrorModule);
	VALA_CODE_VISITOR_CLASS (vala_gerror_module_parent_class)->finalize (obj);
}

static GType
vala_gerror_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGErrorModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gerror_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGErrorModule), 0, (GInstanceInitFunc) vala_gerror_module_instance_init, NULL };
	GType vala_gerror_module_type_id;
	vala_gerror_module_type_id = g_type_register_static (VALA_TYPE_CCODE_DELEGATE_MODULE, "ValaGErrorModule", &g_define_type_info, 0);
	ValaGErrorModule_private_offset = g_type_add_instance_private (vala_gerror_module_type_id, sizeof (ValaGErrorModulePrivate));
	return vala_gerror_module_type_id;
}

GType
vala_gerror_module_get_type (void)
{
	static volatile gsize vala_gerror_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gerror_module_type_id__volatile)) {
		GType vala_gerror_module_type_id;
		vala_gerror_module_type_id = vala_gerror_module_get_type_once ();
		g_once_init_leave (&vala_gerror_module_type_id__volatile, vala_gerror_module_type_id);
	}
	return vala_gerror_module_type_id__volatile;
}

