--TEST--
Test token_get_all() function : usage variations - with bitwise operators
--FILE--
<?php
/* Prototype  : array token_get_all(string $source)
 * Description: splits the given source into an array of PHP languange tokens
 * Source code: ext/tokenizer/tokenizer.c
*/

/*
 * Passing 'source' argument with different bitwise operators to test them for token
 *  << - T_SL(287)
 *  >> - T_SR(286)
*/

echo "*** Testing token_get_all() : 'source' string with different bitwise operators ***\n";

// bitwise operators : '<<' , '>>'
$source = '<?php
$a = 2, $b = 4;
$a = $a << 2;
$b = $b >> 2;
var_dump($a);
var_dump($b);
?>';
var_dump( token_get_all($source));

echo "Done"
?>
--EXPECTF--
*** Testing token_get_all() : 'source' string with different bitwise operators ***
array(50) {
  [0]=>
  array(3) {
    [0]=>
    int(368)
    [1]=>
    string(6) "<?php
"
    [2]=>
    int(1)
  }
  [1]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$a"
    [2]=>
    int(2)
  }
  [2]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(2)
  }
  [3]=>
  string(1) "="
  [4]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(2)
  }
  [5]=>
  array(3) {
    [0]=>
    int(305)
    [1]=>
    string(1) "2"
    [2]=>
    int(2)
  }
  [6]=>
  string(1) ","
  [7]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(2)
  }
  [8]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$b"
    [2]=>
    int(2)
  }
  [9]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(2)
  }
  [10]=>
  string(1) "="
  [11]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(2)
  }
  [12]=>
  array(3) {
    [0]=>
    int(305)
    [1]=>
    string(1) "4"
    [2]=>
    int(2)
  }
  [13]=>
  string(1) ";"
  [14]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) "
"
    [2]=>
    int(2)
  }
  [15]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$a"
    [2]=>
    int(3)
  }
  [16]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(3)
  }
  [17]=>
  string(1) "="
  [18]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(3)
  }
  [19]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$a"
    [2]=>
    int(3)
  }
  [20]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(3)
  }
  [21]=>
  array(3) {
    [0]=>
    int(287)
    [1]=>
    string(2) "<<"
    [2]=>
    int(3)
  }
  [22]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(3)
  }
  [23]=>
  array(3) {
    [0]=>
    int(305)
    [1]=>
    string(1) "2"
    [2]=>
    int(3)
  }
  [24]=>
  string(1) ";"
  [25]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) "
"
    [2]=>
    int(3)
  }
  [26]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$b"
    [2]=>
    int(4)
  }
  [27]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(4)
  }
  [28]=>
  string(1) "="
  [29]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(4)
  }
  [30]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$b"
    [2]=>
    int(4)
  }
  [31]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(4)
  }
  [32]=>
  array(3) {
    [0]=>
    int(286)
    [1]=>
    string(2) ">>"
    [2]=>
    int(4)
  }
  [33]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) " "
    [2]=>
    int(4)
  }
  [34]=>
  array(3) {
    [0]=>
    int(305)
    [1]=>
    string(1) "2"
    [2]=>
    int(4)
  }
  [35]=>
  string(1) ";"
  [36]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) "
"
    [2]=>
    int(4)
  }
  [37]=>
  array(3) {
    [0]=>
    int(307)
    [1]=>
    string(8) "var_dump"
    [2]=>
    int(5)
  }
  [38]=>
  string(1) "("
  [39]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$a"
    [2]=>
    int(5)
  }
  [40]=>
  string(1) ")"
  [41]=>
  string(1) ";"
  [42]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) "
"
    [2]=>
    int(5)
  }
  [43]=>
  array(3) {
    [0]=>
    int(307)
    [1]=>
    string(8) "var_dump"
    [2]=>
    int(6)
  }
  [44]=>
  string(1) "("
  [45]=>
  array(3) {
    [0]=>
    int(309)
    [1]=>
    string(2) "$b"
    [2]=>
    int(6)
  }
  [46]=>
  string(1) ")"
  [47]=>
  string(1) ";"
  [48]=>
  array(3) {
    [0]=>
    int(371)
    [1]=>
    string(1) "
"
    [2]=>
    int(6)
  }
  [49]=>
  array(3) {
    [0]=>
    int(370)
    [1]=>
    string(2) "?>"
    [2]=>
    int(7)
  }
}
Done
