/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 12088 $ of $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ipIfStatsTable.h"


/** @defgroup data_get data_get: Routines to get data
 *
 * TODO:230:M: Implement ipIfStatsTable get routines.
 * TODO:240:M: Implement ipIfStatsTable mapping routines (if any).
 *
 * These routine are used to get the value for individual objects. The
 * row context is passed, along with a pointer to the memory where the
 * value should be copied.
 *
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table ipIfStatsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IP-MIB::ipIfStatsTable is subid 3 of ipTrafficStats.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.31.3, length: 9
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement ipIfStatsTable data context functions.
 */
/*
 * ipIfStatsTable_allocate_data
 *
 * Purpose: create new ipIfStatsTable_data.
 */
ipIfStatsTable_data *
ipIfStatsTable_allocate_data(void)
{
    /*
     * TODO:201:r: |-> allocate memory for the ipIfStatsTable data context.
     */
    ipIfStatsTable_data *rtn = SNMP_MALLOC_TYPEDEF(ipIfStatsTable_data);

    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsTable_allocate_data",
                "called\n"));

    if (NULL == rtn) {
        snmp_log(LOG_ERR, "unable to malloc memory for new "
                 "ipIfStatsTable_data.\n");
    }

    return rtn;
}                               /* ipIfStatsTable_allocate_data */

/*
 * ipIfStatsTable_release_data
 *
 * Purpose: release ipIfStatsTable data.
 */
void
ipIfStatsTable_release_data(ipIfStatsTable_data * data)
{
    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsTable_release_data",
                "called\n"));

    /*
     * TODO:202:r: |-> release memory for the ipIfStatsTable data context.
     */
    free(data);
}                               /* ipIfStatsTable_release_data */



/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 * @param ipIfStatsIPVersion_val
 * @param ipIfStatsIfIndex_val
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
ipIfStatsTable_indexes_set_tbl_idx(ipIfStatsTable_mib_index * tbl_idx,
                                   u_long ipIfStatsIPVersion_val,
                                   long ipIfStatsIfIndex_val)
{
    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsTable_indexes_set_tbl_idx", "called\n"));

    /*
     * ipIfStatsIPVersion(1)/InetVersion/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h 
     */
    /** WARNING: this code might not work for netsnmp_ifstats_entry */
    tbl_idx->ipIfStatsIPVersion = ipIfStatsIPVersion_val;

    /*
     * ipIfStatsIfIndex(2)/InterfaceIndex/ASN_INTEGER/long(long)//l/a/w/e/R/d/H 
     */
    /** WARNING: this code might not work for netsnmp_ifstats_entry */
    tbl_idx->ipIfStatsIfIndex = ipIfStatsIfIndex_val;


    return MFD_SUCCESS;
}                               /* ipIfStatsTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
ipIfStatsTable_indexes_set(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                           u_long ipIfStatsIPVersion_val,
                           long ipIfStatsIfIndex_val)
{
    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsTable_indexes_set",
                "called\n"));

    if (MFD_SUCCESS !=
        ipIfStatsTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx,
                                           ipIfStatsIPVersion_val,
                                           ipIfStatsIfIndex_val))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if (0 != ipIfStatsTable_index_to_oid(&rowreq_ctx->oid_idx,
                                         &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* ipIfStatsTable_indexes_set */


/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInReceives
 * ipIfStatsInReceives is subid 3 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.3
 * Description:
The total number of input IP datagrams received, including
            those received in error.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInReceives data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInReceives_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInReceives_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        u_long * ipIfStatsInReceives_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInReceives_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInReceives_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInReceives data.
     * copy (* ipIfStatsInReceives_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINRECEIVES])
        return MFD_SKIP;

    (*ipIfStatsInReceives_val_ptr) =
        rowreq_ctx->data->stats.HCInReceives.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInReceives_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCInReceives
 * ipIfStatsHCInReceives is subid 4 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.4
 * Description:
The total number of input IP datagrams received, including
            those received in error.  This object counts the same
            datagrams as ipIfStatsInReceives, but allows for larger
            values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCInReceives data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCInReceives_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCInReceives_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          U64 * ipIfStatsHCInReceives_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCInReceives_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCInReceives data.
     * get (* ipIfStatsHCInReceives_val_ptr ).low and (* ipIfStatsHCInReceives_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINRECEIVES])
        return MFD_SKIP;

    (*ipIfStatsHCInReceives_val_ptr).low =
        rowreq_ctx->data->stats.HCInReceives.low;
    (*ipIfStatsHCInReceives_val_ptr).high =
        rowreq_ctx->data->stats.HCInReceives.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCInReceives_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInOctets
 * ipIfStatsInOctets is subid 5 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.5
 * Description:
The total number of octets received in input IP datagrams,
            including those received in error.  Octets from datagrams
            counted in ipIfStatsInReceives MUST be counted here.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                      u_long * ipIfStatsInOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInOctets_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInOctets data.
     * copy (* ipIfStatsInOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINOCTETS])
        return MFD_SKIP;

    (*ipIfStatsInOctets_val_ptr) =
        rowreq_ctx->data->stats.HCInOctets.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCInOctets
 * ipIfStatsHCInOctets is subid 6 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.6
 * Description:
The total number of octets received in input IP datagrams,
            including those received in error.  This object counts the
            same octets as ipIfStatsInOctets, but allows for larger
            values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCInOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCInOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCInOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        U64 * ipIfStatsHCInOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCInOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCInOctets data.
     * get (* ipIfStatsHCInOctets_val_ptr ).low and (* ipIfStatsHCInOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINOCTETS])
        return MFD_SKIP;

    (*ipIfStatsHCInOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCInOctets.low;
    (*ipIfStatsHCInOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCInOctets.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCInOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInHdrErrors
 * ipIfStatsInHdrErrors is subid 7 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.7
 * Description:
The number of input IP datagrams discarded due to errors in
            their IP headers, including version number mismatch, other
            format errors, hop count exceeded, errors discovered in
            processing their IP options, etc.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInHdrErrors data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInHdrErrors_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInHdrErrors_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                         u_long * ipIfStatsInHdrErrors_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInHdrErrors_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInHdrErrors_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInHdrErrors data.
     * copy (* ipIfStatsInHdrErrors_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INHDRERRORS])
        return MFD_SKIP;

    (*ipIfStatsInHdrErrors_val_ptr) =
        rowreq_ctx->data->stats.InHdrErrors;

    return MFD_SUCCESS;
}                               /* ipIfStatsInHdrErrors_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInNoRoutes
 * ipIfStatsInNoRoutes is subid 8 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.8
 * Description:
The number of input IP datagrams discarded because no route
            could be found to transmit them to their destination.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInNoRoutes data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInNoRoutes_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInNoRoutes_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        u_long * ipIfStatsInNoRoutes_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInNoRoutes_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInNoRoutes_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInNoRoutes data.
     * copy (* ipIfStatsInNoRoutes_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINNOROUTES])
        return MFD_SKIP;

    (*ipIfStatsInNoRoutes_val_ptr) =
        rowreq_ctx->data->stats.HCInNoRoutes.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInNoRoutes_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInAddrErrors
 * ipIfStatsInAddrErrors is subid 9 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.9
 * Description:
The number of input IP datagrams discarded because the IP
            address in their IP header's destination field was not a
            valid address to be received at this entity.  This count
            includes invalid addresses (e.g., ::0).  For entities that
            are not IP routers and therefore do not forward datagrams,
            this counter includes datagrams discarded because the
            destination address was not a local address.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInAddrErrors data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInAddrErrors_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInAddrErrors_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipIfStatsInAddrErrors_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInAddrErrors_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInAddrErrors_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInAddrErrors data.
     * copy (* ipIfStatsInAddrErrors_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INADDRERRORS])
        return MFD_SKIP;

    (*ipIfStatsInAddrErrors_val_ptr) =
        rowreq_ctx->data->stats.InAddrErrors;

    return MFD_SUCCESS;
}                               /* ipIfStatsInAddrErrors_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInUnknownProtos
 * ipIfStatsInUnknownProtos is subid 10 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.10
 * Description:
The number of locally-addressed IP datagrams received
            successfully but discarded because of an unknown or
            unsupported protocol.

            When tracking interface statistics, the counter of the
            interface to which these datagrams were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the datagrams.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of



            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInUnknownProtos data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInUnknownProtos_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInUnknownProtos_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipIfStatsInUnknownProtos_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInUnknownProtos_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInUnknownProtos_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInUnknownProtos data.
     * copy (* ipIfStatsInUnknownProtos_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INUNKNOWNPROTOS])
        return MFD_SKIP;

    (*ipIfStatsInUnknownProtos_val_ptr) =
        rowreq_ctx->data->stats.InUnknownProtos;

    return MFD_SUCCESS;
}                               /* ipIfStatsInUnknownProtos_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInTruncatedPkts
 * ipIfStatsInTruncatedPkts is subid 11 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.11
 * Description:
The number of input IP datagrams discarded because the
            datagram frame didn't carry enough data.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInTruncatedPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInTruncatedPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInTruncatedPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipIfStatsInTruncatedPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInTruncatedPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInTruncatedPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInTruncatedPkts data.
     * copy (* ipIfStatsInTruncatedPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INTRUNCATEDPKTS])
        return MFD_SKIP;

    (*ipIfStatsInTruncatedPkts_val_ptr) =
        rowreq_ctx->data->stats.InTruncatedPkts;

    return MFD_SUCCESS;
}                               /* ipIfStatsInTruncatedPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInForwDatagrams
 * ipIfStatsInForwDatagrams is subid 12 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.12
 * Description:
The number of input datagrams for which this entity was not
            their final IP destination and for which this entity
            attempted to find a route to forward them to that final
            destination.  In entities that do not act as IP routers,
            this counter will include only those datagrams that were
            Source-Routed via this entity, and the Source-Route
            processing was successful.

            When tracking interface statistics, the counter of the
            incoming interface is incremented for each datagram.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInForwDatagrams_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInForwDatagrams_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipIfStatsInForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInForwDatagrams_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInForwDatagrams_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInForwDatagrams data.
     * copy (* ipIfStatsInForwDatagrams_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipIfStatsInForwDatagrams_val_ptr) =
        rowreq_ctx->data->stats.HCInForwDatagrams.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCInForwDatagrams
 * ipIfStatsHCInForwDatagrams is subid 13 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.13
 * Description:
The number of input datagrams for which this entity was not
            their final IP destination and for which this entity
            attempted to find a route to forward them to that final
            destination.  This object counts the same packets as



            ipIfStatsInForwDatagrams, but allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCInForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCInForwDatagrams_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCInForwDatagrams_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                               U64 * ipIfStatsHCInForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCInForwDatagrams_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCInForwDatagrams data.
     * get (* ipIfStatsHCInForwDatagrams_val_ptr ).low and (* ipIfStatsHCInForwDatagrams_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipIfStatsHCInForwDatagrams_val_ptr).low =
        rowreq_ctx->data->stats.HCInForwDatagrams.low;
    (*ipIfStatsHCInForwDatagrams_val_ptr).high =
        rowreq_ctx->data->stats.HCInForwDatagrams.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCInForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsReasmReqds
 * ipIfStatsReasmReqds is subid 14 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.14
 * Description:
The number of IP fragments received that needed to be
            reassembled at this interface.

            When tracking interface statistics, the counter of the
            interface to which these fragments were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the fragments.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsReasmReqds data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsReasmReqds_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsReasmReqds_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        u_long * ipIfStatsReasmReqds_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsReasmReqds_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsReasmReqds_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsReasmReqds data.
     * copy (* ipIfStatsReasmReqds_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REASMREQDS])
        return MFD_SKIP;

    (*ipIfStatsReasmReqds_val_ptr) =
        rowreq_ctx->data->stats.ReasmReqds;

    return MFD_SUCCESS;
}                               /* ipIfStatsReasmReqds_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsReasmOKs
 * ipIfStatsReasmOKs is subid 15 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.15
 * Description:
The number of IP datagrams successfully reassembled.

            When tracking interface statistics, the counter of the
            interface to which these datagrams were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the datagrams.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsReasmOKs data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsReasmOKs_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsReasmOKs_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                      u_long * ipIfStatsReasmOKs_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsReasmOKs_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsReasmOKs_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsReasmOKs data.
     * copy (* ipIfStatsReasmOKs_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REASMOKS])
        return MFD_SKIP;

    (*ipIfStatsReasmOKs_val_ptr) =
        rowreq_ctx->data->stats.ReasmOKs;

    return MFD_SUCCESS;
}                               /* ipIfStatsReasmOKs_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsReasmFails
 * ipIfStatsReasmFails is subid 16 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.16
 * Description:
The number of failures detected by the IP re-assembly
            algorithm (for whatever reason: timed out, errors, etc.).
            Note that this is not necessarily a count of discarded IP
            fragments since some algorithms (notably the algorithm in
            RFC 815) can lose track of the number of fragments by
            combining them as they are received.

            When tracking interface statistics, the counter of the
            interface to which these fragments were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the fragments.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsReasmFails data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsReasmFails_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsReasmFails_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        u_long * ipIfStatsReasmFails_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsReasmFails_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsReasmFails_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsReasmFails data.
     * copy (* ipIfStatsReasmFails_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REASMFAILS])
        return MFD_SKIP;

    (*ipIfStatsReasmFails_val_ptr) =
        rowreq_ctx->data->stats.ReasmFails;

    return MFD_SUCCESS;
}                               /* ipIfStatsReasmFails_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInDiscards
 * ipIfStatsInDiscards is subid 17 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.17
 * Description:
The number of input IP datagrams for which no problems were
            encountered to prevent their continued processing, but
            were discarded (e.g., for lack of buffer space).  Note that
            this counter does not include any datagrams discarded while
            awaiting re-assembly.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInDiscards data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInDiscards_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInDiscards_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        u_long * ipIfStatsInDiscards_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInDiscards_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInDiscards_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInDiscards data.
     * copy (* ipIfStatsInDiscards_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INDISCARDS])
        return MFD_SKIP;

    (*ipIfStatsInDiscards_val_ptr) =
        rowreq_ctx->data->stats.InDiscards;

    return MFD_SUCCESS;
}                               /* ipIfStatsInDiscards_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInDelivers
 * ipIfStatsInDelivers is subid 18 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.18
 * Description:
The total number of datagrams successfully delivered to IP
            user-protocols (including ICMP).

            When tracking interface statistics, the counter of the
            interface to which these datagrams were addressed is
            incremented.  This interface might not be the same as the



            input interface for some of the datagrams.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInDelivers data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInDelivers_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInDelivers_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        u_long * ipIfStatsInDelivers_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInDelivers_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInDelivers_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInDelivers data.
     * copy (* ipIfStatsInDelivers_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINDELIVERS])
        return MFD_SKIP;

    (*ipIfStatsInDelivers_val_ptr) =
        rowreq_ctx->data->stats.HCInDelivers.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInDelivers_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCInDelivers
 * ipIfStatsHCInDelivers is subid 19 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.19
 * Description:
The total number of datagrams successfully delivered to IP
            user-protocols (including ICMP).  This object counts the
            same packets as ipIfStatsInDelivers, but allows for larger
            values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCInDelivers data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCInDelivers_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCInDelivers_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          U64 * ipIfStatsHCInDelivers_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCInDelivers_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCInDelivers data.
     * get (* ipIfStatsHCInDelivers_val_ptr ).low and (* ipIfStatsHCInDelivers_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINDELIVERS])
        return MFD_SKIP;

    (*ipIfStatsHCInDelivers_val_ptr).low =
        rowreq_ctx->data->stats.HCInDelivers.low;
    (*ipIfStatsHCInDelivers_val_ptr).high =
        rowreq_ctx->data->stats.HCInDelivers.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCInDelivers_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutRequests
 * ipIfStatsOutRequests is subid 20 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.20
 * Description:
The total number of IP datagrams that local IP user-
            protocols (including ICMP) supplied to IP in requests for
            transmission.  Note that this counter does not include any
            datagrams counted in ipIfStatsOutForwDatagrams.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutRequests data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutRequests_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutRequests_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                         u_long * ipIfStatsOutRequests_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutRequests_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutRequests_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutRequests data.
     * copy (* ipIfStatsOutRequests_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTREQUESTS])
        return MFD_SKIP;

    (*ipIfStatsOutRequests_val_ptr) =
        rowreq_ctx->data->stats.HCOutRequests.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutRequests_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCOutRequests
 * ipIfStatsHCOutRequests is subid 21 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.21
 * Description:
The total number of IP datagrams that local IP user-
            protocols (including ICMP) supplied to IP in requests for
            transmission.  This object counts the same packets as



            ipIfStatsOutRequests, but allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCOutRequests data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCOutRequests_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCOutRequests_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                           U64 * ipIfStatsHCOutRequests_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCOutRequests_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCOutRequests data.
     * get (* ipIfStatsHCOutRequests_val_ptr ).low and (* ipIfStatsHCOutRequests_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTREQUESTS])
        return MFD_SKIP;

    (*ipIfStatsHCOutRequests_val_ptr).low =
        rowreq_ctx->data->stats.HCOutRequests.low;
    (*ipIfStatsHCOutRequests_val_ptr).high =
        rowreq_ctx->data->stats.HCOutRequests.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCOutRequests_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutForwDatagrams
 * ipIfStatsOutForwDatagrams is subid 23 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.23
 * Description:
The number of datagrams for which this entity was not their
            final IP destination and for which it was successful in
            finding a path to their final destination.  In entities
            that do not act as IP routers, this counter will include
            only those datagrams that were Source-Routed via this
            entity, and the Source-Route processing was successful.

            When tracking interface statistics, the counter of the
            outgoing interface is incremented for a successfully
            forwarded datagram.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutForwDatagrams_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutForwDatagrams_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipIfStatsOutForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutForwDatagrams_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutForwDatagrams_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutForwDatagrams data.
     * copy (* ipIfStatsOutForwDatagrams_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipIfStatsOutForwDatagrams_val_ptr) =
        rowreq_ctx->data->stats.HCOutForwDatagrams.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCOutForwDatagrams
 * ipIfStatsHCOutForwDatagrams is subid 24 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.24
 * Description:
The number of datagrams for which this entity was not their
            final IP destination and for which it was successful in
            finding a path to their final destination.  This object
            counts the same packets as ipIfStatsOutForwDatagrams, but
            allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of



            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCOutForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCOutForwDatagrams_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCOutForwDatagrams_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                                U64 * ipIfStatsHCOutForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCOutForwDatagrams_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCOutForwDatagrams data.
     * get (* ipIfStatsHCOutForwDatagrams_val_ptr ).low and (* ipIfStatsHCOutForwDatagrams_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipIfStatsHCOutForwDatagrams_val_ptr).low =
        rowreq_ctx->data->stats.HCOutForwDatagrams.low;
    (*ipIfStatsHCOutForwDatagrams_val_ptr).high =
        rowreq_ctx->data->stats.HCOutForwDatagrams.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCOutForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutDiscards
 * ipIfStatsOutDiscards is subid 25 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.25
 * Description:
The number of output IP datagrams for which no problem was
            encountered to prevent their transmission to their
            destination, but were discarded (e.g., for lack of
            buffer space).  Note that this counter would include
            datagrams counted in ipIfStatsOutForwDatagrams if any such
            datagrams met this (discretionary) discard criterion.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutDiscards data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutDiscards_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutDiscards_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                         u_long * ipIfStatsOutDiscards_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutDiscards_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutDiscards_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutDiscards data.
     * copy (* ipIfStatsOutDiscards_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTDISCARDS])
        return MFD_SKIP;

    (*ipIfStatsOutDiscards_val_ptr) =
        rowreq_ctx->data->stats.HCOutDiscards.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutDiscards_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutFragReqds
 * ipIfStatsOutFragReqds is subid 26 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.26
 * Description:
The number of IP datagrams that would require fragmentation
            in order to be transmitted.

            When tracking interface statistics, the counter of the
            outgoing interface is incremented for a successfully
            fragmented datagram.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutFragReqds data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutFragReqds_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutFragReqds_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipIfStatsOutFragReqds_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutFragReqds_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutFragReqds_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutFragReqds data.
     * copy (* ipIfStatsOutFragReqds_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGREQDS])
        return MFD_SKIP;

    (*ipIfStatsOutFragReqds_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragReqds.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutFragReqds_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutFragOKs
 * ipIfStatsOutFragOKs is subid 27 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.27
 * Description:
The number of IP datagrams that have been successfully
            fragmented.

            When tracking interface statistics, the counter of the



            outgoing interface is incremented for a successfully
            fragmented datagram.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutFragOKs data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutFragOKs_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutFragOKs_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                        u_long * ipIfStatsOutFragOKs_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutFragOKs_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutFragOKs_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutFragOKs data.
     * copy (* ipIfStatsOutFragOKs_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGOKS])
        return MFD_SKIP;

    (*ipIfStatsOutFragOKs_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragOKs.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutFragOKs_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutFragFails
 * ipIfStatsOutFragFails is subid 28 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.28
 * Description:
The number of IP datagrams that have been discarded because
            they needed to be fragmented but could not be.  This
            includes IPv4 packets that have the DF bit set and IPv6
            packets that are being forwarded and exceed the outgoing
            link MTU.

            When tracking interface statistics, the counter of the
            outgoing interface is incremented for an unsuccessfully
            fragmented datagram.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutFragFails data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutFragFails_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutFragFails_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipIfStatsOutFragFails_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutFragFails_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutFragFails_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutFragFails data.
     * copy (* ipIfStatsOutFragFails_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGFAILS])
        return MFD_SKIP;

    (*ipIfStatsOutFragFails_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragFails.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutFragFails_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutFragCreates
 * ipIfStatsOutFragCreates is subid 29 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.29
 * Description:
The number of output datagram fragments that have been
            generated as a result of IP fragmentation.

            When tracking interface statistics, the counter of the
            outgoing interface is incremented for a successfully
            fragmented datagram.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutFragCreates data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutFragCreates_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutFragCreates_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipIfStatsOutFragCreates_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutFragCreates_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutFragCreates_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutFragCreates data.
     * copy (* ipIfStatsOutFragCreates_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGCREATES])
        return MFD_SKIP;

    (*ipIfStatsOutFragCreates_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragCreates.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutFragCreates_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutTransmits
 * ipIfStatsOutTransmits is subid 30 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.30
 * Description:
The total number of IP datagrams that this entity supplied
            to the lower layers for transmission.  This includes
            datagrams generated locally and those forwarded by this
            entity.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutTransmits data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutTransmits_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutTransmits_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipIfStatsOutTransmits_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutTransmits_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutTransmits_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutTransmits data.
     * copy (* ipIfStatsOutTransmits_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTTRANSMITS])
        return MFD_SKIP;

    (*ipIfStatsOutTransmits_val_ptr) =
        rowreq_ctx->data->stats.HCOutTransmits.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutTransmits_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCOutTransmits
 * ipIfStatsHCOutTransmits is subid 31 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.31
 * Description:
The total number of IP datagrams that this entity supplied
            to the lower layers for transmission.  This object counts
            the same datagrams as ipIfStatsOutTransmits, but allows for
            larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCOutTransmits data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCOutTransmits_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCOutTransmits_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                            U64 * ipIfStatsHCOutTransmits_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCOutTransmits_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCOutTransmits data.
     * get (* ipIfStatsHCOutTransmits_val_ptr ).low and (* ipIfStatsHCOutTransmits_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTTRANSMITS])
        return MFD_SKIP;

    (*ipIfStatsHCOutTransmits_val_ptr).low =
        rowreq_ctx->data->stats.HCOutTransmits.low;
    (*ipIfStatsHCOutTransmits_val_ptr).high =
        rowreq_ctx->data->stats.HCOutTransmits.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCOutTransmits_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutOctets
 * ipIfStatsOutOctets is subid 32 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.32
 * Description:
The total number of octets in IP datagrams delivered to the
            lower layers for transmission.  Octets from datagrams
            counted in ipIfStatsOutTransmits MUST be counted here.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                       u_long * ipIfStatsOutOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutOctets_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutOctets data.
     * copy (* ipIfStatsOutOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTOCTETS])
        return MFD_SKIP;

    (*ipIfStatsOutOctets_val_ptr) =
        rowreq_ctx->data->stats.HCOutOctets.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCOutOctets
 * ipIfStatsHCOutOctets is subid 33 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.33
 * Description:
The total number of octets in IP datagrams delivered to the
            lower layers for transmission.  This objects counts the same
            octets as ipIfStatsOutOctets, but allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCOutOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCOutOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCOutOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                         U64 * ipIfStatsHCOutOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCOutOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCOutOctets data.
     * get (* ipIfStatsHCOutOctets_val_ptr ).low and (* ipIfStatsHCOutOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTOCTETS])
        return MFD_SKIP;

    (*ipIfStatsHCOutOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCOutOctets.low;
    (*ipIfStatsHCOutOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCOutOctets.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCOutOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInMcastPkts
 * ipIfStatsInMcastPkts is subid 34 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.34
 * Description:
The number of IP multicast datagrams received.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInMcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInMcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                         u_long * ipIfStatsInMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInMcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInMcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInMcastPkts data.
     * copy (* ipIfStatsInMcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsInMcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCInMcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCInMcastPkts
 * ipIfStatsHCInMcastPkts is subid 35 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.35
 * Description:
The number of IP multicast datagrams received.  This object
            counts the same datagrams as ipIfStatsInMcastPkts, but
            allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCInMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCInMcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCInMcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                           U64 * ipIfStatsHCInMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCInMcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCInMcastPkts data.
     * get (* ipIfStatsHCInMcastPkts_val_ptr ).low and (* ipIfStatsHCInMcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsHCInMcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCInMcastPkts.low;
    (*ipIfStatsHCInMcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCInMcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCInMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInMcastOctets
 * ipIfStatsInMcastOctets is subid 36 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.36
 * Description:
The total number of octets received in IP multicast



            datagrams.  Octets from datagrams counted in
            ipIfStatsInMcastPkts MUST be counted here.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInMcastOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInMcastOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                           u_long * ipIfStatsInMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInMcastOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInMcastOctets_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInMcastOctets data.
     * copy (* ipIfStatsInMcastOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTOCTETS])
        return MFD_SKIP;

    (*ipIfStatsInMcastOctets_val_ptr) =
                rowreq_ctx->data->stats.HCInMcastOctets.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCInMcastOctets
 * ipIfStatsHCInMcastOctets is subid 37 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.37
 * Description:
The total number of octets received in IP multicast
            datagrams.  This object counts the same octets as
            ipIfStatsInMcastOctets, but allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCInMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCInMcastOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCInMcastOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                             U64 * ipIfStatsHCInMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCInMcastOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCInMcastOctets data.
     * get (* ipIfStatsHCInMcastOctets_val_ptr ).low and (* ipIfStatsHCInMcastOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTOCTETS])
        return MFD_SKIP;

    (*ipIfStatsHCInMcastOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCInMcastOctets.low;
    (*ipIfStatsHCInMcastOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCInMcastOctets.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCInMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutMcastPkts
 * ipIfStatsOutMcastPkts is subid 38 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.38
 * Description:
The number of IP multicast datagrams transmitted.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutMcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutMcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipIfStatsOutMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutMcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutMcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutMcastPkts data.
     * copy (* ipIfStatsOutMcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsOutMcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCOutMcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCOutMcastPkts
 * ipIfStatsHCOutMcastPkts is subid 39 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.39
 * Description:
The number of IP multicast datagrams transmitted.  This
            object counts the same datagrams as ipIfStatsOutMcastPkts,
            but allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other



            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCOutMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCOutMcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCOutMcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                            U64 * ipIfStatsHCOutMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCOutMcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCOutMcastPkts data.
     * get (* ipIfStatsHCOutMcastPkts_val_ptr ).low and (* ipIfStatsHCOutMcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsHCOutMcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCOutMcastPkts.low;
    (*ipIfStatsHCOutMcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCOutMcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCOutMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutMcastOctets
 * ipIfStatsOutMcastOctets is subid 40 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.40
 * Description:
The total number of octets transmitted in IP multicast
            datagrams.  Octets from datagrams counted in
            ipIfStatsOutMcastPkts MUST be counted here.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutMcastOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutMcastOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipIfStatsOutMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutMcastOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutMcastOctets_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutMcastOctets data.
     * copy (* ipIfStatsOutMcastOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTOCTETS])
        return MFD_SKIP;

    (*ipIfStatsOutMcastOctets_val_ptr) =
        rowreq_ctx->data->stats.HCOutMcastOctets.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCOutMcastOctets
 * ipIfStatsHCOutMcastOctets is subid 41 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.41
 * Description:
The total number of octets transmitted in IP multicast
            datagrams.  This object counts the same octets as
            ipIfStatsOutMcastOctets, but allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCOutMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCOutMcastOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCOutMcastOctets_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                              U64 * ipIfStatsHCOutMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCOutMcastOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCOutMcastOctets data.
     * get (* ipIfStatsHCOutMcastOctets_val_ptr ).low and (* ipIfStatsHCOutMcastOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTOCTETS])
        return MFD_SKIP;

    (*ipIfStatsHCOutMcastOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCOutMcastOctets.low;
    (*ipIfStatsHCOutMcastOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCOutMcastOctets.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCOutMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsInBcastPkts
 * ipIfStatsInBcastPkts is subid 42 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.42
 * Description:
The number of IP broadcast datagrams received.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsInBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsInBcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsInBcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                         u_long * ipIfStatsInBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsInBcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsInBcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsInBcastPkts data.
     * copy (* ipIfStatsInBcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINBCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsInBcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCInBcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsInBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCInBcastPkts
 * ipIfStatsHCInBcastPkts is subid 43 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.43
 * Description:
The number of IP broadcast datagrams received.  This object
            counts the same datagrams as ipIfStatsInBcastPkts, but
            allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCInBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCInBcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCInBcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                           U64 * ipIfStatsHCInBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCInBcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCInBcastPkts data.
     * get (* ipIfStatsHCInBcastPkts_val_ptr ).low and (* ipIfStatsHCInBcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINBCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsHCInBcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCInBcastPkts.low;
    (*ipIfStatsHCInBcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCInBcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCInBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsOutBcastPkts
 * ipIfStatsOutBcastPkts is subid 44 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.44
 * Description:
The number of IP broadcast datagrams transmitted.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsOutBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsOutBcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsOutBcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipIfStatsOutBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsOutBcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsOutBcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsOutBcastPkts data.
     * copy (* ipIfStatsOutBcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTBCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsOutBcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCOutBcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipIfStatsOutBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsHCOutBcastPkts
 * ipIfStatsHCOutBcastPkts is subid 45 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.45
 * Description:
The number of IP broadcast datagrams transmitted.  This
            object counts the same datagrams as ipIfStatsOutBcastPkts,
            but allows for larger values.

            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipIfStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipIfStatsHCOutBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsHCOutBcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsHCOutBcastPkts_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                            U64 * ipIfStatsHCOutBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsHCOutBcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipIfStatsHCOutBcastPkts data.
     * get (* ipIfStatsHCOutBcastPkts_val_ptr ).low and (* ipIfStatsHCOutBcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTBCASTPKTS])
        return MFD_SKIP;

    (*ipIfStatsHCOutBcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCOutBcastPkts.low;
    (*ipIfStatsHCOutBcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCOutBcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipIfStatsHCOutBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsDiscontinuityTime
 * ipIfStatsDiscontinuityTime is subid 46 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.46
 * Description:
The value of sysUpTime on the most recent occasion at which



            any one or more of this entry's counters suffered a
            discontinuity.

            If no such discontinuities have occurred since the last re-
            initialization of the local management subsystem, then this
            object contains a zero value.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is TimeStamp (based on perltype TICKS)
 * The net-snmp type is ASN_TIMETICKS. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsDiscontinuityTime data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsDiscontinuityTime_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsDiscontinuityTime_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                               u_long * ipIfStatsDiscontinuityTime_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsDiscontinuityTime_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsDiscontinuityTime_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsDiscontinuityTime data.
     * copy (* ipIfStatsDiscontinuityTime_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_DISCONTINUITYTIME])
        return MFD_SKIP;

    (*ipIfStatsDiscontinuityTime_val_ptr) =
        rowreq_ctx->ipIfStatsDiscontinuityTime;

    return MFD_SUCCESS;
}                               /* ipIfStatsDiscontinuityTime_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipIfStatsEntry.ipIfStatsRefreshRate
 * ipIfStatsRefreshRate is subid 47 of ipIfStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.3.1.47
 * Description:
The minimum reasonable polling interval for this entry.
            This object provides an indication of the minimum amount of
            time required to update the counters in this entry.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipIfStatsRefreshRate data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipIfStatsRefreshRate_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipIfStatsRefreshRate_get(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                         u_long * ipIfStatsRefreshRate_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipIfStatsRefreshRate_val_ptr);


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsRefreshRate_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipIfStatsRefreshRate data.
     * copy (* ipIfStatsRefreshRate_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REFRESHRATE])
        return MFD_SKIP;

    (*ipIfStatsRefreshRate_val_ptr) =
        rowreq_ctx->ipIfStatsRefreshRate;

    return MFD_SUCCESS;
}                               /* ipIfStatsRefreshRate_get */



/** @} */
