/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.datastore;

import info.aduna.io.ByteArrayUtil;
import java.io.File;
import java.io.IOException;
import org.openrdf.sail.nativerdf.btree.BTree;
import org.openrdf.sail.nativerdf.btree.DefaultRecordComparator;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

public class HashIndex {
    private static final int RECORD_LENGTH = 8;
    private static final int HASH_IDX = 0;
    private static final int ID_IDX = 4;
    private static final byte[] SEARCH_MASK = new byte[8];
    private File file;
    private BTree btree;

    public HashIndex(File file) throws IOException {
        this.file = file;
        this.btree = new BTree(file, 4096, 8, new DefaultRecordComparator());
    }

    public File getFile() {
        return this.file;
    }

    public IDIterator getIDIterator(int hash) throws IOException {
        return new IDIterator(hash);
    }

    public void storeID(int hash, int id) throws IOException {
        this.btree.insert(this.getData(hash, id));
    }

    public void removeID(int hash, int id) throws IOException {
        this.btree.remove(this.getData(hash, id));
    }

    public void sync() throws IOException {
        this.btree.sync();
    }

    public void clear() throws IOException {
        this.btree.clear();
    }

    public void close() throws IOException {
        this.btree.close();
    }

    private byte[] getData(int hash, int id) {
        byte[] data = new byte[8];
        ByteArrayUtil.putInt(hash, data, 0);
        ByteArrayUtil.putInt(id, data, 4);
        return data;
    }

    private byte[] getMinValue(int hash) {
        byte[] minValue = new byte[8];
        ByteArrayUtil.putInt(hash, minValue, 0);
        return minValue;
    }

    private byte[] getMaxValue(int hash) {
        byte[] maxValue = new byte[8];
        ByteArrayUtil.putInt(hash, maxValue, 0);
        ByteArrayUtil.putInt(-1, maxValue, 4);
        return maxValue;
    }

    static {
        ByteArrayUtil.putInt(-1, SEARCH_MASK, 0);
    }

    public class IDIterator {
        private RecordIterator btreeIter;

        private IDIterator(int hash) throws IOException {
            byte[] minValue = HashIndex.this.getMinValue(hash);
            byte[] maxValue = HashIndex.this.getMaxValue(hash);
            this.btreeIter = HashIndex.this.btree.iterateRange(minValue, maxValue);
        }

        public int next() throws IOException {
            byte[] result = this.btreeIter.next();
            if (result == null) {
                return -1;
            }
            return ByteArrayUtil.getInt(result, 4);
        }

        public void close() throws IOException {
            this.btreeIter.close();
        }
    }
}

