/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.repository.QueryResultView;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleQueryResultView
extends QueryResultView {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final TupleQueryResultView INSTANCE = new TupleQueryResultView();

    public static TupleQueryResultView getInstance() {
        return INSTANCE;
    }

    private TupleQueryResultView() {
    }

    public String getContentType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        TupleQueryResultWriterFactory qrWriterFactory = (TupleQueryResultWriterFactory)model.get("factory");
        TupleQueryResultFormat qrFormat = qrWriterFactory.getTupleQueryResultFormat();
        response.setStatus(200);
        this.setContentType(response, qrFormat);
        this.setContentDisposition(model, response, qrFormat);
        ServletOutputStream out = response.getOutputStream();
        try {
            TupleQueryResultWriter qrWriter = qrWriterFactory.getWriter((OutputStream)out);
            TupleQueryResult tupleQueryResult = (TupleQueryResult)model.get("queryResult");
            QueryResultUtil.report(tupleQueryResult, qrWriter);
        }
        catch (QueryEvaluationException e) {
            this.logger.error("Query evaluation error", (Throwable)e);
            response.sendError(500, "Query evaluation error: " + e.getMessage());
        }
        catch (TupleQueryResultHandlerException e) {
            this.logger.error("Serialization error", (Throwable)e);
            response.sendError(500, "Serialization error: " + e.getMessage());
        }
        finally {
            out.close();
        }
    }
}

