/* KDevelop QMake Support
 *
 * Copyright 2006 Andreas Pakulat <apaku@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef QMAKEMANAGER_H
#define QMAKEMANAGER_H

#include <project/interfaces/ibuildsystemmanager.h>
#include <interfaces/iplugin.h>
#include <QtCore/QVariant>

template <typename T> class QList;
class QString;

//#include "domutil.h"
//#include <project/projectmodel.h>

class QDir;
class QObject;
class KDialogBase;
class IQMakeBuilder;
class QMakeCache;
class QMakeMkSpecs;
namespace KDevelop
{
class IProject;
class ProjectFolderItem;
class ProjectBaseItem;
class ProjectFileItem;
class ProjectTargetItem;
class IProjectBuilder;
}

class QMakeProjectManager : public KDevelop::IPlugin, public KDevelop::IBuildSystemManager
{
Q_OBJECT
Q_INTERFACES( KDevelop::IProjectFileManager )
Q_INTERFACES( KDevelop::IBuildSystemManager )
public:
    explicit QMakeProjectManager( QObject* parent = 0, const QVariantList& args = QVariantList() );

    virtual ~QMakeProjectManager();

    virtual Features features() const { return Features(Folders | Targets | Files); }
    virtual KDevelop::IProjectBuilder*  builder(KDevelop::ProjectFolderItem*) const;
    virtual KUrl buildDirectory(const KDevelop::ProjectBaseItem*) const;
    virtual KUrl::List includeDirectories(KDevelop::ProjectBaseItem*) const;
    virtual QHash<QString,QString> defines(KDevelop::ProjectBaseItem*) const { return QHash<QString,QString>(); }
    virtual QHash<QString,QString> environment(KDevelop::ProjectBaseItem*) const { return QHash<QString,QString>(); }

    virtual KDevelop::ProjectTargetItem* createTarget( const QString&,
            KDevelop::ProjectFolderItem* ) { return false; }

    virtual bool addFileToTarget( KDevelop::ProjectFileItem*,
                                  KDevelop::ProjectTargetItem* ) { return false; }

    virtual bool removeTarget( KDevelop::ProjectTargetItem* ) { return false; }

    virtual bool removeFileFromTarget( KDevelop::ProjectFileItem*,
                                       KDevelop::ProjectTargetItem* ) { return false; }

    virtual QList<KDevelop::ProjectTargetItem*> targets(KDevelop::ProjectFolderItem*) const;

    virtual QList<KDevelop::ProjectFolderItem*> parse( KDevelop::ProjectFolderItem* dom );
    virtual KDevelop::ProjectFolderItem* import( KDevelop::IProject* );

    virtual bool reload(KDevelop::ProjectBaseItem*) { return false; }

    virtual KDevelop::ProjectFolderItem* addFolder( const KUrl&,
            KDevelop::ProjectFolderItem* ) { return 0; }

    virtual KDevelop::ProjectFileItem* addFile( const KUrl&,
            KDevelop::ProjectFolderItem* ) { return 0; }

    virtual bool removeFile( KDevelop::ProjectFileItem* ) { return false; }
    virtual bool removeFolder( KDevelop::ProjectFolderItem* ) { return false; }
    virtual bool renameFile( KDevelop::ProjectFileItem*, const KUrl& ) { return false; }
    virtual bool renameFolder( KDevelop::ProjectFolderItem*, const KUrl&  ) { return false; }

Q_SIGNALS:
    void projectItemConfigWidget(const QList<KDevelop::ProjectBaseItem*> &dom, KDialogBase *dialog);

    void folderAdded( KDevelop::ProjectFolderItem* folder );
    void folderRemoved( KDevelop::ProjectFolderItem* folder );
    void folderRenamed( const KUrl& oldFolder,
                        KDevelop::ProjectFolderItem* newFolder );

    void fileAdded(KDevelop::ProjectFileItem* file);
    void fileRemoved(KDevelop::ProjectFileItem* file);
    void fileRenamed(const KUrl& oldFile,
                     KDevelop::ProjectFileItem* newFile);
private:
    QHash<QString,QString> queryQMake( KDevelop::IProject* ) const;
    QString findBasicMkSpec( const QString& mkspecdir ) const;
    QMakeCache* findQMakeCache( const QString& projectfile ) const;
    IQMakeBuilder* m_builder;
};

#endif

