.\"
.\" "$Id: lpstat.man 6649 2007-07-11 21:46:42Z mike $"
.\"
.\"   lpstat man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 2007 by Apple Inc.
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Apple Inc. and are protected by Federal copyright
.\"   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\"   which should have been included with this file.  If this file is
.\"   file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lpstat 1 "Common UNIX Printing System" "23 March 2006" "Apple Inc."
.SH NAME
lpstat \- print cups status information
.SH SYNOPSIS
.B lpstat
[ -E ] [ -U
.I username
] [ -h
.I hostname[:port]
] [ -l ] [ -W
.I which-jobs
] [ -a [
.I destination(s)
] ] [ -c [
.I class(es)
] ] [ -d ] [ -o [
.I destination(s)
] ] [ -p [
.I printer(s)
] ] [ -r ] [ -R ] [ -s ] [ -t ] [ -u [
.I user(s)
] ] [ -v [
.I printer(s)
] ]
.SH DESCRIPTION
\fIlpstat\fR displays status information about the current
classes, jobs, and printers. When run with no arguments,
\fIlpstat\fR will list jobs queued by the current user.
.SH OPTIONS
The \fIlpstat\fR command supports the following options:
.TP 5
-E
.br
Forces encryption when connecting to the server.
.TP 5
-R
.br
Shows the ranking of print jobs.
.TP 5
-U username
.br
Specifies an alternate username.
.TP 5
-W which-jobs
.br
Specifies which jobs to show, \fIcompleted\fR or
\fInot-completed\fR (the default). This option \fImust\fR appear
before the \fI-o\fR option and/or any printer names, otherwise
the default (not-completed) value will be used in the request to
the scheduler.
.TP 5
-a [printer(s)]
.br
Shows the accepting state of printer queues. If no printers are
specified then all printers are listed.
.TP 5
-c [class(es)]
.br
Shows the printer classes and the printers that belong to them.
If no classes are specified then all classes are listed.
.TP 5
-d
.br
Shows the current default destination.
.TP 5
-h server[:port]
.br
Specifies an alternate server.
.TP 5
-l
.br
Shows a long listing of printers, classes, or jobs.
.TP 5
-o [destination(s)]
.br
Shows the jobs queue on the specified destinations. If no destinations are
specified all jobs are shown.
.TP 5
-p [printer(s)]
.br
Shows the printers and whether or not they are enabled for printing. If
no printers are specified then all printers are listed.
.TP 5
-r
.br
Shows whether the CUPS server is running.
.TP 5
-s
.br
Shows a status summary, including the default destination, a
list of classes and their member printers, and a list of printers and
their associated devices. This is equivalent to using the "-d", "-c",
and "-v" options.
.TP 5
-t
.br
Shows all status information. This is equivalent to using the "-r",
"-d", "-c", "-v", "-a", "-p", and "-o" options.
.TP 5
-u [user(s)]
.br
Shows a list of print jobs queued by the specified users. If no users
are specified, lists the jobs queued by the current user.
.TP 5
-v [printer(s)]
.br
Shows the printers and what device they are attached to. If no printers
are specified then all printers are listed.
.SH COMPATIBILITY
Unlike the System V printing system, CUPS allows printer names to
contain any printable character except SPACE, TAB, "/", and "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
The "-h", "-E", "-U", and "-W" options are unique to CUPS.
.LP
The Solaris "-f", "-P", and "-S" options are silently ignored.
.SH SEE ALSO
\fIcancel(1)\fR, \fIlp(1)\fR,
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 2007 by Apple Inc.
.\"
.\" End of "$Id: lpstat.man 6649 2007-07-11 21:46:42Z mike $".
.\"
