.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH VIA __drivermansuffix__ __vendorversion__
.SH NAME
via \- VIA unichrome graphics driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qvia\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B via
is an __xservername__ driver for VIA chipsets with onboard unichrome graphics.
.PP
The
.B via
driver supports the VIA CLE266, KM400/KN400, K8M/N800, PM/N800 and
CN400 chipsets, including 2D acceleration and the Xv video overlay
extensions. Flat panel, TV and VGA outputs are supported, depending on
the hardware configuration.
.PP
Direct rendering 3D is available using experimental drivers in Mesa, www.mesa3d.org.
Also there is an XvMC client library for hardware MPEG1 / MPEG2 decoding 
acceleration available on the CLE266, CN400, PM/N800 and K8M/N800 chipsets that uses the Direct
Rendering Infrastructure, DRI. The XvMC client library implements a nonstandard
\*qVLD\*q extension to the XvMC standard. The current Direct Rendering Manager 
Linux kernel module is available at dri.sourceforge.net.
.PP
The driver supports free modes for Unichome Pro chipsets. (K8M/N800,
PM/N800 and CN400). Currently for Unichrome chipsets, it only supports
a limited number of dotclocks, so if you are using X modelines, you
must make sure that the dotclock is one of those supported. Supported
dotclocks on Unichromes are currently (MHz): 25.2, 25.312, 26.591,
31.5, 31.704, 32.663, 33.750, 35.5, 36.0, 39.822, 40.0, 41.164,
46.981, 49.5, 50.0, 56.3, 57.284, 64.995, 65.0, 65.028, 74.480,
75.0, 78.8, 81.613, 94.5, 108.0, 108.28, 122.0, 122.726, 135.0,
148.5, 155.8, 157.5, 161.793, 162.0, 175.5, 189.0, 202.5, 204.8,
218.3, 229.5. On top of this, bandwidth restrictions apply both for
Unichromes and Unichrome Pros.
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following driver
.B options
are supported
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration. Default: acceleration is enabled.
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Disable or enable use of hardware cursors. The default is enabled.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
Disable or enable the use of a software cursor. The default is disabled.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Use a shadow frame buffer. This is required when rotating the display,
but otherwise defaults to disabled.
.TP
.BI "Option \*qVideoRAM\*q \*q" boolean \*q
Override the VideoRAM auto detection. This should never be needed.
.TP
.BI "Option \*qRotate\*q \*q" string \*q
Rotate the display either clockwise (\*qCW\*q) or counter clockwise (\*qCCW\*q).
Rotation is only supported unaccelerated.
.TP
.BI "Option \*qActiveDevice\*q \*q" string \*q
Specify the active device combination. Any string containing \*qCRT\*q,
\*qLCD\*q, \*qTV\*q should be possible. The default is to use what is
detected. The driver is currently unable to use LCD and TV simultaneously,
and will favour the LCD.
.TP
.BI "Option \*qLCDDualEdge\*q \*q" boolean \*q
Use dual edge mode to set the LCD.
.TP
.BI "Option \*qCenter\*q \*q" boolean \*q
Disable or enable image centering on DVI displays.
.TP
.BI "Option \*qPanelSize\*q \*q" string \*q
Specify the size (width x height) of the LCD panel attached to the
system. Sizes 640x480, 800x600, 1024x768, 1280x1024, and 1400x1050
are supported.
.TP
.BI "Option \*qTVDotCrawl\*q \*q" boolean \*q
Disable or enable dotcrawl.
.TP
.BI "Option \*qTVDeflicker\*q \*q" integer \*q
Specify deflicker setting for TV output. Valid values are 0,1,2
0) No deflicker, 1) 1:1:1 deflicker, 2) 1:2:1 deflicker.
.TP
.BI "Option \*qTVType\*q \*q" string \*q
Specify TV output format. The driver currently supports \*qNTSC\*q and
\*qPAL\*q timings only.
.TP
.BI "Option \*qTVOutput\*q \*q" string \*q
Specify which TV output to use. The driver supports \*qS-Video\*q,
\*qComposite\*q, \*qSC\*q, \*qRGB\*q and \*qYCbCr\*q outputs. Note that on some
EPIA boards the composite video port is shared with audio out and jumper
selected.
.TP
.BI "Option \*qDisableVQ\*q \*q" boolean \*q
Disable or enable the use of VQ. VQ is enabled by default.
.TP
.BI "Option \*qDRIXINERAMA\*q \*q" boolean \*q
Set DRI Xinerama mode. Currently unsupported.
.TP
.BI "Option \*qDisableIRQ\*q \*q" boolean \*q
Disables Vblank IRQ. A workaround for some mainboards that have
problems with IRQs from the unichrome chip. With IRQ disabled,
DRI clients have no way to sync drawing to Vblank.
.TP
.BI "Option \*qEnableAGPDMA\*q \*q" boolean \*q
Enable the AGP DMA functionality in DRM. This requires that DRI is enabled
and will force 2D, and 3D acceleration to use AGP DMA. The XvMC DRI client will also
make use of this on the CLE266 to consume much less CPU. 
.TP
.BI "Option \*qNoAGPFor2D\*q \*q" boolean \*q
With this option on, 2D acceleration will not use AGP DMA even if it is enabled.
.TP
.BI "Option \*qNoXVDMA\*q \*q" boolean \*q
If DRI is enabled, Xv normally uses PCI DMA to transfer video images
from system to frame-buffer memory. This is somewhat slower than
direct copies due to the limitations of the PCI bus, but 
on the other hand it decreases CPU usage significantly. Particularly
on computers with fast processors. Some video players are buggy and
will display rendering artifacts when PCI DMA is used. If you
experience this, or don't want your PCI bus to be stressed 
with Xv images, set this option to "true". This option has no effect
if DRI is not enabled.
.TP
.BI "Option \*qAccelMethod\*q \*q" string \*q
The driver supports \*qXAA\*q and \*qEXA\*q acceleration methods. The default method is 
XAA, since EXA is still experimental. Contrary to XAA. EXA implements acceleration for
screen uploads and downlads (if DRI is enabled) and the Render / Composite extension.
.TP
.BI "Option \*qEXANoComposite\*q \*q" boolean \*q
If Exa is enabled using the above option, Don't accelerate composite. Since EXA, and in
particular, it's composite acceleration is still experimental, This is a way to disable
exa composite acceleration.

.SH "Supported TV Encoders"
Unichromes tend to be paired with several different TV Encoders.
.TP
.BI "VIA Technologies VT1621"
Untested as no combination with Unichrome is known or available.
Supports the following normal modes: \*q640x480\*q and \*q800x600\*q. Use
\*q640x480Over\*q and \*q800x600Over\*q for vertical overscan. These modes
are made available by the driver and modelines provided in __xconfigfile__
will be ignored.
.TP
.BI "VIA Technologies VT1622, VT1622A, VT1623"
Supports the following modes: \*q640x480\*q, \*q800x600\*q, \*q1024x768\*q,
\*q848x480\*q, \*q720x480\*q (NTSC only) and \*q720x576\*q (PAL only). Use
\*q640x480Over\*q, \*q800x600Over\*q, \*q1024x768Over\*q, \*q848x480Over\*q,
\*q720x480Over\*q (NTSC) and \*q720x576Over\*q (PAL) for vertical overscan.
The modes \*q720x480Noscale\*q (NTSC) and \*q720x576Noscale\*q (PAL)
(VT1622 only) provide cleaner TV output (unscaled with only minimal overscan).
These modes are made available by the driver and modelines provided in
__xconfigfile__ will be ignored.

.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
Authors include: ...
