/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggTheora SOFTWARE CODEC SOURCE CODE.   *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE Theora SOURCE CODE IS COPYRIGHT (C) 2002-2007                *
 * by the Xiph.Org Foundation http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

  function:
    last mod: $Id: quant.h 13884 2007-09-22 08:38:10Z giles $

 ********************************************************************/

#if !defined(_quant_H)
# define _quant_H (1)
# include "theora/codec.h"
# include "ocintrin.h"

typedef ogg_uint16_t   oc_quant_table[64];
typedef oc_quant_table oc_quant_tables[64];



/*Maximum scaled quantizer value.*/
#define OC_QUANT_MAX          (1024<<2)



/*Minimum scaled DC coefficient frame quantizer value for intra and inter
   modes.*/
extern unsigned OC_DC_QUANT_MIN[2];
/*Minimum scaled AC coefficient frame quantizer value for intra and inter
   modes.*/
extern unsigned OC_AC_QUANT_MIN[2];



void oc_dequant_tables_init(oc_quant_table *_dequant[2][3],
 int _pp_dc_scale[64],const th_quant_info *_qinfo);

#endif
