// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

using System;
using System.IO;
using System.Collections;

namespace QtCSharp {

	public class QMember {

		string name, access, id;
		bool overload, throttle, boxer;
		ArrayList pinvokeparams, pinvokecallparams, csharpparams, overloadparams;

		public QMember()
		{
			pinvokeparams = new ArrayList();
			pinvokecallparams = new ArrayList();
			csharpparams = new ArrayList();
			overloadparams = new ArrayList();
		}


		public void AddPinvokeParam(QParam pinvokeparam)
		{
			pinvokeparams.Add(pinvokeparam);
		}

		public void AddPinvokeCallParam(QParam pinvokecallparam)
		{
			pinvokecallparams.Add(pinvokecallparam);
		}

		public void AddCSharpParam(QParam csharpparam)
		{
			csharpparams.Add(csharpparam);
		}

		public void AddOverloadParam(QParam overloadparam)
		{
			overloadparams.Add(overloadparam);
		}

		public string Name
		{
			get {return name;}
			set {name = value;}
		}

		public string Access
		{
			get {return access;}
			set {access = value;}
		}

		public bool Overload
		{
			get {return overload;}
			set {overload = value;}
		}

		public string Id
		{
			get {return id;}
			set {id = value;}
		}

		public bool Throttle
		{
			get {return throttle;}
			set {throttle = value;}
		}
		
		public bool Boxer
		{
			get {return boxer;}
			set {boxer = value;}
		}

		public ArrayList PinvokeParams
		{
			get {return pinvokeparams;}
		}

		public ArrayList PinvokeCallParams
		{
			get {return pinvokecallparams;}
		}

		public ArrayList CSharpParams
		{
			get {return csharpparams;}
		}

		public ArrayList OverloadParams
		{
			get {return overloadparams;}
		}
	}
}
