/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.classpath.NotImplementedException;
import gnu.javax.swing.text.html.CharacterAttributeTranslator;
import gnu.javax.swing.text.html.parser.htmlAttributeSet;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;

public class HTMLDocument
extends DefaultStyledDocument {
    public static final String AdditionalComments = "AdditionalComments";
    URL baseURL;
    boolean preservesUnknownTags;
    int tokenThreshold;
    HTMLEditorKit.Parser parser;
    StyleSheet styleSheet;
    AbstractDocument.Content content;

    private /* synthetic */ void finit$() {
        this.baseURL = null;
        this.preservesUnknownTags = true;
        this.tokenThreshold = Integer.MAX_VALUE;
    }

    public HTMLDocument() {
        this((StyleSheet)null);
    }

    public HTMLDocument(StyleSheet styleSheet) {
        this((AbstractDocument.Content)new GapContent(4096), styleSheet);
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
        this.finit$();
        this.content = content;
        if (styleSheet == null) {
            styleSheet = new StyleSheet();
            styleSheet.importStyleSheet(this.getClass().getResource("default.css"));
        }
        this.styleSheet = styleSheet;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.AttributeContext attributeContext = this.getAttributeContext();
        AttributeSet attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.HTML);
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, attributeSet);
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.BODY);
        AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)this.createBranchElement(branchElement, attributeSet);
        branchElement.replace(0, 0, new Element[]{branchElement2});
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.P);
        AbstractDocument.BranchElement branchElement3 = (AbstractDocument.BranchElement)this.createBranchElement(branchElement2, attributeSet);
        branchElement2.replace(0, 0, new Element[]{branchElement3});
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        Element element = this.createLeafElement(branchElement3, attributeSet, 0, 1);
        branchElement3.replace(0, 0, new Element[]{element});
        return branchElement;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        RunElement runElement = new RunElement(this, element, attributeSet, n, n2);
        runElement.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        return new RunElement(this, element, attributeSet, n, n2);
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BlockElement(this, element, attributeSet);
    }

    public HTMLEditorKit.Parser getParser() {
        return this.parser;
    }

    public void setParser(HTMLEditorKit.Parser parser) {
        this.parser = parser;
    }

    public void setTokenThreshold(int n) {
        this.tokenThreshold = n;
    }

    public int getTokenThreshold() {
        return this.tokenThreshold;
    }

    public URL getBase() {
        return this.baseURL;
    }

    public void setBase(URL uRL) {
        this.baseURL = uRL;
        this.styleSheet.setBase(uRL);
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public void setPreservesUnknownTags(boolean bl) {
        this.preservesUnknownTags = bl;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) throws NotImplementedException {
    }

    public Iterator getIterator(HTML.Tag tag) {
        return new LeafIterator(this, tag, this);
    }

    public HTMLEditorKit.ParserCallback getReader(int n) {
        return new HTMLReader(this, n);
    }

    public HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag) {
        return new HTMLReader(this, n, n2, n3, tag);
    }

    public HTMLEditorKit.ParserCallback getInsertingReader(int n, int n2, int n3, HTML.Tag tag, Element element) throws IllegalStateException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        HTMLReader hTMLReader = new HTMLReader(this, element, n, n2, n3, tag){
            private /* synthetic */ HTMLDocument this$0;
            private /* synthetic */ Element val$parent;
            {
                this.this$0 = hTMLDocument;
                super(hTMLDocument, n, n2, n3, tag);
                this.finit$(element);
            }

            private /* synthetic */ void finit$(Element element) {
                this.val$parent = element;
            }

            public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag != HTML.Tag.BODY) {
                    super.handleStartTag(tag, mutableAttributeSet, n);
                }
            }

            public void handleEndTag(HTML.Tag tag, int n) {
                if (tag != HTML.Tag.BODY) {
                    super.handleEndTag(tag, n);
                }
            }
        };
        hTMLReader.parseStack.push(element.getAttributes().getAttribute(StyleConstants.NameAttribute));
        return hTMLReader;
    }

    public Element getElement(Element element, Object object, Object object2) {
        if (element != null) {
            if (element.getAttributes().containsAttribute(object, object2)) {
                return element;
            }
            int n = element.getElementCount();
            for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                if (element2.getAttributes().containsAttribute(object, object2)) {
                    return element2;
                }
                Element element3 = this.getElement(element2, object, object2);
                if (element3 == null) continue;
                return element3;
            }
        }
        return null;
    }

    public Element getElement(String string) {
        return this.getElement(this.getDefaultRootElement(), HTML.Attribute.ID, string);
    }

    public void setInnerHTML(Element element, String string) throws BadLocationException, IOException {
        if (element.isLeaf()) {
            throw new IllegalArgumentException("Element is a leaf");
        }
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(n2, 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
        this.remove(n, n2 - n);
    }

    public void setOuterHTML(Element element, String string) throws BadLocationException, IOException {
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        this.remove(n, n2 - n);
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(n, 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getStartOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getEndOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getEndOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getStartOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        private /* synthetic */ HTMLDocument this$0;
        protected MutableAttributeSet charAttr;
        protected Vector parseBuffer;
        Stack charAttrStack;
        Stack parseStack;
        HashMap tagToAction;
        boolean endHTMLEncountered;
        int popDepth;
        int pushDepth;
        int offset;
        HTML.Tag insertTag;
        boolean insertTagEncountered;
        boolean debug;

        private /* synthetic */ void finit$() {
            this.charAttr = new SimpleAttributeSet();
            this.parseBuffer = new Vector();
            this.charAttrStack = new Stack();
            this.parseStack = new Stack();
            this.endHTMLEncountered = false;
            this.debug = false;
        }

        static HTMLDocument access$0(HTMLReader hTMLReader) {
            return hTMLReader.this$0;
        }

        void print(String string) {
            if (this.debug) {
                System.out.println(string);
            }
        }

        public HTMLReader(HTMLDocument hTMLDocument, int n) {
            this.this$0 = hTMLDocument;
            this(hTMLDocument, n, 0, 0, null);
        }

        public HTMLReader(HTMLDocument hTMLDocument, int n, int n2, int n3, HTML.Tag tag) {
            this.this$0 = hTMLDocument;
            this.finit$();
            this.print("HTMLReader created with pop: " + n2 + " push: " + n3 + " offset: " + n + " tag: " + tag);
            this.insertTag = tag;
            this.offset = n;
            this.popDepth = n2;
            this.pushDepth = n3;
            this.initTags();
        }

        void initTags() {
            this.tagToAction = new HashMap(72);
            CharacterAction characterAction = new CharacterAction(this);
            HiddenAction hiddenAction = new HiddenAction(this);
            AreaAction areaAction = new AreaAction(this);
            BaseAction baseAction = new BaseAction(this);
            BlockAction blockAction = new BlockAction(this);
            SpecialAction specialAction = new SpecialAction(this);
            ParagraphAction paragraphAction = new ParagraphAction(this);
            HeadAction headAction = new HeadAction(this);
            FormAction formAction = new FormAction(this);
            IsindexAction isindexAction = new IsindexAction(this);
            LinkAction linkAction = new LinkAction(this);
            MapAction mapAction = new MapAction(this);
            PreAction preAction = new PreAction(this);
            MetaAction metaAction = new MetaAction(this);
            StyleAction styleAction = new StyleAction(this);
            TitleAction titleAction = new TitleAction(this);
            this.tagToAction.put(HTML.Tag.A, characterAction);
            this.tagToAction.put(HTML.Tag.ADDRESS, characterAction);
            this.tagToAction.put(HTML.Tag.APPLET, hiddenAction);
            this.tagToAction.put(HTML.Tag.AREA, areaAction);
            this.tagToAction.put(HTML.Tag.B, characterAction);
            this.tagToAction.put(HTML.Tag.BASE, baseAction);
            this.tagToAction.put(HTML.Tag.BASEFONT, characterAction);
            this.tagToAction.put(HTML.Tag.BIG, characterAction);
            this.tagToAction.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagToAction.put(HTML.Tag.BODY, blockAction);
            this.tagToAction.put(HTML.Tag.BR, specialAction);
            this.tagToAction.put(HTML.Tag.CAPTION, blockAction);
            this.tagToAction.put(HTML.Tag.CENTER, blockAction);
            this.tagToAction.put(HTML.Tag.CITE, characterAction);
            this.tagToAction.put(HTML.Tag.CODE, characterAction);
            this.tagToAction.put(HTML.Tag.DD, blockAction);
            this.tagToAction.put(HTML.Tag.DFN, characterAction);
            this.tagToAction.put(HTML.Tag.DIR, blockAction);
            this.tagToAction.put(HTML.Tag.DIV, blockAction);
            this.tagToAction.put(HTML.Tag.DL, blockAction);
            this.tagToAction.put(HTML.Tag.DT, paragraphAction);
            this.tagToAction.put(HTML.Tag.EM, characterAction);
            this.tagToAction.put(HTML.Tag.FONT, characterAction);
            this.tagToAction.put(HTML.Tag.FORM, blockAction);
            this.tagToAction.put(HTML.Tag.FRAME, specialAction);
            this.tagToAction.put(HTML.Tag.FRAMESET, blockAction);
            this.tagToAction.put(HTML.Tag.H1, paragraphAction);
            this.tagToAction.put(HTML.Tag.H2, paragraphAction);
            this.tagToAction.put(HTML.Tag.H3, paragraphAction);
            this.tagToAction.put(HTML.Tag.H4, paragraphAction);
            this.tagToAction.put(HTML.Tag.H5, paragraphAction);
            this.tagToAction.put(HTML.Tag.H6, paragraphAction);
            this.tagToAction.put(HTML.Tag.HEAD, headAction);
            this.tagToAction.put(HTML.Tag.HR, specialAction);
            this.tagToAction.put(HTML.Tag.HTML, blockAction);
            this.tagToAction.put(HTML.Tag.I, characterAction);
            this.tagToAction.put(HTML.Tag.IMG, specialAction);
            this.tagToAction.put(HTML.Tag.INPUT, formAction);
            this.tagToAction.put(HTML.Tag.ISINDEX, isindexAction);
            this.tagToAction.put(HTML.Tag.KBD, characterAction);
            this.tagToAction.put(HTML.Tag.LI, blockAction);
            this.tagToAction.put(HTML.Tag.LINK, linkAction);
            this.tagToAction.put(HTML.Tag.MAP, mapAction);
            this.tagToAction.put(HTML.Tag.MENU, blockAction);
            this.tagToAction.put(HTML.Tag.META, metaAction);
            this.tagToAction.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagToAction.put(HTML.Tag.OBJECT, specialAction);
            this.tagToAction.put(HTML.Tag.OL, blockAction);
            this.tagToAction.put(HTML.Tag.OPTION, formAction);
            this.tagToAction.put(HTML.Tag.P, paragraphAction);
            this.tagToAction.put(HTML.Tag.PARAM, hiddenAction);
            this.tagToAction.put(HTML.Tag.PRE, preAction);
            this.tagToAction.put(HTML.Tag.SAMP, characterAction);
            this.tagToAction.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagToAction.put(HTML.Tag.SELECT, formAction);
            this.tagToAction.put(HTML.Tag.SMALL, characterAction);
            this.tagToAction.put(HTML.Tag.STRIKE, characterAction);
            this.tagToAction.put(HTML.Tag.S, characterAction);
            this.tagToAction.put(HTML.Tag.STRONG, characterAction);
            this.tagToAction.put(HTML.Tag.STYLE, styleAction);
            this.tagToAction.put(HTML.Tag.SUB, characterAction);
            this.tagToAction.put(HTML.Tag.SUP, characterAction);
            this.tagToAction.put(HTML.Tag.TABLE, blockAction);
            this.tagToAction.put(HTML.Tag.TD, blockAction);
            this.tagToAction.put(HTML.Tag.TEXTAREA, formAction);
            this.tagToAction.put(HTML.Tag.TH, blockAction);
            this.tagToAction.put(HTML.Tag.TITLE, titleAction);
            this.tagToAction.put(HTML.Tag.TR, blockAction);
            this.tagToAction.put(HTML.Tag.TT, characterAction);
            this.tagToAction.put(HTML.Tag.U, characterAction);
            this.tagToAction.put(HTML.Tag.UL, blockAction);
            this.tagToAction.put(HTML.Tag.VAR, characterAction);
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.isEmpty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.pop();
            }
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagToAction.put(tag, tagAction);
        }

        public void flush() throws BadLocationException {
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[this.parseBuffer.size()];
            this.parseBuffer.copyInto(objectArray);
            this.parseBuffer.removeAllElements();
            if (this.offset == 0) {
                this.this$0.create((DefaultStyledDocument.ElementSpec[])objectArray);
            } else {
                this.this$0.insert(this.offset, (DefaultStyledDocument.ElementSpec[])objectArray);
            }
            this.offset += this.this$0.getLength() - this.offset;
        }

        public void handleText(char[] cArray, int n) {
            if (cArray != null && cArray.length > 0) {
                this.addContent(cArray, 0, cArray.length);
            }
        }

        private boolean shouldInsert() {
            return !this.endHTMLEncountered && (this.insertTagEncountered || this.insertTag == null);
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            TagAction tagAction;
            if (tag == this.insertTag) {
                this.insertTagEncountered = true;
            }
            if (this.shouldInsert() && (tagAction = (TagAction)this.tagToAction.get(tag)) != null) {
                tagAction.start(tag, mutableAttributeSet);
            }
        }

        public void handleComment(char[] cArray, int n) {
            TagAction tagAction;
            if (this.shouldInsert() && (tagAction = (TagAction)this.tagToAction.get(HTML.Tag.COMMENT)) != null) {
                tagAction.start(HTML.Tag.COMMENT, htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET);
                tagAction.end(HTML.Tag.COMMENT);
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            if (this.shouldInsert()) {
                TagAction tagAction;
                if (tag == HTML.Tag.HTML) {
                    this.endHTMLEncountered = true;
                }
                if ((tagAction = (TagAction)this.tagToAction.get(tag)) != null) {
                    tagAction.end(tag);
                }
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            TagAction tagAction;
            if (tag == this.insertTag) {
                this.insertTagEncountered = true;
            }
            if (this.shouldInsert() && (tagAction = (TagAction)this.tagToAction.get(tag)) != null) {
                tagAction.start(tag, mutableAttributeSet);
                tagAction.end(tag);
            }
        }

        public void handleEndOfLineString(String string) {
            this.print("HTMLReader.handleEndOfLineString not implemented yet");
        }

        protected void textAreaContent(char[] cArray) throws NotImplementedException {
            this.print("HTMLReader.textAreaContent not implemented yet");
        }

        protected void preContent(char[] cArray) throws NotImplementedException {
            this.print("HTMLReader.preContent not implemented yet");
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            this.printBuffer();
            this.parseStack.push(tag);
            AbstractDocument.AttributeContext attributeContext = this.this$0.getAttributeContext();
            AttributeSet attributeSet = mutableAttributeSet.copyAttributes();
            attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, tag);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 1);
            this.parseBuffer.addElement(elementSpec);
            this.printBuffer();
        }

        protected void blockClose(HTML.Tag tag) {
            DefaultStyledDocument.ElementSpec elementSpec;
            this.printBuffer();
            DefaultStyledDocument.ElementSpec elementSpec2 = (DefaultStyledDocument.ElementSpec)this.parseBuffer.get(this.parseBuffer.size() - 1);
            if (elementSpec2.getType() == 1) {
                AbstractDocument.AttributeContext attributeContext = this.this$0.getAttributeContext();
                AttributeSet attributeSet = attributeContext.getEmptySet();
                attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, new char[0], 0, 0);
                this.parseBuffer.add(elementSpec);
            }
            elementSpec = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(elementSpec);
            this.printBuffer();
            if (this.parseStack.size() > 0) {
                this.parseStack.pop();
            }
        }

        protected void addContent(char[] cArray, int n, int n2) {
            this.addContent(cArray, n, n2, true);
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            AbstractDocument.AttributeContext attributeContext = this.this$0.getAttributeContext();
            AttributeSet attributeSet = null;
            attributeSet = this.charAttr != null ? this.charAttr.copyAttributes() : attributeContext.getEmptySet();
            attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, cArray, n, n2);
            this.printBuffer();
            this.parseBuffer.addElement(elementSpec);
            this.printBuffer();
            if (this.parseBuffer.size() > this.this$0.getTokenThreshold()) {
                try {
                    this.flush();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            AttributeSet attributeSet = mutableAttributeSet.copyAttributes();
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, new char[]{' ', ' '}, 0, 2);
            this.parseBuffer.add(elementSpec);
        }

        void printBuffer() {
            this.print("\n*********BUFFER**********");
            for (int i = 0; i < this.parseBuffer.size(); ++i) {
                this.print("  " + this.parseBuffer.get(i));
            }
            this.print("***************************");
        }

        class TitleAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("TitleAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("TitleAction.end not implemented");
            }

            TitleAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        class StyleAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("StyleAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("StyleAction.end not implemented");
            }

            StyleAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        class MetaAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("MetaAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("MetaAction.end not implemented");
            }

            MetaAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        class MapAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("MapAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("MapAction.end not implemented");
            }

            MapAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        class LinkAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("LinkAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("LinkAction.end not implemented");
            }

            LinkAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        class HeadAction
        extends BlockAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("HeadAction.start not implemented: " + tag);
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("HeadAction.end not implemented: " + tag);
                super.end(tag);
            }

            HeadAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        class BaseAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("BaseAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("BaseAction.end not implemented");
            }

            BaseAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        class AreaAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("AreaAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("AreaAction.end not implemented");
            }

            AreaAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class SpecialAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.addSpecialElement(tag, mutableAttributeSet);
            }

            public SpecialAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class PreAction
        extends BlockAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("PreAction.start not implemented");
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("PreAction.end not implemented");
                super.end(tag);
            }

            public PreAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class ParagraphAction
        extends BlockAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                this.this$1.blockClose(tag);
            }

            public ParagraphAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class IsindexAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("IsindexAction.start not implemented");
            }

            public IsindexAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class HiddenAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                this.this$1.blockClose(tag);
            }

            public HiddenAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class FormAction
        extends SpecialAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                this.this$1.print("FormAction.start not implemented");
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
                this.this$1.print("FormAction.end not implemented");
            }

            public FormAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class CharacterAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.pushCharacterStyle();
                if (CharacterAttributeTranslator.translateTag(this.this$1.charAttr, tag, mutableAttributeSet)) {
                    return;
                }
                if (mutableAttributeSet != null) {
                    this.this$1.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                }
            }

            public void end(HTML.Tag tag) {
                this.this$1.popCharacterStyle();
            }

            public CharacterAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class BlockAction
        extends TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                this.this$1.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                this.this$1.blockClose(tag);
            }

            public BlockAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
                super((HTMLReader)((Object)HTMLReader.access$0(hTMLReader)));
            }
        }

        public class TagAction {
            private /* synthetic */ HTMLReader this$1;

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }

            public TagAction(HTMLReader hTMLReader) {
                this.this$1 = hTMLReader;
            }
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        private /* synthetic */ HTMLDocument this$0;

        public RunElement(HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet, int n, int n2) {
            this.this$0 = hTMLDocument;
            super(hTMLDocument, element, attributeSet, n, n2);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            String string = null;
            if (object != null) {
                string = object.toString();
            }
            return string;
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        private /* synthetic */ HTMLDocument this$0;

        public BlockElement(HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet) {
            this.this$0 = hTMLDocument;
            super(hTMLDocument, element, attributeSet);
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            String string = null;
            if (object != null) {
                string = object.toString();
            }
            return string;
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getEndOffset();

        public abstract int getStartOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract HTML.Tag getTag();
    }

    class LeafIterator
    extends Iterator {
        private /* synthetic */ HTMLDocument this$0;
        HTML.Tag tag;
        HTMLDocument doc;
        ElementIterator it;

        public LeafIterator(HTMLDocument hTMLDocument, HTML.Tag tag, HTMLDocument hTMLDocument2) {
            this.this$0 = hTMLDocument;
            this.doc = hTMLDocument2;
            this.tag = tag;
            this.it = new ElementIterator(this.doc);
        }

        public AttributeSet getAttributes() {
            if (this.it.current() != null) {
                return this.it.current().getAttributes();
            }
            return null;
        }

        public int getEndOffset() {
            if (this.it.current() != null) {
                return this.it.current().getEndOffset();
            }
            return -1;
        }

        public int getStartOffset() {
            if (this.it.current() != null) {
                return this.it.current().getStartOffset();
            }
            return -1;
        }

        public void next() {
            this.it.next();
            while (this.it.current() != null && !this.it.current().isLeaf()) {
                this.it.next();
            }
        }

        public boolean isValid() {
            return this.it.current() != null;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }
    }
}

