/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class MaskFormatter
extends DefaultFormatter {
    private static final char NUM_CHAR = '#';
    private static final char ESCAPE_CHAR = '\'';
    private static final char UPPERCASE_CHAR = 'U';
    private static final char LOWERCASE_CHAR = 'L';
    private static final char ALPHANUM_CHAR = 'A';
    private static final char LETTER_CHAR = '?';
    private static final char ANYTHING_CHAR = '*';
    private static final char HEX_CHAR = 'H';
    private String mask;
    private String invalidChars;
    private String validChars;
    private String placeHolder;
    private char placeHolderChar;
    private boolean valueContainsLiteralCharacters;
    private static String hexString = "0123456789abcdefABCDEF";
    int maskLength;

    private /* synthetic */ void finit$() {
        this.placeHolderChar = (char)32;
        this.valueContainsLiteralCharacters = true;
        this.maskLength = 0;
    }

    public MaskFormatter() {
        this.finit$();
        this.setAllowsInvalid(false);
    }

    public MaskFormatter(String string) throws ParseException {
        this.finit$();
        this.setAllowsInvalid(false);
        this.setMask(string);
    }

    public String getMask() {
        return this.mask;
    }

    public String getInvalidCharacters() {
        return this.invalidChars;
    }

    public void setInvalidCharacters(String string) {
        this.invalidChars = string;
    }

    public String getValidCharacters() {
        return this.validChars;
    }

    public void setValidCharacters(String string) {
        this.validChars = string;
    }

    public String getPlaceholder() {
        return this.placeHolder;
    }

    public void setPlaceholder(String string) {
        this.placeHolder = string;
    }

    public char getPlaceholderCharacter() {
        return this.placeHolderChar;
    }

    public void setPlaceholderCharacter(char c) {
        this.placeHolderChar = c;
    }

    public boolean getValueContainsLiteralCharacters() {
        return this.valueContainsLiteralCharacters;
    }

    public void setValueContainsLiteralCharacters(boolean bl) {
        this.valueContainsLiteralCharacters = bl;
    }

    public void setMask(String string) throws ParseException {
        this.mask = string;
        int n = string.length() - 1;
        this.maskLength = 0;
        for (int i = 0; i <= n; ++i) {
            if (string.charAt(i) == '\'') {
                if (i != n) {
                    ++this.maskLength;
                }
                ++i;
                continue;
            }
            ++this.maskLength;
        }
    }

    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
        if (jFormattedTextField != null) {
            try {
                this.valueToString(jFormattedTextField.getValue());
            }
            catch (ParseException parseException) {
                jFormattedTextField.setText("");
                this.setEditValid(false);
            }
        }
    }

    public Object stringToValue(String string) throws ParseException {
        int n = string.length();
        if (this.maskLength != n) {
            throw new ParseException("stringToValue passed invalid value", n);
        }
        try {
            this.convertValue(string, false);
        }
        catch (ParseException parseException) {
            throw new ParseException("stringToValue passed invalid value", parseException.getErrorOffset());
        }
        if (!this.getValueContainsLiteralCharacters()) {
            string = this.stripLiterals(string);
        }
        return super.stringToValue(string);
    }

    String stripLiterals(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            switch (this.mask.charAt(i)) {
                case '#': 
                case '*': 
                case '?': 
                case 'A': 
                case 'H': 
                case 'L': 
                case 'U': {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public String valueToString(Object object) throws ParseException {
        String string = super.valueToString(object);
        int n = string.length();
        if (n > this.maskLength) {
            string = string.substring(0, this.maskLength);
        }
        string = this.convertValue(string, true);
        if (n < this.maskLength) {
            return this.pad(string, n);
        }
        return string;
    }

    String convertValue(String string, boolean bl) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl2 = this.invalidChars != null || this.validChars != null;
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            boolean bl3 = false;
            char c = stringBuffer.charAt(n);
            switch (this.mask.charAt(n2)) {
                case '#': {
                    if (Character.isDigit(c)) break;
                    throw new ParseException("Number expected", n);
                }
                case 'U': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n);
                    }
                    if (!bl) break;
                    stringBuffer.setCharAt(n, Character.toUpperCase(c));
                    break;
                }
                case 'L': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n);
                    }
                    if (!bl) break;
                    stringBuffer.setCharAt(n, Character.toLowerCase(c));
                    break;
                }
                case 'A': {
                    if (Character.isLetterOrDigit(c)) break;
                    throw new ParseException("Letter or number expected", n);
                }
                case '?': {
                    if (Character.isLetter(c)) break;
                    throw new ParseException("Letter expected", n);
                }
                case 'H': {
                    if (hexString.indexOf(c) != -1) break;
                    throw new ParseException("Hexadecimal character expected", n);
                }
                case '*': {
                    break;
                }
                case '\'': {
                    bl3 = true;
                    if (c == this.mask.charAt(++n2)) break;
                    throw new ParseException("Invalid character: " + c, n);
                }
                default: {
                    bl3 = true;
                    if (!this.getValueContainsLiteralCharacters() && bl) {
                        throw new ParseException("Invalid character: " + c, n);
                    }
                    if (c == this.mask.charAt(n2)) break;
                    throw new ParseException("Invalid character: " + c, n);
                }
            }
            if (!bl3 && bl2 && !this.isCharValid(c)) {
                throw new ParseException("invalid character: " + c, n);
            }
            ++n;
            ++n2;
        }
        return stringBuffer.toString();
    }

    boolean isCharValid(char c) {
        char c2 = Character.toLowerCase(c);
        char c3 = Character.toUpperCase(c);
        if (this.validChars != null && this.validChars.indexOf(c2) == -1 && this.validChars.indexOf(c3) == -1) {
            return false;
        }
        return this.invalidChars == null || this.invalidChars.indexOf(c2) == -1 && this.invalidChars.indexOf(c3) == -1;
    }

    String pad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n;
        while (stringBuffer.length() < this.maskLength) {
            stringBuffer.append(this.getPadCharAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    char getPadCharAt(int n) {
        boolean bl = false;
        int n2 = n;
        int n3 = this.placeHolder == null ? -1 : this.placeHolder.length();
        for (int i = 0; i < this.mask.length(); ++i) {
            char c = this.mask.charAt(i);
            if (c == '\'' && !bl) {
                ++n2;
                bl = true;
            } else if (bl) {
                if (n2 == i) {
                    return c;
                }
                bl = false;
            }
            if (n2 != i) continue;
            switch (c) {
                case '#': 
                case '*': 
                case '?': 
                case 'A': 
                case 'H': 
                case 'L': 
                case 'U': {
                    if (n3 > n) {
                        return this.placeHolder.charAt(n);
                    }
                    return this.placeHolderChar;
                }
            }
            return c;
        }
        throw new AssertionError((Object)"MaskFormatter.getMaskCharAt failed");
    }
}

