/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class InternationalFormatter
extends DefaultFormatter {
    private static final long serialVersionUID = 2436068675711756856L;
    Format format = null;
    Comparable minimum = null;
    Comparable maximum = null;

    public InternationalFormatter() {
        this.setCommitsOnValidEdit(false);
        this.setOverwriteMode(false);
    }

    public InternationalFormatter(Format format) {
        this();
        this.setFormat(format);
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setMinimum(Comparable comparable) {
        this.minimum = comparable;
        if (this.valueClass == null && comparable != null) {
            this.valueClass = comparable.getClass();
        }
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Comparable comparable) {
        this.maximum = comparable;
        if (this.valueClass == null && comparable != null) {
            this.valueClass = comparable.getClass();
        }
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
    }

    public String valueToString(Object object) throws ParseException {
        if (object == null) {
            return "";
        }
        if (this.format != null) {
            return this.format.format(object);
        }
        return super.valueToString(object);
    }

    public Object stringToValue(String string) throws ParseException {
        if (this.format != null) {
            Object object = this.format.parseObject(string);
            if (this.valueClass != null) {
                object = super.stringToValue(object.toString());
            }
            if (this.minimum != null && this.minimum.compareTo(object) > 0) {
                throw new ParseException("The value may not be less than the specified minimum", 0);
            }
            if (this.maximum != null && this.minimum.compareTo(object) < 0) {
                throw new ParseException("The value may not be greater than the specified maximum", 0);
            }
            return object;
        }
        return super.stringToValue(string);
    }

    public Format.Field[] getFields(int n) {
        AttributedCharacterIterator attributedCharacterIterator = this.format.formatToCharacterIterator(this.getFormattedTextField().getValue());
        attributedCharacterIterator.setIndex(n);
        Map map = attributedCharacterIterator.getAttributes();
        Set set = map.keySet();
        Format.Field[] fieldArray = new Format.Field[set.size()];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            fieldArray[n2] = (Format.Field)iterator.next();
            ++n2;
        }
        return fieldArray;
    }

    protected Action[] getActions() {
        return super.getActions();
    }
}

